/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.ai.goal;

import frostnox.nightfall.entity.Sex;
import frostnox.nightfall.entity.ai.pathfinding.ReversePath;
import frostnox.nightfall.entity.entity.animal.TamableAnimalEntity;
import frostnox.nightfall.util.MathUtil;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class BreedGoal
extends Goal {
    private static final TargetingConditions PARTNER_TARGETING = TargetingConditions.m_148353_().m_26883_(15.0).m_148355_();
    protected final TamableAnimalEntity entity;
    protected final Level level;
    protected final double speedModifier;
    @Nullable
    protected TamableAnimalEntity partner;
    protected ReversePath path;
    protected long lastCanUseCheck;
    protected int breedTimer;

    public BreedGoal(TamableAnimalEntity entity, double speedModifier) {
        this.entity = entity;
        this.level = entity.f_19853_;
        this.speedModifier = speedModifier;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.entity.canBreed()) {
            return false;
        }
        long time = this.entity.f_19853_.m_46467_();
        if (time - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = time;
        double bestDistSqr = Double.MAX_VALUE;
        TamableAnimalEntity partner = null;
        for (TamableAnimalEntity animal : this.level.m_45971_(TamableAnimalEntity.class, PARTNER_TARGETING, (LivingEntity)this.entity, this.entity.m_142469_().m_82400_(15.0))) {
            if (!this.entity.canBreedWith(animal) || !animal.canBreed() || !(this.entity.m_20280_((Entity)animal) < bestDistSqr)) continue;
            this.path = this.entity.getNavigator().findPath((Entity)animal, 0.0f);
            if (this.path == null || !this.path.reachesGoal()) continue;
            partner = animal;
            bestDistSqr = this.entity.m_20280_((Entity)animal);
        }
        this.partner = partner;
        return this.partner != null;
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean m_8045_() {
        return this.entity.canBreed() && this.partner != null && this.partner.m_6084_() && this.partner.canBreed();
    }

    public void m_8056_() {
        if (this.entity.sex == Sex.MALE) {
            this.entity.getNavigator().moveTo(this.path, this.speedModifier);
        } else {
            this.entity.getNavigator().m_26573_();
        }
        this.path = null;
    }

    public void m_8041_() {
        this.partner = null;
        this.entity.getNavigator().m_26573_();
        this.breedTimer = 0;
    }

    public void m_8037_() {
        if (this.entity.sex == Sex.MALE) {
            this.entity.m_21563_().m_24960_((Entity)this.partner, this.entity.getMaxYRotPerTick(), this.entity.getMaxXRotPerTick());
            if (MathUtil.getShortestDistanceSqrBoxToBox(this.entity.m_142469_(), this.partner.m_142469_()) < 0.25) {
                ++this.breedTimer;
                if (this.breedTimer > 30) {
                    this.entity.breedPair(this.partner);
                } else {
                    this.entity.startAction(this.entity.getBreedAction());
                }
            } else if (this.entity.getBreedTime() % 10 == 0 || this.entity.refreshPath || this.entity.getNavigator().m_26571_()) {
                ReversePath path = this.entity.getNavigator().findPath((Entity)this.partner, 0.0f);
                if (path != null && path.reachesGoal()) {
                    this.entity.getNavigator().moveTo(path, this.speedModifier);
                } else {
                    this.partner = null;
                }
            }
        } else {
            this.entity.m_21563_().m_24964_(new Vec3(this.entity.m_20185_() + (this.entity.m_20185_() - this.partner.m_20185_()), this.entity.m_20188_(), this.entity.m_20189_() + (this.entity.m_20189_() - this.partner.m_20189_())));
        }
    }
}

