/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.ai.goal;

import frostnox.nightfall.entity.ai.pathfinding.ReversePath;
import frostnox.nightfall.entity.entity.ActionableEntity;
import java.util.EnumSet;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;

public class FleeEntityGoal<T extends LivingEntity>
extends Goal {
    protected final ActionableEntity mob;
    protected final Class<T> fleeClass;
    protected final double walkSpeedModifier;
    protected final double sprintSpeedModifier;
    protected final TargetingConditions fleeConditions;
    protected final Predicate<LivingEntity> fleePredicate;
    @Nullable
    protected Vec3 avoidPos;
    @Nullable
    protected ReversePath path;

    public FleeEntityGoal(ActionableEntity mob, Class<T> fleeClass, double walkSpeedModifier, double sprintSpeedModifier) {
        this(mob, fleeClass, walkSpeedModifier, sprintSpeedModifier, EntitySelector.f_20406_::test);
    }

    public FleeEntityGoal(ActionableEntity mob, Class<T> fleeClass, double walkSpeedModifier, double sprintSpeedModifier, Predicate<LivingEntity> fleePredicate) {
        this.mob = mob;
        this.fleeClass = fleeClass;
        this.walkSpeedModifier = walkSpeedModifier;
        this.sprintSpeedModifier = sprintSpeedModifier;
        this.fleeConditions = TargetingConditions.m_148352_().m_26888_(fleePredicate);
        this.fleePredicate = fleePredicate;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    protected boolean checkHeardEntities() {
        boolean update = false;
        double avoidDistSqr = this.avoidPos == null ? Double.MAX_VALUE : this.mob.m_20238_(this.avoidPos);
        for (Entity entity : this.mob.getAudioSensing().getHeardEntities()) {
            double distSqr;
            if (!this.fleeClass.isAssignableFrom(entity.getClass()) || !this.fleePredicate.test((LivingEntity)entity) || (distSqr = this.mob.m_20280_(entity)) != avoidDistSqr && (!(distSqr < avoidDistSqr) || !(avoidDistSqr - distSqr > 4.0))) continue;
            update = true;
            avoidDistSqr = distSqr;
            this.avoidPos = entity.m_20182_();
        }
        return update;
    }

    protected boolean updatePath() {
        if (this.avoidPos == null) {
            return false;
        }
        Vec3 randPos = this.getRandomPos();
        if (randPos == null) {
            return false;
        }
        this.onFindPath();
        this.path = this.mob.getNavigator().findPath(randPos.f_82479_, randPos.f_82480_, randPos.f_82481_, 0.0f);
        return this.path != null;
    }

    protected void onFindPath() {
    }

    protected Vec3 getRandomPos() {
        return DefaultRandomPos.m_148407_((PathfinderMob)this.mob, (int)32, (int)8, (Vec3)this.avoidPos);
    }

    public boolean m_8036_() {
        int range = (int)this.mob.m_21133_(Attributes.f_22277_);
        this.fleeConditions.m_26883_((double)range);
        LivingEntity nearestEntity = this.mob.f_19853_.m_45982_(this.mob.f_19853_.m_6443_(this.fleeClass, this.mob.m_142469_().m_82377_((double)range, (double)(range / 2), (double)range), entity -> true), this.fleeConditions, (LivingEntity)this.mob, this.mob.m_20185_(), this.mob.m_20186_(), this.mob.m_20189_());
        if (nearestEntity != null) {
            this.avoidPos = nearestEntity.m_20182_();
        }
        this.checkHeardEntities();
        return this.updatePath();
    }

    public boolean m_8045_() {
        return !this.mob.getNavigator().m_26571_();
    }

    public void m_8056_() {
        this.mob.getNavigator().moveTo(this.path, this.sprintSpeedModifier);
    }

    public void m_8041_() {
        this.avoidPos = null;
        this.path = null;
    }

    public void m_8037_() {
        if (this.checkHeardEntities() && this.updatePath()) {
            this.mob.getNavigator().moveTo(this.path, this.sprintSpeedModifier);
        }
        if (this.mob.m_20238_(this.avoidPos) < 256.0) {
            this.mob.getNavigator().m_26517_(this.sprintSpeedModifier);
        } else {
            this.mob.getNavigator().m_26517_(this.walkSpeedModifier);
        }
    }
}

