/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.ai.goal;

import frostnox.nightfall.entity.ai.pathfinding.ReversePath;
import frostnox.nightfall.entity.entity.ActionableEntity;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;

public class FleeTargetGoal
extends Goal {
    protected final ActionableEntity mob;
    protected final double walkSpeedModifier;
    protected final double sprintSpeedModifier;
    @Nullable
    protected Vec3 avoidPos;
    @Nullable
    protected ReversePath path;

    public FleeTargetGoal(ActionableEntity mob, double walkSpeedModifier, double sprintSpeedModifier) {
        this.mob = mob;
        this.walkSpeedModifier = walkSpeedModifier;
        this.sprintSpeedModifier = sprintSpeedModifier;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    protected boolean updatePath() {
        if (this.avoidPos == null) {
            return false;
        }
        Vec3 randPos = this.getRandomPos();
        if (randPos == null) {
            return false;
        }
        this.onFindPath();
        this.path = this.mob.getNavigator().findPath(randPos.f_82479_, randPos.f_82480_, randPos.f_82481_, 0.0f);
        return this.path != null;
    }

    protected void onFindPath() {
    }

    protected Vec3 getRandomPos() {
        return DefaultRandomPos.m_148407_((PathfinderMob)this.mob, (int)32, (int)8, (Vec3)this.avoidPos);
    }

    public boolean m_8036_() {
        LivingEntity target = this.mob.m_5448_();
        if (target != null && this.mob.shouldFleeFrom(target)) {
            this.avoidPos = target.m_20182_();
        }
        return this.updatePath();
    }

    public boolean m_8045_() {
        return !this.mob.getNavigator().m_26571_();
    }

    public void m_8056_() {
        this.mob.getNavigator().moveTo(this.path, this.sprintSpeedModifier);
    }

    public void m_8041_() {
        this.avoidPos = null;
        this.path = null;
        this.mob.lastTargetPos = null;
    }

    public void m_8037_() {
        if (this.mob.m_20238_(this.avoidPos) < 256.0) {
            this.mob.getNavigator().m_26517_(this.sprintSpeedModifier);
        } else {
            this.mob.getNavigator().m_26517_(this.walkSpeedModifier);
        }
    }
}

