/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.ai.goal;

import frostnox.nightfall.entity.entity.ActionableEntity;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;

public class FollowAllyGoal
extends Goal {
    protected final ActionableEntity mob;
    protected final double speedModifier;
    protected double pathedTargetX;
    protected double pathedTargetY;
    protected double pathedTargetZ;
    protected int recalcTicks;
    protected long lastCanUseCheck;
    protected double maxDistanceSqr;
    protected double strafeStartDistSqr;
    protected boolean strafingClockwise;
    protected boolean strafingBackwards;
    protected int strafingTime = -1;

    public FollowAllyGoal(ActionableEntity entity, double speedIn, double maxDistance, double strafeStartDist) {
        this.mob = entity;
        this.speedModifier = speedIn;
        this.maxDistanceSqr = maxDistance * maxDistance;
        this.strafeStartDistSqr = strafeStartDist * strafeStartDist;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        long time = this.mob.f_19853_.m_46467_();
        if (time - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = time;
        ActionableEntity ally = this.mob.getAlly();
        if (ally == null) {
            return false;
        }
        if (ally.getTargetPos() != null) {
            return true;
        }
        return this.mob.m_20275_(ally.m_20185_(), ally.m_20186_(), ally.m_20189_()) > this.strafeStartDistSqr;
    }

    public boolean m_8045_() {
        ActionableEntity ally = this.mob.getAlly();
        if (ally == null) {
            return false;
        }
        if (ally.getTargetPos() != null) {
            return true;
        }
        return this.mob.m_20275_(ally.m_20185_(), ally.m_20186_(), ally.m_20189_()) > this.strafeStartDistSqr;
    }

    public void m_8056_() {
        this.recalcTicks = 0;
    }

    public void m_8041_() {
        this.mob.getNavigator().m_26573_();
        this.mob.m_21566_().m_24988_(0.0f, 0.0f);
    }

    public void m_8037_() {
        ActionableEntity ally = this.mob.getAlly();
        if (ally != null) {
            double distSqr = this.mob.m_20275_(ally.m_20185_(), ally.m_20186_(), ally.m_20189_());
            if (ally.m_5448_() != null && distSqr <= this.strafeStartDistSqr) {
                this.mob.m_21573_().m_26573_();
                ++this.strafingTime;
            } else {
                this.recalcTicks = Math.max(this.recalcTicks - 1, 0);
                if ((this.recalcTicks == 0 || this.mob.refreshPath || this.mob.getNavigator().m_26571_()) && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || ally.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_21187_().nextFloat() < 0.05f)) {
                    this.pathedTargetX = ally.m_20185_();
                    this.pathedTargetY = ally.m_20186_();
                    this.pathedTargetZ = ally.m_20189_();
                    this.recalcTicks = 2;
                    if (distSqr > 1024.0) {
                        this.recalcTicks += 12;
                    } else if (distSqr > 256.0) {
                        this.recalcTicks += 8;
                    } else if (distSqr > 25.0) {
                        this.recalcTicks += 4;
                    }
                    if (!this.mob.getNavigator().m_5624_((Entity)ally, this.speedModifier)) {
                        this.recalcTicks += 4;
                    }
                    if (this.mob.refreshPath) {
                        this.mob.refreshPath = false;
                    }
                }
                this.mob.m_21566_().m_24988_(0.0f, 0.0f);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 20) {
                if (this.mob.m_21187_().nextFloat() < 0.3f) {
                    boolean bl = this.strafingClockwise = !this.strafingClockwise;
                }
                if (this.mob.m_21187_().nextFloat() < 0.3f) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (distSqr > this.strafeStartDistSqr * 0.75) {
                    this.strafingBackwards = false;
                } else if (distSqr < this.strafeStartDistSqr * 0.25) {
                    this.strafingBackwards = true;
                }
                if (!this.mob.m_20069_()) {
                    this.mob.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                }
                this.mob.m_21391_((Entity)ally, this.mob.getMaxYRotPerTick(), this.mob.getMaxXRotPerTick());
            }
            this.mob.m_21563_().m_24960_((Entity)ally, this.mob.getMaxYRotPerTick(), this.mob.getMaxXRotPerTick());
        }
    }
}

