/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.ai.goal;

import frostnox.nightfall.block.block.eggnest.EggNestBlock;
import frostnox.nightfall.block.block.eggnest.EggNestBlockEntity;
import frostnox.nightfall.entity.ai.pathfinding.ReversePath;
import frostnox.nightfall.entity.entity.animal.DrakefowlEntity;
import frostnox.nightfall.util.LevelUtil;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;

public class LayEggGoal
extends Goal {
    protected final DrakefowlEntity mob;
    protected final Supplier<? extends Block> nestBlock;
    protected final double speedModifier;
    @Nullable
    protected ReversePath path;
    @Nullable
    protected Vec3 pos;
    @Nullable
    protected BlockPos blockPos;
    protected int lookX;
    protected int lookZ;

    public LayEggGoal(DrakefowlEntity mob, Supplier<? extends Block> nestBlock, double speedModifier) {
        this.mob = mob;
        this.nestBlock = nestBlock;
        this.speedModifier = speedModifier;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    protected boolean isNestSpotValid(BlockPos pos) {
        return !LevelUtil.isSkyUnobstructed(this.mob.f_19853_, pos);
    }

    public boolean m_8036_() {
        this.pos = null;
        this.blockPos = null;
        List<BlockEntity> nests = LevelUtil.getBlockEntities(this.mob.f_19853_, this.mob.m_142538_(), 16, entity -> entity instanceof EggNestBlockEntity);
        nests.sort(Comparator.comparingDouble(entity -> {
            BlockPos pos = entity.m_58899_();
            return this.mob.m_20275_((double)pos.m_123341_() + 0.5, pos.m_123342_(), (double)pos.m_123343_() + 0.5);
        }));
        for (BlockEntity entity2 : nests) {
            BlockPos nestPos;
            EggNestBlockEntity nest = (EggNestBlockEntity)entity2;
            if (nest.occupied || LevelUtil.isSkyUnobstructed(this.mob.f_19853_, nestPos = nest.m_58899_())) continue;
            if (this.mob.m_20275_((double)nestPos.m_123341_() + 0.5, nestPos.m_123342_(), (double)nestPos.m_123343_() + 0.5) < 0.25) {
                this.pos = new Vec3((double)nestPos.m_123341_() + 0.5, (double)nestPos.m_123342_(), (double)nestPos.m_123343_() + 0.5);
                this.blockPos = new BlockPos(this.pos);
                break;
            }
            this.path = this.mob.getNavigator().findPath(nestPos, 0.0f);
            if (this.path == null || !this.path.reachesGoal()) continue;
            this.pos = new Vec3((double)nestPos.m_123341_() + 0.5, (double)nestPos.m_123342_(), (double)nestPos.m_123343_() + 0.5);
            this.blockPos = new BlockPos(this.pos);
            nest.occupied = true;
            break;
        }
        if (this.pos != null) {
            return true;
        }
        if (this.mob.getGestationTime() > 0) {
            BlockPos randPos = this.mob.m_142538_().m_142082_(this.mob.m_21187_().nextInt(25) - 12, 0, this.mob.m_21187_().nextInt(25) - 12);
            LevelChunk chunk = this.mob.f_19853_.m_46745_(randPos);
            if (chunk.m_8055_(randPos).m_60795_()) {
                BlockPos.MutableBlockPos belowPos = randPos.m_122032_();
                for (int i = 0; i < 8; ++i) {
                    if (chunk.m_8055_((BlockPos)belowPos.m_142448_(belowPos.m_123342_() - 1)).m_60795_()) continue;
                    this.blockPos = belowPos.m_7494_();
                    this.pos = new Vec3((double)this.blockPos.m_123341_() + 0.5, (double)this.blockPos.m_123342_(), (double)this.blockPos.m_123343_() + 0.5);
                    break;
                }
            } else {
                BlockPos.MutableBlockPos abovePos = randPos.m_122032_();
                for (int i = 0; i < 8; ++i) {
                    if (!chunk.m_8055_((BlockPos)abovePos.m_142448_(abovePos.m_123342_() + 1)).m_60795_()) continue;
                    this.blockPos = abovePos.m_7949_();
                    this.pos = new Vec3((double)this.blockPos.m_123341_() + 0.5, (double)this.blockPos.m_123342_(), (double)this.blockPos.m_123343_() + 0.5);
                    break;
                }
            }
            if (this.pos == null) {
                return false;
            }
            this.blockPos = new BlockPos(this.pos);
            if (!this.isNestSpotValid(this.blockPos)) {
                return false;
            }
            this.path = this.mob.getNavigator().findPath(this.blockPos, 0.0f);
            return this.path != null && this.path.reachesGoal();
        }
        return false;
    }

    public boolean m_8045_() {
        return !this.mob.getNavigator().m_26571_() || this.mob.f_19853_.m_7702_(this.blockPos) instanceof EggNestBlockEntity || this.isNestSpotValid(this.blockPos);
    }

    public void m_8056_() {
        this.mob.getNavigator().moveTo(this.path, this.speedModifier);
        this.path = null;
    }

    public void m_8041_() {
        this.lookX = 0;
        this.lookZ = 0;
        BlockEntity blockEntity = this.mob.f_19853_.m_7702_(this.blockPos);
        if (blockEntity instanceof EggNestBlockEntity) {
            EggNestBlockEntity nest = (EggNestBlockEntity)blockEntity;
            nest.occupied = false;
        }
    }

    public void m_8037_() {
        if (this.mob.refreshPath || this.mob.randTickCount % 20 < 2) {
            this.mob.getNavigator().moveTo(this.pos.f_82479_, this.pos.f_82480_, this.pos.f_82481_, this.speedModifier, 0);
        }
        if (this.mob.m_20238_(this.pos) < 0.0625) {
            if (this.mob.randTickCount % 100 < 2) {
                BlockPos.MutableBlockPos adjPos = this.blockPos.m_122032_();
                this.lookX = 0;
                this.lookZ = 0;
                for (Direction dir : LevelUtil.HORIZONTAL_DIRECTIONS) {
                    if (this.mob.f_19853_.m_8055_((BlockPos)adjPos.m_122159_((Vec3i)this.blockPos, dir)).m_60795_()) continue;
                    this.lookX -= dir.m_122429_();
                    this.lookZ -= dir.m_122431_();
                }
            }
            this.mob.m_21563_().m_24946_(this.mob.m_20185_() + (double)this.lookX, this.mob.m_20188_(), this.mob.m_20189_() + (double)this.lookZ);
            if (this.mob.getGestationTime() > 0 && this.mob.isComfortable() && this.mob.m_21187_().nextInt(1600) == 0) {
                BlockEntity blockEntity = this.mob.f_19853_.m_7702_(this.blockPos);
                if (blockEntity instanceof EggNestBlockEntity) {
                    EggNestBlockEntity nest = (EggNestBlockEntity)blockEntity;
                    for (int i = 0; i < nest.hatchTimes.length; ++i) {
                        if (nest.hatchTimes[i] != 0) continue;
                        this.mob.f_19853_.m_46597_(this.blockPos, (BlockState)nest.m_58900_().m_61124_((Property)EggNestBlock.EGGS, (Comparable)Integer.valueOf((Integer)nest.m_58900_().m_61143_((Property)EggNestBlock.EGGS) + 1)));
                        int n = nest.hatchTimes[i] = this.mob.fatherType == null ? -1 : ((EggNestBlock)nest.m_58900_().m_60734_()).hatchDuration;
                        if (this.mob.fatherType != null) {
                            nest.eggData[0] = this.mob.getDrakefowlType() == this.mob.fatherType ? this.mob.fatherType.ordinal() : (this.mob.m_21187_().nextBoolean() ? this.mob.getDrakefowlType().ordinal() : this.mob.fatherType.ordinal());
                        }
                        break;
                    }
                } else if (this.isNestSpotValid(this.blockPos)) {
                    this.mob.f_19853_.m_46597_(this.blockPos, (BlockState)this.nestBlock.get().m_49966_().m_61124_((Property)EggNestBlock.EGGS, (Comparable)Integer.valueOf(1)));
                    BlockEntity blockEntity2 = this.mob.f_19853_.m_7702_(this.blockPos);
                    if (blockEntity2 instanceof EggNestBlockEntity) {
                        EggNestBlockEntity nest = (EggNestBlockEntity)blockEntity2;
                        int n = nest.hatchTimes[0] = this.mob.fatherType == null ? -1 : ((EggNestBlock)nest.m_58900_().m_60734_()).hatchDuration;
                        if (this.mob.fatherType != null) {
                            nest.eggData[0] = this.mob.getDrakefowlType() == this.mob.fatherType ? this.mob.fatherType.ordinal() : (this.mob.m_21187_().nextBoolean() ? this.mob.getDrakefowlType().ordinal() : this.mob.fatherType.ordinal());
                        }
                        nest.occupied = true;
                    }
                }
                this.mob.endGestation();
            }
        }
    }
}

