/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.ai.goal;

import frostnox.nightfall.entity.entity.animal.TamableAnimalEntity;
import frostnox.nightfall.util.MathUtil;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;

public class LureGoal
extends Goal {
    private final TamableAnimalEntity entity;
    private final double range;
    private final double speedModifier;
    private final TargetingConditions targeting;
    protected long lastCanUseCheck;
    protected int cooldown;
    @Nullable
    protected Player player;

    public LureGoal(TamableAnimalEntity entity, double range, double speedModifier) {
        this.entity = entity;
        this.targeting = TargetingConditions.m_148353_().m_26883_(range).m_26888_(player -> entity.isFeedItem(player.m_21205_()) || entity.isFeedItem(player.m_21206_()));
        this.range = range;
        this.speedModifier = speedModifier;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.cooldown > 0) {
            --this.cooldown;
            return false;
        }
        long time = this.entity.f_19853_.m_46467_();
        if (time - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = time;
        this.player = this.entity.f_19853_.m_45946_(this.targeting, (LivingEntity)this.entity);
        return this.player != null;
    }

    public boolean m_8045_() {
        if (this.entity.m_20280_((Entity)this.player) > this.range * this.range) {
            return this.m_8036_();
        }
        if (!this.entity.isFeedItem(this.player.m_21205_()) && !this.entity.isFeedItem(this.player.m_21206_())) {
            return this.m_8036_();
        }
        return true;
    }

    public void m_8056_() {
        this.entity.tamable = true;
    }

    public void m_8041_() {
        this.entity.tamable = false;
        this.player = null;
        this.entity.getNavigator().m_26573_();
        this.entity.m_21563_().m_24964_(this.entity.m_146892_());
        this.cooldown = LureGoal.m_186073_((int)100);
    }

    public void m_8037_() {
        this.entity.m_21563_().m_24960_((Entity)this.player, this.entity.getMaxYRotPerTick(), this.entity.getMaxXRotPerTick());
        if (MathUtil.getShortestDistanceSqrBoxToBox(this.entity.m_142469_(), this.player.m_142469_()) < 4.0) {
            this.entity.getNavigator().m_26573_();
        } else {
            this.entity.getNavigator().moveTo((Entity)this.player, this.speedModifier, 2);
        }
    }
}

