/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.ai.goal;

import frostnox.nightfall.entity.ai.pathfinding.Node;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.registry.ActionsNF;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.ai.goal.Goal;

public class MineToTargetGoal
extends Goal {
    private final ActionableEntity entity;
    private BlockPos blockPos = null;

    public MineToTargetGoal(ActionableEntity entity) {
        this.entity = entity;
    }

    public boolean m_8036_() {
        if (!this.entity.isInterruptible() || !this.entity.canMineAnything()) {
            return false;
        }
        return this.lookForBlocks();
    }

    public boolean m_8045_() {
        return this.entity.canMineAnything() && (this.entity.getActionTracker().getActionID().equals((Object)ActionsNF.HUSK_MINE.getId()) || this.lookForBlocks());
    }

    public void m_8041_() {
        this.blockPos = null;
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        if (this.blockPos == null || !this.entity.getActionTracker().isDamaging()) {
            return;
        }
        if (this.entity.getActionTracker().getFrame() != this.entity.getActionTracker().getDuration() / 2) {
            return;
        }
        this.lookForBlocks();
        if (this.blockPos.m_203193_((Position)this.entity.m_146892_()) > (double)this.entity.getReachSqr() * 1.25) {
            this.blockPos = null;
            return;
        }
        if (this.entity.mineBlock(this.entity.f_19853_, this.blockPos)) {
            this.blockPos = null;
        }
    }

    protected boolean lookForBlocks() {
        Node node = this.entity.getNavigator().getCurrentNode();
        if (node != null) {
            if (node.mineable) {
                BlockPos nextPos;
                Node nextNode = this.entity.getNavigator().getNextNode();
                BlockPos blockPos = nextPos = nextNode != null ? nextNode.getBlockPos() : this.entity.getTargetPos();
                if (nextPos != null) {
                    BlockPos.MutableBlockPos blockedPos = node.getBlockPos().m_122032_();
                    if (nextPos.m_123342_() > blockedPos.m_123342_()) {
                        BlockPos aboveEntityPos = this.entity.m_142538_().m_6630_(2);
                        if (this.entity.canMineBlock(aboveEntityPos)) {
                            return this.setBlockPos(aboveEntityPos);
                        }
                        if (this.entity.canMineBlock((BlockPos)blockedPos.m_122175_(Direction.UP, 2))) {
                            return this.setBlockPos((BlockPos)blockedPos);
                        }
                        if (this.entity.canMineBlock((BlockPos)blockedPos.m_122173_(Direction.DOWN))) {
                            return this.setBlockPos((BlockPos)blockedPos);
                        }
                        if (this.entity.canMineBlock((BlockPos)blockedPos.m_122173_(Direction.DOWN))) {
                            return this.setBlockPos((BlockPos)blockedPos);
                        }
                    } else {
                        if (this.entity.canMineBlock((BlockPos)blockedPos.m_122173_(Direction.UP))) {
                            return this.setBlockPos((BlockPos)blockedPos);
                        }
                        if (this.entity.canMineBlock((BlockPos)blockedPos.m_122173_(Direction.DOWN))) {
                            return this.setBlockPos((BlockPos)blockedPos);
                        }
                    }
                }
            }
        } else {
            BlockPos targetPos = this.entity.getTargetPos();
            if (targetPos != null && targetPos.m_123342_() >= Mth.m_14165_((double)this.entity.m_20188_())) {
                if (this.entity.canMineBlock(targetPos)) {
                    return this.setBlockPos(targetPos);
                }
                if (this.entity.canMineBlock(targetPos = targetPos.m_7495_())) {
                    return this.setBlockPos(targetPos);
                }
            }
        }
        return false;
    }

    private boolean setBlockPos(BlockPos pos) {
        this.blockPos = pos.m_7949_();
        this.doMineAction();
        return true;
    }

    protected void doMineAction() {
        this.entity.startAction(ActionsNF.HUSK_MINE.getId());
    }
}

