/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.ai.goal;

import frostnox.nightfall.entity.ai.pathfinding.ReversePath;
import frostnox.nightfall.entity.entity.ActionableEntity;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;

public abstract class MoveToEntityGoal
extends Goal {
    protected final ActionableEntity mob;
    protected final Predicate<Entity> entityPredicate;
    protected final double speedModifier;
    protected final double minDistSqr;
    protected final int horizontalRange;
    protected final int verticalRange;
    protected final int tickDelay;
    protected int nextStartTick;
    @Nullable
    protected Entity target;
    @Nullable
    protected ReversePath path;

    public MoveToEntityGoal(ActionableEntity pMob, double pSpeedModifier, int horizontalRange, int verticalRange, Predicate<Entity> entityPredicate) {
        this(pMob, pSpeedModifier, horizontalRange, verticalRange, entityPredicate, 1.0, 200);
    }

    public MoveToEntityGoal(ActionableEntity pMob, double pSpeedModifier, int horizontalRange, int verticalRange, Predicate<Entity> entityPredicate, double minDist, int tickDelay) {
        this.mob = pMob;
        this.speedModifier = pSpeedModifier;
        this.horizontalRange = horizontalRange;
        this.verticalRange = verticalRange;
        this.entityPredicate = entityPredicate;
        this.minDistSqr = minDist * minDist;
        this.tickDelay = tickDelay;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    protected abstract void onReachEntity();

    @Nullable
    protected Entity findNearestEntity() {
        List entities = this.mob.f_19853_.m_6249_((Entity)this.mob, this.mob.m_142469_().m_82377_((double)this.horizontalRange, (double)this.verticalRange, (double)this.horizontalRange), this.entityPredicate);
        if (entities.isEmpty()) {
            return null;
        }
        return (Entity)Collections.min(entities, (entity1, entity2) -> Double.compare(entity1.m_20280_((Entity)this.mob), entity2.m_20280_((Entity)this.mob)));
    }

    public boolean m_8036_() {
        if (this.nextStartTick > 0) {
            --this.nextStartTick;
            return false;
        }
        this.nextStartTick = MoveToEntityGoal.m_186073_((int)(this.tickDelay + this.mob.m_21187_().nextInt(this.tickDelay)));
        Entity nearestEntity = this.findNearestEntity();
        if (nearestEntity == null) {
            return false;
        }
        ReversePath path = this.mob.getNavigator().findPath(nearestEntity, 0.0f);
        if (path != null && path.reachesGoal()) {
            this.path = path;
            this.target = nearestEntity;
            return true;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.path != null && this.path.reachesGoal() && this.target != null && !this.target.m_146910_();
    }

    public void m_8056_() {
        this.mob.getNavigator().moveTo(this.path, this.speedModifier);
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        if (this.mob.m_20280_(this.target) > this.minDistSqr) {
            if (this.mob.randTickCount % 20 == 0) {
                this.path = this.mob.getNavigator().findPath(this.target, 0.0f);
                this.mob.getNavigator().moveTo(this.path, this.speedModifier);
            }
        } else {
            this.onReachEntity();
        }
    }
}

