/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.ai.goal;

import frostnox.nightfall.entity.ai.pathfinding.ReversePath;
import frostnox.nightfall.entity.entity.ActionableEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;

public class PursueTargetGoal
extends Goal {
    protected final ActionableEntity mob;
    protected final double speedModifier;
    protected ReversePath path;
    protected double pathedTargetX;
    protected double pathedTargetY;
    protected double pathedTargetZ;
    protected int recalcTicks;
    protected long lastCanUseCheck;
    protected int pursueTime;
    protected BlockPos lastLastPos = null;

    public PursueTargetGoal(ActionableEntity entity, double speedIn) {
        this.mob = entity;
        this.speedModifier = speedIn;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    protected boolean canPursue() {
        return true;
    }

    protected int getAccuracy() {
        return 1;
    }

    public boolean m_8036_() {
        long time = this.mob.f_19853_.m_46467_();
        if (time - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = time;
        LivingEntity target = this.mob.m_5448_();
        if (target == null || !target.m_6084_()) {
            if (this.mob.lastTargetPos != null) {
                this.path = this.mob.getNavigator().findPath(this.mob.lastTargetPos, 0.0f);
                return true;
            }
            if (this.mob.getAudioSensing().getClosestHeardPos() != null) {
                this.mob.lastTargetPos = this.mob.getAudioSensing().getClosestHeardPos();
                this.path = this.mob.getNavigator().findPath(this.mob.lastTargetPos, 0.0f);
                return true;
            }
            return false;
        }
        this.path = this.mob.getNavigator().findPath((Entity)target, 0.0f);
        return this.path != null;
    }

    public boolean m_8045_() {
        LivingEntity target = this.mob.m_5448_();
        if (this.mob.lastTargetPos != null && target == null) {
            return !this.mob.getNavigator().m_26571_();
        }
        if (target == null) {
            return false;
        }
        if (!target.m_6084_()) {
            return false;
        }
        if (!this.mob.m_21444_(target.m_142538_())) {
            return false;
        }
        return !(target instanceof Player) || !target.m_5833_() && !((Player)target).m_7500_();
    }

    public void m_8056_() {
        this.mob.getNavigator().moveTo(this.path, this.speedModifier);
        this.mob.m_21561_(true);
        this.recalcTicks = 0;
    }

    public void m_8041_() {
        this.mob.m_6710_(null);
        this.mob.lastTargetPos = null;
        this.mob.m_21561_(false);
        this.mob.getNavigator().m_26573_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity target = this.mob.m_5448_();
        if (target != null) {
            this.mob.m_21563_().m_24960_((Entity)target, this.mob.getMaxYRotPerTick(), this.mob.getMaxXRotPerTick());
            this.recalcTicks = Math.max(this.recalcTicks - 1, 0);
            if (this.canPursue()) {
                double distSqr = this.mob.m_20275_(target.m_20185_(), target.m_20186_(), target.m_20189_());
                int accuracy = this.getAccuracy();
                if ((this.recalcTicks == 0 || this.mob.refreshPath || this.mob.getNavigator().m_26571_()) && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || target.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= (double)(accuracy * accuracy) || this.mob.m_21187_().nextFloat() < 0.05f)) {
                    this.pathedTargetX = target.m_20185_();
                    this.pathedTargetY = target.m_20186_();
                    this.pathedTargetZ = target.m_20189_();
                    this.recalcTicks = 2;
                    if (distSqr > 1024.0) {
                        this.recalcTicks += 12;
                    } else if (distSqr > 256.0) {
                        this.recalcTicks += 8;
                    } else if (distSqr > 25.0) {
                        this.recalcTicks += 4;
                    }
                    if (!this.mob.getNavigator().moveTo((Entity)target, this.speedModifier, accuracy)) {
                        this.recalcTicks += 4;
                    }
                    if (this.mob.refreshPath) {
                        this.mob.refreshPath = false;
                    }
                }
            }
        } else if (this.mob.lastTargetPos != null) {
            if (this.mob.m_20097_().m_7494_().equals((Object)this.mob.lastTargetPos)) {
                this.mob.lastTargetPos = null;
            } else if (this.lastLastPos != null && this.lastLastPos.equals((Object)this.mob.lastTargetPos)) {
                ++this.pursueTime;
                if (this.pursueTime > 600) {
                    this.mob.lastTargetPos = null;
                    this.pursueTime = 0;
                }
            } else if (this.canPursue()) {
                this.mob.getNavigator().moveTo(this.mob.lastTargetPos.m_123341_(), this.mob.lastTargetPos.m_123342_(), this.mob.lastTargetPos.m_123343_(), this.speedModifier, this.getAccuracy());
                this.pursueTime = 0;
            }
        }
        if (!this.canPursue()) {
            this.mob.getNavigator().m_26573_();
        }
        this.lastLastPos = this.mob.lastTargetPos;
    }
}

