/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.ai.goal;

import frostnox.nightfall.action.Action;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.registry.ActionsNF;
import frostnox.nightfall.util.CombatUtil;
import java.util.EnumSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;

public class RangedAttackGoal
extends Goal {
    protected ResourceLocation attackID;
    protected int heldAttackTicks = 1000;
    protected final ActionableEntity mob;
    protected final double speedModifier;
    protected long lastCanUseCheck;
    protected int seeTime;
    protected boolean strafingClockwise;
    protected boolean strafingBackwards;
    protected int strafingTime = -1;
    protected final float distanceLimitSqr;
    protected int cooldownTicks;
    protected int cooldownTime;

    public RangedAttackGoal(ActionableEntity entity, double speedIn, float distanceLimit) {
        this.mob = entity;
        this.speedModifier = speedIn;
        this.distanceLimitSqr = distanceLimit * distanceLimit;
        this.cooldownTime = 8 + entity.m_21187_().nextInt() % 5;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        long time = this.mob.f_19853_.m_46467_();
        if (time - this.lastCanUseCheck < 5L) {
            return false;
        }
        this.lastCanUseCheck = time;
        LivingEntity target = this.mob.m_5448_();
        if (target == null) {
            return false;
        }
        if (!target.m_6084_()) {
            return false;
        }
        return this.mob.canDoRangedAction();
    }

    public boolean m_8045_() {
        if (!this.mob.canDoRangedAction()) {
            return false;
        }
        LivingEntity target = this.mob.m_5448_();
        if (target == null || !target.m_6084_()) {
            return false;
        }
        return !(target instanceof Player) || !target.m_5833_() && !((Player)target).m_7500_();
    }

    public void m_8056_() {
        super.m_8056_();
        this.mob.m_21561_(true);
    }

    public void m_8041_() {
        super.m_8041_();
        LivingEntity livingentity = this.mob.m_5448_();
        if (!EntitySelector.f_20406_.test(livingentity)) {
            this.mob.m_6710_(null);
        }
        this.mob.m_21561_(false);
        this.mob.m_21573_().m_26573_();
        this.seeTime = 0;
        Action action = this.mob.getActionTracker().getAction();
        if (this.mob.getActionTracker().getState() == action.getChargeState()) {
            this.mob.queueAction();
        }
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        LivingEntity target = this.mob.m_5448_();
        if (target != null && ActionTracker.isPresent((Entity)this.mob)) {
            boolean hasSeen;
            double distSqr = CombatUtil.getShortestDistanceSqr((Entity)this.mob, (Entity)target);
            boolean canSee = this.mob.m_21574_().m_148306_((Entity)target);
            boolean bl = hasSeen = this.seeTime > 0;
            if (canSee != hasSeen) {
                this.seeTime = 0;
            }
            this.seeTime = canSee ? ++this.seeTime : --this.seeTime;
            if (!(distSqr > (double)this.distanceLimitSqr) && this.seeTime >= 20) {
                this.mob.m_21573_().m_26573_();
                ++this.strafingTime;
            } else {
                this.mob.m_21573_().m_5624_((Entity)target, this.speedModifier);
                this.mob.m_21566_().m_24988_(0.0f, 0.0f);
                this.strafingTime = -1;
            }
            if (this.strafingTime >= 20) {
                if (this.mob.m_21187_().nextFloat() < 0.3f) {
                    boolean bl2 = this.strafingClockwise = !this.strafingClockwise;
                }
                if (this.mob.m_21187_().nextFloat() < 0.3f) {
                    this.strafingBackwards = !this.strafingBackwards;
                }
                this.strafingTime = 0;
            }
            if (this.strafingTime > -1) {
                if (distSqr > (double)(this.distanceLimitSqr * 0.75f)) {
                    this.strafingBackwards = false;
                } else if (distSqr < (double)(this.distanceLimitSqr * 0.25f)) {
                    this.strafingBackwards = true;
                }
                if (!this.mob.m_20069_()) {
                    this.mob.m_21566_().m_24988_(this.strafingBackwards ? -0.5f : 0.5f, this.strafingClockwise ? 0.5f : -0.5f);
                }
                this.mob.m_21391_((Entity)target, this.mob.getMaxYRotPerTick(), this.mob.getMaxXRotPerTick());
            }
            this.mob.m_21563_().m_24960_((Entity)target, this.mob.getMaxYRotPerTick(), this.mob.getMaxXRotPerTick());
            IActionTracker capA = this.mob.getActionTracker();
            if (capA.isInactive()) {
                ++this.cooldownTicks;
            }
            if (this.heldAttackTicks >= 60 || capA.isStunned()) {
                this.attackID = this.mob.pickActionEnemy(distSqr, (Entity)target);
                this.heldAttackTicks = 0;
            }
            ++this.heldAttackTicks;
            double reach = ActionsNF.get(this.attackID).getMaxDistToStart((LivingEntity)this.mob);
            float lookAngle = CombatUtil.getRelativeHorizontalAngle(this.mob.m_146892_(), target.m_146892_(), this.mob.m_6080_());
            if (this.cooldownTicks >= this.cooldownTime && distSqr <= reach * reach && this.mob.isInterruptible() && lookAngle >= -25.0f && lookAngle <= 25.0f && canSee) {
                this.heldAttackTicks = 1000;
                this.cooldownTime = 8 + this.mob.m_21187_().nextInt() % 5;
                this.cooldownTicks = 0;
                this.mob.startAction(this.attackID);
            }
        } else {
            this.heldAttackTicks = 1000;
        }
    }
}

