/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.ai.goal;

import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.entity.ai.goal.PursueTargetGoal;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.registry.ActionsNF;
import frostnox.nightfall.util.CombatUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class RushAttackGoal
extends PursueTargetGoal {
    private ResourceLocation attackID;
    private int heldAttackTicks = 1000;

    public RushAttackGoal(ActionableEntity entity, double speedIn) {
        super(entity, speedIn);
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.heldAttackTicks = 1000;
    }

    @Override
    public void m_8037_() {
        super.m_8037_();
        LivingEntity target = this.mob.m_5448_();
        if (target != null && ActionTracker.isPresent((Entity)this.mob)) {
            IActionTracker capA = this.mob.getActionTracker();
            double distSqr = CombatUtil.getShortestDistanceSqr((Entity)this.mob, (Entity)target);
            if (this.heldAttackTicks >= 60 || capA.isStunned()) {
                this.attackID = this.mob.pickActionEnemy(distSqr, (Entity)target);
                this.heldAttackTicks = 0;
            }
            ++this.heldAttackTicks;
            double reach = ActionsNF.get(this.attackID).getMaxDistToStart((LivingEntity)this.mob);
            float lookAngle = CombatUtil.getRelativeHorizontalAngle(this.mob.m_146892_(), target.m_146892_(), this.mob.m_6080_());
            if (distSqr <= reach * reach && this.mob.isInterruptible() && lookAngle >= -20.0f && lookAngle <= 20.0f && this.mob.hasAnyLineOfSight((Entity)target)) {
                this.heldAttackTicks = 1000;
                this.mob.startAction(this.attackID);
            }
        } else {
            this.heldAttackTicks = 1000;
        }
    }
}

