/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.ai.goal;

import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.registry.ActionsNF;
import frostnox.nightfall.util.CombatUtil;
import java.util.EnumSet;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;

public class SupportAllyGoal
extends Goal {
    protected final ActionableEntity mob;
    protected final double speedModifier;
    protected double pathedTargetX;
    protected double pathedTargetY;
    protected double pathedTargetZ;
    protected int ticksUntilNextPathRecalculation;
    protected long lastCanUseCheck;

    public SupportAllyGoal(ActionableEntity entity, double speedIn) {
        this.mob = entity;
        this.speedModifier = speedIn;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        long i = this.mob.f_19853_.m_46467_();
        if (i - this.lastCanUseCheck < 20L) {
            return false;
        }
        this.lastCanUseCheck = i;
        ActionableEntity ally = this.mob.getAlly();
        if (ally == null || this.mob.m_5448_() == null && ally instanceof Mob && ((Mob)ally).m_5448_() == null) {
            return false;
        }
        return ally.m_6084_();
    }

    public boolean m_8045_() {
        ActionableEntity ally = this.mob.getAlly();
        if (ally == null || this.mob.m_5448_() == null && ally instanceof Mob && ((Mob)ally).m_5448_() == null) {
            return false;
        }
        return ally.m_6084_();
    }

    public void m_8056_() {
        this.ticksUntilNextPathRecalculation = 0;
    }

    public void m_8041_() {
        this.mob.m_21573_().m_26573_();
    }

    public boolean m_183429_() {
        return true;
    }

    public void m_8037_() {
        ActionableEntity ally = this.mob.getAlly();
        if (ally != null) {
            double distSqr = CombatUtil.getShortestDistanceSqr((Entity)this.mob, (Entity)ally);
            this.mob.m_21563_().m_24960_((Entity)ally, 9.0f, 9.0f);
            this.ticksUntilNextPathRecalculation = Math.max(this.ticksUntilNextPathRecalculation - 1, 0);
            if (this.ticksUntilNextPathRecalculation == 0 && (this.pathedTargetX == 0.0 && this.pathedTargetY == 0.0 && this.pathedTargetZ == 0.0 || ally.m_20275_(this.pathedTargetX, this.pathedTargetY, this.pathedTargetZ) >= 1.0 || this.mob.m_21187_().nextFloat() < 0.05f)) {
                this.pathedTargetX = ally.m_20185_();
                this.pathedTargetY = ally.m_20186_();
                this.pathedTargetZ = ally.m_20189_();
                this.ticksUntilNextPathRecalculation = 4 + this.mob.m_21187_().nextInt(7);
                if (distSqr > 1024.0) {
                    this.ticksUntilNextPathRecalculation += 10;
                } else if (distSqr > 256.0) {
                    this.ticksUntilNextPathRecalculation += 5;
                }
                if (!this.mob.m_21573_().m_5624_((Entity)ally, this.speedModifier)) {
                    this.ticksUntilNextPathRecalculation += 15;
                }
                this.ticksUntilNextPathRecalculation = this.m_183277_(this.ticksUntilNextPathRecalculation);
            }
            ResourceLocation actionID = this.mob.pickActionAlly(distSqr, (Entity)ally);
            double reach = ActionsNF.get(actionID).getMaxDistToStart((LivingEntity)this.mob);
            float lookAngle = CombatUtil.getRelativeHorizontalAngle(this.mob.m_146892_(), ally.m_146892_(), this.mob.m_6080_());
            if (distSqr <= reach * reach && this.mob.isInterruptible() && lookAngle >= -20.0f && lookAngle <= 20.0f) {
                this.mob.startAction(actionID);
            }
        }
    }
}

