/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.ai.goal.target;

import frostnox.nightfall.entity.entity.ActionableEntity;
import java.util.function.Predicate;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.Nullable;

public class TrackNearestTargetGoal<T extends LivingEntity>
extends NearestAttackableTargetGoal<T> {
    protected final ActionableEntity actionableMob;
    protected final Predicate<LivingEntity> selector;
    protected int lostTargetTicks;

    public TrackNearestTargetGoal(ActionableEntity pMob, Class<T> pTargetType, boolean pMustSee) {
        this(pMob, pTargetType, 10, pMustSee, false, null);
    }

    public TrackNearestTargetGoal(ActionableEntity mob, Class<T> targetType, boolean mustSee, Predicate<LivingEntity> targetPredicate) {
        this(mob, targetType, 10, mustSee, false, targetPredicate);
    }

    public TrackNearestTargetGoal(ActionableEntity pMob, Class<T> pTargetType, boolean pMustSee, boolean pMustReach) {
        this(pMob, pTargetType, 10, pMustSee, pMustReach, null);
    }

    public TrackNearestTargetGoal(ActionableEntity pMob, Class<T> pTargetType, int pRandomInterval, boolean pMustSee, boolean pMustReach, @Nullable Predicate<LivingEntity> pTargetPredicate) {
        super((Mob)pMob, pTargetType, pRandomInterval, pMustSee, pMustReach, pTargetPredicate);
        this.actionableMob = pMob;
        this.selector = pTargetPredicate;
    }

    public boolean m_183429_() {
        return true;
    }

    public boolean m_8045_() {
        LivingEntity target = this.f_26135_.m_5448_();
        if (this.f_26137_ != null && this.f_26137_.m_146910_()) {
            this.f_26137_ = null;
        }
        if (target == null) {
            target = this.f_26137_;
        }
        if (target == null) {
            return false;
        }
        if (!this.f_26135_.m_6779_(target)) {
            return false;
        }
        Team team = this.f_26135_.m_5647_();
        Team team1 = target.m_5647_();
        if (team != null && team1 == team) {
            return false;
        }
        double dist = this.m_7623_();
        if (this.f_26135_.m_20280_((Entity)target) > dist * dist) {
            return false;
        }
        if (this.f_26136_ && !this.f_26135_.m_21574_().m_148306_((Entity)target) && !this.actionableMob.getAudioSensing().hasHeard((Entity)target)) {
            ++this.lostTargetTicks;
            if (this.lostTargetTicks >= 20) {
                return false;
            }
        } else {
            this.lostTargetTicks = 0;
        }
        this.f_26135_.m_6710_(target);
        return true;
    }

    public boolean m_8036_() {
        double distSqrMin = Double.MAX_VALUE;
        this.f_26050_ = null;
        for (Entity entity : this.actionableMob.getAudioSensing().getHeardEntities()) {
            if (!(entity instanceof LivingEntity)) continue;
            LivingEntity livingEntity = (LivingEntity)entity;
            double distSqr = this.f_26135_.m_20280_(entity);
            if (!(distSqr < distSqrMin)) continue;
            distSqrMin = distSqr;
            this.f_26050_ = livingEntity;
        }
        if (this.f_26050_ != null) {
            return true;
        }
        return super.m_8036_();
    }

    protected void m_26073_() {
        this.f_26051_ = TargetingConditions.m_148352_().m_26883_(this.m_7623_()).m_26888_(this.selector);
        super.m_26073_();
    }

    public void m_8056_() {
        this.lostTargetTicks = 0;
        super.m_8056_();
    }

    public void m_8041_() {
        if (this.f_26050_.m_6084_()) {
            this.actionableMob.lastTargetPos = this.f_26050_.m_142538_();
        }
        super.m_8041_();
    }
}

