/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.ai.pathfinding;

import frostnox.nightfall.entity.ai.pathfinding.EntityNavigator;
import frostnox.nightfall.entity.ai.pathfinding.Node;
import frostnox.nightfall.entity.ai.pathfinding.NodeManager;
import frostnox.nightfall.entity.ai.pathfinding.NodeType;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.world.EntityPathNavigationRegion;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ActionableMoveControl
extends MoveControl {
    protected final ActionableEntity entity;
    protected long lastJumpTime = -100L;
    @Nullable
    protected PathNavigationRegion region;
    protected int regionMinX;
    protected int regionMaxX;
    protected int regionMinZ;
    protected int regionMaxZ;

    public ActionableMoveControl(ActionableEntity entity) {
        super((Mob)entity);
        this.entity = entity;
    }

    protected void setSpeed(float lookAngle) {
        if (Math.abs(lookAngle - this.f_24974_.m_146908_()) < 20.0f) {
            this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)));
        } else {
            this.f_24974_.m_7910_((float)(this.f_24978_ * this.f_24974_.m_21133_(Attributes.f_22279_)) * 0.2f);
        }
    }

    public void m_8126_() {
        if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
            this.f_24981_ = MoveControl.Operation.WAIT;
            Node node = this.entity.getNavigator().getCurrentNode();
            if (node == null) {
                return;
            }
            double dX = this.f_24975_ - this.f_24974_.m_20185_();
            double dZ = this.f_24977_ - this.f_24974_.m_20189_();
            double dY = this.f_24976_ - this.f_24974_.m_20186_();
            this.f_24974_.m_21564_(0.0f);
            this.f_24974_.m_21570_(0.0f);
            if (dX * dX + dY * dY + dZ * dZ < 0.0015) {
                return;
            }
            float lookAngle = MathUtil.getAngleDegrees(dZ, dX);
            this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), lookAngle, 90.0f));
            this.setSpeed(lookAngle);
            BlockPos pos = this.f_24974_.m_142538_();
            BlockState inState = this.f_24974_.f_19853_.m_8055_(pos);
            VoxelShape inShape = inState.m_60812_((BlockGetter)this.f_24974_.f_19853_, pos);
            if (dY > (double)this.f_24974_.getStepHeight() && Math.abs(lookAngle - this.f_24974_.m_146908_()) < 20.0f) {
                double bestDistSqr = Double.POSITIVE_INFINITY;
                AABB entityBox = this.entity.m_142469_();
                if (this.entity.m_20205_() < 1.0f) {
                    for (AABB box : node.floorShape) {
                        double z2;
                        double x2;
                        double z1;
                        double x1 = Math.max(0.0, entityBox.f_82288_ - box.f_82291_);
                        double distSqr = x1 * x1 + (z1 = Math.max(0.0, entityBox.f_82290_ - box.f_82293_)) * z1 + (x2 = Math.max(0.0, box.f_82288_ - entityBox.f_82291_)) * x2 + (z2 = Math.max(0.0, box.f_82290_ - entityBox.f_82293_)) * z2;
                        if (!(distSqr < bestDistSqr)) continue;
                        bestDistSqr = distSqr;
                    }
                } else {
                    bestDistSqr = dX * dX + dZ * dZ - (double)((this.entity.m_20205_() - 1.0f) * (this.entity.m_20205_() - 1.0f) / 2.0f);
                }
                if (!(!(bestDistSqr < (double)(this.f_24974_.m_6113_() * this.f_24974_.m_6113_())) && (inShape.m_83281_() || !(this.f_24974_.m_20186_() < inShape.m_83297_(Direction.Axis.Y) + (double)pos.m_123342_()) || inState.m_204336_(BlockTags.f_13103_) || inState.collisionExtendsVertically((BlockGetter)this.f_24974_.f_19853_, pos, (Entity)this.f_24974_) || !Shapes.m_83157_((VoxelShape)inShape, (VoxelShape)Shapes.m_83064_((AABB)entityBox), (BooleanOp)BooleanOp.f_82689_) || node.mineable && inState.m_60767_().m_76334_()) || this.entity.f_19853_.m_46467_() <= this.lastJumpTime + 14L)) {
                    this.f_24974_.m_21569_().m_24901_();
                    this.f_24981_ = MoveControl.Operation.JUMPING;
                    this.lastJumpTime = this.entity.f_19853_.m_46467_();
                }
            }
        } else if (this.f_24981_ == MoveControl.Operation.JUMPING) {
            this.setSpeed(MathUtil.getAngleDegrees(this.f_24977_ - this.f_24974_.m_20189_(), this.f_24975_ - this.f_24974_.m_20185_()));
            if (this.f_24974_.m_20096_() || this.f_24974_.m_20069_() || this.f_24974_.m_20077_()) {
                this.f_24981_ = MoveControl.Operation.WAIT;
            }
        } else {
            super.m_8126_();
        }
    }

    protected boolean m_24996_(float pRelativeX, float pRelativeZ) {
        NodeManager nodeManager;
        EntityNavigator navigator = this.entity.getNavigator();
        if (navigator != null && (nodeManager = navigator.nodeManager) != null) {
            int y = this.f_24974_.m_146904_();
            if (this.entity.f_19853_.m_151562_(y)) {
                return false;
            }
            int x = Mth.m_14107_((double)(this.f_24974_.m_20185_() + (double)pRelativeX));
            int z = Mth.m_14107_((double)(this.f_24974_.m_20189_() + (double)pRelativeZ));
            int chunkX = SectionPos.m_123171_((int)x);
            int chunkZ = SectionPos.m_123171_((int)z);
            if (this.region == null || chunkX < this.regionMinX || chunkX > this.regionMaxX || chunkZ < this.regionMinZ || chunkZ > this.regionMaxZ) {
                this.regionMinX = SectionPos.m_123171_((int)(x - 8));
                this.regionMaxX = SectionPos.m_123171_((int)(x + 8));
                this.regionMinZ = SectionPos.m_123171_((int)(z - 8));
                this.regionMaxZ = SectionPos.m_123171_((int)(z + 8));
                this.region = new EntityPathNavigationRegion(this.entity.f_19853_, new BlockPos(x - 8, y - 8, z - 8), new BlockPos(x + 8, y + 8, z + 8));
            }
            nodeManager.setupPath(this.region);
            nodeManager.canMine = false;
            nodeManager.canBuild = false;
            if (nodeManager.getSingleNodeType((BlockGetter)this.f_24974_.f_19853_, x, y, z) != NodeType.WALKABLE) {
                nodeManager.cleanupPath();
                return false;
            }
            nodeManager.cleanupPath();
        }
        return true;
    }
}

