/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.ai.pathfinding;

import frostnox.nightfall.entity.ai.pathfinding.Node;
import frostnox.nightfall.entity.ai.pathfinding.NodeManager;
import frostnox.nightfall.entity.ai.pathfinding.ReversePath;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.world.EntityPathNavigationRegion;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.profiling.metrics.MetricCategory;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.NodeEvaluator;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.PathFinder;
import net.minecraft.world.phys.Vec3;

public abstract class EntityNavigator
extends PathNavigation {
    public final ActionableEntity entity;
    public final NodeManager nodeManager;
    @Nullable
    protected ReversePath activePath;
    protected float pathAccuracy;
    protected float maxNodeCost;
    @Nullable
    protected BlockPos activeGoalPos;
    @Nullable
    protected Entity cachedTarget;
    protected double lastActiveX;
    protected double lastActiveZ;
    protected int stuckTicks = 0;

    public EntityNavigator(NodeManager nodeManager, Level level) {
        super((Mob)nodeManager.entity, level);
        this.entity = nodeManager.entity;
        this.nodeManager = nodeManager;
        this.lastActiveX = this.entity.m_20185_();
        this.lastActiveZ = this.entity.m_20189_();
    }

    protected abstract float heuristic(Node var1, Node var2);

    protected boolean isGoalInvalid(Node goal) {
        return false;
    }

    @Nullable
    public ReversePath getActivePath() {
        return this.activePath;
    }

    public void m_7638_() {
        ++this.f_26498_;
        if (this.f_26506_) {
            this.m_26569_();
        }
        if (!this.m_26571_()) {
            if (this.m_7632_()) {
                this.updatePath();
            }
            if (!this.m_26571_()) {
                Vec3 pathPos = this.activePath.getCurrentNode().getPathPos();
                this.f_26494_.m_21566_().m_6849_(pathPos.f_82479_, pathPos.f_82480_, pathPos.f_82481_, this.f_26497_);
                this.lastActiveX = this.f_26494_.m_20185_();
                this.lastActiveZ = this.f_26494_.m_20189_();
            }
        } else {
            this.stuckTicks = 0;
        }
    }

    public boolean m_26571_() {
        return this.activePath == null || !this.activePath.isActive();
    }

    public void m_26573_() {
        this.activePath = null;
        this.activeGoalPos = null;
    }

    public boolean m_200903_(BlockPos pos) {
        if (this.f_26506_) {
            return false;
        }
        if (this.activePath != null && this.activePath.isActive()) {
            Node node = this.activePath.getEndNode();
            Vec3 averagePos = new Vec3(((double)node.pathX + this.f_26494_.m_20185_()) / 2.0, ((double)node.pathY + this.f_26494_.m_20186_()) / 2.0, ((double)node.pathZ + this.f_26494_.m_20189_()) / 2.0);
            return pos.m_203195_((Position)averagePos, (double)this.activePath.getIndex());
        }
        return false;
    }

    public void m_26569_() {
        if (this.f_26495_.m_46467_() - this.f_26507_ > 15L) {
            if (this.activePath != null) {
                this.activePath = this.findPath(this.activePath.getEndNode().blockPos, this.pathAccuracy);
                this.f_26507_ = this.f_26495_.m_46467_();
                this.f_26506_ = false;
            }
        } else {
            this.f_26506_ = true;
        }
    }

    protected void updatePath() {
        this.f_26505_ = this.entity.getNavigatorWaypointDist() * (float)this.f_26497_;
        Node node = this.activePath.getCurrentNode();
        if (Math.abs(this.lastActiveX - this.f_26494_.m_20185_()) < 0.001 && Math.abs(this.lastActiveZ - this.f_26494_.m_20189_()) < 0.001) {
            ++this.stuckTicks;
            if (this.stuckTicks > 40) {
                this.m_26569_();
                this.stuckTicks = 0;
                return;
            }
        }
        Vec3 mobPos = this.m_7475_();
        if (mobPos.f_82480_ > (double)node.pathY || Math.abs(mobPos.f_82480_ - (double)node.pathY) < (double)this.f_26494_.getStepHeight()) {
            double dX = Math.abs(mobPos.f_82479_ - (double)node.pathX);
            double dZ = Math.abs(mobPos.f_82481_ - (double)node.pathZ);
            if (dX <= (double)this.f_26505_ && dZ <= (double)this.f_26505_) {
                this.activePath.advanceIndex();
            }
        }
    }

    protected void m_6804_() {
    }

    public boolean m_26576_() {
        return this.nodeManager.canSwim;
    }

    public boolean m_6342_(BlockPos pos) {
        BlockPos belowPos = pos.m_7495_();
        BlockState state = this.f_26495_.m_8055_(belowPos);
        return state.m_60804_((BlockGetter)this.f_26495_, belowPos) || !state.m_60819_().m_76178_();
    }

    public boolean m_26519_(double x, double pY, double z, double pSpeed) {
        return this.moveTo(x, pY, z, pSpeed, 1);
    }

    public boolean m_5624_(Entity pEntity, double pSpeed) {
        return this.moveTo(pEntity, pSpeed, 1);
    }

    public boolean moveTo(double x, double pY, double z, double pSpeed, int accuracy) {
        return this.moveTo(this.findPath(x, pY, z, accuracy), pSpeed);
    }

    public boolean moveTo(Entity pEntity, double pSpeed, int accuracy) {
        ReversePath path = this.findPath(pEntity, (float)accuracy);
        return path != null && this.moveTo(path, pSpeed);
    }

    public boolean moveTo(@Nullable ReversePath path, double pSpeed) {
        if (path == null) {
            this.activePath = null;
            return false;
        }
        this.activePath = path;
        if (this.m_26571_()) {
            return false;
        }
        this.m_6804_();
        if (this.activePath.getSize() <= 0) {
            return false;
        }
        this.f_26497_ = pSpeed;
        return true;
    }

    @Nullable
    public Node getCurrentNode() {
        if (this.m_26571_()) {
            return null;
        }
        return this.activePath.getCurrentNode();
    }

    @Nullable
    public Node getNextNode() {
        if (this.m_26571_() || this.activePath.getIndex() < 1) {
            return null;
        }
        return this.activePath.getNode(this.activePath.getIndex() - 1);
    }

    @Nullable
    public ReversePath findPath(double x, double y, double z, float accuracy) {
        return this.findPath(new BlockPos(x, y, z), accuracy);
    }

    @Nullable
    public ReversePath findPath(BlockPos goalPos, float accuracy) {
        return this.findPath(goalPos, null, 8, (float)this.f_26494_.m_21133_(Attributes.f_22277_), false, accuracy);
    }

    @Nullable
    public ReversePath findPath(Entity goal, float accuracy) {
        return this.findPath(goal.m_142538_(), goal, 16, (float)this.f_26494_.m_21133_(Attributes.f_22277_), true, accuracy);
    }

    @Nullable
    public ReversePath findPath(BlockPos goalPos, @Nullable Entity target, int regionOffset, float regionRange, boolean offsetUp, float accuracy) {
        if (this.f_26494_.m_20186_() < (double)this.f_26495_.m_141937_() || !this.m_7632_()) {
            return null;
        }
        this.f_26495_.m_46473_().m_6180_("pathfind");
        BlockPos pos = offsetUp ? this.f_26494_.m_142538_().m_7494_() : this.f_26494_.m_142538_();
        int i = (int)(regionRange + (float)regionOffset);
        EntityPathNavigationRegion region = new EntityPathNavigationRegion(this.f_26495_, pos.m_142082_(-i, -i, -i), pos.m_142082_(i, i, i));
        this.nodeManager.setupPath(region);
        this.cachedTarget = target;
        this.maxNodeCost = this.entity.getMaxNodeCost();
        ReversePath path = this.findPath(region.m_151625_(), goalPos, accuracy);
        this.cachedTarget = null;
        this.nodeManager.cleanupPath();
        this.f_26495_.m_46473_().m_7238_();
        if (path != null && path.reachesGoal()) {
            Node endNode = path.getEndNode();
            this.activeGoalPos = new BlockPos(endNode.x, endNode.y, endNode.z);
            this.pathAccuracy = accuracy;
            this.m_26565_();
        }
        return path;
    }

    protected ReversePath findPath(ProfilerFiller profiler, BlockPos goalPos, float accuracy) {
        profiler.m_6180_("find_path");
        profiler.m_142259_(MetricCategory.PATH_FINDING);
        Node start = this.nodeManager.getStartNode();
        Node goal = this.nodeManager.getGoalNode(goalPos, this.cachedTarget);
        BinaryHeap openSet = new BinaryHeap(128);
        start.totalCost = start.goalCost = this.heuristic(start, goal);
        if (this.isGoalInvalid(goal)) {
            return new ReversePath(start, false);
        }
        Node bestNode = start;
        openSet.push(start);
        int visits = 0;
        Node[] neighbors = new Node[32];
        while (!openSet.isEmpty() && ++visits < 512) {
            Node current = openSet.pop();
            current.closed = true;
            if (current.distOctile(goal) <= accuracy) {
                profiler.m_7238_();
                return new ReversePath(current, true);
            }
            if (current.totalCost > this.maxNodeCost) continue;
            int neighborsSize = this.nodeManager.findNeighbors(current, neighbors);
            for (int i = 0; i < neighborsSize; ++i) {
                Node neighbor = neighbors[i];
                float newAccumulatedCost = current.accumulatedCost + this.heuristic(neighbor, current) + neighbor.terrainCost;
                if (neighbor.inOpenSet() && !(newAccumulatedCost < neighbor.accumulatedCost)) continue;
                neighbor.prev = current;
                neighbor.accumulatedCost = newAccumulatedCost;
                neighbor.goalCost = this.heuristic(neighbor, goal);
                if (neighbor.inOpenSet()) {
                    openSet.modifyValue(neighbor, newAccumulatedCost + neighbor.goalCost);
                } else {
                    neighbor.totalCost = newAccumulatedCost + neighbor.goalCost;
                    openSet.push(neighbor);
                }
                if (!(neighbor.totalCost <= this.maxNodeCost) || !(neighbor.goalCost < bestNode.goalCost)) continue;
                bestNode = neighbor;
            }
        }
        profiler.m_7238_();
        return new ReversePath(bestNode, false);
    }

    @Nullable
    @Deprecated
    protected PathFinder m_5532_(int p_26531_) {
        return null;
    }

    @Nullable
    @Deprecated
    protected Path m_148222_(Set<BlockPos> p_148223_, int p_148224_, boolean p_148225_, int p_148226_, float p_148227_) {
        return null;
    }

    @Nullable
    @Deprecated
    public Path m_26556_(Stream<BlockPos> pTargets, int pAccuracy) {
        return null;
    }

    @Nullable
    @Deprecated
    public Path m_26548_(Set<BlockPos> pPositions, int pDistance) {
        return null;
    }

    @Nullable
    @Deprecated
    public Path m_7864_(BlockPos pos, int pAccuracy) {
        return null;
    }

    @Nullable
    @Deprecated
    public Path m_148218_(BlockPos p_148219_, int p_148220_, int p_148221_) {
        return null;
    }

    @Nullable
    @Deprecated
    public Path m_6570_(Entity p_26534_, int p_26535_) {
        return null;
    }

    @Nullable
    @Deprecated
    public Path m_26570_() {
        return null;
    }

    @Nullable
    @Deprecated
    public NodeEvaluator m_26575_() {
        return null;
    }

    @Deprecated
    public void m_7008_(boolean pCanSwim) {
    }

    private static class BinaryHeap {
        private Node[] heap;
        private int size;

        BinaryHeap(int capacity) {
            this.heap = new Node[capacity];
            this.size = 0;
        }

        public boolean isEmpty() {
            return this.size == 0;
        }

        public void push(Node data) {
            if (this.size == this.heap.length) {
                Node[] temp = new Node[this.size << 1];
                System.arraycopy(this.heap, 0, temp, 0, this.size);
                this.heap = temp;
            }
            this.heap[this.size] = data;
            data.heapIndex = this.size;
            this.upHeapify(this.size);
            ++this.size;
        }

        public Node pop() {
            Node minNode = this.heap[0];
            minNode.heapIndex = -1;
            --this.size;
            this.heap[0] = this.heap[this.size];
            this.heap[0].heapIndex = 0;
            this.heap[this.size] = null;
            if (this.size > 0) {
                this.downHeapify(0);
            }
            return minNode;
        }

        public void modifyValue(Node node, float totalCost) {
            float oldTotalCost = node.totalCost;
            node.totalCost = totalCost;
            if (oldTotalCost > totalCost) {
                this.upHeapify(node.heapIndex);
            } else {
                this.downHeapify(node.heapIndex);
            }
        }

        private void downHeapify(int pIndex) {
            float rf;
            Node rChild;
            int lIndex = (pIndex << 1) + 1;
            int rIndex = lIndex + 1;
            if (lIndex >= this.size) {
                return;
            }
            Node lChild = this.heap[lIndex];
            float lf = lChild.totalCost;
            if (rIndex >= this.size) {
                rChild = null;
                rf = Float.POSITIVE_INFINITY;
            } else {
                rChild = this.heap[rIndex];
                rf = rChild.totalCost;
            }
            Node parent = this.heap[pIndex];
            if (lf < rf) {
                if (parent.totalCost < lf) {
                    return;
                }
                parent.heapIndex = lIndex;
                lChild.heapIndex = pIndex;
                this.heap[pIndex] = lChild;
                this.heap[lIndex] = parent;
                this.downHeapify(lIndex);
            } else {
                if (parent.totalCost < rf) {
                    return;
                }
                parent.heapIndex = rIndex;
                rChild.heapIndex = pIndex;
                this.heap[pIndex] = rChild;
                this.heap[rIndex] = parent;
                this.downHeapify(rIndex);
            }
        }

        private void upHeapify(int cIndex) {
            int pIndex = cIndex - 1 >> 1;
            while (cIndex != 0) {
                Node child = this.heap[cIndex];
                Node parent = this.heap[pIndex];
                if (!(child.totalCost < parent.totalCost)) break;
                parent.heapIndex = cIndex;
                child.heapIndex = pIndex;
                this.heap[cIndex] = parent;
                this.heap[pIndex] = child;
                cIndex = pIndex;
                pIndex = pIndex - 1 >> 1;
            }
        }
    }
}

