/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.ai.pathfinding;

import frostnox.nightfall.block.ICustomPathfindable;
import frostnox.nightfall.entity.ai.pathfinding.Node;
import frostnox.nightfall.entity.ai.pathfinding.NodeManager;
import frostnox.nightfall.entity.ai.pathfinding.NodeType;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.util.LevelUtil;
import frostnox.nightfall.util.data.Vec2f;
import frostnox.nightfall.util.math.OctalDirection;
import it.unimi.dsi.fastutil.floats.Float2FloatMap;
import it.unimi.dsi.fastutil.floats.Float2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArraySet;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.ForgeMod;

public class LandNodeManager
extends NodeManager {
    protected static final float DRAG = 0.02f;
    protected static final float JUMP_SCALE = 0.97f;
    protected static final float ONE_MINUS_DRAG = 0.98f;
    protected static final double LOG_ONE_MINUS_DRAG = Math.log(0.98f);
    protected final Float2FloatMap jumpHeights = new Float2FloatOpenHashMap(4);

    public LandNodeManager(ActionableEntity entity) {
        super(entity, PathComputationType.LAND);
    }

    protected float calculateJumpHeight(float jumpFactor) {
        double v = (double)(this.entity.getBaseJumpPower() * jumpFactor) + this.entity.m_182332_();
        double g = this.entity.m_21133_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
        double t = v * (double)0.02f + (g *= (double)0.98f);
        t = g / t;
        t = Math.ceil(Math.log(t) / LOG_ONE_MINUS_DRAG);
        return (float)(((v * (double)0.02f + g) * (1.0 - Math.pow(0.98f, t)) / (double)0.02f - g * t) / (double)0.02f) * 0.97f;
    }

    @Override
    protected void cleanupPath() {
        super.cleanupPath();
        this.jumpHeights.clear();
    }

    @Override
    public NodeType getFullNodeType(BlockGetter level, int x, int y, int z, ActionableEntity entity) {
        EnumSet<NodeType> typeSet = EnumSet.noneOf(NodeType.class);
        BlockPos.MutableBlockPos tempPos = new BlockPos.MutableBlockPos();
        tempPos.m_142448_(y - 1);
        for (int xI = -(this.scanWidth - 1); xI < this.scanWidth; ++xI) {
            int xC = x + xI;
            tempPos.m_142451_(xC);
            for (int zI = -(this.scanWidth - 1); zI < this.scanWidth; ++zI) {
                int j;
                ICustomPathfindable pathfindable;
                int zC = z + zI;
                tempPos.m_142443_(zC);
                BlockState lastState = level.m_8055_((BlockPos)tempPos);
                Block block = lastState.m_60734_();
                ICustomPathfindable lastPathfindable = block instanceof ICustomPathfindable ? (pathfindable = (ICustomPathfindable)block) : null;
                float partialX = 0.5f;
                float partialZ = 0.5f;
                int alignmentIndex = 0;
                int partialIndex = 0;
                int mineableIndex = 0;
                for (j = 0; j < this.scanHeight; ++j) {
                    int yC = y + j;
                    Node columnNode = this.getNode(xC, yC, zC);
                    NodeType columnType = this.getSingleNodeType(level, xC, yC, zC);
                    boolean shift = false;
                    if (columnType.walkable && columnType != NodeType.BUILDABLE_WALKABLE) {
                        if (lastPathfindable != null) {
                            List<AABB> boxes = lastPathfindable.getTopFaceShape(lastState);
                            float xPartial = Math.abs(columnNode.getXPartial());
                            float zPartial = Math.abs(columnNode.getZPartial());
                            shift = true;
                            for (AABB box : boxes) {
                                if (!((double)xPartial >= box.f_82288_) || !((double)xPartial <= box.f_82291_) || !((double)zPartial >= box.f_82290_) || !((double)zPartial <= box.f_82293_)) continue;
                                shift = false;
                                break;
                            }
                            if (shift) {
                                OctalDirection moveDirection = lastPathfindable.getDirection(lastState);
                                columnNode.pathX = Mth.m_14036_((float)(columnNode.pathX + moveDirection.xStepHalf), (float)columnNode.x, (float)(columnNode.x + 1));
                                columnNode.pathZ = Mth.m_14036_((float)(columnNode.pathZ + moveDirection.zStepHalf), (float)columnNode.z, (float)(columnNode.z + 1));
                            }
                        } else if (columnNode.getYPartial() == 0.0f && !lastState.m_60767_().m_76334_()) {
                            columnType = NodeType.OPEN;
                        }
                        if (j > 0) {
                            columnType = NodeType.OPEN;
                        }
                    }
                    if (columnNode.partial && !shift) {
                        partialX = columnNode.pathX;
                        partialZ = columnNode.pathZ;
                        alignmentIndex = j;
                    }
                    typeSet.add(columnType);
                    if (columnNode.partial) {
                        partialIndex = j;
                    }
                    if (columnNode.mineable) {
                        mineableIndex = j;
                    }
                    lastState = columnNode.state;
                    lastPathfindable = columnNode.pathfindable;
                }
                for (j = 0; j < this.scanHeight; ++j) {
                    Node node = this.getNode(xC, y + j, zC);
                    if (j < partialIndex) {
                        node.partial = true;
                    }
                    if (j < mineableIndex) {
                        node.mineable = true;
                    }
                    if (j >= alignmentIndex) continue;
                    node.pathX = partialX;
                    node.pathZ = partialZ;
                }
            }
        }
        NodeType worstType = NodeType.CLOSED;
        if (typeSet.contains((Object)NodeType.BUILDABLE_WALKABLE) && typeSet.contains((Object)NodeType.WALKABLE)) {
            typeSet.remove((Object)NodeType.BUILDABLE_WALKABLE);
        }
        for (NodeType type : typeSet) {
            if (type.cost < 0.0f) {
                return type;
            }
            if (!(type.cost >= worstType.cost)) continue;
            worstType = type;
        }
        return worstType;
    }

    @Override
    public NodeType getSingleNodeType(BlockGetter level, int x, int y, int z) {
        boolean openFloor;
        float destroySpeed;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        Node node = this.getNode(x, y, z);
        NodeType type = this.getRawNodeType(level, (BlockPos)pos, node, OctalDirection.CENTER);
        if (this.canMine && type.blocksMovement && (destroySpeed = node.state.m_60800_((BlockGetter)this.region, (BlockPos)pos)) >= 0.0f) {
            node.mineable = true;
            node.pathX = (float)x + 0.5f;
            node.pathY = y;
            node.pathZ = (float)z + 0.5f;
            node.terrainCost = Math.max(2.0f, destroySpeed);
        }
        Node belowNode = this.getNode((BlockPos)pos.m_122178_(x, y - 1, z));
        if (belowNode.state.collisionExtendsVertically(level, (BlockPos)pos, (Entity)this.entity)) {
            node.pathY = Math.max(node.pathY, (float)y + 0.5f);
            openFloor = node.getYPartial() == 0.5f;
        } else {
            boolean bl = openFloor = node.getYPartial() == 0.0f;
        }
        if (!type.blocksMovement && y > level.m_141937_() && openFloor) {
            NodeType belowType = this.getRawNodeType(level, (BlockPos)pos.m_122178_(x, y - 1, z), this.getNode((BlockPos)pos), OctalDirection.DOWN);
            if (belowType.inDanger) {
                type = belowType;
            } else if (type == NodeType.OPEN_OR_WALKABLE) {
                if (!node.partial && belowType.blocksMovement && level.m_8055_((BlockPos)pos.m_122178_(x, y + 1, z)).m_60767_().m_76334_() && this.collidesWith(this.getEntityBox(node.pathX, node.pathY, node.pathZ))) {
                    type = NodeType.CLOSED;
                } else {
                    NodeType nodeType = belowType.blocksMovement ? NodeType.WALKABLE : (type = this.canBuild ? NodeType.BUILDABLE_WALKABLE : NodeType.OPEN);
                }
            }
        }
        if (type.walkable) {
            float speedFactor;
            if (!type.inDanger) {
                type = this.adjustNodeByNeighbors(type, pos.m_122178_(x, y, z));
            }
            if (openFloor && belowNode.pathfindable != null) {
                node.setFloor(belowNode.pathfindable.getTopFaceShape(belowNode.state));
            }
            if (type.walkable && (speedFactor = (double)Math.abs(node.getYPartial()) > 0.0625 ? node.state.m_60734_().m_49964_() : belowNode.state.m_60734_().m_49964_()) != 1.0f) {
                node.terrainCost = (node.terrainCost + 1.0f - speedFactor) * 4.0f;
            }
        }
        return type;
    }

    @Override
    public Node getStartNode() {
        BlockPos.MutableBlockPos pos;
        int y;
        block16: {
            boolean inFluid;
            y = this.entity.m_146904_();
            pos = new BlockPos.MutableBlockPos(this.entity.m_20185_(), (double)y, this.entity.m_20189_());
            BlockState state = this.region.m_8055_((BlockPos)pos);
            boolean bl = inFluid = this.entity.m_20069_() || this.entity.m_20077_();
            if (this.canSwim && inFluid) {
                while (true) {
                    if (state.m_60819_().m_76178_() || this.collidesWith(this.getEntityBox(this.entity.m_20185_(), y, this.entity.m_20189_()))) {
                        --y;
                        break block16;
                    }
                    state = this.region.m_8055_((BlockPos)pos.m_142448_(++y));
                }
            }
            if (!this.entity.m_20096_() && !inFluid) {
                FluidState fluid = this.region.m_6425_((BlockPos)pos.m_142448_(y));
                while (true) {
                    if (!fluid.m_76178_() || this.collidesWith(this.getEntityBox(this.entity.m_20185_(), y, this.entity.m_20189_())) || y < this.region.m_141937_()) {
                        ++y;
                        break;
                    }
                    fluid = this.region.m_6425_((BlockPos)pos.m_142448_(--y));
                }
            }
        }
        BlockPos blockPos = this.entity.m_142538_();
        NodeType startType = this.getCachedNodeType((BlockPos)pos.m_122178_(blockPos.m_123341_(), y, blockPos.m_123343_()));
        Node node = this.getNode((BlockPos)pos);
        if (!startType.walkable || !this.canReachWithoutCollision((Entity)this.entity, new Vec2f(node.pathX, node.pathZ))) {
            AABB box = this.entity.m_142469_();
            double boxWidth = Math.abs(box.f_82291_ - box.f_82288_);
            if (boxWidth < 0.5) {
                box = box.m_82377_(0.5 - boxWidth, 0.0, 0.5 - boxWidth);
            }
            BlockPos bestPos = LevelUtil.NULL_POS;
            ObjectArraySet positions = ObjectArraySet.of((Object)pos.m_122032_());
            if (!positions.contains((Object)pos.m_122169_(box.f_82288_, (double)y, box.f_82290_))) {
                positions.add((Object)pos.m_122032_());
            }
            if (!positions.contains((Object)pos.m_122169_(box.f_82288_, (double)y, box.f_82293_))) {
                positions.add((Object)pos.m_122032_());
            }
            if (!positions.contains((Object)pos.m_122169_(box.f_82291_, (double)y, box.f_82290_))) {
                positions.add((Object)pos.m_122032_());
            }
            if (!positions.contains((Object)pos.m_122169_(box.f_82291_, (double)y, box.f_82293_))) {
                positions.add((Object)pos.m_122032_());
            }
            block2: for (BlockPos.MutableBlockPos cPos : positions) {
                if (this.isWalkable((BlockPos)cPos)) {
                    bestPos = cPos;
                    node = this.typeAndGetNode(bestPos);
                    if (this.canReachWithoutCollision((Entity)this.entity, new Vec2f(node.pathX, node.pathZ))) break;
                }
                for (int i = 1; i < 4; ++i) {
                    cPos.m_142448_(cPos.m_123342_() - 1);
                    if (cPos.m_123342_() <= bestPos.m_123342_()) continue block2;
                    if (!this.isWalkable((BlockPos)cPos)) continue;
                    bestPos = cPos;
                    node = this.typeAndGetNode(bestPos);
                    if (this.canReachWithoutCollision((Entity)this.entity, new Vec2f(node.pathX, node.pathZ))) continue block2;
                }
            }
            if (bestPos != LevelUtil.NULL_POS) {
                node = this.typeAndGetNode(bestPos);
                node.setType(this.getCachedNodeType(bestPos));
                return node;
            }
        }
        node.setType(startType);
        return node;
    }

    @Override
    public Node getGoalNode(BlockPos goalPos, @Nullable Entity target) {
        if (target == null) {
            return this.typeAndGetNode(goalPos);
        }
        BlockPos blockPos = target.m_142538_();
        int y = blockPos.m_123342_();
        NodeType type = this.getCachedNodeType(blockPos.m_123341_(), y, blockPos.m_123343_());
        Node entityNode = this.getNode(blockPos.m_123341_(), y, blockPos.m_123343_());
        if (type.cost < 0.0f || !this.canReachWithoutCollision(target, new Vec2f(entityNode.pathX, entityNode.pathZ))) {
            AABB box = target.m_142469_();
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            if (this.isEnterable(blockPos, (BlockPos)pos.m_122169_(box.f_82288_, (double)y, box.f_82290_)) || this.isEnterable(blockPos, (BlockPos)pos.m_122169_(box.f_82288_, (double)y, box.f_82293_)) || this.isEnterable(blockPos, (BlockPos)pos.m_122169_(box.f_82291_, (double)y, box.f_82290_)) || this.isEnterable(blockPos, (BlockPos)pos.m_122169_(box.f_82291_, (double)y, box.f_82293_))) {
                Node node = this.getNode((BlockPos)pos);
                node.setType(this.getCachedNodeType(node.getBlockPos()));
                return node;
            }
        }
        entityNode.setType(type);
        return entityNode;
    }

    @Override
    protected NodeType getRawNodeType(BlockGetter level, BlockPos pos, Node node, OctalDirection direction) {
        BlockState state = node.state;
        if (this.isOpenType(state)) {
            return NodeType.OPEN_OR_WALKABLE;
        }
        if (state.m_60647_(level, pos, PathComputationType.LAND)) {
            if (node.pathfindable != null) {
                NodeType type = direction == OctalDirection.DOWN ? node.pathfindable.getFloorNodeType(this, state, level, pos) : node.pathfindable.getRawNodeType(this, state, level, pos);
                return this.adjustAndSetNodeByEntity(type, state, pos);
            }
            return this.adjustAndSetNodeByEntity(NodeType.OPEN_OR_WALKABLE, state, pos);
        }
        return this.adjustAndSetNodeByEntity(NodeType.CLOSED, state, pos);
    }

    @Override
    public int findNeighbors(Node startNode, Node[] neighbors) {
        Node nodeDown;
        Node nodeUp;
        Node nodeSE;
        Node nodeSW;
        Node nodeNE;
        Node nodeNW;
        Node nodeN;
        Node nodeE;
        Node nodeW;
        Node nodeS;
        int count = 0;
        int jumpSteps = 0;
        float floor = startNode.pathY;
        float jumpHeight = this.entityStepHeight;
        NodeType type = this.getCachedNodeType(startNode.x, startNode.y, startNode.z);
        NodeType typeAbove = this.getCachedNodeType(startNode.x, startNode.y + 1, startNode.z);
        if (typeAbove.cost >= 0.0f) {
            float jumpFactor = Math.abs((double)floor % 1.0) > 0.0625 ? startNode.state.m_60734_().m_49964_() : this.getNode((int)startNode.x, (int)(startNode.y - 1), (int)startNode.z).state.m_60734_().m_49964_();
            if (!this.jumpHeights.containsKey(jumpFactor)) {
                jumpHeight = this.calculateJumpHeight(jumpFactor);
                this.jumpHeights.put(jumpFactor, jumpHeight);
            } else {
                jumpHeight = this.jumpHeights.get(jumpFactor);
            }
            jumpSteps = Mth.m_14143_((float)(floor % 1.0f + Math.max(jumpHeight, this.entityStepHeight)));
        }
        if (this.isNeighborValid(startNode, nodeS = this.findValidNode(startNode.x, startNode.y, startNode.z + 1, jumpSteps, jumpHeight, floor, OctalDirection.SOUTH, startNode))) {
            neighbors[count++] = nodeS;
        }
        if (this.isNeighborValid(startNode, nodeW = this.findValidNode(startNode.x - 1, startNode.y, startNode.z, jumpSteps, jumpHeight, floor, OctalDirection.WEST, startNode))) {
            neighbors[count++] = nodeW;
        }
        if (this.isNeighborValid(startNode, nodeE = this.findValidNode(startNode.x + 1, startNode.y, startNode.z, jumpSteps, jumpHeight, floor, OctalDirection.EAST, startNode))) {
            neighbors[count++] = nodeE;
        }
        if (this.isNeighborValid(startNode, nodeN = this.findValidNode(startNode.x, startNode.y, startNode.z - 1, jumpSteps, jumpHeight, floor, OctalDirection.NORTH, startNode))) {
            neighbors[count++] = nodeN;
        }
        if (this.canBuild) {
            Node node;
            int y;
            Node[] validNodes = new Node[count];
            System.arraycopy(neighbors, 0, validNodes, 0, count);
            if (typeAbove == NodeType.BUILDABLE_WALKABLE) {
                y = startNode.y + 1;
                for (Node neighbor : validNodes) {
                    if (neighbor.y > startNode.y) continue;
                    node = this.typeAndGetNode(neighbor.x, y, neighbor.z);
                    if (node.type != NodeType.BUILDABLE_WALKABLE || node.closed) continue;
                    neighbors[count++] = node;
                }
            }
            y = startNode.y - 1;
            for (Node neighbor : validNodes) {
                if (neighbor.y > startNode.y || this.getCachedNodeType(neighbor.x, startNode.y, neighbor.z) != NodeType.BUILDABLE_WALKABLE) continue;
                node = this.typeAndGetNode(neighbor.x, y, neighbor.z);
                if (node.type != NodeType.BUILDABLE_WALKABLE || node.closed) continue;
                neighbors[count++] = node;
            }
        }
        if ((nodeNW = this.findValidNode(startNode.x - 1, startNode.y, startNode.z - 1, jumpSteps, jumpHeight, floor, OctalDirection.NORTHWEST, startNode)) != null && this.isDiagonalValid(startNode, nodeNW)) {
            neighbors[count++] = nodeNW;
        }
        if ((nodeNE = this.findValidNode(startNode.x + 1, startNode.y, startNode.z - 1, jumpSteps, jumpHeight, floor, OctalDirection.NORTHEAST, startNode)) != null && this.isDiagonalValid(startNode, nodeNE)) {
            neighbors[count++] = nodeNE;
        }
        if ((nodeSW = this.findValidNode(startNode.x - 1, startNode.y, startNode.z + 1, jumpSteps, jumpHeight, floor, OctalDirection.SOUTHWEST, startNode)) != null && this.isDiagonalValid(startNode, nodeSW)) {
            neighbors[count++] = nodeSW;
        }
        if ((nodeSE = this.findValidNode(startNode.x + 1, startNode.y, startNode.z + 1, jumpSteps, jumpHeight, floor, OctalDirection.SOUTHEAST, startNode)) != null && this.isDiagonalValid(startNode, nodeSE)) {
            neighbors[count++] = nodeSE;
        }
        if (type == NodeType.WALKABLE && startNode.partial && startNode.state.m_60767_().m_76334_()) {
            Node nodeUp2 = this.findValidNode(startNode.x, startNode.y + 1, startNode.z, jumpSteps - 1, jumpHeight, floor, OctalDirection.UP, startNode);
            if (this.isNeighborValid(startNode, nodeUp2)) {
                neighbors[count++] = nodeUp2;
            }
        } else if (startNode.mineable && startNode.prev != null && !startNode.prev.mineable && this.isNeighborValid(startNode, nodeUp = this.findValidNode(startNode.x, startNode.y + 1, startNode.z, 0, jumpHeight, floor, OctalDirection.UP, startNode))) {
            neighbors[count++] = nodeUp;
        }
        if (type.walkable && (!startNode.fullFloor || this.canMine) && (double)floor % 1.0 == 0.0 && this.isNeighborValid(startNode, nodeDown = this.findValidNode(startNode.x, startNode.y - 1, startNode.z, 0, jumpHeight, floor, OctalDirection.DOWN, startNode))) {
            neighbors[count++] = nodeDown;
        }
        return count;
    }

    @Nullable
    protected Node findValidNode(int x, int y, int z, int jumpSteps, float jumpHeight, float fromFloor, OctalDirection dir, Node prev) {
        Node node = null;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        NodeType type = this.getCachedNodeType(x, y, z);
        float cost = type.cost;
        if (cost >= 0.0f) {
            node = this.getNode(x, y, z);
            node.setTypeMaxCost(type);
            if (node.pathY - fromFloor > jumpHeight) {
                return null;
            }
        }
        if (type.walkable && prev.type.walkable && node.y > prev.y && (node.x == prev.x && Math.abs(node.pathZ - prev.pathZ) > 0.5f || node.z == prev.z && Math.abs(node.pathX - prev.pathX) > 0.5f) && this.collidesWith(this.getEntityBox((prev.pathX + node.pathX) / 2.0f, node.pathY, (prev.pathZ + node.pathZ) / 2.0f))) {
            return this.findValidNode(x, y - 1, z, jumpSteps - 1, jumpHeight, fromFloor, dir, prev);
        }
        if (type.walkable && prev.type.walkable && !dir.isVertical() && this.willEntityFall(node, prev, dir)) {
            type = NodeType.OPEN;
            node.setTypeMaxCost(type);
        }
        if (node != null && node.terrainCost >= 0.0f) {
            boolean prevWalkable;
            boolean bl = prevWalkable = prev.type.walkable && prev.partial;
            if (prevWalkable || type.walkable && node.partial) {
                float zC;
                float xC;
                if (prevWalkable) {
                    scale = Math.max(0.5f, Math.max(Math.abs(prev.getXPartial() - 0.5f) * 2.0f, Math.abs(prev.getZPartial() - 0.5f) * 2.0f));
                    xC = dir.isVertical() || Math.abs(dir.xStep * scale) > Math.abs(node.pathX - prev.pathX) ? node.pathX : prev.pathX + dir.xStep * scale;
                    zC = dir.isVertical() || Math.abs(dir.zStep * scale) > Math.abs(node.pathZ - prev.pathZ) ? node.pathZ : prev.pathZ + dir.zStep * scale;
                } else {
                    scale = Math.max(0.5f, Math.max(Math.abs(node.getXPartial() - 0.5f) * 2.0f, Math.abs(node.getZPartial() - 0.5f) * 2.0f));
                    xC = node.pathX - dir.xStep * scale;
                    zC = node.pathZ - dir.zStep * scale;
                }
                if (this.collidesWith(this.getEntityBox(xC, Math.max(prev.pathY, node.pathY), zC))) {
                    if (jumpSteps == 0) {
                        return null;
                    }
                    type = this.getCachedNodeType(x, y + 1, z);
                    if (!type.walkable || this.collidesWith(this.getEntityBox(xC, y + 1, zC))) {
                        return null;
                    }
                    if (type.cost >= 0.0f) {
                        node = this.getNode(x, y + 1, z);
                        if (node.pathY - fromFloor > jumpHeight) {
                            return null;
                        }
                        node.setTypeMaxCost(type);
                    }
                    return node;
                }
            }
        }
        if (node != null && node.mineable && dir != OctalDirection.DOWN) {
            double backZ;
            double backX;
            AABB box;
            Node nodeUp;
            if (jumpSteps > 0 && (nodeUp = this.findValidNode(x, y + 1, z, jumpSteps - 1, jumpHeight, fromFloor, dir, prev)) != null && nodeUp.type.walkable && !nodeUp.mineable && !this.collidesWith(box = new AABB((backX = (double)((float)x - dir.xStep) + 0.5) - (double)this.entityWidthHalf, this.getFloorLevel((BlockPos)pos.m_122169_(backX, (double)(y + 1), backZ = (double)((float)z - dir.zStep) + 0.5)) + 1.001, backZ - (double)this.entityWidthHalf, backX + (double)this.entityWidthHalf, (double)this.entityHeight + this.getFloorLevel((BlockPos)pos.m_122178_(nodeUp.x, nodeUp.y, nodeUp.z)) - 0.002, backZ + (double)this.entityWidthHalf))) {
                node = nodeUp;
            }
        } else if (!type.walkable) {
            if ((node == null || node.terrainCost < 0.0f || node.partial) && jumpSteps > 0 && (node = this.findValidNode(x, y + 1, z, jumpSteps - 1, jumpHeight, fromFloor, dir, prev)) != null && (node.type == NodeType.OPEN || node.type.walkable)) {
                double backZ;
                double backX;
                AABB box;
                type = node.type;
                if (!prev.partial && this.collidesWith(box = new AABB((backX = (double)((float)x - dir.xStep) + 0.5) - (double)this.entityWidthHalf, this.getFloorLevel((BlockPos)pos.m_122169_(backX, (double)(y + 1), backZ = (double)((float)z - dir.zStep) + 0.5)) + 1.001, backZ - (double)this.entityWidthHalf, backX + (double)this.entityWidthHalf, (double)this.entityHeight + this.getFloorLevel((BlockPos)pos.m_122178_(node.x, node.y, node.z)) - 0.002, backZ + (double)this.entityWidthHalf))) {
                    node = null;
                }
            }
            if (type == NodeType.PASSABLE_FLUID && !this.canSwim) {
                if (this.getCachedNodeType(x, y - 1, z) != NodeType.PASSABLE_FLUID) {
                    return node;
                }
                while (y > this.entity.f_19853_.m_141937_()) {
                    if ((type = this.getCachedNodeType(x, --y, z)) != NodeType.PASSABLE_FLUID) {
                        return node;
                    }
                    node = this.getNode(x, y, z);
                    node.setTypeMaxCost(type);
                }
            }
            if (type == NodeType.OPEN) {
                int fallDist = 0;
                int i = y;
                while (type == NodeType.OPEN) {
                    if (--y < this.entity.f_19853_.m_141937_()) {
                        Node minHeightNode = this.getNode(x, i, z);
                        minHeightNode.setType(NodeType.CLOSED);
                        return minHeightNode;
                    }
                    if (fallDist++ >= this.maxFallDistance) {
                        Node maxFallNode = this.getNode(x, y, z);
                        maxFallNode.setType(NodeType.CLOSED);
                        return maxFallNode;
                    }
                    type = this.getCachedNodeType(x, y, z);
                    Node fallNode = this.getNode(x, y, z);
                    if (type == NodeType.OPEN && fallNode.partial) {
                        Node aboveNode = this.getNode(x, y + 1, z);
                        if (aboveNode.partial && (fallNode.getXPartial() != aboveNode.getXPartial() || fallNode.getZPartial() != aboveNode.getZPartial())) {
                            fallNode.setType(NodeType.CLOSED);
                            return fallNode;
                        }
                    }
                    cost = type.cost;
                    if (type != NodeType.OPEN && cost >= 0.0f) {
                        node = this.getNode(x, y, z);
                        node.setTypeMaxCost(type);
                        break;
                    }
                    if (!(cost < 0.0f)) continue;
                    Node closedNode = this.getNode(x, y, z);
                    closedNode.setType(NodeType.CLOSED);
                    return closedNode;
                }
            }
        }
        if (type == NodeType.BUILDABLE_WALKABLE && node != null) {
            for (Node last = node.getPrevious(); last != null; last = last.getPrevious()) {
                if (node.x != last.x || node.z != last.z || last.type != NodeType.BUILDABLE_WALKABLE || node.y - this.scanHeight != prev.y) continue;
                node.setType(NodeType.OPEN);
                return node;
            }
        }
        return node;
    }
}

