/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.ai.pathfinding;

import frostnox.nightfall.block.ICustomPathfindable;
import frostnox.nightfall.entity.ai.pathfinding.NodeType;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;

public class Node {
    private static final float SQRT2 = 1.4142f;
    private static final float SQRT2_MINUS_1 = 0.41419995f;
    private static final float SQRT2_MINUS_2 = -0.58580005f;
    private static final float SQRT3_MINUS_SQRT2 = 0.31785f;
    private static final List<AABB> defaultFloor = Shapes.m_83144_().m_83299_();
    public final int x;
    public final int y;
    public final int z;
    public float pathX;
    public float pathY;
    public float pathZ;
    public float accumulatedCost;
    public float goalCost;
    public float terrainCost;
    public float totalCost;
    public NodeType type = NodeType.CLOSED;
    public boolean partial = false;
    public boolean mineable = false;
    public BlockState state;
    @Nullable
    public ICustomPathfindable pathfindable;
    public List<AABB> floorShape;
    protected boolean fullFloor = true;
    protected final BlockPos blockPos;
    protected boolean closed = false;
    protected int heapIndex = -1;
    @Nullable
    protected Node prev;
    private final int hash;

    public Node(int x, int y, int z, int hash, PathNavigationRegion region) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.pathX = (float)x + 0.5f;
        this.pathY = y;
        this.pathZ = (float)z + 0.5f;
        this.hash = hash;
        this.blockPos = new BlockPos(x, y, z);
        this.floorShape = defaultFloor.stream().map(box -> box.m_82338_(this.blockPos)).collect(Collectors.toList());
        this.state = region.m_8055_(this.blockPos);
        Block block = this.state.m_60734_();
        if (block instanceof ICustomPathfindable) {
            ICustomPathfindable pathfindable;
            this.pathfindable = pathfindable = (ICustomPathfindable)block;
        }
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object object) {
        if (object instanceof Node) {
            Node node = (Node)object;
            return this.hash == node.hash;
        }
        return false;
    }

    public String toString() {
        if (this.state != null) {
            return this.type.toString() + " " + this.state.toString() + " at " + this.pathX + ", " + this.pathY + ", " + this.pathZ;
        }
        return this.type.toString() + " at " + this.pathX + ", " + this.pathY + ", " + this.pathZ;
    }

    public float getXPartial() {
        return this.pathX - (float)this.x;
    }

    public float getYPartial() {
        return this.pathY - (float)this.y;
    }

    public float getZPartial() {
        return this.pathZ - (float)this.z;
    }

    public boolean inOpenSet() {
        return this.heapIndex >= 0;
    }

    public void setType(NodeType type) {
        this.type = type;
        this.terrainCost = type.cost;
    }

    public void setTypeMaxCost(NodeType type) {
        this.type = type;
        if (type.cost > this.terrainCost) {
            this.terrainCost = type.cost;
        }
    }

    public Vec3 getPathPos() {
        return new Vec3((double)this.pathX, (double)this.pathY, (double)this.pathZ);
    }

    public void setPartialPath(float x, float y, float z) {
        this.pathX = x;
        this.pathY = y;
        this.pathZ = z;
        this.partial = true;
    }

    public BlockPos getBlockPos() {
        return this.blockPos;
    }

    @Nullable
    public Node getPrevious() {
        return this.prev;
    }

    public void setFloor(List<AABB> shape) {
        this.floorShape = shape.stream().map(box -> box.m_82338_(this.blockPos)).collect(Collectors.toList());
        this.fullFloor = false;
    }

    public boolean hasFullFloor() {
        return this.fullFloor;
    }

    public float dist(Node node) {
        float dX = this.pathX - node.pathX;
        float dY = this.pathY - node.pathY;
        float dZ = this.pathZ - node.pathZ;
        return (float)Math.sqrt(dX * dX + dY * dY + dZ * dZ);
    }

    public float distManhattan(Node node) {
        float dX = this.pathX - node.pathX;
        float dY = this.pathY - node.pathY;
        float dZ = this.pathZ - node.pathZ;
        return Math.abs(dX) + Math.abs(dY) + Math.abs(dZ);
    }

    public float distChebyshev(Node node) {
        float dX = Math.abs(this.pathX - node.pathX);
        float dY = Math.abs(this.pathY - node.pathY);
        float dZ = Math.abs(this.pathZ - node.pathZ);
        return dX > dZ ? (dX > dY ? dX : dY) : (dZ > dY ? dZ : dY);
    }

    public float distOctile(Node node) {
        float temp;
        float[] fArray = new float[]{Math.abs(this.pathY - node.pathY), Math.abs(this.pathX - node.pathX), Math.abs(this.pathZ - node.pathZ)};
        float[] minToMax = fArray;
        if (minToMax[0] < minToMax[1]) {
            if (minToMax[0] > minToMax[2]) {
                temp = minToMax[2];
                minToMax[2] = minToMax[1];
                minToMax[1] = temp;
            }
        } else if (minToMax[1] < minToMax[2]) {
            temp = minToMax[0];
            minToMax[0] = minToMax[1];
            minToMax[1] = temp;
        } else {
            temp = minToMax[2];
            minToMax[2] = minToMax[0];
            minToMax[0] = temp;
        }
        if (minToMax[2] < minToMax[1]) {
            temp = minToMax[2];
            minToMax[2] = minToMax[1];
            minToMax[1] = temp;
        }
        return 0.31785f * minToMax[0] + 0.41419995f * minToMax[1] + minToMax[2];
    }

    public float horizontalDistOctile(Node node) {
        float dX = Math.abs(this.pathX - node.pathX);
        float dZ = Math.abs(this.pathZ - node.pathZ);
        return dX + dZ + -0.58580005f * Math.min(dX, dZ);
    }

    public float distDiagonalXZ(Node node) {
        float dX = Math.abs(this.x - node.x);
        float dY = Math.abs(this.y - node.y);
        float dZ = Math.abs(this.z - node.z);
        return dX > dZ ? dX - dZ + 1.4142f * dZ + dY : dZ - dX + 1.4142f * dX + dY;
    }
}

