/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.ai.pathfinding;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.entity.ai.pathfinding.Node;
import frostnox.nightfall.entity.ai.pathfinding.NodeType;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.util.DataUtil;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.util.data.Vec2d;
import frostnox.nightfall.util.data.Vec2f;
import frostnox.nightfall.util.math.OctalDirection;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.PathNavigationRegion;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class NodeManager {
    private static final float CHECK_DIST = (float)Math.sqrt(Math.pow(0.0625, 2.0) + Math.pow(0.0625, 2.0));
    public final ActionableEntity entity;
    public final PathComputationType pathType;
    protected final Int2ObjectMap<Node> nodes = new Int2ObjectOpenHashMap();
    protected final Int2ObjectMap<NodeType> types = new Int2ObjectOpenHashMap();
    protected final Object2BooleanMap<AABB> collisions = new Object2BooleanOpenHashMap();
    protected int scanWidth;
    protected int scanHeight;
    protected int maxFallDistance;
    protected float entityWidthHalf;
    protected float entityWidthSqr;
    protected float entityHeight;
    protected float entityStepHeight;
    protected float entityWidthDiagonalSqr;
    public boolean canSwim;
    public boolean canMine;
    public boolean canBuild;
    protected PathNavigationRegion region;

    public NodeManager(ActionableEntity entity, PathComputationType pathType) {
        this.entity = entity;
        this.pathType = pathType;
        this.canSwim = true;
    }

    protected void setupPath(PathNavigationRegion region) {
        this.region = region;
        this.nodes.clear();
        this.entityWidthHalf = this.entity.m_20205_() / 2.0f;
        this.entityHeight = this.entity.m_20206_();
        this.entityWidthSqr = this.entity.m_20205_() * this.entity.m_20205_();
        this.entityWidthDiagonalSqr = this.entityWidthSqr + this.entityWidthSqr;
        this.entityStepHeight = this.entity.getStepHeight();
        this.scanWidth = Mth.m_14143_((float)(this.entity.m_20205_() + 0.999f));
        this.scanHeight = Mth.m_14143_((float)(this.entityHeight + 0.999f));
        this.maxFallDistance = this.entity.m_6056_();
        this.canMine = this.entity.canMineAnything();
        this.canBuild = this.entity.canBuild();
    }

    protected void cleanupPath() {
        this.region = null;
        this.types.clear();
        this.collisions.clear();
    }

    public boolean collidesWith(AABB box) {
        return this.collisions.computeIfAbsent((Object)box, o -> !this.region.m_45756_((Entity)this.entity, box));
    }

    public AABB getEntityBox(double x, double y, double z) {
        return new AABB(x - (double)this.entityWidthHalf, y + 0.001, z - (double)this.entityWidthHalf, x + (double)this.entityWidthHalf, y + (double)this.entityHeight - 0.002, z + (double)this.entityWidthHalf);
    }

    public AABB getEntityBox(double x, double y, double z, double ySize) {
        return new AABB(x - (double)this.entityWidthHalf, y + 0.001, z - (double)this.entityWidthHalf, x + (double)this.entityWidthHalf, y + ySize - 0.002, z + (double)this.entityWidthHalf);
    }

    public int getScanHeight() {
        return this.scanHeight;
    }

    public int getScanWidth() {
        return this.scanWidth;
    }

    public float getEntityHeight() {
        return this.entityHeight;
    }

    public float getEntityWidthHalf() {
        return this.entityWidthHalf;
    }

    public int getMaxBuildHeight() {
        return this.region.m_151558_();
    }

    public int getMinBuildHeight() {
        return this.region.m_141937_();
    }

    public Node getNode(BlockPos pos) {
        return this.getNode(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public Node getNode(int x, int y, int z) {
        int hash = DataUtil.hashPos(x, y, z);
        return (Node)this.nodes.computeIfAbsent(hash, i -> new Node(x, y, z, hash, this.region));
    }

    protected Node typeAndGetNode(BlockPos pos) {
        return this.typeAndGetNode(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    protected Node typeAndGetNode(int x, int y, int z) {
        NodeType type = this.getCachedNodeType(x, y, z);
        float cost = type.cost;
        Node node = this.getNode(x, y, z);
        if (cost >= 0.0f) {
            node.setTypeMaxCost(type);
        }
        return node;
    }

    protected boolean willEntityFall(Node cur, Node prev, OctalDirection dir) {
        if (cur.hasFullFloor() && prev.hasFullFloor()) {
            return false;
        }
        float xStep = cur.pathX - prev.pathX;
        float xStepBack = -xStep;
        float zStep = cur.pathZ - prev.pathZ;
        float zStepBack = -zStep;
        double size = dir.isDiagonal() ? (double)this.entityWidthDiagonalSqr : (double)this.entityWidthSqr;
        for (AABB prevBox : prev.floorShape) {
            double b;
            Double m;
            if (cur.pathX == prev.pathX) {
                m = null;
                b = prev.pathX;
            } else {
                m = (double)zStep / (double)xStep;
                b = (double)prev.pathZ - m * (double)prev.pathX;
            }
            Vec2d prevPoint = NodeManager.findIntersectionPoint(m, b, prevBox, xStep, zStep);
            for (AABB curBox : cur.floorShape) {
                Vec2d curPoint = NodeManager.findIntersectionPoint(m, b, curBox, xStepBack, zStepBack);
                if (!(prevPoint.distSqr(curPoint) < size)) continue;
                return false;
            }
        }
        return true;
    }

    private static Vec2d findIntersectionPoint(Double m, double b, AABB box, float xStep, float zStep) {
        double x;
        double z;
        if (m == null) {
            if (zStep > 0.0f) {
                return new Vec2d(b, box.f_82293_);
            }
            return new Vec2d(b, box.f_82290_);
        }
        Double xEdge = null;
        Double zEdge = null;
        if (xStep > 0.0f) {
            xEdge = box.f_82291_;
        } else if (xStep < 0.0f) {
            xEdge = box.f_82288_;
        }
        if (xEdge != null && (z = m * xEdge + b) >= box.f_82290_ && z <= box.f_82293_) {
            return new Vec2d(xEdge, z);
        }
        if (zStep > 0.0f) {
            zEdge = box.f_82293_;
        } else if (zStep < 0.0f) {
            zEdge = box.f_82290_;
        }
        if (zEdge != null && (x = (zEdge - b) / m) >= box.f_82288_ && x <= box.f_82291_) {
            return new Vec2d(x, zEdge);
        }
        Nightfall.LOGGER.error("NodeManager failed to find intersection point in box " + box.toString());
        return Vec2d.ZERO;
    }

    protected boolean canEntityMoveDiagonally(BlockPos.MutableBlockPos pos1, BlockPos.MutableBlockPos pos2) {
        double minDistSqr = Double.POSITIVE_INFINITY;
        float baseY1 = pos1.m_123342_();
        float baseY2 = pos2.m_123342_();
        for (int i = 0; i < this.scanHeight; ++i) {
            for (AABB box1 : this.region.m_8055_((BlockPos)pos1).m_60812_((BlockGetter)this.region, (BlockPos)pos1).m_83216_((double)pos1.m_123341_(), (double)pos1.m_123342_(), (double)pos1.m_123343_()).m_83299_()) {
                if (box1.f_82289_ - (double)baseY1 > (double)this.entityHeight) continue;
                for (AABB box2 : this.region.m_8055_((BlockPos)pos2).m_60812_((BlockGetter)this.region, (BlockPos)pos2).m_83216_((double)pos2.m_123341_(), (double)pos2.m_123342_(), (double)pos2.m_123343_()).m_83299_()) {
                    double dist;
                    if (box2.f_82289_ - (double)baseY2 > (double)this.entityHeight || !((dist = MathUtil.getShortestDistanceSqrBoxToBox(box1, box2)) < minDistSqr)) continue;
                    minDistSqr = dist;
                }
            }
            pos1.m_142448_(pos1.m_123342_() + 1);
            pos2.m_142448_(pos2.m_123342_() + 1);
        }
        if (minDistSqr == Double.POSITIVE_INFINITY) {
            return true;
        }
        return minDistSqr >= (double)this.entityWidthDiagonalSqr;
    }

    protected boolean isNeighborValid(Node startNode, @Nullable Node node) {
        return node != null && !node.closed && (node.terrainCost >= 0.0f || startNode.terrainCost < 0.0f) && (node.y <= startNode.y || Math.abs(node.pathX - startNode.pathX) < 1.5f && Math.abs(node.pathZ - startNode.pathZ) < 1.5f);
    }

    protected boolean isDiagonalValid(Node startNode, Node node) {
        if (node.closed || node.terrainCost < 0.0f || node.y > startNode.y && (Math.abs(node.pathX - startNode.pathX) >= 1.5f || Math.abs(node.pathZ - startNode.pathZ) >= 1.5f)) {
            return false;
        }
        int diagonalY = Math.max(startNode.y, node.y);
        Node xNode = this.typeAndGetNode(node.x, diagonalY, startNode.z);
        Node zNode = this.typeAndGetNode(startNode.x, diagonalY, node.z);
        if (xNode.partial && zNode.partial || !xNode.type.blocksMovement && !zNode.type.blocksMovement) {
            if (zNode.partial || xNode.partial) {
                if ((double)this.entityWidthDiagonalSqr >= 1.0) {
                    return false;
                }
                return this.canEntityMoveDiagonally(xNode.blockPos.m_122032_(), zNode.blockPos.m_122032_());
            }
            return !xNode.mineable || !zNode.mineable;
        }
        return false;
    }

    protected boolean canReachWithoutCollision(Entity entity, Vec2f pos) {
        float x = (float)entity.m_20185_();
        float z = (float)entity.m_20189_();
        Vec2f dist = pos.subtract(x, z);
        dist = dist.scale(1.0f / dist.length() * CHECK_DIST);
        AABB tempBox = entity.m_142469_();
        AABB box = new AABB(tempBox.f_82288_, tempBox.f_82289_ + 0.001, tempBox.f_82290_, tempBox.f_82291_, tempBox.f_82292_ - 0.002, tempBox.f_82293_);
        while (pos.distSqr(x, z) > CHECK_DIST * CHECK_DIST) {
            if (this.collidesWith(box = box.m_82386_((double)dist.x(), 0.0, (double)dist.y()))) {
                return false;
            }
            x += dist.x();
            z += dist.y();
        }
        return true;
    }

    protected NodeType adjustNodeByNeighbors(NodeType type, BlockPos.MutableBlockPos pos) {
        int xCenter = pos.m_123341_();
        int yCenter = pos.m_123342_();
        int zCenter = pos.m_123343_();
        for (OctalDirection direction : OctalDirection.CARDINALS) {
            if (!this.entity.adjustPathType((NodeType)type, (BlockState)this.getNode((BlockPos)pos.m_122178_((int)(xCenter + direction.xStepInt), (int)yCenter, (int)(zCenter + direction.zStepInt))).state).inDanger) continue;
            return NodeType.NEAR_DANGER;
        }
        return type;
    }

    protected NodeType adjustAndSetNodeByEntity(NodeType type, BlockState state, BlockPos pos) {
        if ((type = this.entity.adjustPathType(type, state)) == NodeType.PASSABLE_FLUID) {
            Node node = this.getNode(pos);
            node.pathY = node.partial ? Math.max(node.pathY, (float)node.y + state.m_60819_().m_76182_()) : (float)node.y + state.m_60819_().m_76182_();
        }
        return type;
    }

    protected double getFloorLevel(BlockPos pos) {
        BlockPos belowPos = pos.m_7495_();
        BlockState belowState = this.region.m_8055_(belowPos);
        if (!belowState.m_60819_().m_76178_()) {
            return pos.m_123342_();
        }
        VoxelShape shape = this.region.m_8055_(belowPos).m_60812_((BlockGetter)this.region, belowPos);
        return (double)belowPos.m_123342_() + (shape.m_83281_() ? 0.0 : shape.m_83297_(Direction.Axis.Y));
    }

    protected boolean isWalkable(BlockPos pos) {
        NodeType type = this.getCachedNodeType(pos);
        return type.walkable;
    }

    protected boolean isEnterable(BlockPos invalidPos, BlockPos pos) {
        return (invalidPos.m_123341_() != pos.m_123341_() || invalidPos.m_123343_() != pos.m_123343_()) && this.getCachedNodeType((BlockPos)pos).cost >= 0.0f;
    }

    public boolean isOpenType(BlockState state) {
        return state.m_60795_();
    }

    protected abstract NodeType getRawNodeType(BlockGetter var1, BlockPos var2, Node var3, OctalDirection var4);

    public abstract NodeType getFullNodeType(BlockGetter var1, int var2, int var3, int var4, ActionableEntity var5);

    public abstract NodeType getSingleNodeType(BlockGetter var1, int var2, int var3, int var4);

    protected NodeType getCachedNodeType(int x, int y, int z) {
        return (NodeType)((Object)this.types.computeIfAbsent(DataUtil.hashPos(x, y, z), i -> this.getFullNodeType((BlockGetter)this.region, x, y, z, this.entity)));
    }

    protected NodeType getCachedNodeType(BlockPos pos) {
        return this.getCachedNodeType(pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public abstract Node getStartNode();

    public abstract Node getGoalNode(BlockPos var1, @Nullable Entity var2);

    public abstract int findNeighbors(Node var1, Node[] var2);
}

