/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.ai.pathfinding;

import frostnox.nightfall.entity.ai.pathfinding.Node;
import net.minecraft.util.Mth;

public class ReversePath {
    private Node[] reversePath = new Node[32];
    private int size = 0;
    private int index;
    private final boolean success;

    ReversePath(Node end, boolean success) {
        while (end != null) {
            if (this.size == this.reversePath.length) {
                Node[] temp = new Node[this.size << 1];
                System.arraycopy(this.reversePath, 0, temp, 0, this.size);
                this.reversePath = temp;
            }
            this.reversePath[this.size] = end;
            end = end.prev;
            ++this.size;
        }
        this.success = success;
        this.index = Math.max(0, this.size - 1 - 1);
    }

    public boolean reachesGoal() {
        return this.success;
    }

    public boolean isActive() {
        return this.index >= 0;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = Mth.m_14045_((int)index, (int)0, (int)(this.size - 1));
    }

    public int getSize() {
        return this.size;
    }

    public void advanceIndex() {
        --this.index;
    }

    public Node getEndNode() {
        return this.reversePath[0];
    }

    public Node getStartNode() {
        return this.reversePath[this.size - 1];
    }

    public Node getCurrentNode() {
        return this.reversePath[this.index];
    }

    public Node getNode(int index) {
        return this.reversePath[index];
    }
}

