/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.ai.sensing;

import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.registry.vanilla.GameEventsNF;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.GameEventListenerRegistrar;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraftforge.common.util.FakePlayer;
import org.apache.commons.compress.utils.Lists;
import org.jetbrains.annotations.NotNull;

public class AudioSensing {
    protected final ActionableEntity entity;
    protected final Int2IntMap heardEntities = new Int2IntOpenHashMap();
    @Nullable
    protected BlockPos closestHeardPos = null;
    protected double closestHeardDistSqr = Double.MAX_VALUE;
    protected final int memoryDuration;
    private final GameEventListener eventListener = new GameEventListener(){

        @NotNull
        public PositionSource m_142460_() {
            return new EntityPositionSource(AudioSensing.this.entity.m_142049_());
        }

        public int m_142078_() {
            return (int)AudioSensing.this.entity.m_21051_((Attribute)AttributesNF.HEARING_RANGE.get()).m_22135_();
        }

        public boolean m_142721_(@NotNull Level level, @NotNull GameEvent event, @Nullable Entity eventEntity, @NotNull BlockPos pos) {
            Player player;
            if (eventEntity == AudioSensing.this.entity || eventEntity == null || eventEntity instanceof FakePlayer || eventEntity instanceof Player && (player = (Player)eventEntity).m_7500_()) {
                return false;
            }
            float soundRange = AudioSensing.this.getSoundRange(event, eventEntity);
            double blockDistSqr = pos.m_203193_((Position)AudioSensing.this.entity.m_20182_());
            if (blockDistSqr <= (double)(soundRange * soundRange)) {
                if (eventEntity != null) {
                    LivingEntity livingEntity;
                    int id = eventEntity.m_142049_();
                    if (!eventEntity.m_6084_() || eventEntity instanceof LivingEntity && !AudioSensing.this.entity.canTargetFromSound(livingEntity = (LivingEntity)eventEntity)) {
                        return false;
                    }
                    AudioSensing.this.heardEntities.put(id, AudioSensing.this.memoryDuration);
                    return true;
                }
                if (blockDistSqr < AudioSensing.this.closestHeardDistSqr) {
                    AudioSensing.this.closestHeardPos = pos;
                    AudioSensing.this.closestHeardDistSqr = blockDistSqr;
                    return true;
                }
            }
            return false;
        }
    };
    private final GameEventListenerRegistrar eventListenerRegistrar = new GameEventListenerRegistrar(this.eventListener);

    public AudioSensing(ActionableEntity entity, int memoryDuration) {
        this.entity = entity;
        this.memoryDuration = memoryDuration;
    }

    public void tick() {
        if (!this.heardEntities.isEmpty()) {
            IntArraySet removals = new IntArraySet(4);
            for (Int2IntMap.Entry entry : this.heardEntities.int2IntEntrySet()) {
                int ticks = entry.getIntValue();
                if (ticks == 1) {
                    removals.add(entry.getIntKey());
                    continue;
                }
                entry.setValue(ticks - 1);
            }
            ObjectIterator objectIterator = removals.iterator();
            while (objectIterator.hasNext()) {
                int key = (Integer)objectIterator.next();
                this.heardEntities.remove(key);
            }
        }
        this.closestHeardPos = null;
        this.closestHeardDistSqr = Double.MAX_VALUE;
    }

    public List<Entity> getHeardEntities() {
        ArrayList list = Lists.newArrayList();
        IntIterator intIterator = this.heardEntities.keySet().iterator();
        while (intIterator.hasNext()) {
            int id = (Integer)intIterator.next();
            Entity heardEntity = this.entity.f_19853_.m_6815_(id);
            if (heardEntity == null) continue;
            list.add(heardEntity);
        }
        return list;
    }

    public boolean hasHeard(Entity target) {
        return this.heardEntities.keySet().contains(target.m_142049_());
    }

    @Nullable
    public BlockPos getClosestHeardPos() {
        return this.closestHeardPos;
    }

    public float getSoundRange(GameEvent event, Entity eventEntity) {
        return GameEventsNF.getEventRange(event, eventEntity);
    }

    public GameEventListener getEventListener() {
        return this.eventListener;
    }

    public GameEventListenerRegistrar getEventListenerRegistrar() {
        return this.eventListenerRegistrar;
    }
}

