/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.entity;

import com.mojang.authlib.GameProfile;
import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.Attack;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.DamageTypeSource;
import frostnox.nightfall.action.HitData;
import frostnox.nightfall.action.Impact;
import frostnox.nightfall.action.Poise;
import frostnox.nightfall.block.IAdjustableNodeType;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.GlobalChunkData;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.capability.IGlobalChunkData;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.ai.pathfinding.ActionableMoveControl;
import frostnox.nightfall.entity.ai.pathfinding.EntityNavigator;
import frostnox.nightfall.entity.ai.pathfinding.LandEntityNavigator;
import frostnox.nightfall.entity.ai.pathfinding.NodeType;
import frostnox.nightfall.entity.ai.sensing.AudioSensing;
import frostnox.nightfall.entity.entity.RopeKnotEntity;
import frostnox.nightfall.item.item.TieredArmorItem;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.GenericEntityToClient;
import frostnox.nightfall.network.message.capability.ActionToClient;
import frostnox.nightfall.network.message.world.DigBlockToClient;
import frostnox.nightfall.registry.ActionsNF;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.registry.forge.ItemsNF;
import frostnox.nightfall.registry.forge.ParticleTypesNF;
import frostnox.nightfall.registry.vanilla.GameEventsNF;
import frostnox.nightfall.util.CombatUtil;
import frostnox.nightfall.util.LevelUtil;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.data.Wrapper;
import frostnox.nightfall.world.ToolActionsNF;
import java.util.EnumMap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.gameevent.GameEventListenerRegistrar;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.FakePlayerFactory;

public abstract class ActionableEntity
extends PathfinderMob {
    public static final float PUSH_ZERO = 0.0f;
    public static final float PUSH_LOW = 1.0f;
    public static final float PUSH_MEDIUM = 2.0f;
    public static final float PUSH_HIGH = 3.0f;
    public static final float PUSH_MAX = 4.0f;
    protected static final EntityDataAccessor<Integer> RANDOM = SynchedEntityData.m_135353_(ActionableEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Nullable
    public BlockPos lastInteractPos = null;
    @Nullable
    public BlockPos lastTargetPos = null;
    public boolean refreshPath = true;
    public boolean reactToDamage = false;
    protected final float reach;
    protected final float reachSqr;
    protected float lastSyncedHealth = Float.MIN_VALUE;
    protected final AudioSensing audioSensing = this.createAudioSensing();
    public int noDespawnTicks = -1;
    public boolean reducedAI = false;
    protected long lastTickedGameTime;
    public int randTickCount;

    public ActionableEntity(EntityType<? extends ActionableEntity> type, Level level) {
        super(type, level);
        this.f_21342_ = new ActionableMoveControl(this);
        this.m_21441_(BlockPathTypes.UNPASSABLE_RAIL, 0.0f);
        this.reach = this.getBaseReach();
        this.reachSqr = this.reach * this.reach;
    }

    public static EnumMap<EntityPart, AnimationData> getGenericAnimMap() {
        EnumMap<EntityPart, AnimationData> map = new EnumMap<EntityPart, AnimationData>(EntityPart.class);
        for (EntityPart part : EntityPart.values()) {
            map.put(part, new AnimationData(new Vector3f(0.0f, 0.0f, 0.0f)));
        }
        return map;
    }

    public ActionableEntity getEntity() {
        return this;
    }

    protected float getBaseReach() {
        return 1.0f;
    }

    protected AudioSensing createAudioSensing() {
        return new AudioSensing(this, 20);
    }

    public boolean canTargetFromSound(LivingEntity target) {
        return this.m_6779_(target);
    }

    public ResourceLocation pickActionEnemy(double distanceSqr, Entity target) {
        return ActionsNF.EMPTY.getId();
    }

    public ResourceLocation pickActionAlly(double distanceSqr, Entity ally) {
        return ActionsNF.EMPTY.getId();
    }

    public boolean panicsOnFireDamage() {
        return true;
    }

    public long getLastTickedGameTime() {
        return this.lastTickedGameTime;
    }

    public float getMineSpeed(BlockState block) {
        return this.m_6844_(EquipmentSlot.MAINHAND).m_41691_(block);
    }

    public float getNaturalRegen() {
        return 0.0016666667f;
    }

    public boolean mineBlock(Level level, BlockPos pos) {
        LevelChunk chunk = level.m_46745_(pos);
        IGlobalChunkData chunkData = GlobalChunkData.get(chunk);
        BlockState block = chunk.m_8055_(pos);
        float progress = chunkData.getBreakProgress(pos) + this.getMineSpeed(block) / block.m_60800_((BlockGetter)level, pos) / 30.0f * 4.0f;
        if (progress >= 1.0f) {
            FakePlayer player = FakePlayerFactory.get((ServerLevel)((ServerLevel)level), (GameProfile)LevelUtil.FAKE_PROFILE);
            block.m_60734_().m_6240_(level, (Player)player, pos, block, level.m_7702_(pos), this.m_6844_(EquipmentSlot.MAINHAND));
            block.onDestroyedByPlayer(level, pos, (Player)player, true, level.m_6425_(pos));
            chunkData.removeBreakProgress(pos);
            NetworkHandler.toAllTrackingChunk(level.m_46745_(pos), new DigBlockToClient(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), -1.0f));
            this.refreshPath = true;
            return true;
        }
        SoundType sound = block.getSoundType((LevelReader)level, pos, (Entity)this);
        level.m_5594_(null, pos, sound.m_56778_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.75f);
        chunkData.setBreakProgress(pos, progress);
        NetworkHandler.toAllTrackingChunk(level.m_46745_(pos), new DigBlockToClient(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), progress));
        return false;
    }

    public abstract EquipmentSlot getHitSlot(Vector3d var1, int var2);

    public Impact modifyIncomingImpact(DamageTypeSource source, Impact impact) {
        return impact;
    }

    public boolean isImmuneTo(DamageTypeSource source, float damage) {
        return false;
    }

    protected float modifyIncomingDamageBySlot(EquipmentSlot slot, float damage) {
        if (slot == EquipmentSlot.HEAD) {
            return damage * 1.2f;
        }
        return damage;
    }

    public float modifyIncomingDamage(DamageTypeSource source, float damage, Wrapper<Poise> poise) {
        if (source.hasHitCoords()) {
            float durabilityDmg = Math.max(1.0f, damage / 5.0f);
            EquipmentSlot slot = this.getHitSlot(source.getHitCoords(), source.getHitBoxIndex());
            damage = this.modifyIncomingDamageBySlot(slot, damage);
            ItemStack stack = this.m_6844_(slot);
            Item item = stack.m_41720_();
            if (item instanceof TieredArmorItem) {
                TieredArmorItem armor = (TieredArmorItem)item;
                if (((Poise)((Object)poise.val)).ordinal() < armor.material.getPoise().ordinal()) {
                    poise.val = armor.material.getPoise();
                }
                if (armor.material.isMetal()) {
                    source.tryArmorSoundConversion();
                }
                damage = armor.material.getFinalDamage(armor.slot, source.types, stack.m_41773_(), damage, false);
                int index = armor.slot.m_20749_();
                stack.m_41622_((int)durabilityDmg, (LivingEntity)this, p_214023_1_ -> p_214023_1_.m_21166_(EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)index)));
            }
        } else {
            float durabilityDmg = Math.max(1.0f, damage / 20.0f);
            boolean isMetal = false;
            int totalPoise = 0;
            for (ItemStack stack : this.m_6168_()) {
                Item item = stack.m_41720_();
                if (!(item instanceof TieredArmorItem)) continue;
                TieredArmorItem armor = (TieredArmorItem)item;
                totalPoise += armor.material.getPoise().ordinal();
                if (!isMetal && armor.material.isMetal()) {
                    isMetal = true;
                }
                damage = armor.material.getFinalDamage(armor.slot, source.types, stack.m_41773_(), damage, true);
                int index = armor.slot.m_20749_();
                stack.m_41622_((int)durabilityDmg, (LivingEntity)this, p_214023_1_ -> p_214023_1_.m_21166_(EquipmentSlot.m_20744_((EquipmentSlot.Type)EquipmentSlot.Type.ARMOR, (int)index)));
            }
            if (((Poise)((Object)poise.val)).ordinal() < (totalPoise /= 4)) {
                poise.val = Poise.values()[totalPoise];
            }
            if (isMetal) {
                source.tryArmorSoundConversion();
            }
        }
        return damage;
    }

    public ParticleOptions getHurtParticle() {
        return (ParticleOptions)ParticleTypesNF.BLOOD_RED.get();
    }

    public boolean canMineAnything() {
        return false;
    }

    public boolean canBuild() {
        return false;
    }

    public boolean canDoRangedAction() {
        return false;
    }

    public ActionableEntity getAlly() {
        return null;
    }

    public void setAlly(ActionableEntity ally) {
    }

    public float getMaxXRotPerTick() {
        return 30.0f;
    }

    public float getMaxYRotPerTick() {
        return 30.0f;
    }

    public float getVisionAngle() {
        return 75.0f;
    }

    public boolean canMineBlock(BlockPos pos) {
        double z;
        double y;
        BlockState state = this.f_19853_.m_8055_(pos);
        boolean climbable = state.m_204336_(BlockTags.f_13082_);
        if (!climbable && state.m_60808_((BlockGetter)this.f_19853_, pos).m_83281_()) {
            return false;
        }
        double x = (double)pos.m_123341_() + 0.5 - this.m_20185_();
        if (x * x + (y = (double)pos.m_123342_() + 0.5 - this.m_20188_()) * y + (z = (double)pos.m_123343_() + 0.5 - this.m_20189_()) * z > (double)this.getReachSqr()) {
            return false;
        }
        return (climbable || state.m_60767_().m_76334_()) && state.m_60800_((BlockGetter)this.f_19853_, pos) >= 0.0f;
    }

    public float getReach() {
        return this.reach;
    }

    public float getReachSqr() {
        return this.reachSqr;
    }

    public float getSafeDistanceToTarget() {
        return 0.0f;
    }

    @Nullable
    public BlockPos getTargetPos() {
        return this.m_5448_() != null ? this.m_5448_().m_142538_() : this.lastTargetPos;
    }

    public boolean isInterruptible() {
        if (!this.m_6084_()) {
            return false;
        }
        IActionTracker capA = this.getActionTracker();
        return capA.isInactive() || capA.getAction().isInterruptible();
    }

    public IActionTracker getActionTracker() {
        return ActionTracker.get((Entity)this);
    }

    public void forceAction(ResourceLocation actionID) {
        if (!this.m_6084_()) {
            return;
        }
        IActionTracker capA = this.getActionTracker();
        capA.startAction(actionID);
        capA.setFrame(0);
        if (!this.f_19853_.m_5776_()) {
            NetworkHandler.toAllTracking((Entity)this, new ActionToClient(actionID, this.m_142049_()));
        }
    }

    public void startAction(ResourceLocation actionID) {
        if (!this.m_6084_()) {
            return;
        }
        IActionTracker capA = this.getActionTracker();
        if (!capA.isInactive()) {
            return;
        }
        capA.startAction(actionID);
        capA.setFrame(0);
        if (!this.f_19853_.m_5776_()) {
            NetworkHandler.toAllTracking((Entity)this, new ActionToClient(actionID, this.m_142049_()));
        }
    }

    public void queueAction() {
        this.getActionTracker().queue();
        if (!this.f_19853_.m_5776_()) {
            NetworkHandler.toAllTracking((Entity)this, new GenericEntityToClient(NetworkHandler.Type.QUEUE_ACTION_TRACKER, this.m_142049_()));
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.m_21559_(false);
        this.lastTickedGameTime = worldIn.m_6106_().m_6793_();
        this.f_19804_.m_135381_(RANDOM, (Object)(worldIn.m_5822_().nextInt() & Integer.MAX_VALUE));
        if (this.noDespawnTicks == -1 && reason != MobSpawnType.NATURAL && reason != MobSpawnType.CHUNK_GENERATION && reason != MobSpawnType.STRUCTURE && reason != MobSpawnType.BREEDING && reason != MobSpawnType.EVENT && reason != MobSpawnType.CONVERSION) {
            this.noDespawnTicks = 0;
        }
        return spawnDataIn;
    }

    public boolean m_8028_() {
        return super.m_8028_();
    }

    protected PathNavigation m_6037_(Level level) {
        return new LandEntityNavigator(this, level);
    }

    @Deprecated
    public PathNavigation m_21573_() {
        return super.m_21573_();
    }

    public EntityNavigator getNavigator() {
        return (EntityNavigator)this.m_21573_();
    }

    public NodeType adjustPathType(NodeType type, BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof IAdjustableNodeType) {
            IAdjustableNodeType adjustable = (IAdjustableNodeType)block;
            type = adjustable.adjustNodeType(type, state, (LivingEntity)this);
        } else {
            if (type == NodeType.CLOSED) {
                return type;
            }
            if (state.m_60734_() instanceof BaseFireBlock) {
                return this.m_5825_() ? type : NodeType.PASSABLE_DANGER_MAJOR;
            }
        }
        FluidState fluid = state.m_60819_();
        if (!fluid.m_76178_()) {
            if (fluid.m_205070_(FluidTags.f_13132_)) {
                return this.m_5825_() ? NodeType.PASSABLE_FLUID : NodeType.IMPASSABLE_DANGER;
            }
            if (fluid.m_205070_(FluidTags.f_13131_)) {
                return this.m_6126_() ? NodeType.IMPASSABLE_DANGER : NodeType.PASSABLE_FLUID;
            }
        }
        return type;
    }

    public float getMaxNodeCost() {
        if (this.getTargetPos() != null) {
            return 50.0f;
        }
        return 35.0f;
    }

    public float getNavigatorWaypointDist() {
        return this.m_20205_() / 2.0f;
    }

    public boolean shouldFleeFrom(LivingEntity target) {
        return this.m_21223_() / this.m_21233_() < 0.25f;
    }

    public void onKillRemoval() {
        this.f_19853_.m_7605_((Entity)this, (byte)60);
    }

    public AudioSensing getAudioSensing() {
        return this.audioSensing;
    }

    public MobType getMobTypeSecondary() {
        return MobType.f_21640_;
    }

    public int getSynchedRandom() {
        return (Integer)this.m_20088_().m_135370_(RANDOM);
    }

    public abstract boolean dropLootFromSkinning();

    public boolean canBeSkinned() {
        return this.dropLootFromSkinning() && !this.m_6084_();
    }

    public boolean tryToolAction(ItemStack stack, Player player, InteractionHand hand, ToolAction toolAction) {
        if (toolAction == ToolActionsNF.SKIN && this.canBeSkinned()) {
            if (this.f_19853_.f_46443_) {
                return true;
            }
            DamageSource damageSource = this.m_21225_();
            this.forceDropAllDeathLoot(damageSource == null ? DamageTypeSource.GENERIC : damageSource);
            this.onKillRemoval();
            this.m_142687_(Entity.RemovalReason.KILLED);
            return true;
        }
        return false;
    }

    public float getAttackYRot(float partial) {
        return Mth.m_14179_((float)partial, (float)this.f_20884_, (float)this.f_20883_);
    }

    public double getReducedAIThresholdSqr() {
        return 22500.0;
    }

    public float getBaseJumpPower() {
        return 0.42f;
    }

    protected float m_6118_() {
        return this.getBaseJumpPower() * this.m_20098_();
    }

    public void forceDropAllDeathLoot(DamageSource damageSource) {
        super.m_6668_(damageSource);
    }

    protected void m_6668_(DamageSource pDamageSource) {
        if (!this.dropLootFromSkinning()) {
            super.m_6668_(pDamageSource);
        }
    }

    public boolean m_6914_(LevelReader pLevel) {
        return !pLevel.m_46855_(this.m_142469_()) && pLevel.m_45786_((Entity)this);
    }

    public void m_7023_(Vec3 target) {
        if (this.m_6142_() && this.m_20077_() && this.m_6129_() && !this.m_203441_(this.f_19853_.m_6425_(this.m_142538_()))) {
            double speed = 0.7 * (double)this.getLavaSlowDown();
            double gravity = this.m_21133_((Attribute)ForgeMod.ENTITY_GRAVITY.get());
            boolean falling = this.m_20184_().f_82480_ <= 0.0;
            double oldY = this.m_20186_();
            this.m_19920_(0.02f * (float)this.m_21133_((Attribute)ForgeMod.SWIM_SPEED.get()), target);
            this.m_6478_(MoverType.SELF, this.m_20184_());
            if (this.m_204036_(FluidTags.f_13132_) <= this.m_20204_()) {
                this.m_20256_(this.m_20184_().m_82542_(speed, 0.8, speed));
                Vec3 fluidDir = this.m_20994_(gravity, falling, this.m_20184_());
                this.m_20256_(fluidDir);
            } else {
                this.m_20256_(this.m_20184_().m_82490_(speed));
            }
            if (!this.m_20068_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -gravity / 4.0, 0.0));
            }
            Vec3 vec34 = this.m_20184_();
            if (this.f_19862_ && this.m_20229_(vec34.f_82479_, vec34.f_82480_ + 0.6 - this.m_20186_() + oldY, vec34.f_82481_)) {
                this.m_20334_(vec34.f_82479_, 0.3f, vec34.f_82481_);
            }
        } else {
            super.m_7023_(target);
        }
    }

    protected float m_5632_(float pYRot, float pAnimStep) {
        float oldYBodyRot = this.f_20883_;
        float step = super.m_5632_(pYRot, pAnimStep);
        if (this.m_6084_() && !this.getActionTracker().isInactive()) {
            this.f_20883_ = oldYBodyRot;
            this.f_20884_ = oldYBodyRot;
        }
        return step;
    }

    public boolean m_204031_(TagKey<Fluid> pFluidTag, double pMotionScale) {
        return super.m_204031_(pFluidTag, pFluidTag == FluidTags.f_13132_ ? pMotionScale : pMotionScale * 0.2);
    }

    protected float m_6108_() {
        return 0.9f;
    }

    protected float getLavaSlowDown() {
        return this.m_6108_();
    }

    public EntityDimensions m_6972_(Pose pPose) {
        if (this.m_21224_() && this.m_6095_().m_20679_() > this.m_6095_().m_20678_()) {
            return super.m_6972_(pPose).m_20390_(1.0f, this.m_6095_().m_20678_() / this.m_6095_().m_20679_());
        }
        return super.m_6972_(pPose);
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (f_20961_.equals(pKey)) {
            float health = this.m_21223_();
            if (Math.signum(this.lastSyncedHealth) != Math.signum(health)) {
                this.m_6210_();
            }
            this.lastSyncedHealth = health;
        }
        super.m_7350_(pKey);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(RANDOM, (Object)0);
    }

    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("random", this.getSynchedRandom());
        if (this.f_20919_ > 0) {
            tag.m_128405_("deathTime", this.f_20919_);
        }
        if (this.noDespawnTicks != -1) {
            tag.m_128405_("noDespawnTicks", this.noDespawnTicks);
        }
        if (this.f_20958_ != null) {
            tag.m_128359_("lastDamageSourceId", this.f_20958_.m_19385_());
            DamageSource damageSource = this.f_20958_;
            if (damageSource instanceof DamageTypeSource) {
                DamageTypeSource typeSource = (DamageTypeSource)damageSource;
                tag.m_128405_("lastDamageSourceTypes", typeSource.types.length);
                for (int i = 0; i < typeSource.types.length; ++i) {
                    tag.m_128359_("lastDamageSourceType_" + i, typeSource.types[i].toString());
                }
            }
        }
        tag.m_128356_("lastGameTime", this.lastTickedGameTime);
    }

    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.f_19804_.m_135381_(RANDOM, (Object)tag.m_128451_("random"));
        this.f_20919_ = tag.m_128451_("deathTime");
        if (tag.m_128441_("noDespawnTicks")) {
            this.noDespawnTicks = tag.m_128451_("noDespawnTicks");
        }
        if (tag.m_128441_("lastDamageSourceId")) {
            DamageType[] types;
            String sourceId = tag.m_128461_("lastDamageSourceId");
            if (tag.m_128441_("lastDamageSourceTypes")) {
                int size = tag.m_128451_("lastDamageSourceTypes");
                types = new DamageType[size];
                for (int i = 0; i < size; ++i) {
                    String typeName = tag.m_128461_("lastDamageSourceType_" + i);
                    for (DamageType type : DamageType.values()) {
                        if (!type.toString().equals(typeName)) continue;
                        types[i] = type;
                        break;
                    }
                    if (types[i] != null) continue;
                    types[i] = DamageType.ABSOLUTE;
                }
            } else {
                types = new DamageType[]{DamageType.ABSOLUTE};
            }
            this.f_20958_ = new DamageTypeSource(sourceId, types);
        }
        this.lastTickedGameTime = tag.m_128454_("lastGameTime");
    }

    @Nullable
    public DamageSource m_21225_() {
        if (!this.m_6084_()) {
            return this.f_20958_;
        }
        return super.m_21225_();
    }

    public float getPushResistance() {
        return 2.0f;
    }

    public float getPushForce() {
        return 2.0f;
    }

    protected void m_6138_() {
        if (!this.m_21224_()) {
            List entities;
            List list = entities = this.f_19853_.f_46443_ ? ClientEngine.get().getPlayerToPush(this) : this.f_19853_.m_6249_((Entity)this, this.m_142469_(), EntitySelector.m_20421_((Entity)this).and(target -> {
                float f;
                if (target instanceof ActionableEntity) {
                    ActionableEntity actionable = (ActionableEntity)((Object)target);
                    f = actionable.getPushResistance();
                } else {
                    f = 2.0f;
                }
                float pushResistance = f;
                return this.getPushForce() >= pushResistance;
            }));
            if (!entities.isEmpty()) {
                int maxGroup = this.f_19853_.m_46469_().m_46215_(GameRules.f_46149_);
                if (maxGroup > 0 && entities.size() > maxGroup - 1 && this.f_19796_.nextInt(4) == 0) {
                    int count = 0;
                    for (Entity entity : entities) {
                        if (entity.m_20159_()) continue;
                        ++count;
                    }
                    if (count > maxGroup - 1) {
                        this.m_6469_(DamageSource.f_19311_, 6.0f);
                    }
                }
                for (Entity entity : entities) {
                    this.m_7324_(entity);
                }
            }
        }
    }

    public void m_7334_(Entity pusher) {
        double dZ;
        double dX;
        double maxD;
        if (!this.m_20365_(pusher) && !pusher.f_19794_ && !this.f_19794_ && (maxD = Mth.m_14005_((double)(dX = pusher.m_20185_() - this.m_20185_()), (double)(dZ = pusher.m_20189_() - this.m_20189_()))) >= 0.01) {
            ActionableEntity actionable;
            maxD = Math.sqrt(maxD);
            dX /= maxD;
            dZ /= maxD;
            double scale = 1.0 / maxD;
            if (scale > 1.0) {
                scale = 1.0;
            }
            dX *= scale * 0.05;
            dZ *= scale * 0.05;
            if (!this.m_20160_()) {
                float f;
                if (pusher instanceof ActionableEntity) {
                    actionable = (ActionableEntity)pusher;
                    f = actionable.getPushForce();
                } else {
                    f = 2.0f;
                }
                if (f >= this.getPushResistance()) {
                    this.m_5997_(-dX, 0.0, -dZ);
                }
            }
            if (!pusher.m_20160_()) {
                float f;
                if (pusher instanceof ActionableEntity) {
                    actionable = (ActionableEntity)pusher;
                    f = actionable.getPushResistance();
                } else {
                    f = 2.0f;
                }
                if (f <= this.getPushForce()) {
                    pusher.m_5997_(dX, 0.0, dZ);
                }
            }
        }
    }

    public boolean m_5830_() {
        if (this.f_19853_.f_46443_) {
            return false;
        }
        return super.m_5830_();
    }

    public void m_21455_(boolean pBroadcastPacket, boolean pDropLeash) {
        if (this.f_21357_ != null) {
            this.f_21357_ = null;
            this.f_21359_ = null;
            if (!this.f_19853_.f_46443_ && pDropLeash) {
                this.m_19998_((ItemLike)ItemsNF.ROPE.get());
            }
            if (!this.f_19853_.f_46443_ && pBroadcastPacket && this.f_19853_ instanceof ServerLevel) {
                ((ServerLevel)this.f_19853_).m_7726_().m_8445_((Entity)this, (Packet)new ClientboundSetEntityLinkPacket((Entity)this, (Entity)null));
            }
        }
    }

    public boolean m_6573_(Player pPlayer) {
        return false;
    }

    protected void m_21528_() {
        if (this.f_21359_ != null && this.f_19853_ instanceof ServerLevel) {
            if (this.f_21359_.m_128403_("UUID")) {
                UUID uuid = this.f_21359_.m_128342_("UUID");
                Entity entity = ((ServerLevel)this.f_19853_).m_8791_(uuid);
                if (entity != null) {
                    this.m_21463_(entity, true);
                    return;
                }
            } else if (this.f_21359_.m_128425_("X", 99) && this.f_21359_.m_128425_("Y", 99) && this.f_21359_.m_128425_("Z", 99)) {
                BlockPos blockpos = NbtUtils.m_129239_((CompoundTag)this.f_21359_);
                this.m_21463_((Entity)RopeKnotEntity.m_31844_(this.f_19853_, blockpos), true);
                return;
            }
            if (this.f_19797_ > 100) {
                this.m_19998_((ItemLike)ItemsNF.ROPE.get());
                this.f_21359_ = null;
            }
        }
    }

    public void m_8107_() {
        LivingEntity target;
        super.m_8107_();
        this.audioSensing.tick();
        this.f_20891_ = 0;
        if (this.noDespawnTicks > 0) {
            --this.noDespawnTicks;
        }
        if ((target = this.m_5448_()) != null && target.m_146910_()) {
            this.m_6710_(null);
        }
    }

    protected void simulateTime(int timePassed) {
        if (this.noDespawnTicks > 0) {
            this.noDespawnTicks = Math.max(0, this.noDespawnTicks - timePassed - 1);
            if (this.noDespawnTicks == 0) {
                this.m_146870_();
            }
        }
        if (!this.m_146910_()) {
            this.m_5634_(this.getNaturalRegen() * (float)timePassed);
        }
    }

    public void m_8119_() {
        Attack attack;
        boolean isActive;
        GameEventListenerRegistrar listener;
        this.randTickCount = this.getSynchedRandom() + this.f_19797_;
        if (!this.f_19853_.f_46443_) {
            long timePassed;
            if (this.randTickCount % 200 == 0) {
                Player nearPlayer = this.f_19853_.m_45930_((Entity)this, -1.0);
                if (nearPlayer == null) {
                    this.reducedAI = true;
                } else {
                    boolean bl = this.reducedAI = nearPlayer.m_20280_((Entity)this) > this.getReducedAIThresholdSqr();
                }
            }
            if ((timePassed = this.f_19853_.m_46467_() - this.lastTickedGameTime) > 1L) {
                this.simulateTime(timePassed > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)timePassed);
            }
            this.lastTickedGameTime = this.f_19853_.m_46467_();
        }
        float yRot = this.f_20883_;
        super.m_8119_();
        if (this.m_146910_()) {
            return;
        }
        IActionTracker capA = this.getActionTracker();
        if (!this.m_6084_()) {
            if (!capA.isInactive()) {
                capA.tick();
            }
            if (capA.isInactive()) {
                capA.startAction(ActionsNF.EMPTY.getId());
            }
            this.f_20883_ = yRot;
            capA.setLastPosition(this.m_20182_());
            return;
        }
        if (!this.f_19853_.f_46443_ && this.f_19797_ == 1 && (listener = this.m_146887_()) != null) {
            listener.m_157862_(this.f_19853_);
        }
        if (this.m_21223_() < this.m_21233_()) {
            this.m_5634_(this.getNaturalRegen());
        }
        capA.tick();
        if (capA.isInactive()) {
            capA.startAction(ActionsNF.EMPTY.getId());
        }
        if (capA.isStunned()) {
            this.m_5810_();
        }
        Action action = capA.getAction();
        action.onTick((LivingEntity)this);
        float maxRotX = this.getMaxXRotPerTick();
        float maxRotY = this.getMaxYRotPerTick();
        boolean bl = isActive = !capA.isInactive();
        if (action instanceof Attack) {
            attack = (Attack)action;
            if (isActive && capA.getActionID() != ActionsNF.EMPTY.getId()) {
                maxRotX = attack.getMaxXRot(capA.getState());
                maxRotY = attack.getMaxYRot(capA.getState());
            }
        }
        this.m_146926_(Mth.m_14036_((float)this.m_146909_(), (float)(this.f_19860_ - maxRotX), (float)(this.f_19860_ + maxRotX)));
        this.m_146922_(Mth.m_14036_((float)this.m_146908_(), (float)(this.f_19859_ - maxRotY), (float)(this.f_19859_ + maxRotY)));
        this.f_20883_ = Mth.m_14036_((float)this.f_20883_, (float)(this.f_20884_ - maxRotY), (float)(this.f_20884_ + maxRotY));
        this.f_20885_ = Mth.m_14036_((float)this.f_20885_, (float)(this.f_20886_ - maxRotY), (float)(this.f_20886_ + maxRotY));
        if (isActive && action instanceof Attack && capA.getActionID() != ActionsNF.EMPTY.getId()) {
            CombatUtil.alignBodyRotWithHead((LivingEntity)this, capA);
        }
        if (action instanceof Attack) {
            attack = (Attack)action;
            if (capA.isDamaging() && !this.f_19853_.m_5776_()) {
                List<HitData> targets = capA.getEntitiesInAttack(attack, 1.0f);
                for (HitData hitData : targets) {
                    LivingEntity livingTarget;
                    Entity target = hitData.hitEntity;
                    if (target instanceof LivingEntity && !this.m_6779_(livingTarget = (LivingEntity)target)) continue;
                    target.m_6469_((DamageSource)DamageTypeSource.createAttackSource((LivingEntity)this, attack, hitData).setImpactSoundType(attack.getImpactSoundType((LivingEntity)this), target), attack.getDamage((LivingEntity)this) * capA.getChargeAttackMultiplier());
                    if (!(target instanceof LivingEntity)) continue;
                    ((LivingEntity)target).m_6703_((LivingEntity)this);
                }
            }
        }
        if (action.getSound() != null && capA.getFrame() == 1 && !capA.hasHitPause() && capA.isDamaging()) {
            this.m_5496_(action.isChargeable() && capA.getCharge() >= Math.round((float)action.getMaxCharge() * 0.75f) ? action.getExtraSound().get() : action.getSound().get(), 1.0f, 1.0f + this.f_19853_.f_46441_.nextFloat(-0.03f, 0.03f));
            this.m_146850_(GameEventsNF.ACTION_SOUND);
        }
        capA.setLastPosition(this.m_20182_());
        if (!this.f_19853_.f_46443_ && this.f_19797_ % 5 != 0) {
            this.m_8022_();
        }
    }

    protected void m_8022_() {
        if (this.m_6084_() && !this.m_146910_()) {
            boolean notControlled = !(this.m_6688_() instanceof Mob);
            boolean notInBoat = !(this.m_20202_() instanceof Boat);
            IActionTracker capA = this.getActionTracker();
            if (!capA.getActionID().equals((Object)ActionsNF.EMPTY.getId())) {
                Action action = capA.getAction();
                int state = capA.getState();
                boolean canMove = notControlled && action.allowFlag(state, Goal.Flag.MOVE);
                this.f_21345_.m_25360_(Goal.Flag.MOVE, canMove);
                if (!canMove) {
                    this.getNavigator().m_26573_();
                }
                this.f_21345_.m_25360_(Goal.Flag.LOOK, notControlled && action.allowFlag(state, Goal.Flag.LOOK));
                this.f_21345_.m_25360_(Goal.Flag.JUMP, notControlled && notInBoat && action.allowFlag(state, Goal.Flag.JUMP));
            } else {
                this.f_21345_.m_25360_(Goal.Flag.MOVE, notControlled);
                this.f_21345_.m_25360_(Goal.Flag.LOOK, notControlled);
                this.f_21345_.m_25360_(Goal.Flag.JUMP, notControlled && notInBoat);
            }
        }
    }

    public boolean m_7313_(Entity pEntity) {
        return this.f_20919_ > 0;
    }

    @Nullable
    public ResourceLocation getCollapseAction() {
        return null;
    }

    public void m_6667_(DamageSource pCause) {
        if (ForgeHooks.onLivingDeath((LivingEntity)this, (DamageSource)pCause)) {
            return;
        }
        super.m_6667_(pCause);
        this.getActionTracker().stun(16, false);
        Vec3 move = new Vec3(0.22 * (double)(this.getSynchedRandom() % 2 == 0 ? 1 : -1), 0.0, 0.0).m_82524_(-MathUtil.toRadians(this.m_146908_()));
        this.m_20256_(this.m_20184_().m_82549_(move));
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == (this.dropLootFromSkinning() ? 6000 : 20) && !this.f_19853_.m_5776_()) {
            this.onKillRemoval();
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public boolean m_142582_(Entity target) {
        if (target.f_19853_ != this.f_19853_) {
            return false;
        }
        Vec3 start = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
        Vec3 end = new Vec3(target.m_20185_(), target.m_20188_(), target.m_20189_());
        if (end.m_82557_(start) > 16384.0) {
            return false;
        }
        float angle = this.getVisionAngle();
        if (angle < 180.0f && CombatUtil.getRelativeHorizontalAngle(start, end, this.m_6080_()) > angle) {
            return false;
        }
        return this.f_19853_.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() == HitResult.Type.MISS;
    }

    public int m_6056_() {
        if (this.m_5448_() == null) {
            return 3;
        }
        if (this.lastTargetPos != null) {
            return 3 + (int)Math.max(0.0f, this.m_21223_() / 10.0f - this.m_21233_() * 0.033f);
        }
        return 3 + (int)Math.max(0.0f, this.m_21223_() / 5.0f - this.m_21233_() * 0.066f);
    }

    public boolean hasAnyLineOfSight(Entity target) {
        if (target.f_19853_ != this.f_19853_) {
            return false;
        }
        Vec3 start = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
        Vec3 end = new Vec3(target.m_20185_(), target.m_20188_(), target.m_20189_());
        if (end.m_82557_(start) > 16384.0) {
            return false;
        }
        return this.f_19853_.m_45547_(new ClipContext(start, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).m_6662_() == HitResult.Type.MISS;
    }

    @Nullable
    public GameEventListenerRegistrar m_146887_() {
        if (this.m_21051_((Attribute)AttributesNF.HEARING_RANGE.get()).m_22135_() > 0.0) {
            return this.audioSensing.getEventListenerRegistrar();
        }
        return null;
    }

    public boolean m_7327_(Entity entityIn) {
        return true;
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        if (!this.m_6084_() || this.noDespawnTicks == 0) {
            return pDistanceToClosestPlayer > 6400.0;
        }
        return false;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22266_((Attribute)AttributesNF.STRENGTH.get()).m_22266_((Attribute)AttributesNF.HEARING_RANGE.get()).m_22266_((Attribute)AttributesNF.ACTION_SPEED.get()).m_22266_((Attribute)AttributesNF.STRIKING_DEFENSE.get()).m_22266_((Attribute)AttributesNF.SLASHING_DEFENSE.get()).m_22266_((Attribute)AttributesNF.PIERCING_DEFENSE.get()).m_22266_((Attribute)AttributesNF.FIRE_DEFENSE.get()).m_22266_((Attribute)AttributesNF.FROST_DEFENSE.get()).m_22266_((Attribute)AttributesNF.ELECTRIC_DEFENSE.get()).m_22266_((Attribute)AttributesNF.WITHER_DEFENSE.get()).m_22266_((Attribute)AttributesNF.POISE.get()).m_22266_((Attribute)AttributesNF.BLEEDING_RESISTANCE.get()).m_22266_((Attribute)AttributesNF.POISON_RESISTANCE.get()).m_22268_((Attribute)ForgeMod.SWIM_SPEED.get(), 1.4);
    }
}

