/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.entity;

import frostnox.nightfall.action.DamageTypeSource;
import frostnox.nightfall.block.Tree;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.entity.IEntityWithItem;
import frostnox.nightfall.item.item.BuildingMaterialItem;
import frostnox.nightfall.item.item.TieredArmorItem;
import frostnox.nightfall.registry.forge.BlocksNF;
import frostnox.nightfall.registry.forge.ItemsNF;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Rotations;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class ArmorStandDummyEntity
extends LivingEntity
implements IEntityWithItem {
    private static final Rotations ZERO = new Rotations(0.0f, 0.0f, 0.0f);
    private static final Rotations DEFAULT_LEFT_ARM_POSE = new Rotations(-10.0f, 0.0f, -10.0f);
    private static final Rotations DEFAULT_RIGHT_ARM_POSE = new Rotations(-15.0f, 0.0f, 10.0f);
    private static final EntityDimensions MARKER_DIMENSIONS = new EntityDimensions(0.0f, 0.0f, true);
    private static final double FEET_OFFSET = 0.1;
    private static final double CHEST_OFFSET = 0.9;
    private static final double LEGS_OFFSET = 0.4;
    private static final double HEAD_OFFSET = 1.6;
    public static final int DISABLE_TAKING_OFFSET = 8;
    public static final int DISABLE_PUTTING_OFFSET = 16;
    public static final int CLIENT_FLAG_SMALL = 1;
    public static final int CLIENT_FLAG_SHOW_ARMS = 4;
    public static final int CLIENT_FLAG_NO_BASEPLATE = 8;
    public static final int CLIENT_FLAG_MARKER = 16;
    public static final EntityDataAccessor<Byte> DATA_CLIENT_FLAGS = SynchedEntityData.m_135353_(ArmorStandDummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    public static final EntityDataAccessor<Rotations> DATA_HEAD_POSE = SynchedEntityData.m_135353_(ArmorStandDummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    public static final EntityDataAccessor<Rotations> DATA_BODY_POSE = SynchedEntityData.m_135353_(ArmorStandDummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    public static final EntityDataAccessor<Rotations> DATA_LEFT_ARM_POSE = SynchedEntityData.m_135353_(ArmorStandDummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    public static final EntityDataAccessor<Rotations> DATA_RIGHT_ARM_POSE = SynchedEntityData.m_135353_(ArmorStandDummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    public static final EntityDataAccessor<Rotations> DATA_LEFT_LEG_POSE = SynchedEntityData.m_135353_(ArmorStandDummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    public static final EntityDataAccessor<Rotations> DATA_RIGHT_LEG_POSE = SynchedEntityData.m_135353_(ArmorStandDummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135037_);
    private static final EntityDataAccessor<String> MATERIAL = SynchedEntityData.m_135353_(ArmorStandDummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);
    private static final Predicate<Entity> RIDEABLE_MINECARTS = entity -> {
        AbstractMinecart cart;
        return entity instanceof AbstractMinecart && (cart = (AbstractMinecart)entity).canBeRidden();
    };
    private final NonNullList<ItemStack> handItems = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private final NonNullList<ItemStack> armorItems = NonNullList.m_122780_((int)4, (Object)ItemStack.f_41583_);
    private boolean invisible;
    public long lastHit;
    private int disabledSlots;
    private Rotations headPose = ZERO;
    private Rotations bodyPose = ZERO;
    private Rotations leftArmPose = DEFAULT_LEFT_ARM_POSE;
    private Rotations rightArmPose = DEFAULT_RIGHT_ARM_POSE;
    private Rotations leftLegPose = ZERO;
    private Rotations rightLegPose = ZERO;

    public ArmorStandDummyEntity(EntityType<? extends ArmorStandDummyEntity> type, Level level) {
        super(type, level);
        this.f_19793_ = 0.0f;
    }

    @Override
    public Item getItemForm() {
        return (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)this.getMaterial().replace("plank", "armor_stand")));
    }

    private void setMaterial(String name) {
        if (name.contains(":")) {
            this.f_19804_.m_135381_(MATERIAL, (Object)name);
        }
    }

    public void setMaterial(ResourceLocation id) {
        this.f_19804_.m_135381_(MATERIAL, (Object)id.toString());
    }

    public String getMaterial() {
        return (String)this.f_19804_.m_135370_(MATERIAL);
    }

    public void setShowArms(boolean pShowArms) {
        this.f_19804_.m_135381_(DATA_CLIENT_FLAGS, (Object)this.setBit((Byte)this.f_19804_.m_135370_(DATA_CLIENT_FLAGS), 4, pShowArms));
    }

    protected byte setBit(byte p_31570_, int p_31571_, boolean p_31572_) {
        p_31570_ = p_31572_ ? (byte)(p_31570_ | p_31571_) : (byte)(p_31570_ & ~p_31571_);
        return p_31570_;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CLIENT_FLAGS, (Object)4);
        this.f_19804_.m_135372_(DATA_HEAD_POSE, (Object)ZERO);
        this.f_19804_.m_135372_(DATA_BODY_POSE, (Object)ZERO);
        this.f_19804_.m_135372_(DATA_LEFT_ARM_POSE, (Object)DEFAULT_LEFT_ARM_POSE);
        this.f_19804_.m_135372_(DATA_RIGHT_ARM_POSE, (Object)DEFAULT_RIGHT_ARM_POSE);
        this.f_19804_.m_135372_(DATA_LEFT_LEG_POSE, (Object)ZERO);
        this.f_19804_.m_135372_(DATA_RIGHT_LEG_POSE, (Object)ZERO);
        this.f_19804_.m_135372_(MATERIAL, (Object)ItemsNF.PLANKS.get(Tree.OAK).getId().toString());
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        ListTag listtag = new ListTag();
        for (ItemStack itemstack : this.armorItems) {
            CompoundTag compoundtag = new CompoundTag();
            if (!itemstack.m_41619_()) {
                itemstack.m_41739_(compoundtag);
            }
            listtag.add((Object)compoundtag);
        }
        pCompound.m_128365_("ArmorItems", (Tag)listtag);
        ListTag listtag1 = new ListTag();
        for (ItemStack itemstack1 : this.handItems) {
            CompoundTag compoundtag1 = new CompoundTag();
            if (!itemstack1.m_41619_()) {
                itemstack1.m_41739_(compoundtag1);
            }
            listtag1.add((Object)compoundtag1);
        }
        pCompound.m_128365_("HandItems", (Tag)listtag1);
        pCompound.m_128379_("Invisible", this.m_20145_());
        pCompound.m_128379_("Small", this.isSmall());
        pCompound.m_128379_("ShowArms", this.isShowArms());
        pCompound.m_128405_("DisabledSlots", this.disabledSlots);
        pCompound.m_128379_("NoBasePlate", this.isNoBasePlate());
        if (this.isMarker()) {
            pCompound.m_128379_("Marker", this.isMarker());
        }
        pCompound.m_128365_("Pose", (Tag)this.writePose());
        pCompound.m_128359_("Material", this.getMaterial());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("ArmorItems", 9)) {
            ListTag listtag = pCompound.m_128437_("ArmorItems", 10);
            for (int i = 0; i < this.armorItems.size(); ++i) {
                this.armorItems.set(i, (Object)ItemStack.m_41712_((CompoundTag)listtag.m_128728_(i)));
            }
        }
        if (pCompound.m_128425_("HandItems", 9)) {
            ListTag listtag1 = pCompound.m_128437_("HandItems", 10);
            for (int j = 0; j < this.handItems.size(); ++j) {
                this.handItems.set(j, (Object)ItemStack.m_41712_((CompoundTag)listtag1.m_128728_(j)));
            }
        }
        this.m_6842_(pCompound.m_128471_("Invisible"));
        this.setSmall(pCompound.m_128471_("Small"));
        if (pCompound.m_128441_("ShowArms")) {
            this.setShowArms(pCompound.m_128471_("ShowArms"));
        }
        this.disabledSlots = pCompound.m_128451_("DisabledSlots");
        this.setNoBasePlate(pCompound.m_128471_("NoBasePlate"));
        this.setMarker(pCompound.m_128471_("Marker"));
        this.f_19794_ = !this.hasPhysics();
        CompoundTag compoundtag = pCompound.m_128469_("Pose");
        this.readPose(compoundtag);
        this.setMaterial(pCompound.m_128461_("Material"));
    }

    protected void m_147218_(ItemStack itemStack) {
        Item item;
        SoundEvent soundevent = itemStack.m_150920_();
        if (soundevent == null && (item = itemStack.m_41720_()) instanceof TieredArmorItem) {
            TieredArmorItem armorItem = (TieredArmorItem)item;
            soundevent = armorItem.material.getSoundEvent();
        }
        if (soundevent != null && !this.m_5833_()) {
            this.m_146850_(GameEvent.f_157811_);
            this.m_5496_(soundevent, 1.0f, 1.0f);
        }
    }

    protected void brokenByPlayer(DamageSource pSource) {
        Block.m_49840_((Level)this.f_19853_, (BlockPos)this.m_142538_(), (ItemStack)new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)this.getMaterial())), 12));
        this.brokenByAnything(pSource);
    }

    public InteractionResult m_7111_(Player pPlayer, Vec3 pVec, InteractionHand pHand) {
        if (!ActionTracker.get((Entity)pPlayer).isInactive()) {
            return InteractionResult.FAIL;
        }
        InteractionResult result = this.tryItemSwap(pPlayer, pVec, pHand);
        if (pPlayer.f_19853_.m_5776_() && result == InteractionResult.CONSUME) {
            return InteractionResult.SUCCESS;
        }
        return result;
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        DamageTypeSource source;
        if (pSource.m_19385_().equals("lava")) {
            this.causeDamage(pSource, pAmount);
            return false;
        }
        if (pSource instanceof DamageTypeSource && (source = (DamageTypeSource)pSource).m_19384_()) {
            this.causeDamage(pSource, pAmount);
            return false;
        }
        if (!this.f_19853_.f_46443_ && !this.m_146910_()) {
            if (DamageSource.f_19317_.equals(pSource)) {
                this.m_6074_();
                return false;
            }
            if (!(this.m_6673_(pSource) || this.invisible || this.isMarker())) {
                if (pSource.m_19372_()) {
                    this.brokenByAnything(pSource);
                    this.m_6074_();
                    return false;
                }
                if (DamageSource.f_19305_.equals(pSource)) {
                    if (this.m_6060_()) {
                        this.causeDamage(pSource, 0.15f);
                    } else {
                        this.m_20254_(5);
                    }
                    return false;
                }
                if (DamageSource.f_19307_.equals(pSource) && this.m_21223_() > 0.5f) {
                    this.causeDamage(pSource, 4.0f);
                    return false;
                }
                boolean fromArrow = pSource.m_7640_() instanceof AbstractArrow;
                boolean fromPiercingArrow = fromArrow && ((AbstractArrow)pSource.m_7640_()).m_36796_() > 0;
                boolean fromPlayer = pSource.m_7639_() instanceof Player;
                if (!fromPlayer && !fromArrow) {
                    return false;
                }
                if (fromPlayer && !((Player)pSource.m_7639_()).m_150110_().f_35938_) {
                    return false;
                }
                if (pSource.m_19390_()) {
                    this.playBrokenSound();
                    this.showBreakingParticles();
                    this.m_6074_();
                    return fromPiercingArrow;
                }
                long time = this.f_19853_.m_46467_();
                if (time - this.lastHit > 5L && !fromArrow) {
                    this.f_19853_.m_7605_((Entity)this, (byte)32);
                    this.m_146852_(GameEvent.f_157808_, pSource.m_7639_());
                    this.lastHit = time;
                } else {
                    this.brokenByPlayer(pSource);
                    this.showBreakingParticles();
                    this.m_6074_();
                }
                return true;
            }
            return false;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    protected void showBreakingParticles() {
        block2: {
            if (!(this.f_19853_ instanceof ServerLevel)) break block2;
            var4_1 = ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)this.getMaterial()));
            if (!(var4_1 instanceof BuildingMaterialItem)) ** GOTO lbl-1000
            buildingItem = (BuildingMaterialItem)var4_1;
            var4_1 = buildingItem.getRecipes((Level)this.f_19853_, null).get((int)0).output;
            if (var4_1 instanceof BlockItem) {
                blockItem = (BlockItem)var4_1;
                state = blockItem.m_40614_().m_49966_();
            } else lbl-1000:
            // 2 sources

            {
                state = ((Block)BlocksNF.PLANK_BLOCKS.get(Tree.OAK).get()).m_49966_();
            }
            ((ServerLevel)this.f_19853_).m_8767_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, state), this.m_20185_(), this.m_20227_(0.6666666666666666), this.m_20189_(), 10, (double)(this.m_20205_() / 4.0f), (double)(this.m_20206_() / 4.0f), (double)(this.m_20205_() / 4.0f), 0.05);
        }
    }

    @Override
    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)this.getMaterial())));
    }

    public void m_6210_() {
        double d0 = this.m_20185_();
        double d1 = this.m_20186_();
        double d2 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d0, d1, d2);
    }

    private boolean hasPhysics() {
        return !this.isMarker() && !this.m_20068_();
    }

    public boolean m_6142_() {
        return super.m_6142_() && this.hasPhysics();
    }

    public Iterable<ItemStack> m_6167_() {
        return this.handItems;
    }

    public Iterable<ItemStack> m_6168_() {
        return this.armorItems;
    }

    public ItemStack m_6844_(EquipmentSlot pSlot) {
        switch (pSlot.m_20743_()) {
            case HAND: {
                return (ItemStack)this.handItems.get(pSlot.m_20749_());
            }
            case ARMOR: {
                return (ItemStack)this.armorItems.get(pSlot.m_20749_());
            }
        }
        return ItemStack.f_41583_;
    }

    public void m_8061_(EquipmentSlot pSlot, ItemStack pStack) {
        this.m_181122_(pStack);
        switch (pSlot.m_20743_()) {
            case HAND: {
                this.m_147218_(pStack);
                this.handItems.set(pSlot.m_20749_(), (Object)pStack);
                break;
            }
            case ARMOR: {
                this.m_147218_(pStack);
                this.armorItems.set(pSlot.m_20749_(), (Object)pStack);
            }
        }
    }

    public boolean m_7066_(ItemStack pItemstack) {
        EquipmentSlot equipmentslot = Mob.m_147233_((ItemStack)pItemstack);
        return this.m_6844_(equipmentslot).m_41619_() && !this.isDisabled(equipmentslot);
    }

    private void readPose(CompoundTag pTagCompound) {
        ListTag listtag = pTagCompound.m_128437_("Head", 5);
        this.setHeadPose(listtag.isEmpty() ? ZERO : new Rotations(listtag));
        ListTag listtag1 = pTagCompound.m_128437_("Body", 5);
        this.setBodyPose(listtag1.isEmpty() ? ZERO : new Rotations(listtag1));
        ListTag listtag2 = pTagCompound.m_128437_("LeftArm", 5);
        this.setLeftArmPose(listtag2.isEmpty() ? DEFAULT_LEFT_ARM_POSE : new Rotations(listtag2));
        ListTag listtag3 = pTagCompound.m_128437_("RightArm", 5);
        this.setRightArmPose(listtag3.isEmpty() ? DEFAULT_RIGHT_ARM_POSE : new Rotations(listtag3));
        ListTag listtag4 = pTagCompound.m_128437_("LeftLeg", 5);
        this.setLeftLegPose(listtag4.isEmpty() ? ZERO : new Rotations(listtag4));
        ListTag listtag5 = pTagCompound.m_128437_("RightLeg", 5);
        this.setRightLegPose(listtag5.isEmpty() ? ZERO : new Rotations(listtag5));
    }

    private CompoundTag writePose() {
        CompoundTag compoundtag = new CompoundTag();
        if (!ZERO.equals((Object)this.headPose)) {
            compoundtag.m_128365_("Head", (Tag)this.headPose.m_123155_());
        }
        if (!ZERO.equals((Object)this.bodyPose)) {
            compoundtag.m_128365_("Body", (Tag)this.bodyPose.m_123155_());
        }
        if (!DEFAULT_LEFT_ARM_POSE.equals((Object)this.leftArmPose)) {
            compoundtag.m_128365_("LeftArm", (Tag)this.leftArmPose.m_123155_());
        }
        if (!DEFAULT_RIGHT_ARM_POSE.equals((Object)this.rightArmPose)) {
            compoundtag.m_128365_("RightArm", (Tag)this.rightArmPose.m_123155_());
        }
        if (!ZERO.equals((Object)this.leftLegPose)) {
            compoundtag.m_128365_("LeftLeg", (Tag)this.leftLegPose.m_123155_());
        }
        if (!ZERO.equals((Object)this.rightLegPose)) {
            compoundtag.m_128365_("RightLeg", (Tag)this.rightLegPose.m_123155_());
        }
        return compoundtag;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity pEntity) {
    }

    protected void m_6138_() {
        if (this.f_19853_.f_46443_) {
            return;
        }
        List list = this.f_19853_.m_6249_((Entity)this, this.m_142469_(), RIDEABLE_MINECARTS);
        for (int i = 0; i < list.size(); ++i) {
            Entity entity = (Entity)list.get(i);
            if (!(this.m_20280_(entity) <= 0.2)) continue;
            entity.m_7334_((Entity)this);
        }
    }

    public boolean m_5830_() {
        if (this.f_19853_.f_46443_) {
            return false;
        }
        return super.m_5830_();
    }

    protected InteractionResult tryItemSwap(Player pPlayer, Vec3 pVec, InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (!this.isMarker() && !itemstack.m_150930_(Items.f_42656_)) {
            if (pPlayer.m_5833_()) {
                return InteractionResult.SUCCESS;
            }
            if (pPlayer.f_19853_.f_46443_) {
                return InteractionResult.CONSUME;
            }
            EquipmentSlot equipmentslot = Mob.m_147233_((ItemStack)itemstack);
            if (itemstack.m_41619_()) {
                EquipmentSlot equipmentslot2;
                EquipmentSlot equipmentslot1 = this.getClickedSlot(pVec);
                EquipmentSlot equipmentSlot = equipmentslot2 = this.isDisabled(equipmentslot1) ? equipmentslot : equipmentslot1;
                if (this.m_21033_(equipmentslot2) && this.swapItem(pPlayer, equipmentslot2, itemstack, pHand)) {
                    return InteractionResult.SUCCESS;
                }
            } else {
                if (this.isDisabled(equipmentslot)) {
                    return InteractionResult.FAIL;
                }
                if (equipmentslot.m_20743_() == EquipmentSlot.Type.HAND && !this.isShowArms()) {
                    return InteractionResult.FAIL;
                }
                if (this.swapItem(pPlayer, equipmentslot, itemstack, pHand)) {
                    return InteractionResult.SUCCESS;
                }
            }
            return InteractionResult.PASS;
        }
        return InteractionResult.PASS;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private EquipmentSlot getClickedSlot(Vec3 p_31660_) {
        EquipmentSlot equipmentslot = EquipmentSlot.MAINHAND;
        boolean flag = this.isSmall();
        double d0 = flag ? p_31660_.f_82480_ * 2.0 : p_31660_.f_82480_;
        EquipmentSlot equipmentslot1 = EquipmentSlot.FEET;
        if (d0 >= 0.1) {
            double d = flag ? 0.8 : 0.45;
            if (d0 < 0.1 + d && this.m_21033_(equipmentslot1)) {
                return EquipmentSlot.FEET;
            }
        }
        double d = flag ? 0.3 : 0.0;
        if (d0 >= 0.9 + d) {
            double d2 = flag ? 1.0 : 0.7;
            if (d0 < 0.9 + d2 && this.m_21033_(EquipmentSlot.CHEST)) {
                return EquipmentSlot.CHEST;
            }
        }
        if (d0 >= 0.4) {
            double d3 = flag ? 1.0 : 0.8;
            if (d0 < 0.4 + d3 && this.m_21033_(EquipmentSlot.LEGS)) {
                return EquipmentSlot.LEGS;
            }
        }
        if (d0 >= 1.6 && this.m_21033_(EquipmentSlot.HEAD)) {
            return EquipmentSlot.HEAD;
        }
        if (this.m_21033_(EquipmentSlot.MAINHAND)) return equipmentslot;
        if (!this.m_21033_(EquipmentSlot.OFFHAND)) return equipmentslot;
        return EquipmentSlot.OFFHAND;
    }

    private boolean isDisabled(EquipmentSlot pSlot) {
        return (this.disabledSlots & 1 << pSlot.m_20750_()) != 0 || pSlot.m_20743_() == EquipmentSlot.Type.HAND && !this.isShowArms();
    }

    private boolean swapItem(Player pPlayer, EquipmentSlot pSlot, ItemStack pStack, InteractionHand pHand) {
        ItemStack itemstack = this.m_6844_(pSlot);
        if (!itemstack.m_41619_() && (this.disabledSlots & 1 << pSlot.m_20750_() + 8) != 0) {
            return false;
        }
        if (itemstack.m_41619_() && (this.disabledSlots & 1 << pSlot.m_20750_() + 16) != 0) {
            return false;
        }
        if (pPlayer.m_150110_().f_35937_ && itemstack.m_41619_() && !pStack.m_41619_()) {
            ItemStack itemstack2 = pStack.m_41777_();
            itemstack2.m_41764_(1);
            this.m_8061_(pSlot, itemstack2);
            return true;
        }
        if (!pStack.m_41619_() && pStack.m_41613_() > 1) {
            if (!itemstack.m_41619_()) {
                return false;
            }
            ItemStack itemstack1 = pStack.m_41777_();
            itemstack1.m_41764_(1);
            this.m_8061_(pSlot, itemstack1);
            pStack.m_41774_(1);
            return true;
        }
        this.m_8061_(pSlot, pStack);
        pPlayer.m_21008_(pHand, itemstack);
        return true;
    }

    public void m_7822_(byte pId) {
        if (pId == 32) {
            if (this.f_19853_.f_46443_) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11683_, this.m_5720_(), 0.3f, 1.0f, false);
                this.lastHit = this.f_19853_.m_46467_();
            }
        } else {
            super.m_7822_(pId);
        }
    }

    public boolean m_6783_(double pDistance) {
        double d0 = this.m_142469_().m_82309_() * 4.0;
        if (Double.isNaN(d0) || d0 == 0.0) {
            d0 = 4.0;
        }
        return pDistance < (d0 *= 64.0) * d0;
    }

    private void causeDamage(DamageSource p_31649_, float p_31650_) {
        float f = this.m_21223_();
        if ((f -= p_31650_) <= 0.5f) {
            this.brokenByAnything(p_31649_);
            this.m_6074_();
        } else {
            this.m_21153_(f);
            this.m_146852_(GameEvent.f_157808_, p_31649_.m_7639_());
        }
    }

    private void brokenByAnything(DamageSource p_31654_) {
        this.playBrokenSound();
        this.m_6668_(p_31654_);
        for (int i = 0; i < this.handItems.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.handItems.get(i);
            if (itemstack.m_41619_()) continue;
            Block.m_49840_((Level)this.f_19853_, (BlockPos)this.m_142538_().m_7494_(), (ItemStack)itemstack);
            this.handItems.set(i, (Object)ItemStack.f_41583_);
        }
        for (int j = 0; j < this.armorItems.size(); ++j) {
            ItemStack itemstack1 = (ItemStack)this.armorItems.get(j);
            if (itemstack1.m_41619_()) continue;
            Block.m_49840_((Level)this.f_19853_, (BlockPos)this.m_142538_().m_7494_(), (ItemStack)itemstack1);
            this.armorItems.set(j, (Object)ItemStack.f_41583_);
        }
    }

    private void playBrokenSound() {
        this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11681_, this.m_5720_(), 1.0f, 1.0f);
    }

    protected float m_5632_(float p_31644_, float p_31645_) {
        this.f_20884_ = this.f_19859_;
        this.f_20883_ = this.m_146908_();
        return 0.0f;
    }

    protected float m_6431_(Pose pPose, EntityDimensions pSize) {
        return pSize.f_20378_ * (this.m_6162_() ? 0.5f : 0.9f);
    }

    public double m_6049_() {
        return this.isMarker() ? 0.0 : (double)0.1f;
    }

    public void m_7023_(Vec3 pTravelVector) {
        if (this.hasPhysics()) {
            super.m_7023_(pTravelVector);
        }
    }

    public void m_5618_(float pOffset) {
        this.f_20884_ = this.f_19859_ = pOffset;
        this.f_20886_ = this.f_20885_ = pOffset;
    }

    public void m_5616_(float pRotation) {
        this.f_20884_ = this.f_19859_ = pRotation;
        this.f_20886_ = this.f_20885_ = pRotation;
    }

    public void m_8119_() {
        Rotations rotations5;
        Rotations rotations4;
        Rotations rotations3;
        Rotations rotations2;
        Rotations rotations1;
        super.m_8119_();
        Rotations rotations = (Rotations)this.f_19804_.m_135370_(DATA_HEAD_POSE);
        if (!this.headPose.equals((Object)rotations)) {
            this.setHeadPose(rotations);
        }
        if (!this.bodyPose.equals((Object)(rotations1 = (Rotations)this.f_19804_.m_135370_(DATA_BODY_POSE)))) {
            this.setBodyPose(rotations1);
        }
        if (!this.leftArmPose.equals((Object)(rotations2 = (Rotations)this.f_19804_.m_135370_(DATA_LEFT_ARM_POSE)))) {
            this.setLeftArmPose(rotations2);
        }
        if (!this.rightArmPose.equals((Object)(rotations3 = (Rotations)this.f_19804_.m_135370_(DATA_RIGHT_ARM_POSE)))) {
            this.setRightArmPose(rotations3);
        }
        if (!this.leftLegPose.equals((Object)(rotations4 = (Rotations)this.f_19804_.m_135370_(DATA_LEFT_LEG_POSE)))) {
            this.setLeftLegPose(rotations4);
        }
        if (!this.rightLegPose.equals((Object)(rotations5 = (Rotations)this.f_19804_.m_135370_(DATA_RIGHT_LEG_POSE)))) {
            this.setRightLegPose(rotations5);
        }
    }

    protected void m_8034_() {
        this.m_6842_(this.invisible);
    }

    public void m_6842_(boolean pInvisible) {
        this.invisible = pInvisible;
        super.m_6842_(pInvisible);
    }

    public boolean m_6162_() {
        return this.isSmall();
    }

    public void m_6074_() {
        this.m_142687_(Entity.RemovalReason.KILLED);
    }

    public boolean m_6128_() {
        return this.m_20145_();
    }

    public PushReaction m_7752_() {
        return this.isMarker() ? PushReaction.IGNORE : super.m_7752_();
    }

    private void setSmall(boolean pSmall) {
        this.f_19804_.m_135381_(DATA_CLIENT_FLAGS, (Object)this.setBit((Byte)this.f_19804_.m_135370_(DATA_CLIENT_FLAGS), 1, pSmall));
    }

    public boolean isSmall() {
        return ((Byte)this.f_19804_.m_135370_(DATA_CLIENT_FLAGS) & 1) != 0;
    }

    public boolean isShowArms() {
        return ((Byte)this.f_19804_.m_135370_(DATA_CLIENT_FLAGS) & 4) != 0;
    }

    private void setNoBasePlate(boolean pNoBasePlate) {
        this.f_19804_.m_135381_(DATA_CLIENT_FLAGS, (Object)this.setBit((Byte)this.f_19804_.m_135370_(DATA_CLIENT_FLAGS), 8, pNoBasePlate));
    }

    public boolean isNoBasePlate() {
        return ((Byte)this.f_19804_.m_135370_(DATA_CLIENT_FLAGS) & 8) != 0;
    }

    private void setMarker(boolean pMarker) {
        this.f_19804_.m_135381_(DATA_CLIENT_FLAGS, (Object)this.setBit((Byte)this.f_19804_.m_135370_(DATA_CLIENT_FLAGS), 16, pMarker));
    }

    public boolean isMarker() {
        return ((Byte)this.f_19804_.m_135370_(DATA_CLIENT_FLAGS) & 0x10) != 0;
    }

    public void setHeadPose(Rotations pVec) {
        this.headPose = pVec;
        this.f_19804_.m_135381_(DATA_HEAD_POSE, (Object)pVec);
    }

    public void setBodyPose(Rotations pVec) {
        this.bodyPose = pVec;
        this.f_19804_.m_135381_(DATA_BODY_POSE, (Object)pVec);
    }

    public void setLeftArmPose(Rotations pVec) {
        this.leftArmPose = pVec;
        this.f_19804_.m_135381_(DATA_LEFT_ARM_POSE, (Object)pVec);
    }

    public void setRightArmPose(Rotations pVec) {
        this.rightArmPose = pVec;
        this.f_19804_.m_135381_(DATA_RIGHT_ARM_POSE, (Object)pVec);
    }

    public void setLeftLegPose(Rotations pVec) {
        this.leftLegPose = pVec;
        this.f_19804_.m_135381_(DATA_LEFT_LEG_POSE, (Object)pVec);
    }

    public void setRightLegPose(Rotations pVec) {
        this.rightLegPose = pVec;
        this.f_19804_.m_135381_(DATA_RIGHT_LEG_POSE, (Object)pVec);
    }

    public Rotations getHeadPose() {
        return this.headPose;
    }

    public Rotations getBodyPose() {
        return this.bodyPose;
    }

    public Rotations getLeftArmPose() {
        return this.leftArmPose;
    }

    public Rotations getRightArmPose() {
        return this.rightArmPose;
    }

    public Rotations getLeftLegPose() {
        return this.leftLegPose;
    }

    public Rotations getRightLegPose() {
        return this.rightLegPose;
    }

    public boolean m_6087_() {
        return super.m_6087_() && !this.isMarker();
    }

    public boolean m_7313_(Entity pEntity) {
        Player player;
        return pEntity instanceof Player && !this.f_19853_.m_7966_(player = (Player)pEntity, this.m_142538_());
    }

    public HumanoidArm m_5737_() {
        return HumanoidArm.RIGHT;
    }

    public LivingEntity.Fallsounds m_196493_() {
        return new LivingEntity.Fallsounds(SoundEvents.f_11682_, SoundEvents.f_11682_);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11683_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11681_;
    }

    public void m_8038_(ServerLevel level, LightningBolt pLightning) {
    }

    public boolean m_5801_() {
        return false;
    }

    public void m_7350_(EntityDataAccessor<?> pKey) {
        if (DATA_CLIENT_FLAGS.equals(pKey)) {
            this.m_6210_();
            this.f_19850_ = !this.isMarker();
        }
        super.m_7350_(pKey);
    }

    public boolean m_5789_() {
        return false;
    }

    public EntityDimensions m_6972_(Pose pPose) {
        return this.getDimensionsMarker(this.isMarker());
    }

    private EntityDimensions getDimensionsMarker(boolean p_31684_) {
        if (p_31684_) {
            return MARKER_DIMENSIONS;
        }
        return this.m_6162_() ? this.m_6095_().m_20680_().m_20388_(0.5f) : this.m_6095_().m_20680_();
    }

    public Vec3 m_7371_(float pPartialTicks) {
        if (this.isMarker()) {
            AABB aabb = this.getDimensionsMarker(false).m_20393_(this.m_20182_());
            BlockPos blockpos = this.m_142538_();
            int i = Integer.MIN_VALUE;
            for (BlockPos blockpos1 : BlockPos.m_121940_((BlockPos)new BlockPos(aabb.f_82288_, aabb.f_82289_, aabb.f_82290_), (BlockPos)new BlockPos(aabb.f_82291_, aabb.f_82292_, aabb.f_82293_))) {
                int j = Math.max(this.f_19853_.m_45517_(LightLayer.BLOCK, blockpos1), this.f_19853_.m_45517_(LightLayer.SKY, blockpos1));
                if (j == 15) {
                    return Vec3.m_82512_((Vec3i)blockpos1);
                }
                if (j <= i) continue;
                i = j;
                blockpos = blockpos1.m_7949_();
            }
            return Vec3.m_82512_((Vec3i)blockpos);
        }
        return super.m_7371_(pPartialTicks);
    }

    public boolean m_142065_() {
        return !this.m_20145_() && !this.isMarker();
    }
}

