/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.entity;

import frostnox.nightfall.block.Tree;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.entity.IEntityWithItem;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.entity.entity.ArmorStandDummyEntity;
import frostnox.nightfall.registry.forge.EntitiesNF;
import frostnox.nightfall.registry.forge.ItemsNF;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.registries.ForgeRegistries;

public class BoatEntity
extends Boat
implements IEntityWithItem {
    private static final EntityDataAccessor<String> MATERIAL = SynchedEntityData.m_135353_(ArmorStandDummyEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135030_);

    public BoatEntity(EntityType<? extends BoatEntity> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public BoatEntity(Level pLevel, double pX, double pY, double pZ) {
        this((EntityType<? extends BoatEntity>)((EntityType)EntitiesNF.BOAT.get()), pLevel);
        this.m_6034_(pX, pY, pZ);
        this.f_19854_ = pX;
        this.f_19855_ = pY;
        this.f_19856_ = pZ;
    }

    private void setMaterial(String name) {
        if (name.contains(":")) {
            this.f_19804_.m_135381_(MATERIAL, (Object)name);
        }
    }

    public void setMaterial(ResourceLocation id) {
        this.f_19804_.m_135381_(MATERIAL, (Object)id.toString());
    }

    public String getMaterial() {
        return (String)this.f_19804_.m_135370_(MATERIAL);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(MATERIAL, (Object)ItemsNF.PLANKS.get(Tree.OAK).getId().toString());
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128359_("Material", this.getMaterial());
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setMaterial(pCompound.m_128461_("Material"));
    }

    public Item m_38369_() {
        return (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)this.getMaterial()));
    }

    @Override
    public Item getItemForm() {
        return (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)this.getMaterial().replace("plank", "boat")));
    }

    @Override
    public ItemStack getPickedResult(HitResult target) {
        return new ItemStack((ItemLike)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)this.getMaterial())));
    }

    public boolean m_6469_(DamageSource pSource, float pAmount) {
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (!this.f_19853_.f_46443_ && !this.m_146910_()) {
            boolean canDrop;
            this.m_38362_(-this.m_38386_());
            this.m_38354_(10);
            this.m_38311_(this.m_38384_() + pAmount * 10.0f);
            this.m_5834_();
            this.m_146852_(GameEvent.f_157808_, pSource.m_7639_());
            boolean bl = canDrop = pSource.m_7639_() instanceof Player && ((Player)pSource.m_7639_()).m_150110_().f_35937_;
            if (canDrop || this.m_38384_() > 40.0f) {
                if (!canDrop && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                    this.m_19983_(new ItemStack((ItemLike)this.m_38369_(), 16));
                }
                this.m_146870_();
            }
            return true;
        }
        return true;
    }

    public float m_38377_() {
        return Math.min(0.8f, super.m_38377_());
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState pState, BlockPos pPos) {
        this.f_38281_ = this.m_20184_().f_82480_;
        if (!this.m_20159_()) {
            if (pOnGround) {
                if (this.f_19789_ > 3.0f) {
                    this.m_142535_(this.f_19789_, 1.0f, DamageSource.f_19315_);
                    if (!this.f_19853_.f_46443_ && this.f_19789_ >= 10.0f && !this.m_146910_()) {
                        this.m_6074_();
                        if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                            this.m_19983_(new ItemStack((ItemLike)this.m_38369_(), 16));
                        }
                    }
                }
                this.m_183634_();
            } else if (!this.f_19853_.m_6425_(this.m_142538_().m_7495_()).m_205070_(FluidTags.f_13131_) && pY < 0.0) {
                this.f_19789_ -= (float)pY;
            }
        }
    }

    protected void m_38396_() {
        Player player;
        Entity entity = this.m_6688_();
        if (entity instanceof Player && (player = (Player)entity).m_6084_() && (player.m_6117_() || !ActionTracker.get((Entity)player).isInactive())) {
            this.m_38339_(false, false);
            return;
        }
        super.m_38396_();
    }

    protected void m_38321_(Entity rider) {
        if (!rider.m_6084_() || !(rider instanceof Player) && !(rider instanceof ActionableEntity) || ActionTracker.get(rider).isInactive()) {
            rider.m_5618_(this.m_146908_());
        }
        float rot = Mth.m_14177_((float)(rider.m_146908_() - this.m_146908_()));
        float maxRot = Mth.m_14036_((float)rot, (float)-105.0f, (float)105.0f);
        rider.f_19859_ += maxRot - rot;
        rider.m_146922_(rider.m_146908_() + maxRot - rot);
        rider.m_5616_(rider.m_146908_());
    }
}

