/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.entity;

import frostnox.nightfall.action.DamageTypeSource;
import frostnox.nightfall.block.IFoodBlock;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.entity.IHungerEntity;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.entity.EatItemToClient;
import frostnox.nightfall.util.LevelUtil;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public abstract class HungryEntity
extends ActionableEntity
implements IHungerEntity {
    protected int satiety;

    public HungryEntity(EntityType<? extends ActionableEntity> type, Level level) {
        super(type, level);
    }

    public double getSatietyPercent() {
        return (double)this.satiety / (double)this.getMaxSatiety();
    }

    public int getSatiety() {
        return this.satiety;
    }

    protected abstract int getMaxSatiety();

    public int m_8100_() {
        return 120;
    }

    public void m_8024_() {
        super.m_8024_();
        if (this.satiety > 0) {
            --this.satiety;
        }
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.satiety > 0) {
            tag.m_128405_("satiety", this.satiety);
        }
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.satiety = tag.m_128451_("satiety");
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        this.satiety = this.getMaxSatiety() / 2 + this.f_19796_.nextInt(this.getMaxSatiety() / 2);
        return super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    public void addSatiety(int amount) {
        this.satiety = Mth.m_14045_((int)(this.satiety + amount), (int)0, (int)this.getMaxSatiety());
    }

    @Override
    public boolean isHungry() {
        return this.satiety <= 0;
    }

    @Override
    public void eatBlock(BlockState state, BlockPos pos) {
        if (this.canEat(state)) {
            this.m_5496_(this.getEatSound(), 1.0f, 1.0f);
            Block block = state.m_60734_();
            if (block instanceof IFoodBlock) {
                IFoodBlock foodBlock = (IFoodBlock)block;
                foodBlock.eat((Entity)this, this.f_19853_, pos);
            } else {
                LevelUtil.destroyBlockNoSound((LevelAccessor)this.f_19853_, pos, true, (Entity)this);
            }
            this.addSatiety(this.getMaxSatiety());
        }
    }

    @Override
    public void eatEntity(Entity entity) {
        if (!this.f_19853_.f_46443_ && this.canEat(entity)) {
            if (entity instanceof ItemEntity) {
                ItemEntity itemEntity = (ItemEntity)entity;
                ItemStack item = itemEntity.m_32055_();
                NetworkHandler.toAllTracking((Entity)this, new EatItemToClient(item.m_41777_(), this.m_142049_()));
                item.m_41764_(item.m_41613_() - 1);
            } else {
                if (entity instanceof ActionableEntity) {
                    ActionableEntity actionable;
                    actionable.forceDropAllDeathLoot((actionable = (ActionableEntity)entity).m_21225_() == null ? DamageTypeSource.GENERIC : actionable.m_21225_());
                }
                if (entity instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)entity;
                    this.f_19853_.m_7605_(entity, (byte)60);
                    ItemStack foodDrop = ItemStack.f_41583_;
                    for (Item item : LevelUtil.getAllLootItems(livingEntity.m_5743_(), (ServerLevel)this.f_19853_)) {
                        if (!item.m_204114_().m_203656_(TagsNF.CARNIVORE_FOOD)) continue;
                        foodDrop = new ItemStack((ItemLike)item);
                        break;
                    }
                    NetworkHandler.toAllTracking((Entity)this, new EatItemToClient(foodDrop, this.m_142049_()));
                }
                entity.m_142687_(Entity.RemovalReason.KILLED);
            }
            this.addSatiety(this.getMaxSatiety());
        }
    }
}

