/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.entity;

import frostnox.nightfall.Nightfall;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.DamageTypeSource;
import frostnox.nightfall.block.BlockStatePropertiesNF;
import frostnox.nightfall.block.IDropsItems;
import frostnox.nightfall.block.IFallable;
import frostnox.nightfall.block.IWaterloggedBlock;
import frostnox.nightfall.block.block.DirtBlock;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.GenericEntityToClient;
import frostnox.nightfall.registry.forge.BlocksNF;
import frostnox.nightfall.registry.forge.EntitiesNF;
import frostnox.nightfall.util.LevelUtil;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.CrashReportCategory;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.Containers;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.logging.log4j.Logger;

public class MovingBlockEntity
extends Entity {
    public static final int SLIDE_DURATION = 4;
    public static final int SOUND_DURATION = 18;
    public static final double SLIDE_SPEED = 0.25;
    private static final Logger LOGGER = Nightfall.LOGGER;
    private BlockState blockState = ((DirtBlock)BlocksNF.DIRT.get()).m_49966_();
    private SoundEvent sound = null;
    public int time;
    protected int slideTime;
    protected int soundTime;
    public boolean dropItem = true;
    private boolean hurtEntities;
    private int fallDamageMax = 40;
    private float fallDamagePerDistance;
    private boolean queueDiscard = false;
    private boolean triedPlacement = false;
    @Nullable
    public CompoundTag blockData;
    protected static final EntityDataAccessor<BlockPos> DATA_START_POS = SynchedEntityData.m_135353_(MovingBlockEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135038_);
    public Direction slideDir = Direction.DOWN;
    public boolean makeSlideParticles = true;
    public boolean canRender = true;

    public MovingBlockEntity(EntityType<? extends MovingBlockEntity> type, Level level) {
        super(type, level);
    }

    protected MovingBlockEntity(Level level, BlockPos pos, BlockState state) {
        this((EntityType<? extends MovingBlockEntity>)((EntityType)EntitiesNF.MOVING_BLOCK.get()), level);
        double x = (double)pos.m_123341_() + 0.5;
        double y = (double)pos.m_123342_() + 0.005;
        double z = (double)pos.m_123343_() + 0.5;
        this.setBlockState(state);
        this.f_19850_ = true;
        this.m_6034_(x, y, z);
        this.m_20256_(Vec3.f_82478_);
        this.f_19854_ = x;
        this.f_19855_ = y;
        this.f_19856_ = z;
        this.setStartPos(this.m_142538_());
        float strength = state.m_60734_().m_155943_();
        this.setHurtsEntities(strength < 0.0f ? 15.0f : Math.min(strength * 2.5f, 17.5f), 250);
        Block block = state.m_60734_();
        if (block instanceof IFallable) {
            IFallable fallable = (IFallable)block;
            fallable.onMovingBlockEntityCreated(state, level, pos, this);
        }
    }

    public static MovingBlockEntity fall(Level level, BlockPos pos, BlockState state) {
        level.m_7731_(pos, state.m_60819_().m_76188_(), 3);
        if (state.m_61138_((Property)BlockStatePropertiesNF.WATER_LEVEL)) {
            state = (BlockState)state.m_61124_((Property)BlockStatePropertiesNF.WATER_LEVEL, (Comparable)Integer.valueOf(0));
        }
        MovingBlockEntity entity = new MovingBlockEntity(level, pos, state);
        level.m_7967_((Entity)entity);
        entity.playSound();
        return entity;
    }

    public static MovingBlockEntity slide(Level level, BlockPos pos, Direction direction, BlockState state) {
        level.m_7731_(pos, state.m_60819_().m_76188_(), 3);
        if (state.m_61138_((Property)BlockStatePropertiesNF.WATER_LEVEL)) {
            state = (BlockState)state.m_61124_((Property)BlockStatePropertiesNF.WATER_LEVEL, (Comparable)Integer.valueOf(0));
        }
        MovingBlockEntity entity = new MovingBlockEntity(level, pos, state);
        entity.slideDir = direction;
        level.m_7967_((Entity)entity);
        return entity;
    }

    public boolean m_6097_() {
        return false;
    }

    public void setBlockState(BlockState state) {
        this.blockState = state;
        Block block = state.m_60734_();
        if (block instanceof IFallable) {
            IFallable fallable = (IFallable)block;
            this.sound = fallable.getFallSound(state);
        } else {
            this.sound = null;
        }
    }

    public void setStartPos(BlockPos pOrigin) {
        this.f_19804_.m_135381_(DATA_START_POS, (Object)pOrigin);
    }

    public BlockPos getStartPos() {
        return (BlockPos)this.f_19804_.m_135370_(DATA_START_POS);
    }

    public int getSlideTime() {
        return this.slideTime;
    }

    public void setSlideTime(int slideTime) {
        this.slideTime = slideTime;
    }

    public boolean isSliding() {
        return this.slideTime > 0 && this.slideTime <= 4;
    }

    public void recenterPos() {
        if (this.m_20185_() % 1.0 != 0.5 || this.m_20189_() % 1.0 != 0.5) {
            this.m_6034_((double)Mth.m_14107_((double)this.m_20185_()) + 0.5, this.m_20186_(), (double)Mth.m_14107_((double)this.m_20189_()) + 0.5);
        }
    }

    public void queueDiscard() {
        this.queueDiscard = true;
        if (!this.f_19853_.m_5776_()) {
            NetworkHandler.toAllTracking(this, new GenericEntityToClient(NetworkHandler.Type.MOVING_BLOCK_STOP_PHYSICS_CLIENT, this.m_142049_()));
        }
    }

    public void playSound() {
        if (!this.f_19853_.f_46443_) {
            this.soundTime = this.sound != null ? 1 : 0;
            this.f_19853_.m_6269_(null, (Entity)this, this.sound, SoundSource.BLOCKS, 1.5f, 0.94f + this.f_19853_.f_46441_.nextFloat() * 0.12f);
        }
    }

    public boolean m_6000_(double x, double pY, double z) {
        if (this.blockState.m_60795_()) {
            return false;
        }
        return super.m_6000_(x, pY, z);
    }

    protected float m_6380_(Pose pPose, EntityDimensions pSize) {
        return pSize.f_20378_ * 0.5f;
    }

    protected Entity.MovementEmission m_142319_() {
        return Entity.MovementEmission.NONE;
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(DATA_START_POS, (Object)BlockPos.f_121853_);
    }

    public boolean m_6087_() {
        return !this.m_146910_();
    }

    protected AABB m_142242_() {
        if (this.queueDiscard) {
            return AABB.m_165882_((Vec3)this.m_20182_(), (double)0.0, (double)0.0, (double)0.0);
        }
        if (this.blockState == null) {
            return super.m_142242_();
        }
        VoxelShape shape = this.blockState.m_60812_((BlockGetter)this.f_19853_, this.m_142538_());
        if (shape.m_83281_()) {
            return AABB.m_165882_((Vec3)this.m_20182_(), (double)0.0, (double)0.0, (double)0.0);
        }
        if (shape == Shapes.m_83144_()) {
            return super.m_142242_();
        }
        AABB box = shape.m_83215_();
        double xSize = box.m_82362_() * 0.99 / 2.0;
        double zSize = box.m_82385_() * 0.99 / 2.0;
        return new AABB(this.m_20185_() - xSize, this.m_20186_(), this.m_20189_() - zSize, this.m_20185_() + xSize, this.m_20186_() + box.m_82376_() * 0.99, this.m_20189_() + zSize);
    }

    public BlockPos m_20097_() {
        return new BlockPos(Mth.m_14107_((double)this.m_20182_().f_82479_), Mth.m_14107_((double)(this.m_20182_().f_82480_ - 0.2)), Mth.m_14107_((double)this.m_20182_().f_82481_));
    }

    public void m_8119_() {
        this.triedPlacement = false;
        if (this.queueDiscard && !this.f_19853_.m_5776_()) {
            this.blockState = Blocks.f_50016_.m_49966_();
            NetworkHandler.toAllTracking(this, new GenericEntityToClient(NetworkHandler.Type.MOVING_BLOCK_SET_AIR_CLIENT, this.m_142049_()));
            this.queueDiscard = false;
        }
        if (this.blockState.m_60795_()) {
            if (!this.f_19853_.f_46443_) {
                if (this.soundTime == 0) {
                    this.m_146870_();
                }
                ++this.soundTime;
                if (this.soundTime > 18) {
                    this.m_146870_();
                }
            }
            this.m_142242_();
        } else {
            boolean canSlide;
            Block block = this.blockState.m_60734_();
            ++this.time;
            boolean bl = canSlide = this.slideDir != Direction.DOWN;
            if (canSlide) {
                ++this.slideTime;
            }
            if (this.soundTime > 0) {
                ++this.soundTime;
                if (this.soundTime > 18) {
                    this.soundTime = 0;
                }
            }
            boolean isSliding = this.isSliding() && canSlide;
            BlockPos blockPos = this.m_142538_();
            if (isSliding) {
                if (this.slideTime == 1) {
                    this.f_19794_ = true;
                    this.m_20256_(this.m_20184_().m_82520_((double)this.slideDir.m_122429_() * 0.25, (double)this.slideDir.m_122430_() * 0.25, (double)this.slideDir.m_122431_() * 0.25));
                    this.playSound();
                }
                if (this.f_19853_.f_46443_ && this.makeSlideParticles) {
                    VoxelShape shape;
                    double x = this.m_20185_() - 0.5 + this.f_19853_.f_46441_.nextDouble();
                    double y = this.m_20186_() + 0.05;
                    double z = this.m_20189_() - 0.5 + this.f_19853_.f_46441_.nextDouble();
                    BlockState insideState = this.f_19853_.m_8055_(blockPos);
                    if (!insideState.m_60795_() && !(shape = insideState.m_60812_((BlockGetter)this.f_19853_, blockPos).m_83216_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_())).m_83281_() && shape.m_83215_().m_82393_(x, this.m_20186_(), z)) {
                        this.f_19853_.m_7106_((ParticleOptions)new BlockParticleOption(ParticleTypes.f_123794_, this.blockState), x, y, z, (this.f_19853_.f_46441_.nextDouble() - 0.5) * 2.0, 1.0 + this.f_19853_.f_46441_.nextDouble() * 0.5, (this.f_19853_.f_46441_.nextDouble() - 0.5) * 2.0);
                    }
                }
            } else if (this.slideTime == 5 && canSlide) {
                this.f_19794_ = false;
                this.m_20256_(this.m_20184_().m_82492_((double)this.slideDir.m_122429_() * 0.25, (double)this.slideDir.m_122430_() * 0.25 + 0.04, (double)this.slideDir.m_122431_() * 0.25));
            }
            if (!this.m_20068_() && this.slideDir != Direction.UP) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
            }
            this.m_6478_(MoverType.SELF, this.m_20184_());
            if (!this.f_19861_) {
                if (!(this.f_19853_.f_46443_ || (this.time <= 100 || blockPos.m_123342_() > this.f_19853_.m_141937_() && blockPos.m_123342_() <= this.f_19853_.m_151558_()) && this.time <= 6000)) {
                    if (this.dropItem && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                        this.m_19998_((ItemLike)block);
                    }
                    this.queueDiscard();
                }
            } else if (!isSliding) {
                this.recenterPos();
                this.m_20256_(this.m_20184_().m_82542_(0.7, -0.5, 0.7));
            }
            if (!this.blockState.m_60795_()) {
                if (isSliding) {
                    this.m_20256_(this.m_20184_().m_82542_(1.0, 0.98, 1.0));
                } else {
                    this.m_20256_(this.m_20184_().m_82490_(0.98));
                    if (this.f_19797_ > 0 && !this.f_19794_) {
                        Vec3 entityPos = this.m_20318_(1.0f);
                        if (this.f_19861_ || !LevelUtil.canFallThrough(this.f_19853_.m_8055_(new BlockPos(entityPos)))) {
                            this.tryPlacement();
                            this.m_6034_(entityPos.f_82479_, Math.ceil(entityPos.f_82480_), entityPos.f_82481_);
                        }
                    }
                }
            }
        }
    }

    public void tryPlacement() {
        if (this.triedPlacement || this.queueDiscard) {
            return;
        }
        this.triedPlacement = true;
        Block block = this.blockState.m_60734_();
        BlockPos blockPos = this.m_142538_();
        BlockState inState = this.f_19853_.m_8055_(blockPos);
        if (!inState.m_60713_(Blocks.f_50110_)) {
            boolean canReplace = inState.m_204336_(TagsNF.FALLING_DESTROYABLE) || inState.m_60629_((BlockPlaceContext)new DirectionalPlaceContext(this.f_19853_, blockPos, Direction.DOWN, ItemStack.f_41583_, Direction.UP));
            boolean yChanged = false;
            while (!canReplace && blockPos.m_123342_() < this.f_19853_.m_151558_()) {
                yChanged = true;
                inState = this.f_19853_.m_8055_(blockPos = blockPos.m_7494_());
                canReplace = inState.m_204336_(TagsNF.FALLING_DESTROYABLE) || inState.m_60629_((BlockPlaceContext)new DirectionalPlaceContext(this.f_19853_, blockPos, Direction.DOWN, ItemStack.f_41583_, Direction.UP));
            }
            if (yChanged) {
                this.m_6034_(this.m_20185_(), blockPos.m_123342_(), this.m_20189_());
            }
            if (!this.f_19853_.f_46443_) {
                if (canReplace && this.blockState.m_60710_((LevelReader)this.f_19853_, blockPos)) {
                    IFallable movable;
                    if (!(block instanceof IFallable) || (movable = (IFallable)block).canLand(this.f_19853_, blockPos, this.blockState, inState, this)) {
                        if (inState.m_204336_(TagsNF.FALLING_DESTROYABLE)) {
                            this.f_19853_.m_46961_(blockPos, true);
                        }
                        this.blockState = Block.m_49931_((BlockState)this.blockState, (LevelAccessor)this.f_19853_, (BlockPos)blockPos);
                        Block block2 = this.blockState.m_60734_();
                        if (block2 instanceof IWaterloggedBlock) {
                            IWaterloggedBlock waterloggable = (IWaterloggedBlock)block2;
                            this.blockState = waterloggable.addLiquidToPlacement(this.blockState, blockPos, (LevelAccessor)this.f_19853_);
                        }
                        if (this.f_19853_.m_7731_(blockPos, this.blockState, 3)) {
                            ((ServerLevel)this.f_19853_).m_7726_().f_8325_.m_140201_((Entity)this, (Packet)new ClientboundBlockUpdatePacket(blockPos, this.f_19853_.m_8055_(blockPos)));
                            this.queueDiscard();
                            if (this.blockData != null && this.blockState.m_155947_()) {
                                BlockEntity entity = this.f_19853_.m_7702_(blockPos);
                                this.loadBlockEntityData(entity);
                            }
                            if (block instanceof IFallable) {
                                IFallable movable2 = (IFallable)block;
                                movable2.onLand(this.f_19853_, blockPos, this.blockState, inState, this);
                            }
                            for (MovingBlockEntity other : this.f_19853_.m_45976_(((Object)((Object)this)).getClass(), this.m_142469_())) {
                                if (other == this || other.f_19797_ <= 0) continue;
                                other.tryPlacement();
                            }
                            if (this.blockState.m_204336_(TagsNF.SHATTER_ON_FALL)) {
                                this.f_19853_.m_46961_(blockPos, true);
                            } else {
                                this.f_19853_.m_5594_(null, blockPos, this.blockState.m_60827_().m_56776_(), SoundSource.BLOCKS, 0.55f, this.f_19853_.f_46441_.nextFloat() * 0.1f + 0.9f);
                            }
                        } else if (this.dropItem && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                            this.queueDiscard();
                            this.callOnBrokenAfterFall(block, blockPos);
                        }
                    }
                } else {
                    this.queueDiscard();
                    if (this.dropItem && this.f_19853_.m_46469_().m_46207_(GameRules.f_46137_)) {
                        this.callOnBrokenAfterFall(block, blockPos);
                    }
                }
            }
        }
    }

    protected void loadBlockEntityData(BlockEntity entity) {
        if (entity != null) {
            CompoundTag tag = entity.m_187482_();
            for (String s : this.blockData.m_128431_()) {
                tag.m_128365_(s, this.blockData.m_128423_(s).m_6426_());
            }
            try {
                entity.m_142466_(tag);
            }
            catch (Exception exception) {
                LOGGER.error("Failed to load block entity from moving block", (Throwable)exception);
            }
            entity.m_6596_();
        }
    }

    public void callOnBrokenAfterFall(Block block, BlockPos pos) {
        BlockEntity blockEntity;
        if (block instanceof IFallable) {
            IFallable movable = (IFallable)block;
            movable.onBrokenAfterFall(this.f_19853_, pos, this);
        }
        if (this.blockData != null && block instanceof EntityBlock) {
            EntityBlock entityBlock = (EntityBlock)block;
            blockEntity = entityBlock.m_142194_(pos, this.blockState);
            this.loadBlockEntityData(blockEntity);
        } else {
            blockEntity = null;
        }
        Block.m_49892_((BlockState)this.blockState, (LevelAccessor)this.f_19853_, (BlockPos)pos, blockEntity);
        if (blockEntity instanceof IDropsItems) {
            IDropsItems droppable = (IDropsItems)blockEntity;
            Containers.m_19010_((Level)this.f_19853_, (BlockPos)pos, droppable.getContainerDrops());
        }
    }

    public void setHurtsEntities(float fallDamagePerDistance, int fallDamageMax) {
        this.hurtEntities = true;
        this.fallDamagePerDistance = fallDamagePerDistance;
        this.fallDamageMax = fallDamageMax;
    }

    protected void m_7840_(double pY, boolean pOnGround, BlockState state, BlockPos pos) {
        super.m_7840_(pY, pOnGround, state, pos);
        if (this.hurtEntities && !this.f_19853_.m_5776_()) {
            DamageTypeSource damageSource;
            int fallDist = Math.max(1, Mth.m_14167_((float)this.f_19789_));
            Block block = this.blockState.m_60734_();
            if (block instanceof IFallable) {
                IFallable movable = (IFallable)block;
                damageSource = DamageTypeSource.createFallingSource(movable.getFallDamageType());
            } else {
                damageSource = DamageTypeSource.createFallingSource(DamageType.STRIKING);
            }
            int damage = Math.min(Mth.m_14143_((float)((float)fallDist * this.fallDamagePerDistance)), this.fallDamageMax);
            List entities = this.f_19853_.m_6249_((Entity)this, this.m_142469_(), LevelUtil.ALIVE_ACTION_TRACKER_ENTITY);
            for (Entity entity : entities) {
                IActionTracker capA = ActionTracker.get(entity);
                if (capA.getMovingBlockInvulnerableTime() > 0) continue;
                capA.setMovingBlockInvulnerableTime(10);
                damageSource.setSound(() -> damage >= 20 ? SoundEvents.f_12319_ : SoundEvents.f_12276_);
                entity.m_6469_((DamageSource)damageSource, (float)damage);
            }
        }
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return pFallDistance >= 3.0f * pMultiplier;
    }

    protected void m_7380_(CompoundTag pCompound) {
        pCompound.m_128365_("BlockState", (Tag)NbtUtils.m_129202_((BlockState)this.blockState));
        pCompound.m_128405_("Time", this.time);
        pCompound.m_128379_("DropItem", this.dropItem);
        pCompound.m_128379_("HurtEntities", this.hurtEntities);
        pCompound.m_128379_("QueueDiscard", this.queueDiscard);
        pCompound.m_128350_("FallHurtAmount", this.fallDamagePerDistance);
        pCompound.m_128405_("FallHurtMax", this.fallDamageMax);
        if (this.slideDir != Direction.DOWN) {
            pCompound.m_128405_("Direction", this.slideDir.ordinal());
        }
        pCompound.m_128405_("SlideTime", this.getSlideTime());
        if (this.blockData != null) {
            pCompound.m_128365_("TileEntityData", (Tag)this.blockData);
        }
    }

    protected void m_7378_(CompoundTag pCompound) {
        this.setBlockState(NbtUtils.m_129241_((CompoundTag)pCompound.m_128469_("BlockState")));
        this.time = pCompound.m_128451_("Time");
        if (pCompound.m_128425_("HurtEntities", 99)) {
            this.hurtEntities = pCompound.m_128471_("HurtEntities");
            this.fallDamagePerDistance = pCompound.m_128457_("FallHurtAmount");
            this.fallDamageMax = pCompound.m_128451_("FallHurtMax");
        } else if (this.blockState.m_204336_(BlockTags.f_13033_)) {
            this.hurtEntities = true;
        }
        this.queueDiscard = pCompound.m_128471_("QueueDiscard");
        if (pCompound.m_128425_("DropItem", 99)) {
            this.dropItem = pCompound.m_128471_("DropItem");
        }
        if (pCompound.m_128425_("TileEntityData", 10)) {
            this.blockData = pCompound.m_128469_("TileEntityData");
        }
        if (this.blockState.m_60795_()) {
            this.setBlockState(((DirtBlock)BlocksNF.DIRT.get()).m_49966_());
        }
        if (pCompound.m_128425_("Direction", 3)) {
            this.slideDir = Direction.values()[pCompound.m_128451_("Direction")];
        }
        this.setSlideTime(pCompound.m_128451_("SlideTime"));
    }

    public boolean m_6051_() {
        return false;
    }

    public void m_7976_(CrashReportCategory pCategory) {
        super.m_7976_(pCategory);
        pCategory.m_128159_("Imitating BlockState", (Object)this.blockState.toString());
    }

    public BlockState getBlockState() {
        return this.blockState;
    }

    public boolean m_6127_() {
        return true;
    }

    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket((Entity)this, Block.m_49956_((BlockState)this.getBlockState()));
    }

    public void m_141965_(ClientboundAddEntityPacket pPacket) {
        super.m_141965_(pPacket);
        this.setBlockState(Block.m_49803_((int)pPacket.m_131509_()));
        this.f_19850_ = true;
        double d0 = pPacket.m_131500_();
        double d1 = pPacket.m_131501_();
        double d2 = pPacket.m_131502_();
        this.m_6034_(d0, d1, d2);
        this.setStartPos(this.m_142538_());
    }
}

