/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.entity.ambient;

import com.mojang.math.Vector3d;
import frostnox.nightfall.action.AttackEffect;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.DamageTypeSource;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.entity.entity.ambient.AquaticAmbientEntity;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.registry.forge.DataSerializersNF;
import frostnox.nightfall.registry.forge.EffectsNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.LevelUtil;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.XoroshiroRandomSource;
import net.minecraft.world.phys.Vec3;

public class JellyfishEntity
extends AquaticAmbientEntity {
    public static final int PROPULSION_DURATION = 24;
    protected static final EntityDataAccessor<Type> TYPE = SynchedEntityData.m_135353_(JellyfishEntity.class, DataSerializersNF.JELLYFISH_TYPE);
    protected static final EntityDataAccessor<Boolean> SPECIAL = SynchedEntityData.m_135353_(JellyfishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> DEFLATING = SynchedEntityData.m_135353_(JellyfishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Integer> PROPULSION_TICKS = SynchedEntityData.m_135353_(JellyfishEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    protected boolean wasInWaterOrBubble = true;
    protected int driftSeed;
    protected float driftX;
    protected float driftZ;
    protected int lightSensitivity;
    protected int stingCooldown;

    public JellyfishEntity(EntityType<? extends ActionableEntity> type, Level level) {
        super(type, level);
    }

    public static AttributeSupplier.Builder getAttributeMap() {
        return JellyfishEntity.createAttributes().m_22268_(Attributes.f_22276_, 1.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22283_, 4.0).m_22268_(Attributes.f_22277_, 0.0).m_22268_((Attribute)AttributesNF.HEARING_RANGE.get(), 0.0).m_22268_((Attribute)AttributesNF.FIRE_DEFENSE.get(), 0.5).m_22268_((Attribute)AttributesNF.ELECTRIC_DEFENSE.get(), -0.5);
    }

    public Type getJellyfishType() {
        return (Type)((Object)this.m_20088_().m_135370_(TYPE));
    }

    public boolean isSpecial() {
        return (Boolean)this.m_20088_().m_135370_(SPECIAL);
    }

    public boolean isDeflating() {
        return (Boolean)this.m_20088_().m_135370_(DEFLATING);
    }

    protected void setDeflating(boolean deflating) {
        this.m_20088_().m_135381_(DEFLATING, (Object)deflating);
    }

    public int getPropulsionTicks() {
        return (Integer)this.m_20088_().m_135370_(PROPULSION_TICKS);
    }

    protected void setPropulsionTicks(int ticks) {
        this.m_20088_().m_135381_(PROPULSION_TICKS, (Object)ticks);
    }

    protected void updateDriftSeed(int seed) {
        this.driftSeed = seed;
        XoroshiroRandomSource random = new XoroshiroRandomSource((long)this.driftSeed);
        float angle = random.nextFloat() * 2.0f * (float)Math.PI;
        float speed = 5.0E-4f + random.nextFloat() * 2.5E-4f;
        this.driftX = Mth.m_14089_((float)angle) * speed;
        this.driftZ = Mth.m_14031_((float)angle) * speed;
    }

    protected boolean shouldPropel() {
        if (this.m_6084_() && this.randTickCount % 8 == 0 && this.f_19796_.nextBoolean()) {
            if (LevelUtil.isDayTimeWithin(this.f_19853_, 46000L, 26000L)) {
                return this.f_19853_.m_45517_(LightLayer.SKY, this.m_146901_()) <= this.lightSensitivity && this.f_19853_.m_6425_(this.m_146901_().m_7494_()).m_205070_(FluidTags.f_13131_);
            }
            return this.f_19853_.m_45517_(LightLayer.SKY, this.m_146901_()) < 15 - this.lightSensitivity && this.f_19853_.m_6425_(this.m_146901_().m_7494_()).m_205070_(FluidTags.f_13131_);
        }
        return false;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_20072_() != this.wasInWaterOrBubble || this.f_19797_ == 1) {
            this.m_6210_();
        }
        this.wasInWaterOrBubble = this.m_20072_();
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_) {
            int propulsionTicks;
            if (this.stingCooldown > 0) {
                --this.stingCooldown;
            }
            if ((propulsionTicks = this.getPropulsionTicks()) >= 0) {
                this.setPropulsionTicks(propulsionTicks - 1);
                if (propulsionTicks == 0 && !this.isDeflating() && this.m_6084_()) {
                    Vec3 velocity = this.m_20184_();
                    this.m_20334_(velocity.f_82479_, velocity.f_82480_ + 0.15, velocity.f_82481_);
                    this.f_19812_ = true;
                    this.setDeflating(true);
                    this.setPropulsionTicks(24);
                }
            } else if (this.shouldPropel()) {
                this.setPropulsionTicks(24);
                this.setDeflating(false);
            }
        }
    }

    @Override
    public void m_7023_(Vec3 pTravelVector) {
        if (this.m_6142_() && this.m_20069_()) {
            this.m_19920_(0.1f, pTravelVector);
            this.m_20256_(this.m_20184_().m_82490_(0.9));
            this.m_20256_(this.m_20184_().m_82520_((double)this.driftX, -0.0025, (double)this.driftZ));
            this.m_6478_(MoverType.SELF, this.m_20184_());
        } else {
            super.m_7023_(pTravelVector);
        }
    }

    @Override
    protected void m_6138_() {
        if (this.f_19853_.f_46443_) {
            return;
        }
        List entities = this.f_19853_.m_6249_((Entity)this, this.m_142469_(), EntitySelector.m_20421_((Entity)this));
        if (!entities.isEmpty()) {
            int maxGroup = this.f_19853_.m_46469_().m_46215_(GameRules.f_46149_);
            if (maxGroup > 0 && entities.size() > maxGroup - 1 && this.f_19796_.nextInt(4) == 0) {
                int count = 0;
                for (Entity entity : entities) {
                    if (entity.m_20159_()) continue;
                    ++count;
                }
                if (count > maxGroup - 1) {
                    this.m_6469_(DamageSource.f_19311_, 6.0f);
                }
            }
            DamageTypeSource damageSource = DamageTypeSource.createEntitySource((LivingEntity)this, "sting", DamageType.ABSOLUTE).setSound((Supplier<SoundEvent>)SoundsNF.JELLYFISH_STING);
            if (this.getJellyfishType().paralyzing) {
                damageSource.setEffects(new AttackEffect((Supplier<MobEffect>)EffectsNF.PARALYSIS, 1200, 0, 1.0f));
            }
            boolean stung = false;
            for (Entity entity : entities) {
                float pushResistance;
                if (entity instanceof ActionableEntity) {
                    ActionableEntity actionable = (ActionableEntity)entity;
                    v0 = actionable.getPushResistance();
                } else {
                    v0 = pushResistance = 2.0f;
                }
                if (this.getPushForce() >= pushResistance) {
                    this.m_7324_(entity);
                }
                if (this.stingCooldown > 0 || entity.m_6095_().m_204039_(TagsNF.JELLYFISH_IMMUNE)) continue;
                stung = true;
                entity.m_6469_((DamageSource)damageSource, 5.0f);
            }
            if (stung) {
                this.stingCooldown = 10;
            }
        }
    }

    @Override
    public ParticleOptions getHurtParticle() {
        return null;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.95f;
    }

    public float m_6134_() {
        return this.m_21224_() ? 0.75f : 1.0f;
    }

    @Override
    public EntityDimensions m_6972_(Pose pPose) {
        if (!this.m_20072_()) {
            return new EntityDimensions(this.m_6095_().m_20678_(), 0.31875f, false).m_20388_(this.m_6134_());
        }
        if (this.getJellyfishType() == Type.MOON) {
            return new EntityDimensions(this.m_6095_().m_20678_(), 0.44375f, false).m_20388_(this.m_6134_());
        }
        return this.m_6095_().m_20680_().m_20388_(this.m_6134_());
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)SoundsNF.JELLYFISH_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundsNF.JELLYFISH_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState pBlock) {
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TYPE, (Object)Type.MOON);
        this.f_19804_.m_135372_(SPECIAL, (Object)false);
        this.f_19804_.m_135372_(DEFLATING, (Object)false);
        this.f_19804_.m_135372_(PROPULSION_TICKS, (Object)-1);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        boolean special;
        super.m_7380_(tag);
        int type = this.getJellyfishType().ordinal();
        if (type != 0) {
            tag.m_128405_("type", type);
        }
        if (special = this.isSpecial()) {
            tag.m_128379_("special", special);
        }
        tag.m_128379_("deflating", this.isDeflating());
        if (this.getPropulsionTicks() > -1) {
            tag.m_128405_("propulsion", this.getPropulsionTicks());
        }
        tag.m_128405_("driftSeed", this.driftSeed);
        tag.m_128405_("sensitivity", this.lightSensitivity);
        tag.m_128405_("stingCooldown", this.stingCooldown);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.m_20088_().m_135381_(TYPE, (Object)Type.values()[tag.m_128451_("type")]);
        this.m_20088_().m_135381_(SPECIAL, (Object)tag.m_128471_("special"));
        this.m_20088_().m_135381_(DEFLATING, (Object)tag.m_128471_("deflating"));
        if (tag.m_128441_("propulsion")) {
            this.m_20088_().m_135381_(PROPULSION_TICKS, (Object)tag.m_128451_("propulsion"));
        }
        if (tag.m_128441_("driftSeed")) {
            this.updateDriftSeed(tag.m_128451_("driftSeed"));
        }
        this.lightSensitivity = tag.m_128451_("sensitivity");
        this.stingCooldown = tag.m_128451_("stingCooldown");
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        Type type;
        if ((spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, (SpawnGroupData)spawnDataIn, dataTag)) instanceof GroupData) {
            GroupData data = (GroupData)((Object)spawnDataIn);
            type = data.type;
        } else {
            spawnDataIn = GroupData.create(worldIn.m_5822_());
            type = ((GroupData)((Object)spawnDataIn)).type;
        }
        this.updateDriftSeed(((GroupData)((Object)spawnDataIn)).driftSeed);
        this.m_20088_().m_135381_(TYPE, (Object)type);
        this.lightSensitivity = this.f_19796_.nextInt(5);
        if (this.f_19796_.nextInt() % 8192 == 0) {
            this.m_20088_().m_135381_(SPECIAL, (Object)true);
        }
        this.m_146922_(this.f_19796_.nextInt(4) * 90);
        return spawnDataIn;
    }

    @Override
    public EquipmentSlot getHitSlot(Vector3d hitPos, int boxIndex) {
        return EquipmentSlot.CHEST;
    }

    public static enum Type {
        MOON(false),
        AMBER(false),
        ROSE(true),
        SCARLET(true);

        public final boolean paralyzing;

        private Type(boolean paralyzing) {
            this.paralyzing = paralyzing;
        }
    }

    public static class GroupData
    extends AgeableMob.AgeableMobGroupData {
        public final Type type;
        public final int driftSeed;

        public GroupData(Type type, int driftSeed) {
            super(0.0f);
            this.type = type;
            this.driftSeed = driftSeed;
        }

        public static GroupData create(Random random) {
            return new GroupData(Type.values()[random.nextInt(Type.values().length)], random.nextInt());
        }
    }
}

