/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.entity.animal;

import frostnox.nightfall.entity.entity.ActionableEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public abstract class BabyAnimalEntity
extends ActionableEntity {
    protected static final EntityDataAccessor<Boolean> SPECIAL = SynchedEntityData.m_135353_(BabyAnimalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected final int matureTime;
    protected int age;

    public BabyAnimalEntity(EntityType<? extends ActionableEntity> type, Level level, int matureTime) {
        super(type, level);
        this.matureTime = matureTime;
    }

    protected abstract ActionableEntity createMatureEntity();

    public boolean isSpecial() {
        return (Boolean)this.m_20088_().m_135370_(SPECIAL);
    }

    public int getAge() {
        if (this.f_19853_.f_46443_) {
            return 0;
        }
        return this.age;
    }

    public void setAge(int age) {
        this.age = age;
        if (age >= this.matureTime) {
            ActionableEntity adult = this.createMatureEntity();
            adult.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
            this.m_146870_();
            this.f_19853_.m_7967_((Entity)adult);
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_() && !this.f_19853_.f_46443_) {
            this.setAge(this.age + 1);
        }
    }

    @Override
    public boolean m_6573_(Player pPlayer) {
        return !this.m_21523_();
    }

    protected InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        return InteractionResult.PASS;
    }

    @Override
    protected void simulateTime(int timePassed) {
        super.simulateTime(timePassed);
        if (this.m_6084_()) {
            this.setAge(this.age + timePassed);
        }
    }

    @Override
    public double getReducedAIThresholdSqr() {
        return 62500.0;
    }

    @Override
    public boolean dropLootFromSkinning() {
        return true;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPECIAL, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("age", this.getAge());
        tag.m_128379_("special", this.isSpecial());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setAge(tag.m_128451_("age"));
        this.m_20088_().m_135381_(SPECIAL, (Object)tag.m_128471_("special"));
    }

    @Override
    public float getPushResistance() {
        return 0.0f;
    }

    @Override
    public float getPushForce() {
        return 0.0f;
    }
}

