/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.entity.animal;

import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import frostnox.nightfall.capability.ChunkData;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.IOrientedHitBoxes;
import frostnox.nightfall.entity.Sex;
import frostnox.nightfall.entity.ai.goal.EatBlockGoal;
import frostnox.nightfall.entity.ai.goal.EatEntityGoal;
import frostnox.nightfall.entity.ai.goal.FloatAtHeightGoal;
import frostnox.nightfall.entity.ai.goal.ReducedWanderLandGoal;
import frostnox.nightfall.entity.ai.goal.StepUpFleeDamageGoal;
import frostnox.nightfall.entity.ai.goal.StepUpFleeEntityGoal;
import frostnox.nightfall.entity.ai.sensing.AmplifiedAudioSensing;
import frostnox.nightfall.entity.ai.sensing.AudioSensing;
import frostnox.nightfall.entity.entity.Diet;
import frostnox.nightfall.entity.entity.animal.AnimalEntity;
import frostnox.nightfall.registry.ActionsNF;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.registry.forge.DataSerializersNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.OBB;
import java.util.EnumMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class DeerEntity
extends AnimalEntity
implements IOrientedHitBoxes {
    private static final EntityPart[] OBB_PARTS = new EntityPart[]{EntityPart.BODY, EntityPart.NECK, EntityPart.HEAD};
    protected static final EntityDataAccessor<Type> TYPE = SynchedEntityData.m_135353_(DeerEntity.class, DataSerializersNF.DEER_TYPE);
    protected static final EntityDataAccessor<Boolean> SPECIAL = SynchedEntityData.m_135353_(DeerEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Sex> SEX = SynchedEntityData.m_135353_(DeerEntity.class, DataSerializersNF.SEX);
    public int sprintTime;
    public int sprintTimeLast;

    public DeerEntity(EntityType<? extends DeerEntity> type, Level level) {
        super((EntityType<? extends AnimalEntity>)type, level);
    }

    @Override
    protected int getMaxSatiety() {
        return 48000;
    }

    public static AttributeSupplier.Builder getAttributeMap() {
        return DeerEntity.createAttributes().m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22283_, 4.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_((Attribute)AttributesNF.HEARING_RANGE.get(), 24.0).m_22268_((Attribute)AttributesNF.FROST_DEFENSE.get(), 0.2);
    }

    public Type getDeerType() {
        return (Type)((Object)this.m_20088_().m_135370_(TYPE));
    }

    public boolean isSpecial() {
        return (Boolean)this.m_20088_().m_135370_(SPECIAL);
    }

    public Sex getSex() {
        return (Sex)((Object)this.m_20088_().m_135370_(SEX));
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatAtHeightGoal((Mob)this, 0.9));
        this.f_21345_.m_25352_(2, new StepUpFleeEntityGoal<LivingEntity>(this, LivingEntity.class, 1.6, 1.8, entity -> {
            if (entity.m_21224_()) {
                return false;
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                return !player.m_7500_() && !player.m_5833_();
            }
            return entity.m_6095_().m_204039_(TagsNF.DEER_PREDATOR);
        }));
        this.f_21345_.m_25352_(3, (Goal)new StepUpFleeDamageGoal(this, 1.6));
        this.f_21345_.m_25352_(4, (Goal)new EatEntityGoal(this, 1.3, 20, 2));
        this.f_21345_.m_25352_(5, (Goal)new EatBlockGoal(this, 1.3, 20, 2));
        this.f_21345_.m_25352_(6, (Goal)new ReducedWanderLandGoal(this, 0.8, 8));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.sprintTimeLast = this.sprintTime;
        if (this.m_6084_()) {
            IActionTracker capA = this.getActionTracker();
            if (capA.isCharging() && capA.getFrame() > 100 && capA.getActionID().equals((Object)ActionsNF.DEER_GRAZE.getId()) && this.f_19796_.nextFloat() < 0.005f) {
                this.queueAction();
            }
            if (this.getStepHeight() >= 1.0f) {
                this.m_6858_(true);
                if (this.sprintTime < 9) {
                    ++this.sprintTime;
                }
            } else {
                this.m_6858_(false);
                if (this.sprintTime > 0) {
                    --this.sprintTime;
                }
            }
            if (!this.f_19853_.f_46443_ && this.sprintTime == 0 && capA.isInactive() && this.m_20075_().m_204336_(TagsNF.TILLABLE_SOIL) && (double)this.f_19796_.nextFloat() < (double)0.0015f * (1.9 - this.getSatietyPercent())) {
                this.startAction(ActionsNF.DEER_GRAZE.getId());
            }
        }
    }

    public boolean m_6779_(LivingEntity pTarget) {
        return pTarget.m_142066_();
    }

    @Override
    public EquipmentSlot getHitSlot(Vector3d hitPos, int boxIndex) {
        return boxIndex >= 0 ? EquipmentSlot.HEAD : EquipmentSlot.CHEST;
    }

    @Override
    protected AudioSensing createAudioSensing() {
        return new AmplifiedAudioSensing(this, 10, 1.25f);
    }

    @Override
    public float getVisionAngle() {
        return 180.0f;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TYPE, (Object)Type.SPOTTED);
        this.f_19804_.m_135372_(SPECIAL, (Object)false);
        this.f_19804_.m_135372_(SEX, (Object)Sex.FEMALE);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        boolean special;
        super.m_7380_(tag);
        int type = this.getDeerType().ordinal();
        if (type != 0) {
            tag.m_128405_("type", type);
        }
        if (special = this.isSpecial()) {
            tag.m_128379_("special", special);
        }
        tag.m_128379_("female", this.getSex() == Sex.FEMALE);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.m_20088_().m_135381_(TYPE, (Object)Type.values()[tag.m_128451_("type")]);
        this.m_20088_().m_135381_(SPECIAL, (Object)tag.m_128471_("special"));
        if (tag.m_128441_("female")) {
            this.m_20088_().m_135381_(SEX, (Object)(tag.m_128471_("female") ? Sex.FEMALE : Sex.MALE));
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        Type type;
        if ((spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, (SpawnGroupData)spawnDataIn, dataTag)) instanceof GroupData) {
            GroupData data = (GroupData)((Object)spawnDataIn);
            type = data.type;
        } else {
            float temperature = ChunkData.get(worldIn.m_6018_().m_46745_(this.m_142538_())).getTemperature(this.m_142538_());
            type = temperature < 0.35f ? Type.RED : (temperature > 0.65f ? Type.BRIAR : Type.SPOTTED);
            spawnDataIn = new GroupData(type);
        }
        this.m_20088_().m_135381_(TYPE, (Object)type);
        if (this.f_19796_.nextInt() % 8192 == 0) {
            this.m_20088_().m_135381_(SPECIAL, (Object)true);
        }
        if (this.f_19796_.nextBoolean()) {
            this.m_20088_().m_135381_(SEX, (Object)Sex.MALE);
        }
        return spawnDataIn;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ - 0.01f;
    }

    public float m_6100_() {
        if (this.getSex() == Sex.MALE) {
            return super.m_6100_() * 0.8f;
        }
        return super.m_6100_();
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)SoundsNF.DEER_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundsNF.DEER_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState pBlock) {
        this.m_5496_((SoundEvent)SoundsNF.DEER_STEP.get(), 0.15f, 1.3f);
    }

    @Override
    public boolean includeAABB() {
        return true;
    }

    @Override
    public float getModelScale() {
        return this.getSex() == Sex.MALE ? 1.0625f : 1.0f;
    }

    @Override
    public Vector3f getOBBTranslation() {
        return new Vector3f(0.0f, 0.78125f, 0.0f);
    }

    @Override
    public EnumMap<EntityPart, AnimationData> getDefaultAnimMap() {
        EnumMap<EntityPart, AnimationData> map = DeerEntity.getGenericAnimMap();
        map.put(EntityPart.BODY, new AnimationData(new Vector3f(0.0f, -0.40625f, -0.34375f), new Vector3f(0.0f, 0.0f, 0.0f)));
        map.put(EntityPart.NECK, new AnimationData(new Vector3f(0.0f, -0.4375f, 0.0f), new Vector3f(15.0f, 0.0f, 0.0f)));
        map.put(EntityPart.HEAD, new AnimationData(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(-15.0f, 0.0f, 0.0f)));
        return map;
    }

    @Override
    public EntityPart[] getOrderedOBBParts() {
        return OBB_PARTS;
    }

    @Override
    public OBB[] getDefaultOBBs() {
        return new OBB[]{new OBB(0.21875, 0.53125, 0.21875, 0.0, 0.25, 0.0), new OBB(0.28125, 0.28125, 0.28125, 0.0, 0.125, 0.0)};
    }

    @Override
    public AABB getEnclosingAABB() {
        AABB bb = this.m_142469_();
        return new AABB(bb.f_82288_ - 0.6, bb.f_82289_, bb.f_82290_ - 0.6, bb.f_82291_ + 0.6, bb.f_82292_ + 0.6, bb.f_82293_ + 0.6);
    }

    @Override
    public Diet getDiet() {
        return Diet.HERBIVORE;
    }

    @Override
    public SoundEvent getEatSound() {
        return null;
    }

    public static enum Type {
        BRIAR,
        RED,
        SPOTTED;

    }

    public static class GroupData
    extends AgeableMob.AgeableMobGroupData {
        public final Type type;

        public GroupData(Type type) {
            super(0.0f);
            this.type = type;
        }
    }
}

