/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.entity.animal;

import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.IOrientedHitBoxes;
import frostnox.nightfall.entity.Sex;
import frostnox.nightfall.entity.ai.goal.FleeDamageGoal;
import frostnox.nightfall.entity.ai.goal.FleeEntityGoal;
import frostnox.nightfall.entity.ai.goal.FloatAtHeightGoal;
import frostnox.nightfall.entity.ai.goal.FollowParentGoal;
import frostnox.nightfall.entity.ai.goal.RandomLookGoal;
import frostnox.nightfall.entity.ai.goal.target.TrackNearestTargetGoal;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.entity.entity.animal.BabyAnimalEntity;
import frostnox.nightfall.entity.entity.animal.DrakefowlEntity;
import frostnox.nightfall.entity.entity.animal.TamableAnimalEntity;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.registry.forge.DataSerializersNF;
import frostnox.nightfall.registry.forge.EntitiesNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.OBB;
import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class DrakefowlBabyEntity
extends BabyAnimalEntity
implements IOrientedHitBoxes {
    private static final EntityPart[] OBB_PARTS = new EntityPart[]{EntityPart.BODY, EntityPart.NECK, EntityPart.HEAD};
    protected static final EntityDataAccessor<DrakefowlEntity.Type> TYPE = SynchedEntityData.m_135353_(DrakefowlEntity.class, DataSerializersNF.DRAKEFOWL_TYPE);

    public DrakefowlBabyEntity(EntityType<? extends ActionableEntity> type, Level level) {
        super(type, level, 192000);
    }

    public static AttributeSupplier.Builder getAttributeMap() {
        return DrakefowlBabyEntity.createAttributes().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, (double)0.23f).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22277_, 15.0).m_22268_((Attribute)AttributesNF.HEARING_RANGE.get(), 15.0).m_22268_((Attribute)AttributesNF.FIRE_DEFENSE.get(), 0.3);
    }

    public DrakefowlEntity.Type getDrakefowlType() {
        return (DrakefowlEntity.Type)((Object)this.m_20088_().m_135370_(TYPE));
    }

    @Override
    protected ActionableEntity createMatureEntity() {
        DrakefowlEntity adult = this.f_19796_.nextBoolean() ? (DrakefowlEntity)((EntityType)EntitiesNF.DRAKEFOWL_ROOSTER.get()).m_20615_(this.f_19853_) : (DrakefowlEntity)((EntityType)EntitiesNF.DRAKEFOWL_HEN.get()).m_20615_(this.f_19853_);
        adult.m_6518_((ServerLevelAccessor)((ServerLevel)this.f_19853_), this.f_19853_.m_6436_(this.m_142538_()), MobSpawnType.CONVERSION, (SpawnGroupData)new DrakefowlEntity.GroupData(this.getDrakefowlType()), null);
        adult.m_20088_().m_135381_(TamableAnimalEntity.TAMED, (Object)true);
        return adult;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatAtHeightGoal((Mob)this, 0.4));
        this.f_21345_.m_25352_(2, (Goal)new FollowParentGoal(this, 1.1));
        this.f_21345_.m_25352_(3, new FleeEntityGoal<LivingEntity>(this, LivingEntity.class, 1.1, 1.1, entity -> {
            if (entity.m_21224_()) {
                return false;
            }
            return entity.m_6095_().m_204039_(TagsNF.DRAKEFOWL_PREDATOR);
        }));
        this.f_21345_.m_25352_(4, (Goal)new FleeDamageGoal(this, 1.1));
        this.f_21345_.m_25352_(5, (Goal)new RandomLookGoal((Mob)this, 0.02f));
        this.f_21346_.m_25352_(1, new TrackNearestTargetGoal<DrakefowlEntity>((ActionableEntity)this, DrakefowlEntity.class, true, entity -> {
            if (entity.m_21224_()) {
                return false;
            }
            return ((DrakefowlEntity)entity).sex == Sex.FEMALE;
        }));
        this.f_21346_.m_25352_(2, new TrackNearestTargetGoal<DrakefowlEntity>((ActionableEntity)this, DrakefowlEntity.class, true, entity -> {
            if (entity.m_21224_()) {
                return false;
            }
            return ((DrakefowlEntity)entity).sex == Sex.MALE;
        }));
    }

    protected int m_5639_(float pFallDistance, float pDamageMultiplier) {
        return super.m_5639_(pFallDistance, pDamageMultiplier) - 30;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ - 0.01f;
    }

    @Override
    public float getVisionAngle() {
        return 180.0f;
    }

    @Override
    public float getNavigatorWaypointDist() {
        return 0.375f;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TYPE, (Object)DrakefowlEntity.Type.EMERALD);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("type", this.getDrakefowlType().ordinal());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.m_20088_().m_135381_(TYPE, (Object)DrakefowlEntity.Type.values()[tag.m_128451_("type")]);
    }

    protected SoundEvent m_7515_() {
        if (this.getActionTracker().getActionID().equals((Object)this.getCollapseAction())) {
            return null;
        }
        return (SoundEvent)SoundsNF.DRAKEFOWL_BABY_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)SoundsNF.DRAKEFOWL_BABY_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundsNF.DRAKEFOWL_BABY_DEATH.get();
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
    }

    @Override
    public boolean includeAABB() {
        return true;
    }

    @Override
    public Vector3f getOBBTranslation() {
        return new Vector3f(0.0f, 0.21875f, 0.0f);
    }

    @Override
    public EnumMap<EntityPart, AnimationData> getDefaultAnimMap() {
        EnumMap<EntityPart, AnimationData> map = DrakefowlBabyEntity.getGenericAnimMap();
        map.put(EntityPart.BODY, new AnimationData(new Vector3f(0.0f, -0.0625f, -0.09375f)));
        map.put(EntityPart.NECK, new AnimationData(new Vector3f(0.0f, 0.0f, 0.0f)));
        map.put(EntityPart.HEAD, new AnimationData(new Vector3f(0.0f, 0.0f, 0.0f)));
        return map;
    }

    @Override
    public EntityPart[] getOrderedOBBParts() {
        return OBB_PARTS;
    }

    @Override
    public OBB[] getDefaultOBBs() {
        return new OBB[]{new OBB(0.140625, 0.140625, 0.140625, 0.0, 0.03125, 0.03125)};
    }

    @Override
    public AABB getEnclosingAABB() {
        AABB bb = this.m_142469_();
        return new AABB(bb.f_82288_ - 0.3, bb.f_82289_, bb.f_82290_ - 0.3, bb.f_82291_ + 0.3, bb.f_82292_ + 0.3, bb.f_82293_ + 0.3);
    }

    @Override
    public EquipmentSlot getHitSlot(Vector3d hitPos, int boxIndex) {
        return boxIndex >= 0 ? EquipmentSlot.HEAD : EquipmentSlot.CHEST;
    }
}

