/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.entity.animal;

import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import frostnox.nightfall.capability.ChunkData;
import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.IOrientedHitBoxes;
import frostnox.nightfall.entity.Sex;
import frostnox.nightfall.entity.ai.goal.BreedGoal;
import frostnox.nightfall.entity.ai.goal.EatBlockGoal;
import frostnox.nightfall.entity.ai.goal.EatEntityGoal;
import frostnox.nightfall.entity.ai.goal.FleeDamageGoal;
import frostnox.nightfall.entity.ai.goal.FleeEntityGoal;
import frostnox.nightfall.entity.ai.goal.FloatAtHeightGoal;
import frostnox.nightfall.entity.ai.goal.LayEggGoal;
import frostnox.nightfall.entity.ai.goal.LureGoal;
import frostnox.nightfall.entity.ai.goal.RandomLookGoal;
import frostnox.nightfall.entity.ai.goal.ReducedWanderLandGoal;
import frostnox.nightfall.entity.ai.goal.RushAttackGoal;
import frostnox.nightfall.entity.ai.goal.target.TrackNearestTargetGoal;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.entity.entity.Diet;
import frostnox.nightfall.entity.entity.animal.DrakefowlBabyEntity;
import frostnox.nightfall.entity.entity.animal.TamableAnimalEntity;
import frostnox.nightfall.entity.entity.monster.CockatriceEntity;
import frostnox.nightfall.registry.ActionsNF;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.registry.forge.BlocksNF;
import frostnox.nightfall.registry.forge.DataSerializersNF;
import frostnox.nightfall.registry.forge.EntitiesNF;
import frostnox.nightfall.registry.forge.ItemsNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.LevelUtil;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.OBB;
import java.util.EnumMap;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DrakefowlEntity
extends TamableAnimalEntity
implements IOrientedHitBoxes {
    private static final EntityPart[] OBB_PARTS = new EntityPart[]{EntityPart.BODY, EntityPart.NECK, EntityPart.HEAD};
    protected static final EntityDataAccessor<Type> TYPE = SynchedEntityData.m_135353_(DrakefowlEntity.class, DataSerializersNF.DRAKEFOWL_TYPE);
    private final Goal fleePlayerGoal = new FleeEntityGoal<Player>(this, Player.class, 1.2, 1.3, entity -> {
        Player player = (Player)entity;
        return !player.m_21224_() && !player.m_6047_() && !player.m_5833_() && !player.m_7500_();
    });
    private final Goal breedGoal = new BreedGoal(this, 0.8);
    private final Goal lureGoal = new LureGoal(this, 10.0, 0.9);
    private final Goal eggGoal = new LayEggGoal(this, (Supplier)BlocksNF.DRAKEFOWL_NEST, 1.0){

        @Override
        protected boolean isNestSpotValid(BlockPos pos) {
            return super.isNestSpotValid(pos) && this.mob.f_19853_.m_8055_(pos.m_7495_()).m_204336_(TagsNF.DRAKEFOWL_NEST_BLOCK);
        }

        @Override
        public boolean m_8036_() {
            if (LevelUtil.isDayTimeWithin(this.mob.f_19853_, 0L, 26000L)) {
                return false;
            }
            return super.m_8036_();
        }

        @Override
        public boolean m_8045_() {
            if (LevelUtil.isDayTimeWithin(this.mob.f_19853_, 0L, 26000L)) {
                return false;
            }
            return super.m_8045_();
        }
    };
    public float flap;
    public float flapSpeed;
    public float oFlapSpeed;
    public float oFlap;
    public float flapping = 1.0f;
    public float nextFlap = 1.0f;
    protected int ticksOffGround = 0;
    @Nullable
    public Type fatherType;

    public DrakefowlEntity(EntityType<? extends TamableAnimalEntity> type, Level level, Sex sex) {
        super(type, level, sex);
        this.updateGoals();
    }

    public static DrakefowlEntity createFemale(EntityType<? extends TamableAnimalEntity> type, Level level) {
        return new DrakefowlEntity(type, level, Sex.FEMALE);
    }

    public static DrakefowlEntity createMale(EntityType<? extends TamableAnimalEntity> type, Level level) {
        return new DrakefowlEntity(type, level, Sex.MALE);
    }

    public static AttributeSupplier.Builder getAttributeMap() {
        return DrakefowlEntity.createAttributes().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, (double)0.275f).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_((Attribute)AttributesNF.HEARING_RANGE.get(), 15.0).m_22268_((Attribute)AttributesNF.SLASHING_DEFENSE.get(), 0.2).m_22268_((Attribute)AttributesNF.PIERCING_DEFENSE.get(), 0.1).m_22268_((Attribute)AttributesNF.FIRE_DEFENSE.get(), 0.3);
    }

    public Type getDrakefowlType() {
        return (Type)((Object)this.m_20088_().m_135370_(TYPE));
    }

    @Override
    protected void updateGoals() {
        if (!this.f_19853_.f_46443_) {
            this.f_21345_.m_25363_(this.fleePlayerGoal);
            this.f_21345_.m_25363_(this.breedGoal);
            this.f_21345_.m_25363_(this.lureGoal);
            this.f_21345_.m_25363_(this.eggGoal);
            if (this.isTamed()) {
                this.f_21345_.m_25352_(6, this.breedGoal);
                this.f_21345_.m_25352_(7, this.lureGoal);
                if (this.sex == Sex.FEMALE) {
                    this.f_21345_.m_25352_(8, this.eggGoal);
                }
            } else {
                this.f_21345_.m_25352_(4, this.fleePlayerGoal);
                if (this.sex == Sex.FEMALE) {
                    this.f_21345_.m_25352_(7, this.lureGoal);
                }
            }
        }
    }

    @Override
    public boolean canBreedWith(TamableAnimalEntity other) {
        if (other instanceof DrakefowlEntity) {
            DrakefowlEntity drakefowl = (DrakefowlEntity)other;
            return drakefowl.sex != this.sex;
        }
        return false;
    }

    @Override
    public void breedWith(TamableAnimalEntity other) {
        if (this.sex == Sex.FEMALE) {
            this.fatherType = ((DrakefowlEntity)other).getDrakefowlType();
        }
    }

    @Override
    protected boolean checkComfort() {
        return (!LevelData.isPresent(this.f_19853_) || LevelData.get(this.f_19853_).getSeasonalTemperature(ChunkData.get(this.f_19853_.m_46745_(this.m_142538_())), this.m_142538_()) > 0.4f) && this.f_19853_.m_45976_(TamableAnimalEntity.class, this.m_142469_().m_82377_(8.0, 1.0, 8.0)).size() <= 25;
    }

    @Override
    public boolean isFeedItem(ItemStack item) {
        return item.m_204117_(TagsNF.OMNIVORE_FOOD) && !item.m_150930_((Item)ItemsNF.DRAKEFOWL_EGG.get());
    }

    @Override
    public ResourceLocation getBreedAction() {
        return ActionsNF.DRAKEFOWL_BREED.getId();
    }

    @Override
    protected void onGestationEnd() {
        this.fatherType = null;
    }

    @Override
    protected void onFeed() {
        super.onFeed();
        this.gestationTime = 48000;
    }

    @Override
    public boolean canTargetFromSound(LivingEntity target) {
        Player player;
        return target.m_6095_().m_204039_(TagsNF.DRAKEFOWL_PREY) || target instanceof Player && !(player = (Player)target).m_7500_() && !player.m_5833_();
    }

    public boolean m_6779_(LivingEntity target) {
        return target.m_142066_() && !(target instanceof DrakefowlEntity) && !(target instanceof DrakefowlBabyEntity);
    }

    @Override
    public ResourceLocation pickActionEnemy(double distanceSqr, Entity target) {
        if (this.getNavigator().getActivePath() != null && !this.getNavigator().getActivePath().reachesGoal() || distanceSqr > 4.0 && (double)this.f_19796_.nextFloat() < Math.min(0.9, distanceSqr / 25.0)) {
            return ActionsNF.DRAKEFOWL_SPIT.getId();
        }
        return ActionsNF.DRAKEFOWL_CLAW.getId();
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatAtHeightGoal((Mob)this, 0.4));
        this.f_21345_.m_25352_(2, new FleeEntityGoal<LivingEntity>(this, LivingEntity.class, 1.2, 1.3, entity -> {
            if (entity.m_21224_()) {
                return false;
            }
            return entity.m_6095_().m_204039_(TagsNF.DRAKEFOWL_PREDATOR);
        }));
        this.f_21345_.m_25352_(5, (Goal)new FleeDamageGoal(this, 1.3));
        this.f_21345_.m_25352_(9, (Goal)new EatEntityGoal(this, 1.0, 15, 2));
        this.f_21345_.m_25352_(10, (Goal)new EatBlockGoal(this, 1.0, 15, 2));
        this.f_21345_.m_25352_(11, (Goal)new ReducedWanderLandGoal(this, 0.8, 6){

            @Nullable
            protected Vec3 m_7037_() {
                Vec3 pos = super.m_7037_();
                return pos != null && this.f_25725_.f_19853_.m_8055_(new BlockPos(pos)).m_60713_((Block)BlocksNF.DRAKEFOWL_NEST.get()) ? null : pos;
            }
        });
        this.f_21345_.m_25352_(12, (Goal)new RandomLookGoal((Mob)this, 0.0033333332f));
        if (this.m_6095_() == EntitiesNF.DRAKEFOWL_ROOSTER.get()) {
            this.f_21345_.m_25352_(3, (Goal)new RushAttackGoal(this, 1.2));
            this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
            this.f_21346_.m_25352_(2, (Goal)new TrackNearestTargetGoal<LivingEntity>((ActionableEntity)this, LivingEntity.class, true, entity -> {
                if (entity.m_21224_()) {
                    return false;
                }
                return entity.m_6095_().m_204039_(TagsNF.DRAKEFOWL_PREY);
            }){

                protected double m_7623_() {
                    return super.m_7623_() * 2.0 / 3.0;
                }
            });
        }
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.f_19853_.f_46443_ && this.f_19797_ == 1) {
            this.m_6478_(MoverType.SELF, new Vec3(0.0, -0.1, 0.0));
        }
        this.ticksOffGround = !this.f_19861_ ? ++this.ticksOffGround : 0;
        this.oFlap = this.flap;
        this.oFlapSpeed = this.flapSpeed;
        boolean shouldFlap = this.m_6084_() && (!this.f_19861_ && this.ticksOffGround > 5 || this.getActionTracker().getAction().isSpecial());
        this.flapSpeed += (!shouldFlap ? -1.0f : 4.0f) * 0.3f;
        this.flapSpeed = Mth.m_14036_((float)this.flapSpeed, (float)0.0f, (float)1.0f);
        if (shouldFlap && this.flapping < 1.0f) {
            this.flapping = 1.0f;
        }
        this.flapping *= 0.9f;
        Vec3 velocity = this.m_20184_();
        if (shouldFlap && velocity.f_82480_ < 0.0) {
            this.m_20256_(velocity.m_82542_(1.0, 0.6, 1.0));
        }
        this.flap += this.flapping * 2.0f;
        if (shouldFlap && this.f_19853_.f_46443_ && this.randTickCount % 11 == 0) {
            ClientEngine.get().playEntitySound((Entity)this, (SoundEvent)SoundsNF.DRAKEFOWL_FLAP.get(), SoundSource.NEUTRAL, 1.0f, 1.0f + this.f_19796_.nextFloat(-0.05f, 0.05f));
        }
        this.f_19789_ = 0.0f;
        if (this.f_19853_.f_46443_ && this.isTamed() && this.sex == Sex.MALE && this.m_6084_() && LevelUtil.isDayTimeExactly(this.f_19853_, 0L)) {
            ClientEngine.get().playUniqueEntitySound((Entity)this, (SoundEvent)SoundsNF.DRAKEFOWL_CROW.get(), SoundSource.NEUTRAL, 2.0f, 1.0f);
        }
        if (!this.f_19853_.f_46443_ && this.isSpecial() && (double)this.m_21187_().nextFloat() < 1.0416666666666666E-5) {
            CockatriceEntity cockatrice = (CockatriceEntity)((EntityType)EntitiesNF.COCKATRICE.get()).m_20615_(this.f_19853_);
            cockatrice.m_6518_((ServerLevelAccessor)((ServerLevel)this.f_19853_), this.f_19853_.m_6436_(this.m_142538_()), MobSpawnType.CONVERSION, (SpawnGroupData)new CockatriceEntity.GroupData(CockatriceEntity.Type.values()[this.getDrakefowlType().ordinal()]), null);
            cockatrice.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
            this.m_146870_();
            this.f_19853_.m_7967_((Entity)cockatrice);
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        Type type;
        if ((spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, (SpawnGroupData)spawnDataIn, dataTag)) instanceof GroupData) {
            GroupData data = (GroupData)((Object)spawnDataIn);
            type = data.type;
        } else {
            float temperature = ChunkData.get(worldIn.m_6018_().m_46745_(this.m_142538_())).getTemperature(this.m_142538_());
            type = temperature > 0.7f ? Type.EMERALD : Type.BRONZE;
            spawnDataIn = new GroupData(type);
        }
        this.m_20088_().m_135381_(TYPE, (Object)type);
        if (this.sex == Sex.MALE && this.f_19796_.nextInt() % 512 == 0) {
            this.m_20088_().m_135381_(SPECIAL, (Object)true);
        }
        this.updateGoals();
        return spawnDataIn;
    }

    protected boolean m_142039_() {
        return this.f_146794_ > this.nextFlap;
    }

    protected void m_142043_() {
        this.nextFlap = this.f_146794_ + this.flapSpeed / 2.0f;
    }

    public boolean m_142535_(float pFallDistance, float pMultiplier, DamageSource pSource) {
        return false;
    }

    @Override
    public float getVisionAngle() {
        return 160.0f;
    }

    public float m_6100_() {
        if (this.sex == Sex.MALE) {
            return super.m_6100_() * 0.97f;
        }
        return super.m_6100_() * 1.03f;
    }

    protected SoundEvent m_7515_() {
        if (this.getActionTracker().getActionID().equals((Object)this.getCollapseAction())) {
            return null;
        }
        return (SoundEvent)SoundsNF.DRAKEFOWL_AMBIENT.get();
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)SoundsNF.DRAKEFOWL_HURT.get();
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundsNF.DRAKEFOWL_DEATH.get();
    }

    protected void m_7355_(BlockPos pPos, BlockState pBlock) {
        this.m_5496_((SoundEvent)SoundsNF.DRAKEFOWL_STEP.get(), 0.15f, 1.0f);
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ - 0.01f;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TYPE, (Object)Type.EMERALD);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("type", this.getDrakefowlType().ordinal());
        tag.m_128405_("ticksOffGround", this.ticksOffGround);
        if (this.fatherType != null) {
            tag.m_128405_("fatherType", this.fatherType.ordinal());
        }
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.m_20088_().m_135381_(TYPE, (Object)Type.values()[tag.m_128451_("type")]);
        this.ticksOffGround = tag.m_128451_("ticksOffGround");
        if (tag.m_128441_("fatherType")) {
            this.fatherType = Type.values()[tag.m_128451_("fatherType")];
        }
        this.updateGoals();
    }

    @Override
    public float getPushResistance() {
        return 1.0f;
    }

    @Override
    public float getPushForce() {
        return 1.0f;
    }

    @Override
    @Nullable
    public ResourceLocation getCollapseAction() {
        return ActionsNF.DRAKEFOWL_COLLAPSE.getId();
    }

    @Override
    public Diet getDiet() {
        return Diet.OMNIVORE;
    }

    @Override
    public boolean canEat(BlockState state) {
        if (state.m_60713_((Block)BlocksNF.DRAKEFOWL_NEST.get())) {
            return false;
        }
        return super.canEat(state);
    }

    @Override
    public boolean canEat(Entity entity) {
        ItemEntity itemEntity;
        if (entity instanceof ItemEntity && (itemEntity = (ItemEntity)entity).m_32055_().m_150930_((Item)ItemsNF.DRAKEFOWL_EGG.get())) {
            return false;
        }
        if (super.canEat(entity)) {
            return true;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity.f_20919_ > 20 && entity.m_6095_().m_204039_(TagsNF.EDIBLE_CORPSE) && !(entity instanceof DrakefowlEntity) && !(entity instanceof DrakefowlBabyEntity);
        }
        return false;
    }

    @Override
    public SoundEvent getEatSound() {
        return (SoundEvent)SoundsNF.DRAKEFOWL_EAT.get();
    }

    @Override
    protected int getMaxSatiety() {
        return 48000;
    }

    @Override
    public boolean includeAABB() {
        return true;
    }

    @Override
    public Vector3f getOBBTranslation() {
        return new Vector3f(0.0f, 0.40625f, 0.0f);
    }

    @Override
    public EnumMap<EntityPart, AnimationData> getDefaultAnimMap() {
        EnumMap<EntityPart, AnimationData> map = DrakefowlEntity.getGenericAnimMap();
        map.put(EntityPart.BODY, new AnimationData(new Vector3f(0.0f, -0.28125f, -0.1875f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 17.5f, 0.0f)));
        map.put(EntityPart.NECK, new AnimationData(new Vector3f(0.0f, -0.25f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, -0.5f, -3.0f)));
        map.put(EntityPart.HEAD, new AnimationData(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f)));
        return map;
    }

    @Override
    public EntityPart[] getOrderedOBBParts() {
        return OBB_PARTS;
    }

    @Override
    public OBB[] getDefaultOBBs() {
        return new OBB[]{new OBB(0.15625, 0.34375, 0.15625, 0.0, 0.09375, 0.0), new OBB(0.21875, 0.21875, 0.21875, 0.0, 0.03125, 0.03125)};
    }

    @Override
    public AABB getEnclosingAABB() {
        AABB bb = this.m_142469_();
        return new AABB(bb.f_82288_ - 0.5, bb.f_82289_, bb.f_82290_ - 0.5, bb.f_82291_ + 0.5, bb.f_82292_ + 0.5, bb.f_82293_ + 0.5);
    }

    @Override
    public EquipmentSlot getHitSlot(Vector3d hitPos, int boxIndex) {
        return boxIndex >= 0 ? EquipmentSlot.HEAD : EquipmentSlot.CHEST;
    }

    public static enum Type {
        BRONZE,
        EMERALD;

    }

    public static class GroupData
    extends AgeableMob.AgeableMobGroupData {
        public final Type type;

        public GroupData(Type type) {
            super(0.0f);
            this.type = type;
        }
    }
}

