/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.entity.animal;

import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import frostnox.nightfall.block.block.nest.NestBlockEntity;
import frostnox.nightfall.capability.ChunkData;
import frostnox.nightfall.capability.IChunkData;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.IHomeEntity;
import frostnox.nightfall.entity.IOrientedHitBoxes;
import frostnox.nightfall.entity.ai.goal.EatBlockGoal;
import frostnox.nightfall.entity.ai.goal.EatEntityGoal;
import frostnox.nightfall.entity.ai.goal.MoveToNestGoal;
import frostnox.nightfall.entity.ai.goal.ReducedWanderLandGoal;
import frostnox.nightfall.entity.ai.goal.StepUpFleeDamageGoal;
import frostnox.nightfall.entity.ai.goal.StepUpFleeEntityOrHomeGoal;
import frostnox.nightfall.entity.ai.sensing.AmplifiedAudioSensing;
import frostnox.nightfall.entity.ai.sensing.AudioSensing;
import frostnox.nightfall.entity.entity.Diet;
import frostnox.nightfall.entity.entity.animal.AnimalEntity;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.registry.forge.DataSerializersNF;
import frostnox.nightfall.util.LevelUtil;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.OBB;
import java.util.EnumMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class RabbitEntity
extends AnimalEntity
implements IOrientedHitBoxes,
IHomeEntity {
    private static final EntityPart[] OBB_PARTS = new EntityPart[]{EntityPart.BODY, EntityPart.HEAD};
    protected static final EntityDataAccessor<Type> TYPE = SynchedEntityData.m_135353_(RabbitEntity.class, DataSerializersNF.RABBIT_TYPE);
    protected static final EntityDataAccessor<Boolean> SPECIAL = SynchedEntityData.m_135353_(RabbitEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected BlockPos homePos = null;

    public RabbitEntity(EntityType<? extends RabbitEntity> type, Level level) {
        super((EntityType<? extends AnimalEntity>)type, level);
    }

    @Override
    protected int getMaxSatiety() {
        return 96000;
    }

    public static AttributeSupplier.Builder getAttributeMap() {
        return RabbitEntity.createAttributes().m_22268_(Attributes.f_22276_, 10.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22283_, 4.0).m_22268_(Attributes.f_22277_, 20.0).m_22268_((Attribute)AttributesNF.HEARING_RANGE.get(), 30.0).m_22268_((Attribute)AttributesNF.FROST_DEFENSE.get(), 0.2);
    }

    public Type getRabbitType() {
        return (Type)((Object)this.m_20088_().m_135370_(TYPE));
    }

    public boolean isSpecial() {
        return (Boolean)this.m_20088_().m_135370_(SPECIAL);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, new StepUpFleeEntityOrHomeGoal<LivingEntity>(this, LivingEntity.class, 1.6, 1.8, entity -> {
            if (entity.m_21224_()) {
                return false;
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                return !player.m_7500_() && !player.m_5833_();
            }
            return entity.m_6095_().m_204039_(TagsNF.RABBIT_PREDATOR);
        }));
        this.f_21345_.m_25352_(3, (Goal)new MoveToNestGoal(this, 1.3, 1.1){

            @Override
            public boolean m_8036_() {
                if (LevelUtil.isDayTimeWithin(RabbitEntity.this.f_19853_, 0L, 24000L) || RabbitEntity.this.f_19853_.f_46441_.nextInt() % 16 != 0) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new StepUpFleeDamageGoal(this, 1.8));
        this.f_21345_.m_25352_(5, (Goal)new EatEntityGoal(this, 1.3, 20, 2));
        this.f_21345_.m_25352_(6, (Goal)new EatBlockGoal(this, 1.3, 20, 2));
        this.f_21345_.m_25352_(7, (Goal)new ReducedWanderLandGoal(this, 1.3, 16));
    }

    public boolean m_6779_(LivingEntity pTarget) {
        return pTarget.m_142066_();
    }

    @Override
    public EquipmentSlot getHitSlot(Vector3d hitPos, int boxIndex) {
        return boxIndex == 0 ? EquipmentSlot.HEAD : EquipmentSlot.CHEST;
    }

    @Override
    public void m_6667_(DamageSource pCause) {
        BlockEntity blockEntity;
        super.m_6667_(pCause);
        if (this.f_20890_ && this.homePos != null && !this.f_19853_.f_46443_ && (blockEntity = this.f_19853_.m_7702_(this.homePos)) instanceof NestBlockEntity) {
            NestBlockEntity nest = (NestBlockEntity)blockEntity;
            nest.stopTrackingEntity(this.m_142081_());
        }
    }

    @Override
    protected AudioSensing createAudioSensing() {
        return new AmplifiedAudioSensing(this, 10, 1.5f);
    }

    @Override
    public float getVisionAngle() {
        return 180.0f;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TYPE, (Object)Type.BRUSH);
        this.f_19804_.m_135372_(SPECIAL, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        boolean special;
        super.m_7380_(tag);
        int type = this.getRabbitType().ordinal();
        if (type != 0) {
            tag.m_128405_("type", type);
        }
        if (special = this.isSpecial()) {
            tag.m_128379_("special", special);
        }
        if (this.homePos != null) {
            tag.m_128365_("homePos", (Tag)NbtUtils.m_129224_((BlockPos)this.homePos));
        }
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.m_20088_().m_135381_(TYPE, (Object)Type.values()[tag.m_128451_("type")]);
        this.m_20088_().m_135381_(SPECIAL, (Object)tag.m_128471_("special"));
        if (tag.m_128441_("homePos")) {
            this.homePos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("homePos"));
        }
    }

    @Override
    public float getPushResistance() {
        return 1.0f;
    }

    @Override
    public float getPushForce() {
        return 1.0f;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        Type type;
        if ((spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, (SpawnGroupData)spawnDataIn, dataTag)) instanceof GroupData) {
            GroupData data = (GroupData)((Object)spawnDataIn);
            type = data.type;
        } else {
            IChunkData chunkData = ChunkData.get(worldIn.m_6018_().m_46745_(this.m_142538_()));
            float temp = chunkData.getTemperature(this.m_142538_());
            float humidity = chunkData.getHumidity(this.m_142538_());
            spawnDataIn = GroupData.create(temp, humidity);
            type = ((GroupData)((Object)spawnDataIn)).type;
        }
        this.m_20088_().m_135381_(TYPE, (Object)type);
        if (this.f_19796_.nextInt() % 8192 == 0) {
            this.m_20088_().m_135381_(SPECIAL, (Object)true);
        }
        return spawnDataIn;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.95f;
    }

    protected int m_5639_(float pFallDistance, float pDamageMultiplier) {
        return super.m_5639_(pFallDistance, pDamageMultiplier) - 60;
    }

    protected SoundEvent m_7515_() {
        return null;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12353_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_12352_;
    }

    protected void m_7355_(BlockPos pos, BlockState pBlock) {
    }

    @Override
    public boolean includeAABB() {
        return true;
    }

    @Override
    public Vector3f getOBBTranslation() {
        return new Vector3f(0.0f, 0.15625f + 0.15625f * Math.min(1.0f, this.f_20924_ * 2.0f), 0.0f);
    }

    @Override
    public EnumMap<EntityPart, AnimationData> getDefaultAnimMap() {
        EnumMap<EntityPart, AnimationData> map = RabbitEntity.getGenericAnimMap();
        map.put(EntityPart.BODY, new AnimationData(new Vector3f(0.0f, -0.125f, -0.21875f), new Vector3f(0.0f, 0.0f, 0.0f)));
        map.put(EntityPart.HEAD, new AnimationData(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f)));
        return map;
    }

    @Override
    public EntityPart[] getOrderedOBBParts() {
        return OBB_PARTS;
    }

    @Override
    public OBB[] getDefaultOBBs() {
        return new OBB[]{new OBB(0.203125, 0.203125, 0.265625, 0.0, 0.03125, 0.09375)};
    }

    @Override
    public AABB getEnclosingAABB() {
        AABB bb = this.m_142469_();
        return new AABB(bb.f_82288_ - 0.5, bb.f_82289_, bb.f_82290_ - 0.5, bb.f_82291_ + 0.5, bb.f_82292_ + 0.5, bb.f_82293_ + 0.5);
    }

    @Override
    @Nullable
    public BlockPos getHomePos() {
        return this.homePos;
    }

    @Override
    public void setHomePos(@Nullable BlockPos pos) {
        this.homePos = pos;
    }

    @Override
    public Diet getDiet() {
        return Diet.CARNIVORE;
    }

    @Override
    public SoundEvent getEatSound() {
        return null;
    }

    public static enum Type {
        BRUSH,
        COTTONTAIL,
        ARCTIC,
        STRIPED;

    }

    public static class GroupData
    extends AgeableMob.AgeableMobGroupData {
        public final Type type;

        public GroupData(Type type) {
            super(0.0f);
            this.type = type;
        }

        public static GroupData create(float temp, float humidity) {
            Type type = temp < 0.3f ? Type.ARCTIC : (humidity > 0.7f ? Type.STRIPED : (temp > 0.7f ? Type.COTTONTAIL : Type.BRUSH));
            return new GroupData(type);
        }
    }
}

