/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.entity.animal;

import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.entity.ITamable;
import frostnox.nightfall.entity.Sex;
import frostnox.nightfall.entity.entity.animal.AnimalEntity;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.GenericEntityToClient;
import frostnox.nightfall.network.message.entity.EatItemToClient;
import frostnox.nightfall.registry.KnowledgeNF;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public abstract class TamableAnimalEntity
extends AnimalEntity
implements ITamable {
    protected static final EntityDataAccessor<Boolean> SPECIAL = SynchedEntityData.m_135353_(TamableAnimalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> TAMED = SynchedEntityData.m_135353_(TamableAnimalEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public final Sex sex;
    public boolean tamable;
    protected int breedTime;
    protected int gestationTime;
    protected boolean comfortable;

    public TamableAnimalEntity(EntityType<? extends AnimalEntity> type, Level level, Sex sex) {
        super(type, level);
        this.sex = sex;
    }

    public int getBreedTime() {
        return this.breedTime;
    }

    public int getGestationTime() {
        return this.gestationTime;
    }

    public boolean isComfortable() {
        return this.comfortable;
    }

    public void endGestation() {
        this.gestationTime = 0;
        this.onGestationEnd();
    }

    public boolean isSpecial() {
        return (Boolean)this.m_20088_().m_135370_(SPECIAL);
    }

    @Override
    public boolean isTamed() {
        return (Boolean)this.m_20088_().m_135370_(TAMED);
    }

    public boolean canBreed() {
        return this.breedTime > 0 && this.gestationTime == 0 && this.comfortable;
    }

    public final void breedPair(TamableAnimalEntity other) {
        this.breedWith(other);
        other.breedWith(this);
        this.breedTime = 0;
        other.breedTime = 0;
    }

    protected void updateGoals() {
    }

    protected void onGestationEnd() {
    }

    protected void onFeed() {
        this.breedTime = 400;
    }

    public abstract boolean canBreedWith(TamableAnimalEntity var1);

    protected abstract void breedWith(TamableAnimalEntity var1);

    protected abstract boolean checkComfort();

    public abstract boolean isFeedItem(ItemStack var1);

    public abstract ResourceLocation getBreedAction();

    @Override
    public boolean m_6573_(Player pPlayer) {
        return !this.m_21523_() && this.isTamed();
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.m_6084_()) {
            if (this.breedTime > 0) {
                --this.breedTime;
            }
            if (this.gestationTime > 0) {
                --this.gestationTime;
                if (this.gestationTime == 0) {
                    this.onGestationEnd();
                }
            }
            if (!this.f_19853_.f_46443_ && this.randTickCount % 30 == 0) {
                this.comfortable = this.checkComfort();
            }
        }
    }

    @Override
    public void addSatiety(int amount) {
        if (this.satiety == 0 && this.gestationTime == 0 && amount >= this.getMaxSatiety() && this.isTamed()) {
            this.onFeed();
        }
        super.addSatiety(amount);
    }

    protected InteractionResult m_6071_(Player pPlayer, InteractionHand pHand) {
        ItemStack item;
        if (!this.isTamed()) {
            ItemStack item2;
            if (this.tamable && this.isFeedItem(item2 = pPlayer.m_21120_(pHand))) {
                if (!this.f_19853_.f_46443_) {
                    PlayerData.get(pPlayer).addKnowledge(KnowledgeNF.TAMED_ANIMAL.getId());
                    NetworkHandler.toAllTracking((Entity)this, new EatItemToClient(item2.m_41777_(), this.m_142049_()));
                    item2.m_41774_(1);
                    this.m_20088_().m_135381_(TAMED, (Object)true);
                    this.m_6710_(null);
                    this.lastTargetPos = null;
                    this.m_21561_(false);
                    this.noDespawnTicks = -1;
                    this.satiety = this.getMaxSatiety();
                    this.updateGoals();
                    if (this.getCollapseAction() != null && this.getActionTracker().getActionID().equals((Object)this.getCollapseAction()) && this.getActionTracker().isCharging()) {
                        this.getActionTracker().queue();
                        NetworkHandler.toAllTracking((Entity)this, new GenericEntityToClient(NetworkHandler.Type.QUEUE_ACTION_TRACKER, this.m_142049_()));
                    }
                }
                return this.f_19853_.f_46443_ ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
            }
        } else if (this.breedTime == 0 && this.satiety == 0 && this.gestationTime == 0 && this.isFeedItem(item = pPlayer.m_21120_(pHand))) {
            if (!this.f_19853_.f_46443_) {
                NetworkHandler.toAllTracking((Entity)this, new EatItemToClient(item.m_41777_(), this.m_142049_()));
                item.m_41774_(1);
                this.addSatiety(this.getMaxSatiety());
            }
            return this.f_19853_.f_46443_ ? InteractionResult.SUCCESS : InteractionResult.CONSUME;
        }
        return InteractionResult.PASS;
    }

    @Override
    protected void simulateTime(int timePassed) {
        super.simulateTime(timePassed);
        if (this.m_6084_()) {
            // empty if block
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPECIAL, (Object)false);
        this.f_19804_.m_135372_(TAMED, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("special", this.isSpecial());
        tag.m_128379_("tamed", this.isTamed());
        tag.m_128379_("tamable", this.tamable);
        tag.m_128379_("comfortable", this.comfortable);
        tag.m_128405_("breedTime", this.breedTime);
        tag.m_128405_("gestationTime", this.gestationTime);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.m_20088_().m_135381_(SPECIAL, (Object)tag.m_128471_("special"));
        this.m_20088_().m_135381_(TAMED, (Object)tag.m_128471_("tamed"));
        this.tamable = tag.m_128471_("tamable");
        this.comfortable = tag.m_128471_("comfortable");
        this.breedTime = tag.m_128451_("breedTime");
        this.gestationTime = tag.m_128451_("gestationTime");
    }
}

