/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.entity.monster;

import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Poise;
import frostnox.nightfall.capability.ChunkData;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.IChaser;
import frostnox.nightfall.entity.IOrientedHitBoxes;
import frostnox.nightfall.entity.ai.goal.EatBlockGoal;
import frostnox.nightfall.entity.ai.goal.EatEntityGoal;
import frostnox.nightfall.entity.ai.goal.FloatAtHeightGoal;
import frostnox.nightfall.entity.ai.goal.RandomLookGoal;
import frostnox.nightfall.entity.ai.goal.ReducedWanderLandGoal;
import frostnox.nightfall.entity.ai.goal.StepUpFleeDamageGoal;
import frostnox.nightfall.entity.ai.goal.StepUpFleeEntityGoal;
import frostnox.nightfall.entity.ai.goal.StepUpRushAttackGoal;
import frostnox.nightfall.entity.ai.goal.target.TrackNearestTargetGoal;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.entity.entity.Diet;
import frostnox.nightfall.entity.entity.monster.HungryMonsterEntity;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.GenericEntityToClient;
import frostnox.nightfall.registry.ActionsNF;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.registry.forge.DataSerializersNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.Easing;
import frostnox.nightfall.util.math.OBB;
import java.util.EnumMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class CockatriceEntity
extends HungryMonsterEntity
implements IOrientedHitBoxes,
IChaser {
    private static final EntityPart[] OBB_PARTS = new EntityPart[]{EntityPart.BODY, EntityPart.NECK, EntityPart.HEAD};
    protected static final EntityDataAccessor<Type> TYPE = SynchedEntityData.m_135353_(CockatriceEntity.class, DataSerializersNF.COCKATRICE_TYPE);
    protected static final EntityDataAccessor<Boolean> SPECIAL = SynchedEntityData.m_135353_(CockatriceEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int targetTime;
    public int targetTimeLast;
    public boolean isChasingTarget;

    public CockatriceEntity(EntityType<? extends CockatriceEntity> type, Level worldIn) {
        super((EntityType<? extends HungryMonsterEntity>)type, worldIn);
    }

    public static AttributeSupplier.Builder getAttributeMap() {
        return CockatriceEntity.createAttributes().m_22268_(Attributes.f_22276_, 100.0).m_22268_(Attributes.f_22279_, (double)0.275f).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22283_, 4.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_((Attribute)AttributesNF.HEARING_RANGE.get(), 15.0).m_22268_((Attribute)AttributesNF.SLASHING_DEFENSE.get(), 0.35).m_22268_((Attribute)AttributesNF.PIERCING_DEFENSE.get(), 0.2).m_22268_((Attribute)AttributesNF.FIRE_DEFENSE.get(), 0.3).m_22268_((Attribute)AttributesNF.POISE.get(), (double)Poise.LOW.ordinal());
    }

    public static EnumMap<EntityPart, AnimationData> getHeadAnimMap() {
        EnumMap<EntityPart, AnimationData> map = new EnumMap<EntityPart, AnimationData>(EntityPart.class);
        map.put(EntityPart.BODY, new AnimationData(new Vector3f(0.0f, -0.46875f, 0.3125f)));
        map.put(EntityPart.NECK, new AnimationData(new Vector3f(0.0f, -0.625f, 0.0f), new Vector3f(35.0f, 0.0f, 0.0f)));
        map.put(EntityPart.HEAD, new AnimationData(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(-35.0f, 0.0f, 0.0f)));
        return map;
    }

    public Type getCockatriceType() {
        return (Type)((Object)this.m_20088_().m_135370_(TYPE));
    }

    public boolean isSpecial() {
        return (Boolean)this.m_20088_().m_135370_(SPECIAL);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatAtHeightGoal((Mob)this, 0.8));
        this.f_21345_.m_25352_(2, new StepUpFleeEntityGoal<LivingEntity>(this, LivingEntity.class, 1.6, 1.8, entity -> {
            if (entity.m_21224_()) {
                return false;
            }
            return entity.m_6095_().m_204039_(TagsNF.COCKATRICE_PREDATOR);
        }));
        this.f_21345_.m_25352_(3, (Goal)new StepUpRushAttackGoal(this, 1.7){

            @Override
            public void m_8056_() {
                super.m_8056_();
                CockatriceEntity.this.isChasingTarget = true;
                NetworkHandler.toAllTracking((Entity)this.mob, new GenericEntityToClient(NetworkHandler.Type.CHASER_ACQUIRE_TARGET_CLIENT, this.mob.m_142049_()));
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                CockatriceEntity.this.isChasingTarget = false;
                NetworkHandler.toAllTracking((Entity)this.mob, new GenericEntityToClient(NetworkHandler.Type.CHASER_REMOVE_TARGET_CLIENT, this.mob.m_142049_()));
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new StepUpFleeDamageGoal(this, 1.7));
        this.f_21345_.m_25352_(5, (Goal)new EatEntityGoal(this, 1.0, 15, 2));
        this.f_21345_.m_25352_(6, (Goal)new EatBlockGoal(this, 1.0, 15, 2));
        this.f_21345_.m_25352_(7, (Goal)new ReducedWanderLandGoal(this, 0.75, 6));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookGoal((Mob)this, 0.0025f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new TrackNearestTargetGoal<LivingEntity>((ActionableEntity)this, LivingEntity.class, true, entity -> {
            if (entity.m_21224_()) {
                return false;
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                return !player.m_7500_() && !player.m_5833_();
            }
            return entity.m_6095_().m_204039_(TagsNF.COCKATRICE_PREY);
        }){

            protected double m_7623_() {
                return super.m_7623_() * Math.max(0.3, 1.0 - CockatriceEntity.this.getSatietyPercent());
            }
        });
    }

    @Override
    public double getReducedAIThresholdSqr() {
        return 62500.0;
    }

    @Override
    public boolean canTargetFromSound(LivingEntity target) {
        return target.m_6095_().m_204039_(TagsNF.COCKATRICE_PREY) || target instanceof Player;
    }

    public boolean m_6779_(LivingEntity target) {
        return target.m_142066_() && !(target instanceof CockatriceEntity);
    }

    @Override
    public ResourceLocation pickActionEnemy(double distanceSqr, Entity target) {
        if (distanceSqr > 7.5625 && (double)this.f_19796_.nextFloat() < Math.min(0.95, distanceSqr / 36.0)) {
            return ActionsNF.COCKATRICE_SPIT.getId();
        }
        if (target.m_20206_() < 0.3125f) {
            return ActionsNF.COCKATRICE_BITE.getId();
        }
        if (distanceSqr > 3.0625) {
            return this.f_19796_.nextFloat() < 0.75f ? ActionsNF.COCKATRICE_BITE.getId() : ActionsNF.COCKATRICE_CLAW.getId();
        }
        return this.f_19796_.nextFloat() < 0.5f ? ActionsNF.COCKATRICE_BITE.getId() : ActionsNF.COCKATRICE_CLAW.getId();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.targetTimeLast = this.targetTime;
        if (this.m_6084_()) {
            if (this.isChasingTarget) {
                if (this.targetTime < 9) {
                    ++this.targetTime;
                }
            } else if (this.targetTime > 0) {
                --this.targetTime;
            }
        }
    }

    @Override
    public float getVisionAngle() {
        return 100.0f;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TYPE, (Object)Type.EMERALD);
        this.f_19804_.m_135372_(SPECIAL, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        boolean special;
        super.m_7380_(tag);
        int type = this.getCockatriceType().ordinal();
        if (type != 0) {
            tag.m_128405_("type", type);
        }
        if (special = this.isSpecial()) {
            tag.m_128379_("special", special);
        }
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.m_20088_().m_135381_(TYPE, (Object)Type.values()[tag.m_128451_("type")]);
        this.m_20088_().m_135381_(SPECIAL, (Object)tag.m_128471_("special"));
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        Type type;
        if ((spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, (SpawnGroupData)spawnDataIn, dataTag)) instanceof GroupData) {
            GroupData data = (GroupData)((Object)spawnDataIn);
            type = data.type;
        } else {
            float temperature = ChunkData.get(worldIn.m_6018_().m_46745_(this.m_142538_())).getTemperature(this.m_142538_());
            type = temperature > 0.7f ? Type.BRONZE : Type.EMERALD;
            spawnDataIn = new GroupData(type);
        }
        this.m_20088_().m_135381_(TYPE, (Object)type);
        if (this.f_19796_.nextInt() % 8192 == 0) {
            this.m_20088_().m_135381_(SPECIAL, (Object)true);
        }
        return spawnDataIn;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ - 0.01f;
    }

    public float m_6100_() {
        return 1.0f + (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.1f;
    }

    protected SoundEvent m_7515_() {
        if (!this.isChasingTarget) {
            return (SoundEvent)SoundsNF.COCKATRICE_AMBIENT.get();
        }
        return null;
    }

    @Override
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)SoundsNF.COCKATRICE_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundsNF.COCKATRICE_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState pBlock) {
        this.m_5496_((SoundEvent)SoundsNF.COCKATRICE_STEP.get(), 0.15f, 1.0f);
    }

    @Override
    protected int getMaxSatiety() {
        return 48000;
    }

    @Override
    public Diet getDiet() {
        return Diet.CARNIVORE;
    }

    @Override
    public boolean canEat(Entity entity) {
        if (super.canEat(entity)) {
            return true;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity.f_20919_ > 20 && entity.m_6095_().m_204039_(TagsNF.EDIBLE_CORPSE);
        }
        return false;
    }

    @Override
    public SoundEvent getEatSound() {
        return (SoundEvent)SoundsNF.COCKATRICE_BITE.get();
    }

    @Override
    public boolean includeAABB() {
        return true;
    }

    @Override
    public Vector3f getOBBTranslation() {
        return new Vector3f(0.0f, 0.75f, 0.0f);
    }

    @Override
    public EnumMap<EntityPart, AnimationData> getDefaultAnimMap() {
        EnumMap<EntityPart, AnimationData> map = CockatriceEntity.getGenericAnimMap();
        float trackAmount = AnimationUtil.applyEasing((float)this.targetTime / 9.0f, Easing.inOutSine);
        map.put(EntityPart.BODY, new AnimationData(new Vector3f(0.0f, -0.46875f, -0.3125f)));
        map.put(EntityPart.NECK, new AnimationData(new Vector3f(0.0f, -0.5f, 0.0f), new Vector3f(35.0f + trackAmount * 45.0f, 0.0f, 0.0f)));
        map.put(EntityPart.HEAD, new AnimationData(new Vector3f(0.0f, 0.0f, 1.0f * trackAmount / 16.0f), new Vector3f(-35.0f + trackAmount * -45.0f, 0.0f, 0.0f)));
        return map;
    }

    @Override
    public EntityPart[] getOrderedOBBParts() {
        return OBB_PARTS;
    }

    @Override
    public OBB[] getDefaultOBBs() {
        return new OBB[]{new OBB(0.21875, 0.65625, 0.21875, 0.0, 0.25, -0.03125), new OBB(0.28125, 0.28125, 0.40625, 0.0, 0.125, 0.03125)};
    }

    @Override
    public AABB getEnclosingAABB() {
        AABB bb = this.m_142469_();
        return new AABB(bb.f_82288_ - 0.55, bb.f_82289_, bb.f_82290_ - 0.55, bb.f_82291_ + 0.55, bb.f_82292_ + 0.55, bb.f_82293_ + 0.55);
    }

    @Override
    public EquipmentSlot getHitSlot(Vector3d hitPos, int boxIndex) {
        return boxIndex >= 0 ? EquipmentSlot.HEAD : EquipmentSlot.CHEST;
    }

    @Override
    public void setChasing(boolean value) {
        this.isChasingTarget = value;
    }

    @Override
    public boolean isChasing() {
        return this.isChasingTarget;
    }

    public static enum Type {
        BRONZE,
        EMERALD;

    }

    public static class GroupData
    extends AgeableMob.AgeableMobGroupData {
        public final Type type;

        public GroupData(Type type) {
            super(0.0f);
            this.type = type;
        }
    }
}

