/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.entity.monster;

import com.mojang.math.Vector3d;
import frostnox.nightfall.action.DamageTypeSource;
import frostnox.nightfall.action.Impact;
import frostnox.nightfall.entity.ai.goal.FleeDamageGoal;
import frostnox.nightfall.entity.ai.goal.PursueTargetGoal;
import frostnox.nightfall.entity.ai.goal.RandomLookGoal;
import frostnox.nightfall.entity.ai.goal.WanderLandGoal;
import frostnox.nightfall.entity.ai.goal.target.TrackNearestTargetGoal;
import frostnox.nightfall.entity.ai.pathfinding.FlankingLandEntityNavigator;
import frostnox.nightfall.entity.entity.monster.MonsterEntity;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.registry.forge.ParticleTypesNF;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.event.ForgeEventFactory;

public class CreeperEntity
extends MonsterEntity {
    public static final int MAX_SWELL = 20;
    public static final float EXPLOSION_RADIUS = 3.25f;
    private static final EntityDataAccessor<Boolean> SWELLING = SynchedEntityData.m_135353_(CreeperEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private int oldSwell;
    private int swell;

    public CreeperEntity(EntityType<? extends MonsterEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder getAttributeMap() {
        return CreeperEntity.createAttributes().m_22268_(Attributes.f_22276_, 40.0).m_22268_(Attributes.f_22279_, (double)0.2675f).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_((Attribute)AttributesNF.HEARING_RANGE.get(), 15.0).m_22268_((Attribute)AttributesNF.STRIKING_DEFENSE.get(), 0.2).m_22268_((Attribute)AttributesNF.SLASHING_DEFENSE.get(), -0.2).m_22268_((Attribute)AttributesNF.FIRE_DEFENSE.get(), -0.25);
    }

    public boolean isSwelling() {
        return (Boolean)this.f_19804_.m_135370_(SWELLING);
    }

    public void setSwelling(boolean swelling) {
        this.f_19804_.m_135381_(SWELLING, (Object)swelling);
    }

    public float getSwelling(float pPartialTicks) {
        return Mth.m_14179_((float)pPartialTicks, (float)this.oldSwell, (float)this.swell) / 18.0f;
    }

    @Override
    public EquipmentSlot getHitSlot(Vector3d hitPos, int boxIndex) {
        double y = hitPos.f_86215_;
        if (y > 0.375 && y <= 1.125) {
            return EquipmentSlot.CHEST;
        }
        if (y > 1.125) {
            return EquipmentSlot.HEAD;
        }
        return EquipmentSlot.LEGS;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, new Goal(){

            public boolean m_8036_() {
                LivingEntity target = CreeperEntity.this.m_5448_();
                return CreeperEntity.this.isSwelling() || target != null && CreeperEntity.this.m_20280_((Entity)target) < 9.0;
            }

            public boolean m_183429_() {
                return true;
            }

            public void m_8037_() {
                LivingEntity target = CreeperEntity.this.m_5448_();
                if (target == null || CreeperEntity.this.getActionTracker().isStunned() || CreeperEntity.this.m_20280_((Entity)target) > 12.25 || !CreeperEntity.this.hasAnyLineOfSight((Entity)target)) {
                    CreeperEntity.this.setSwelling(false);
                } else {
                    CreeperEntity.this.setSwelling(true);
                }
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new PursueTargetGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new WanderLandGoal(this, 0.8));
        this.f_21345_.m_25352_(5, (Goal)new FleeDamageGoal(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new RandomLookGoal((Mob)this, 0.005f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new TrackNearestTargetGoal<Player>(this, Player.class, true));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.oldSwell = this.swell;
        if (this.m_6084_()) {
            boolean swelling = this.isSwelling();
            if (swelling && this.swell == 0) {
                this.m_5496_(SoundEvents.f_11837_, 1.0f, 0.5f);
                this.m_146850_(GameEvent.f_157776_);
            }
            this.swell = swelling ? ++this.swell : --this.swell;
            if (this.swell < 0) {
                this.swell = 0;
            } else if (this.swell >= 20) {
                this.swell = 20;
                if (!this.f_19853_.f_46443_) {
                    Explosion.BlockInteraction interaction = ForgeEventFactory.getMobGriefingEvent((Level)this.f_19853_, (Entity)this) ? Explosion.BlockInteraction.DESTROY : Explosion.BlockInteraction.NONE;
                    this.f_20890_ = true;
                    this.f_19853_.m_7703_((Entity)this, (DamageSource)DamageTypeSource.createExplosionSource((LivingEntity)this).setImpact(Impact.MAXIMUM).setStun(20), null, this.m_20185_(), this.m_20186_(), this.m_20189_(), 3.25f, false, interaction);
                    this.m_146870_();
                }
            }
        } else if (this.swell > 0) {
            --this.swell;
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SWELLING, (Object)false);
    }

    @Override
    public ParticleOptions getHurtParticle() {
        return (ParticleOptions)ParticleTypesNF.FRAGMENT_CREEPER.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_11836_;
    }

    @Override
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11835_;
    }

    @Override
    public boolean m_7327_(Entity pEntity) {
        return true;
    }

    public boolean m_6779_(LivingEntity pTarget) {
        Player player;
        return pTarget instanceof Player && !(player = (Player)pTarget).m_7500_() && !player.m_5833_();
    }

    @Override
    protected PathNavigation m_6037_(Level level) {
        return new FlankingLandEntityNavigator(this, level);
    }
}

