/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.entity.monster;

import com.mojang.math.Vector3d;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.entity.ai.goal.FleeDamageGoal;
import frostnox.nightfall.entity.ai.goal.FollowAllyGoal;
import frostnox.nightfall.entity.ai.goal.StareAtTargetGoal;
import frostnox.nightfall.entity.ai.goal.target.TrackNearestTargetGoal;
import frostnox.nightfall.entity.ai.pathfinding.LandEntityNavigator;
import frostnox.nightfall.entity.ai.pathfinding.Node;
import frostnox.nightfall.entity.ai.pathfinding.NodeType;
import frostnox.nightfall.entity.ai.pathfinding.ReversePath;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.entity.entity.monster.UndeadEntity;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.entity.SetAllyToClient;
import frostnox.nightfall.registry.ActionsNF;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.registry.forge.ParticleTypesNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.world.MoonPhase;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelTimeAccess;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class DregEntity
extends UndeadEntity {
    @Nullable
    public UndeadEntity ally;
    public boolean buildDone = true;
    public boolean cowerOnly;
    protected int buildCooldown = 0;
    @Nullable
    protected ReversePath buildPath;
    protected boolean canBuild = false;
    private final List<Goal> goals = List.of(new FollowAllyGoal(this, 1.0, 12.0, 8.0), new StareAtTargetGoal(this, true), new FleeDamageGoal(this, 0.8), new RandomLookAroundGoal((Mob)this));
    private final List<Goal> targetGoals = List.of(new HurtByTargetGoal((PathfinderMob)this, new Class[0]), new TrackNearestTargetGoal<Player>(this, Player.class, MoonPhase.get((LevelTimeAccess)this.f_19853_) != MoonPhase.FULL));

    public DregEntity(EntityType<? extends DregEntity> type, Level worldIn) {
        super((EntityType<? extends UndeadEntity>)type, worldIn);
        this.setCowerOnly(false);
    }

    @Nullable
    public ReversePath getBuildPath() {
        return this.buildPath;
    }

    public void setCowerOnly(boolean value) {
        this.cowerOnly = value;
        if (!this.f_19853_.f_46443_) {
            for (Goal goal : this.goals) {
                this.f_21345_.m_25363_(goal);
            }
            for (Goal goal : this.targetGoals) {
                this.f_21346_.m_25363_(goal);
            }
            if (!this.cowerOnly) {
                int i;
                for (i = 0; i < this.goals.size(); ++i) {
                    this.f_21345_.m_25352_(i + 3, this.goals.get(i));
                }
                for (i = 0; i < this.targetGoals.size(); ++i) {
                    this.f_21346_.m_25352_(i + 1, this.targetGoals.get(i));
                }
            }
        }
    }

    public static AttributeSupplier.Builder getAttributeMap() {
        return DregEntity.createAttributes().m_22268_(Attributes.f_22276_, 70.0).m_22268_((Attribute)AttributesNF.WILLPOWER.get(), 20.0).m_22268_(Attributes.f_22279_, (double)0.26f).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_((Attribute)AttributesNF.HEARING_RANGE.get(), 15.0);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new DregActionGoal(this));
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (this.f_19853_.f_46443_ && this.f_19796_.nextInt(6) == 0) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypesNF.ESSENCE_MOON.get(), this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
        }
        if (!this.m_6084_()) {
            return;
        }
        if (this.ally != null && this.ally.m_146910_()) {
            this.ally = null;
        }
        if (!this.f_19853_.f_46443_) {
            if (this.buildCooldown > 0) {
                --this.buildCooldown;
            }
            if (this.randTickCount % 30 == 0 && (this.ally == null || this.ally instanceof DregEntity || this.m_20280_((Entity)this.ally) > 900.0)) {
                List entities = this.f_19853_.m_45933_((Entity)this, this.m_142469_().m_82377_(16.0, 8.0, 16.0));
                UndeadEntity candidate = null;
                int cPrio = 0;
                double cDistSqr = Double.MAX_VALUE;
                for (Entity entity : entities) {
                    UndeadEntity undead;
                    int uPrio = 0;
                    if (!(entity instanceof UndeadEntity) || (undead = (UndeadEntity)entity) != this.ally && undead.hasDregAlly) continue;
                    double uDistSqr = this.m_20280_((Entity)undead);
                    if (!undead.m_6084_()) {
                        uPrio += 100;
                    }
                    if (!(undead instanceof DregEntity)) {
                        uPrio += 10;
                    }
                    if (uDistSqr < cDistSqr) {
                        ++uPrio;
                    }
                    if (uPrio <= cPrio) continue;
                    candidate = undead;
                    cPrio = uPrio;
                    cDistSqr = uDistSqr;
                }
                if (this.ally != null) {
                    this.ally.hasDregAlly = false;
                }
                this.setAlly(candidate);
                if (this.ally != null) {
                    NetworkHandler.toAllTracking((Entity)this, new SetAllyToClient(this.ally.m_142049_(), this.m_142049_()));
                }
            }
        }
    }

    @Override
    public void m_142687_(Entity.RemovalReason pReason) {
        super.m_142687_(pReason);
        if (this.ally != null) {
            this.ally.hasDregAlly = false;
        }
    }

    @Override
    public void m_6667_(DamageSource pCause) {
        super.m_6667_(pCause);
        if (this.f_20890_ && this.ally != null) {
            this.ally.hasDregAlly = false;
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setCowerOnly(this.f_19796_.nextInt(1024) == 0);
        this.equipHumanoid(worldIn.m_5822_(), 0.55f, 0.6f, 0.65f, 0.2f, MoonPhase.get((LevelTimeAccess)worldIn) == MoonPhase.FULL ? 0.25f : 0.0f);
        return spawnDataIn;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.cowerOnly) {
            tag.m_128379_("cowerOnly", this.cowerOnly);
        }
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setCowerOnly(tag.m_128471_("cowerOnly"));
    }

    @Override
    public UndeadEntity getAlly() {
        return this.ally;
    }

    @Override
    public void setAlly(ActionableEntity ally) {
        if (ally instanceof UndeadEntity) {
            UndeadEntity undead;
            this.ally = undead = (UndeadEntity)ally;
            undead.hasDregAlly = true;
        }
    }

    @Override
    public boolean canBuild() {
        return this.getEssence() >= 50.0f && this.canBuild;
    }

    @Override
    protected PathNavigation m_6037_(Level level) {
        return new LandEntityNavigator(this, level){

            @Override
            protected boolean isGoalInvalid(Node goal) {
                return !goal.type.walkable || goal.type == NodeType.BUILDABLE_WALKABLE;
            }
        };
    }

    @Override
    public EquipmentSlot getHitSlot(Vector3d hitPos, int boxIndex) {
        double y = hitPos.f_86215_;
        if (y > 0.3125 && y <= 0.75) {
            return EquipmentSlot.LEGS;
        }
        if (y > 0.75 && y <= 1.375) {
            return EquipmentSlot.CHEST;
        }
        if (y > 1.375) {
            return EquipmentSlot.HEAD;
        }
        return EquipmentSlot.FEET;
    }

    @Override
    public ParticleOptions getHurtParticle() {
        return (ParticleOptions)ParticleTypesNF.BLOOD_DARK_RED.get();
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        if (this.m_21224_()) {
            return super.m_6431_(poseIn, sizeIn);
        }
        return 1.65f;
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundsNF.DREG_AMBIENT.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)SoundsNF.DREG_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundsNF.DREG_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState pBlock) {
        this.m_5496_((SoundEvent)SoundsNF.DREG_STEP.get(), 0.15f, 1.0f);
    }

    private static class DregActionGoal
    extends Goal {
        private final DregEntity dreg;

        DregActionGoal(DregEntity dreg) {
            this.dreg = dreg;
        }

        public boolean m_8036_() {
            return this.dreg.getAlly() != null || this.dreg.m_5448_() != null || this.dreg.cowerOnly;
        }

        public boolean m_8045_() {
            return this.m_8036_();
        }

        public boolean m_183429_() {
            return true;
        }

        public void m_8041_() {
            this.dreg.queueAction();
            this.dreg.buildDone = true;
            this.dreg.buildPath = null;
        }

        public void m_8037_() {
            if (!ActionTracker.isPresent((Entity)this.dreg)) {
                return;
            }
            IActionTracker capA = this.dreg.getActionTracker();
            if (!capA.isInactive() && !capA.isCharging()) {
                return;
            }
            if (this.dreg.cowerOnly) {
                this.dreg.startAction(ActionsNF.DREG_COWER.getId());
                return;
            }
            UndeadEntity ally = this.dreg.getAlly();
            ResourceLocation action = ActionsNF.EMPTY.getId();
            if (ally != null) {
                if (!ally.m_6084_() && !ally.resurrecting) {
                    action = ActionsNF.DREG_RESURRECT.getId();
                } else if (ally.getTargetPos() != null) {
                    ReversePath path = ally.getNavigator().getActivePath();
                    if (path != null) {
                        this.dreg.canBuild = true;
                        if (!this.dreg.canBuild() || this.dreg.buildCooldown > 0 || path.reachesGoal() || path.getSize() > 4) {
                            action = ActionsNF.DREG_BUFF.getId();
                        } else {
                            if (this.dreg.buildDone) {
                                LivingEntity target = ally.m_5448_();
                                this.dreg.buildPath = target != null ? this.dreg.getNavigator().findPath((Entity)target, 1.0f) : this.dreg.getNavigator().findPath(ally.lastTargetPos, 1.0f);
                                this.dreg.buildDone = false;
                                this.dreg.buildCooldown = 20;
                            }
                            action = ActionsNF.DREG_BUILD.getId();
                        }
                        this.dreg.canBuild = false;
                    }
                } else {
                    this.dreg.buildDone = true;
                }
            } else if (this.dreg.m_5448_() != null) {
                action = ActionsNF.DREG_COWER.getId();
            }
            if (!action.equals((Object)capA.getActionID())) {
                if (!capA.isInactive()) {
                    this.dreg.queueAction();
                } else {
                    this.dreg.startAction(action);
                }
            }
        }
    }
}

