/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.entity.monster;

import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.DamageTypeSource;
import frostnox.nightfall.action.Impact;
import frostnox.nightfall.action.Poise;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.ai.goal.RushAttackGoal;
import frostnox.nightfall.entity.ai.goal.WanderLandGoal;
import frostnox.nightfall.entity.entity.monster.MonsterEntity;
import frostnox.nightfall.entity.entity.monster.UndeadEntity;
import frostnox.nightfall.registry.ActionsNF;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.registry.forge.EffectsNF;
import frostnox.nightfall.registry.forge.EntitiesNF;
import frostnox.nightfall.registry.forge.ParticleTypesNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.animation.AnimationData;
import java.util.EnumMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;

public class EctoplasmEntity
extends MonsterEntity {
    protected static final EntityDataAccessor<Float> ESSENCE = SynchedEntityData.m_135353_(UndeadEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    public final Size size;
    protected final Goal attackGoal = new RushAttackGoal(this, 1.0);
    protected final Goal targetGoal = new HurtByTargetGoal((PathfinderMob)this, new Class[0]);

    protected EctoplasmEntity(EntityType<? extends MonsterEntity> type, Level worldIn, Size size) {
        super(type, worldIn);
        this.size = size;
        this.updateGoals();
    }

    public static EctoplasmEntity createLarge(EntityType<? extends MonsterEntity> type, Level worldIn) {
        return new EctoplasmEntity(type, worldIn, Size.LARGE);
    }

    public static EctoplasmEntity createMedium(EntityType<? extends MonsterEntity> type, Level worldIn) {
        return new EctoplasmEntity(type, worldIn, Size.MEDIUM);
    }

    public static EctoplasmEntity createSmall(EntityType<? extends MonsterEntity> type, Level worldIn) {
        return new EctoplasmEntity(type, worldIn, Size.SMALL);
    }

    private static AttributeSupplier.Builder getAttributeMap() {
        return EctoplasmEntity.createAttributes().m_22268_(Attributes.f_22276_, 40.0).m_22268_((Attribute)AttributesNF.WILLPOWER.get(), 200.0).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22277_, 10.0).m_22268_((Attribute)AttributesNF.HEARING_RANGE.get(), 0.0).m_22268_((Attribute)AttributesNF.STRIKING_DEFENSE.get(), 0.75).m_22268_((Attribute)AttributesNF.PIERCING_DEFENSE.get(), 0.75).m_22268_((Attribute)AttributesNF.FIRE_DEFENSE.get(), 0.25).m_22268_((Attribute)AttributesNF.FROST_DEFENSE.get(), 0.25).m_22268_((Attribute)AttributesNF.ELECTRIC_DEFENSE.get(), 0.25);
    }

    public static AttributeSupplier.Builder getLargeAttributeMap() {
        return EctoplasmEntity.getAttributeMap().m_22268_(Attributes.f_22276_, 40.0).m_22268_((Attribute)AttributesNF.WILLPOWER.get(), 200.0).m_22268_(Attributes.f_22279_, (double)0.06f).m_22268_((Attribute)AttributesNF.POISE.get(), (double)Poise.MEDIUM.ordinal()).m_22268_(Attributes.f_22278_, 0.5);
    }

    public static AttributeSupplier.Builder getMediumAttributeMap() {
        return EctoplasmEntity.getAttributeMap().m_22268_(Attributes.f_22276_, 20.0).m_22268_((Attribute)AttributesNF.WILLPOWER.get(), 100.0).m_22268_(Attributes.f_22279_, (double)0.065f).m_22268_((Attribute)AttributesNF.POISE.get(), (double)Poise.LOW.ordinal()).m_22268_(Attributes.f_22278_, 0.25);
    }

    public static AttributeSupplier.Builder getSmallAttributeMap() {
        return EctoplasmEntity.getAttributeMap().m_22268_(Attributes.f_22276_, 10.0).m_22268_((Attribute)AttributesNF.WILLPOWER.get(), 50.0).m_22268_(Attributes.f_22279_, (double)0.07f).m_22268_(Attributes.f_22278_, 0.0);
    }

    public static EnumMap<EntityPart, AnimationData> getClubAnimMap() {
        EnumMap<EntityPart, AnimationData> map = new EnumMap<EntityPart, AnimationData>(EntityPart.class);
        map.put(EntityPart.HAND_RIGHT, new AnimationData(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(0.0f, 0.0f, 0.0f)));
        return map;
    }

    public float getMaxEssence() {
        return (float)AttributesNF.getMaxEssence((LivingEntity)this);
    }

    public float getEssencePercentage() {
        return this.getEssence() / this.getMaxEssence();
    }

    public float getEssence() {
        return ((Float)this.m_20088_().m_135370_(ESSENCE)).floatValue();
    }

    public void setEssence(float essence) {
        this.m_20088_().m_135381_(ESSENCE, (Object)Float.valueOf(Mth.m_14036_((float)essence, (float)0.0f, (float)this.getMaxEssence())));
    }

    public void addEssence(float essence) {
        this.setEssence(this.getEssence() + essence);
    }

    public float getTransparency() {
        return Math.min(0.5f, this.getEssencePercentage());
    }

    public void updateGoals() {
        if (!this.f_19853_.f_46443_) {
            this.f_21345_.m_25363_(this.attackGoal);
            this.f_21346_.m_25363_(this.targetGoal);
            if (this.size != Size.SMALL) {
                this.f_21345_.m_25352_(2, this.attackGoal);
                this.f_21346_.m_25352_(1, this.targetGoal);
            }
        }
    }

    protected void split() {
        if (this.size != Size.SMALL) {
            float splitAngle = this.f_19796_.nextFloat((float)Math.PI * 2);
            float halfWidth = this.m_20205_() * 0.35f;
            for (int i = 0; i < 2; ++i) {
                EctoplasmEntity ectoplasm;
                EctoplasmEntity ectoplasmEntity = ectoplasm = this.size == Size.LARGE ? (EctoplasmEntity)((EntityType)EntitiesNF.ECTOPLASM_MEDIUM.get()).m_20615_(this.f_19853_) : (EctoplasmEntity)((EntityType)EntitiesNF.ECTOPLASM_SMALL.get()).m_20615_(this.f_19853_);
                if (this.m_21532_()) {
                    ectoplasm.m_21530_();
                }
                ectoplasm.m_21557_(this.m_21525_());
                ectoplasm.m_20331_(this.m_20147_());
                ectoplasm.setEssence(this.getEssence() / 2.0f);
                if (i == 0) {
                    ectoplasm.m_7678_(this.m_20185_() + (double)(halfWidth * Mth.m_14089_((float)splitAngle)), this.m_20186_(), this.m_20189_() + (double)(halfWidth * Mth.m_14031_((float)splitAngle)), this.f_19796_.nextFloat() * 360.0f, 0.0f);
                } else {
                    ectoplasm.m_7678_(this.m_20185_() + (double)(halfWidth * Mth.m_14031_((float)splitAngle)), this.m_20186_(), this.m_20189_() + (double)(halfWidth * Mth.m_14089_((float)splitAngle)), this.f_19796_.nextFloat() * 360.0f, 0.0f);
                }
                this.f_19853_.m_7967_((Entity)ectoplasm);
            }
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new WanderLandGoal(this, 0.5));
    }

    @Override
    public ResourceLocation pickActionEnemy(double distanceSqr, Entity target) {
        if (this.m_21223_() / this.m_21233_() <= 0.5f || this.f_19796_.nextInt(10) == 0) {
            return this.size == Size.LARGE ? ActionsNF.ECTOPLASM_EXPLODE_LARGE.getId() : ActionsNF.ECTOPLASM_EXPLODE_MEDIUM.getId();
        }
        return this.size == Size.LARGE ? ActionsNF.ECTOPLASM_CLUB_LARGE.getId() : ActionsNF.ECTOPLASM_CLUB_MEDIUM.getId();
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setEssence(this.getMaxEssence());
        this.updateGoals();
        return spawnDataIn;
    }

    @Override
    public void m_8107_() {
        super.m_8107_();
        if (!this.f_19853_.f_46443_ && this.getEssence() < this.getMaxEssence() && this.f_19796_.nextFloat() < 0.01f) {
            for (ItemEntity entity : this.f_19853_.m_45976_(ItemEntity.class, this.m_142469_())) {
                ItemStack item = entity.m_32055_();
                if (!item.m_204117_(TagsNF.CRUSHABLE_TO_BONE_SHARD)) continue;
                this.addEssence(40 * item.m_41613_());
                entity.m_146870_();
                if (!(this.getEssence() >= this.getMaxEssence())) continue;
                break;
            }
        }
    }

    @Override
    public float getAttackYRot(float partial) {
        return this.m_5675_(partial);
    }

    @Override
    public boolean dropLootFromSkinning() {
        return false;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ESSENCE, (Object)Float.valueOf(100.0f));
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("essence", this.getEssence());
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setEssence(tag.m_128457_("essence"));
        this.updateGoals();
    }

    @Override
    public float getPushResistance() {
        return switch (this.size) {
            default -> throw new IncompatibleClassChangeError();
            case Size.LARGE -> 3.0f;
            case Size.MEDIUM -> 2.0f;
            case Size.SMALL -> 1.0f;
        };
    }

    @Override
    public float getPushForce() {
        return this.getPushResistance();
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ / 2.0f;
    }

    @Override
    public float getVisionAngle() {
        return 180.0f;
    }

    @Override
    public boolean m_142582_(Entity target) {
        return true;
    }

    public boolean m_6779_(LivingEntity target) {
        return target.m_142066_() && !(target instanceof EctoplasmEntity);
    }

    public boolean m_7301_(MobEffectInstance pEffectInstance) {
        MobEffect effect = pEffectInstance.m_19544_();
        if (effect == EffectsNF.BLEEDING.get() || effect == EffectsNF.POISON.get()) {
            return false;
        }
        return super.m_7301_(pEffectInstance);
    }

    protected int m_5639_(float pFallDistance, float pDamageMultiplier) {
        return super.m_5639_(pFallDistance, pDamageMultiplier) - 40;
    }

    public void m_5997_(double pX, double pY, double pZ) {
        switch (this.size) {
            case LARGE: {
                super.m_5997_(pX * 0.5, pY * 0.75, pZ * 0.5);
                break;
            }
            case MEDIUM: {
                super.m_5997_(pX, pY, pZ);
                break;
            }
            case SMALL: {
                super.m_5997_(pX * 2.0, pY * 1.5, pZ * 2.0);
            }
        }
    }

    protected float m_6121_() {
        return switch (this.size) {
            default -> throw new IncompatibleClassChangeError();
            case Size.LARGE -> 1.0f;
            case Size.MEDIUM -> 0.75f;
            case Size.SMALL -> 0.5f;
        };
    }

    @Override
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return this.size == Size.SMALL ? (SoundEvent)SoundsNF.ECTOPLASM_HURT_SMALL.get() : (SoundEvent)SoundsNF.ECTOPLASM_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return this.size == Size.SMALL ? (SoundEvent)SoundsNF.ECTOPLASM_DEATH_SMALL.get() : (SoundEvent)SoundsNF.ECTOPLASM_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState pBlock) {
    }

    @Override
    public ParticleOptions getHurtParticle() {
        return (ParticleOptions)ParticleTypesNF.ECTOPLASM.get();
    }

    @Override
    public Impact modifyIncomingImpact(DamageTypeSource source, Impact impact) {
        return source.isType(DamageType.SLASHING) ? impact : impact.decrease();
    }

    @Override
    public void onKillRemoval() {
        this.split();
    }

    public void m_142036_() {
        if (this.f_20919_ > 15) {
            if (this.size == Size.SMALL) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundsNF.ENTITY_WARP.get(), this.m_5720_(), 1.0f, 1.0f, false);
            }
            int i = 0;
            while ((float)i < this.m_20205_() * 32.0f + (float)this.f_19853_.f_46441_.nextInt(8)) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypesNF.ESSENCE.get(), this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
                ++i;
            }
        }
    }

    @Override
    public EquipmentSlot getHitSlot(Vector3d hitPos, int boxIndex) {
        return EquipmentSlot.CHEST;
    }

    public static enum Size {
        SMALL,
        MEDIUM,
        LARGE;

    }
}

