/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.entity.monster;

import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.ai.goal.FleeDamageGoal;
import frostnox.nightfall.entity.ai.goal.MineToTargetGoal;
import frostnox.nightfall.entity.ai.goal.RushAttackGoal;
import frostnox.nightfall.entity.ai.goal.WanderLandGoal;
import frostnox.nightfall.entity.ai.goal.target.TrackNearestTargetGoal;
import frostnox.nightfall.entity.entity.monster.UndeadEntity;
import frostnox.nightfall.registry.ActionsNF;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.registry.forge.BlocksNF;
import frostnox.nightfall.registry.forge.ItemsNF;
import frostnox.nightfall.registry.forge.ParticleTypesNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.CombatUtil;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.world.MoonPhase;
import java.util.EnumMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelTimeAccess;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public class HuskEntity
extends UndeadEntity {
    public HuskEntity(EntityType<? extends HuskEntity> type, Level worldIn) {
        super((EntityType<? extends UndeadEntity>)type, worldIn);
    }

    public static AttributeSupplier.Builder getAttributeMap() {
        return HuskEntity.createAttributes().m_22268_(Attributes.f_22276_, 120.0).m_22268_(Attributes.f_22279_, (double)0.275f).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_((Attribute)AttributesNF.HEARING_RANGE.get(), 15.0).m_22268_((Attribute)AttributesNF.STRIKING_DEFENSE.get(), 0.1).m_22268_((Attribute)AttributesNF.SLASHING_DEFENSE.get(), 0.1).m_22268_((Attribute)AttributesNF.PIERCING_DEFENSE.get(), 0.1).m_22268_((Attribute)AttributesNF.ELECTRIC_DEFENSE.get(), 0.1);
    }

    public static EnumMap<EntityPart, AnimationData> getRightArmAnimMap() {
        EnumMap<EntityPart, AnimationData> map = new EnumMap<EntityPart, AnimationData>(EntityPart.class);
        map.put(EntityPart.BODY, new AnimationData(new Vector3f(0.375f, -0.125f, 0.0f), new Vector3f(12.5f, 0.0f, 0.0f)));
        map.put(EntityPart.ARM_RIGHT, new AnimationData(new Vector3f(0.0f, 0.5f, 0.0f)));
        map.put(EntityPart.HAND_RIGHT, new AnimationData(new Vector3f(0.0f, 0.5f, 0.0f), new Vector3f(-20.0f, -3.0f, -3.0f)));
        return map;
    }

    public static EnumMap<EntityPart, AnimationData> getLeftArmAnimMap() {
        EnumMap<EntityPart, AnimationData> map = new EnumMap<EntityPart, AnimationData>(EntityPart.class);
        map.put(EntityPart.BODY, new AnimationData(new Vector3f(-0.375f, -0.125f, 0.0f), new Vector3f(12.5f, 0.0f, 0.0f)));
        map.put(EntityPart.ARM_LEFT, new AnimationData(new Vector3f(0.0f, 0.5f, 0.0f)));
        map.put(EntityPart.HAND_LEFT, new AnimationData(new Vector3f(0.0f, 0.5f, 0.0f), new Vector3f(-20.0f, 3.0f, 3.0f)));
        return map;
    }

    @Override
    protected float getBaseReach() {
        return 3.5f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new RushAttackGoal(this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new MineToTargetGoal(this));
        this.f_21345_.m_25352_(5, (Goal)new FleeDamageGoal(this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new WanderLandGoal(this, 0.8));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new TrackNearestTargetGoal<Player>(this, Player.class, MoonPhase.get((LevelTimeAccess)this.f_19853_) != MoonPhase.FULL));
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (worldIn.m_5822_().nextFloat() < 0.9f) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ItemsNF.RUSTED_MAUL.get()));
        }
        this.equipHumanoid(worldIn.m_5822_(), 0.45f, 0.5f, 0.55f, 0.4f, MoonPhase.get((LevelTimeAccess)worldIn) == MoonPhase.FULL ? 0.25f : 0.0f);
        return spawnDataIn;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_6084_()) {
            return;
        }
        IActionTracker capA = this.getActionTracker();
        if (!capA.isInactive() && !capA.isStunned() && this.m_5448_() != null) {
            ResourceLocation id = capA.getActionID();
            if (id.equals((Object)ActionsNF.HUSK_OVERHEAD.getId())) {
                if (capA.getFrame() == 1 && capA.getState() == 1) {
                    CombatUtil.addFacingMovement(0.5, (LivingEntity)this);
                }
            } else if (id.equals((Object)ActionsNF.HUSK_RIGHT_SWIPE_2.getId()) || id.equals((Object)ActionsNF.HUSK_LEFT_SWIPE_2.getId())) {
                if (capA.getFrame() == 1 && capA.getState() == 1) {
                    CombatUtil.addFacingMovement(0.3, (LivingEntity)this);
                }
            } else if (id.equals((Object)ActionsNF.HUSK_RIGHT_SWIPE_1.getId()) || id.equals((Object)ActionsNF.HUSK_LEFT_SWIPE_1.getId())) {
                double reach = ((Action)((Object)ActionsNF.get(id).getChain((LivingEntity)this).get())).getMaxDistToStart((LivingEntity)this);
                double distSqr = CombatUtil.getShortestDistanceSqr((Entity)this, (Entity)this.m_5448_());
                if (distSqr <= reach * reach && capA.getState() == 2) {
                    this.queueAction();
                } else if (capA.getFrame() == 1 && capA.getState() == 1) {
                    CombatUtil.addFacingMovement(0.3, (LivingEntity)this);
                }
            }
        }
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        if (this.m_21224_()) {
            return super.m_6431_(poseIn, sizeIn);
        }
        return 1.7f;
    }

    @Override
    public boolean canMineAnything() {
        return !this.m_6844_(EquipmentSlot.MAINHAND).m_41619_() && this.getTargetPos() != null;
    }

    @Override
    public boolean canMineBlock(BlockPos pos) {
        double z;
        double y;
        BlockState state = this.f_19853_.m_8055_(pos);
        if (state.m_60713_((Block)BlocksNF.MOON_ESSENCE.get())) {
            return false;
        }
        boolean climbable = state.m_204336_(BlockTags.f_13082_);
        if (!climbable && state.m_60808_((BlockGetter)this.f_19853_, pos).m_83281_()) {
            return false;
        }
        double x = (double)pos.m_123341_() + 0.5 - this.m_20185_();
        if (x * x + (y = (double)pos.m_123342_() + 0.5 - this.m_20188_()) * y + (z = (double)pos.m_123343_() + 0.5 - this.m_20189_()) * z > (double)this.getReachSqr()) {
            return false;
        }
        return (climbable || state.m_60767_().m_76334_()) && state.m_60800_((BlockGetter)this.f_19853_, pos) >= 0.0f;
    }

    @Override
    public ResourceLocation pickActionEnemy(double distanceSqr, Entity target) {
        boolean offItem;
        if (this.f_19796_.nextDouble() < Math.min(0.85, 0.15 + distanceSqr / 6.25)) {
            return ActionsNF.HUSK_OVERHEAD.getId();
        }
        boolean mainItem = !this.m_21205_().m_41619_();
        boolean bl = offItem = !this.m_21206_().m_41619_();
        float mainWeight = mainItem == offItem ? 0.6f : (mainItem ? 0.9f : 0.15f);
        if (this.f_19796_.nextDouble() < (double)mainWeight) {
            return ActionsNF.HUSK_RIGHT_SWIPE_1.getId();
        }
        return ActionsNF.HUSK_LEFT_SWIPE_1.getId();
    }

    @Override
    public EquipmentSlot getHitSlot(Vector3d hitPos, int boxIndex) {
        double y = hitPos.f_86215_;
        if (y > 0.3125 && y <= 0.75) {
            return EquipmentSlot.LEGS;
        }
        if (y > 0.75 && y <= 1.4375) {
            return EquipmentSlot.CHEST;
        }
        if (y > 1.4375) {
            return EquipmentSlot.HEAD;
        }
        return EquipmentSlot.FEET;
    }

    @Override
    public ParticleOptions getHurtParticle() {
        return (ParticleOptions)ParticleTypesNF.BLOOD_DARK_RED.get();
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundsNF.HUSK_AMBIENT.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)SoundsNF.HUSK_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundsNF.HUSK_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState pBlock) {
        this.m_5496_((SoundEvent)SoundsNF.HUSK_STEP.get(), 0.15f, 1.0f);
    }

    public float m_6100_() {
        return 1.0f + (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.1f;
    }
}

