/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.entity.monster;

import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import frostnox.nightfall.action.DamageTypeSource;
import frostnox.nightfall.action.Impact;
import frostnox.nightfall.action.Poise;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.IOrientedHitBoxes;
import frostnox.nightfall.entity.ai.goal.EatBlockGoal;
import frostnox.nightfall.entity.ai.goal.EatEntityGoal;
import frostnox.nightfall.entity.ai.goal.FleeDamageGoal;
import frostnox.nightfall.entity.ai.goal.LandFleeEntityGoal;
import frostnox.nightfall.entity.ai.goal.LandFleeTargetGoal;
import frostnox.nightfall.entity.ai.goal.RandomLookGoal;
import frostnox.nightfall.entity.ai.goal.RushAttackGoal;
import frostnox.nightfall.entity.ai.goal.WanderLandGoal;
import frostnox.nightfall.entity.ai.goal.target.TrackNearestTargetGoal;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.entity.entity.Diet;
import frostnox.nightfall.entity.entity.monster.CockatriceEntity;
import frostnox.nightfall.entity.entity.monster.HungryMonsterEntity;
import frostnox.nightfall.registry.ActionsNF;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.OBB;
import java.util.EnumMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class PitDevilEntity
extends HungryMonsterEntity
implements IOrientedHitBoxes {
    public static final int GROWL_DURATION = 240;
    private static final EntityPart[] OBB_PARTS = new EntityPart[]{EntityPart.BODY, EntityPart.NECK, EntityPart.HEAD};
    protected static final EntityDataAccessor<Boolean> SPECIAL = SynchedEntityData.m_135353_(CockatriceEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int growlTicks;

    public PitDevilEntity(EntityType<? extends HungryMonsterEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder getAttributeMap() {
        return PitDevilEntity.createAttributes().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22279_, (double)0.275f).m_22268_(Attributes.f_22278_, 0.25).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22277_, 15.0).m_22268_((Attribute)AttributesNF.HEARING_RANGE.get(), 15.0).m_22268_((Attribute)AttributesNF.STRIKING_DEFENSE.get(), 0.25).m_22268_((Attribute)AttributesNF.SLASHING_DEFENSE.get(), 0.5).m_22268_((Attribute)AttributesNF.PIERCING_DEFENSE.get(), 0.5).m_22268_((Attribute)AttributesNF.FIRE_DEFENSE.get(), 0.25).m_22268_((Attribute)AttributesNF.FROST_DEFENSE.get(), 0.25).m_22268_((Attribute)AttributesNF.ELECTRIC_DEFENSE.get(), 0.25).m_22268_((Attribute)AttributesNF.POISE.get(), (double)Poise.MEDIUM.ordinal());
    }

    public static EnumMap<EntityPart, AnimationData> getHeadAnimMap() {
        EnumMap<EntityPart, AnimationData> map = new EnumMap<EntityPart, AnimationData>(EntityPart.class);
        map.put(EntityPart.BODY, new AnimationData(new Vector3f(0.0f, -0.125f, -0.34375f)));
        map.put(EntityPart.NECK, new AnimationData(new Vector3f(0.0f, 0.0f, 0.0f)));
        map.put(EntityPart.HEAD, new AnimationData(new Vector3f(0.0f, 0.0f, 0.0f)));
        return map;
    }

    public boolean isSpecial() {
        return (Boolean)this.m_20088_().m_135370_(SPECIAL);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, new LandFleeEntityGoal<LivingEntity>(this, LivingEntity.class, 1.35, 1.45, entity -> {
            if (entity.m_21224_()) {
                return false;
            }
            return entity.m_6095_().m_204039_(TagsNF.PIT_DEVIL_PREDATOR);
        }));
        this.f_21345_.m_25352_(3, (Goal)new LandFleeTargetGoal(this, 1.35, 1.45));
        this.f_21345_.m_25352_(4, (Goal)new RushAttackGoal(this, 1.35){

            @Override
            protected boolean canPursue() {
                return ActionTracker.isPresent((Entity)this.mob) && (PitDevilEntity.this.getActionTracker().getState() == 2 || !PitDevilEntity.this.getActionTracker().getActionID().equals((Object)ActionsNF.PIT_DEVIL_GROWL.getId()));
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                if (this.mob.m_6084_()) {
                    this.mob.getActionTracker().releaseCharge();
                }
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new FleeDamageGoal(this, 1.35));
        this.f_21345_.m_25352_(6, (Goal)new EatEntityGoal(this, 1.0, 15, 2));
        this.f_21345_.m_25352_(7, (Goal)new EatBlockGoal(this, 1.0, 15, 2));
        this.f_21345_.m_25352_(8, (Goal)new WanderLandGoal(this, 0.8));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookGoal((Mob)this, 0.01f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new TrackNearestTargetGoal<LivingEntity>((ActionableEntity)this, LivingEntity.class, true, entity -> {
            if (entity.m_21224_()) {
                return false;
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                return !player.m_7500_() && !player.m_5833_();
            }
            return entity.m_6095_().m_204039_(TagsNF.PIT_DEVIL_PREY);
        }));
    }

    @Override
    public boolean shouldFleeFrom(LivingEntity target) {
        return super.shouldFleeFrom(target) && !target.m_6095_().m_204039_(TagsNF.PIT_DEVIL_PREY);
    }

    @Override
    protected void simulateTime(int timePassed) {
        this.growlTicks = Math.max(0, this.growlTicks - timePassed);
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_146910_() && this.getActionTracker().isInactive() && this.m_5448_() == null && this.growlTicks > 0) {
            --this.growlTicks;
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(SPECIAL, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128379_("special", this.isSpecial());
        tag.m_128405_("growlTicks", this.growlTicks);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.m_20088_().m_135381_(SPECIAL, (Object)tag.m_128471_("special"));
        this.growlTicks = tag.m_128451_("growlTicks");
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (this.f_19796_.nextInt() % 4096 == 0) {
            this.m_20088_().m_135381_(SPECIAL, (Object)true);
        }
        return spawnDataIn;
    }

    @Override
    public EntityDimensions m_6972_(Pose pPose) {
        if (this.m_21224_()) {
            return new EntityDimensions(0.75f, 0.4375f, false).m_20388_(this.m_6134_());
        }
        return this.m_6095_().m_20680_().m_20388_(this.m_6134_());
    }

    @Override
    public ResourceLocation pickActionEnemy(double distanceSqr, Entity target) {
        if (distanceSqr < 4.0) {
            return ActionsNF.PIT_DEVIL_BITE.getId();
        }
        return this.growlTicks <= 0 ? ActionsNF.PIT_DEVIL_GROWL.getId() : ActionsNF.PIT_DEVIL_BITE.getId();
    }

    public boolean m_6779_(LivingEntity target) {
        return target.m_142066_() && !(target instanceof PitDevilEntity);
    }

    @Override
    public boolean canTargetFromSound(LivingEntity target) {
        return target.m_6095_().m_204039_(TagsNF.PIT_DEVIL_PREY) || target instanceof Player;
    }

    @Override
    public int m_8100_() {
        return 1800;
    }

    protected SoundEvent m_7515_() {
        if (this.m_5448_() == null && this.f_19797_ > 100) {
            return (SoundEvent)SoundsNF.PIT_DEVIL_HOWL.get();
        }
        return null;
    }

    public void m_8032_() {
        SoundEvent sound = this.m_7515_();
        if (sound != null) {
            this.f_19853_.m_6269_(null, (Entity)this, sound, SoundSource.HOSTILE, 2.0f, 1.0f);
        }
    }

    @Override
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)SoundsNF.PIT_DEVIL_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundsNF.PIT_DEVIL_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState pBlock) {
        this.m_5496_((SoundEvent)SoundsNF.PIT_DEVIL_STEP.get(), 0.2f, 0.75f);
    }

    @Override
    public EquipmentSlot getHitSlot(Vector3d hitPos, int boxIndex) {
        if (boxIndex == 0) {
            return hitPos.f_86215_ > 0.8125 ? EquipmentSlot.LEGS : EquipmentSlot.HEAD;
        }
        return hitPos.f_86215_ > 0.5 ? EquipmentSlot.CHEST : EquipmentSlot.LEGS;
    }

    @Override
    protected float modifyIncomingDamageBySlot(EquipmentSlot slot, float damage) {
        if (slot == EquipmentSlot.HEAD) {
            return damage * 1.5f;
        }
        if (slot == EquipmentSlot.LEGS) {
            return damage * 1.25f;
        }
        return damage;
    }

    @Override
    public Impact modifyIncomingImpact(DamageTypeSource source, Impact impact) {
        EquipmentSlot slot = this.getHitSlot(source.getHitCoords(), source.getHitBoxIndex());
        return slot == EquipmentSlot.LEGS || slot == EquipmentSlot.HEAD ? impact.increase() : impact;
    }

    @Override
    public boolean includeAABB() {
        return true;
    }

    @Override
    public Vector3f getOBBTranslation() {
        return new Vector3f(0.0f, 0.5625f, 0.0f);
    }

    @Override
    public EnumMap<EntityPart, AnimationData> getDefaultAnimMap() {
        EnumMap<EntityPart, AnimationData> map = PitDevilEntity.getGenericAnimMap();
        map.put(EntityPart.BODY, new AnimationData(new Vector3f(0.0f, -0.125f, -0.34375f)));
        map.put(EntityPart.NECK, new AnimationData(new Vector3f(0.0f, 0.0f, 0.0f)));
        map.put(EntityPart.HEAD, new AnimationData(new Vector3f(0.0f, 0.0f, 0.0f)));
        return map;
    }

    @Override
    public EntityPart[] getOrderedOBBParts() {
        return OBB_PARTS;
    }

    @Override
    public OBB[] getDefaultOBBs() {
        return new OBB[]{new OBB(0.40625, 0.34375, 0.40625, 0.0, 0.03125, 0.1875)};
    }

    @Override
    public AABB getEnclosingAABB() {
        AABB bb = this.m_142469_();
        return new AABB(bb.f_82288_ - 0.75, bb.f_82289_, bb.f_82290_ - 0.75, bb.f_82291_ + 0.75, bb.f_82292_ + 0.5, bb.f_82293_ + 0.75);
    }

    @Override
    protected int getMaxSatiety() {
        return 24000;
    }

    @Override
    public Diet getDiet() {
        return Diet.CARNIVORE;
    }

    @Override
    public boolean canEat(Entity entity) {
        if (super.canEat(entity)) {
            return true;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity.f_20919_ > 20 && entity.m_6095_().m_204039_(TagsNF.EDIBLE_CORPSE);
        }
        return false;
    }

    @Override
    public SoundEvent getEatSound() {
        return (SoundEvent)SoundsNF.PIT_DEVIL_EAT.get();
    }
}

