/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.entity.monster;

import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import frostnox.nightfall.action.DamageTypeSource;
import frostnox.nightfall.action.Impact;
import frostnox.nightfall.action.Poise;
import frostnox.nightfall.block.block.nest.GuardedNestBlockEntity;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.IOrientedHitBoxes;
import frostnox.nightfall.entity.ai.sensing.AudioSensing;
import frostnox.nightfall.entity.entity.monster.MonsterEntity;
import frostnox.nightfall.registry.ActionsNF;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.registry.forge.BlocksNF;
import frostnox.nightfall.registry.forge.ParticleTypesNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.util.math.OBB;
import java.util.EnumMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RockwormEntity
extends MonsterEntity
implements IOrientedHitBoxes {
    private static final EntityPart[] OBB_PARTS = new EntityPart[]{EntityPart.BODY, EntityPart.BODY_2, EntityPart.HEAD};
    public int retreatCooldown;

    public RockwormEntity(EntityType<? extends MonsterEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder getAttributeMap() {
        return RockwormEntity.createAttributes().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22279_, 0.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22277_, 30.0).m_22268_((Attribute)AttributesNF.HEARING_RANGE.get(), 15.0).m_22268_((Attribute)AttributesNF.STRIKING_DEFENSE.get(), 0.25).m_22268_((Attribute)AttributesNF.SLASHING_DEFENSE.get(), 0.5).m_22268_((Attribute)AttributesNF.PIERCING_DEFENSE.get(), 0.5).m_22268_((Attribute)AttributesNF.FIRE_DEFENSE.get(), 0.25).m_22268_((Attribute)AttributesNF.FROST_DEFENSE.get(), 0.25).m_22268_((Attribute)AttributesNF.ELECTRIC_DEFENSE.get(), 0.25).m_22268_((Attribute)AttributesNF.POISE.get(), (double)Poise.MEDIUM.ordinal());
    }

    public static EnumMap<EntityPart, AnimationData> getHeadAnimMap() {
        EnumMap<EntityPart, AnimationData> map = new EnumMap<EntityPart, AnimationData>(EntityPart.class);
        map.put(EntityPart.BODY, new AnimationData(new Vector3f(0.0f, -1.625f, 0.0f), new Vector3f(10.0f, 0.0f, 0.0f)));
        map.put(EntityPart.BODY_2, new AnimationData(new Vector3f(0.0f, -0.8125f, 0.0f), new Vector3f(10.0f, 0.0f, 0.0f)));
        map.put(EntityPart.HEAD, new AnimationData(new Vector3f(0.0f, 0.0f, 0.0f), new Vector3f(75.0f, 0.0f, 0.0f)));
        return map;
    }

    public boolean enterNest(boolean simulate) {
        BlockPos.MutableBlockPos pos = this.m_142538_().m_122032_();
        LevelChunk chunk = this.f_19853_.m_46745_((BlockPos)pos);
        for (int i = 0; i < 16; ++i) {
            BlockState belowState = chunk.m_8055_((BlockPos)pos.m_142448_(pos.m_123342_() - 1));
            if (belowState.m_60713_((Block)BlocksNF.ANCHORING_RESIN.get())) {
                BlockEntity blockEntity = chunk.m_7702_((BlockPos)pos);
                if (!(blockEntity instanceof GuardedNestBlockEntity)) continue;
                GuardedNestBlockEntity nest = (GuardedNestBlockEntity)blockEntity;
                if (!nest.isFull()) {
                    if (!simulate) {
                        this.getActionTracker().startAction(ActionsNF.EMPTY.getId());
                        nest.addEntity((Entity)this);
                    }
                    return true;
                }
                return false;
            }
            if (belowState.m_204336_(TagsNF.STONE_TUNNELS)) continue;
            return false;
        }
        return false;
    }

    public boolean isInsideBlock(BlockPos pos, BlockState block) {
        if (!block.m_60795_() && block.m_60828_((BlockGetter)this.f_19853_, pos)) {
            return Shapes.m_83157_((VoxelShape)block.m_60812_((BlockGetter)this.f_19853_, pos).m_83216_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), (VoxelShape)Shapes.m_83064_((AABB)this.m_142469_()), (BooleanOp)BooleanOp.f_82689_);
        }
        return false;
    }

    @Override
    public boolean canMineAnything() {
        return true;
    }

    @Override
    public float getMineSpeed(BlockState block) {
        return 20.0f;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.m_5618_(this.m_6080_());
        if (!this.f_19853_.f_46443_ && this.m_6084_()) {
            if (this.f_19797_ > 1 && !this.f_201939_) {
                this.m_6469_(DamageTypeSource.UPROOTED, Float.MAX_VALUE);
            } else {
                IActionTracker capA = this.getActionTracker();
                BlockPos.MutableBlockPos pos = this.m_142538_().m_122032_();
                if (capA.isInactive() && (this.isInsideBlock((BlockPos)pos, this.f_19853_.m_8055_((BlockPos)pos)) || this.isInsideBlock((BlockPos)pos.m_142448_(pos.m_123342_() + 1), this.f_19853_.m_8055_((BlockPos)pos)))) {
                    if (this.retreatCooldown > 10) {
                        this.retreatCooldown = 10;
                    } else if (this.retreatCooldown > 0) {
                        --this.retreatCooldown;
                    }
                    if (this.retreatCooldown == 0 && this.enterNest(true)) {
                        this.startAction(ActionsNF.ROCKWORM_RETREAT.getId());
                        this.retreatCooldown = 10;
                    }
                } else {
                    Entity target = null;
                    double bestDistSqr = Double.MAX_VALUE;
                    Vec3 eyePos = this.m_146892_();
                    for (Entity entity : this.audioSensing.getHeardEntities()) {
                        double dist = MathUtil.getShortestDistanceSqrPointToBox(eyePos.f_82479_, eyePos.f_82480_, eyePos.f_82481_, entity.m_142469_());
                        if (!(dist < bestDistSqr) || !(dist < 4.41)) continue;
                        target = entity;
                    }
                    if (target != null) {
                        this.m_21563_().m_148051_(target);
                        if (capA.isInactive()) {
                            this.startAction(ActionsNF.ROCKWORM_BITE.getId());
                        }
                    } else if (capA.isInactive()) {
                        if (this.retreatCooldown > 0) {
                            --this.retreatCooldown;
                        }
                        if (this.retreatCooldown == 0 && this.f_19797_ > 20 && this.enterNest(true)) {
                            this.startAction(ActionsNF.ROCKWORM_RETREAT.getId());
                            this.retreatCooldown = 400 + this.f_19796_.nextInt(200);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        this.retreatCooldown = tag.m_128451_("retreatCooldown");
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        tag.m_128405_("retreatCooldown", this.retreatCooldown);
    }

    public int m_21529_() {
        return 20;
    }

    @Override
    protected AudioSensing createAudioSensing() {
        return new AudioSensing(this, 30);
    }

    @Override
    public EntityDimensions m_6972_(Pose pPose) {
        if (this.m_21224_()) {
            return new EntityDimensions(0.875f, 0.25f, false).m_20388_(this.m_6134_());
        }
        return this.m_6095_().m_20680_().m_20388_(this.m_6134_());
    }

    public boolean m_6063_() {
        return false;
    }

    @Override
    public boolean m_5830_() {
        return false;
    }

    public void m_20256_(Vec3 pMotion) {
        super.m_20256_(new Vec3(0.0, pMotion.f_82480_, 0.0));
    }

    @Override
    public boolean canTargetFromSound(LivingEntity target) {
        return !(target instanceof RockwormEntity);
    }

    public boolean m_6779_(LivingEntity target) {
        return target.m_142066_() && !(target instanceof RockwormEntity);
    }

    @Override
    public ParticleOptions getHurtParticle() {
        return (ParticleOptions)ParticleTypesNF.BLOOD_GREEN.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)SoundsNF.ROCKWORM_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundsNF.ROCKWORM_DEATH.get();
    }

    @Override
    public EquipmentSlot getHitSlot(Vector3d hitPos, int boxIndex) {
        if (boxIndex == 2) {
            return EquipmentSlot.HEAD;
        }
        MathUtil.rotateVector3dByYaw(hitPos, -this.f_20883_);
        if (Math.abs(MathUtil.toDegrees(Math.atan2(hitPos.f_86214_, hitPos.f_86216_))) < 35.0) {
            return EquipmentSlot.HEAD;
        }
        return EquipmentSlot.CHEST;
    }

    @Override
    protected float modifyIncomingDamageBySlot(EquipmentSlot slot, float damage) {
        if (slot == EquipmentSlot.HEAD) {
            return damage * 1.5f;
        }
        return damage;
    }

    @Override
    public Impact modifyIncomingImpact(DamageTypeSource source, Impact impact) {
        return this.getHitSlot(source.getHitCoords(), source.getHitBoxIndex()) == EquipmentSlot.HEAD ? impact.increase() : impact;
    }

    @Override
    public boolean includeAABB() {
        return !this.m_6084_();
    }

    @Override
    public Vector3f getOBBTranslation() {
        return Vector3f.f_176763_;
    }

    @Override
    public EnumMap<EntityPart, AnimationData> getDefaultAnimMap() {
        return RockwormEntity.getHeadAnimMap();
    }

    @Override
    public EntityPart[] getOrderedOBBParts() {
        return OBB_PARTS;
    }

    @Override
    public OBB[] getDefaultOBBs() {
        return new OBB[]{new OBB(0.40625, 0.84375, 0.40625, 0.0, 0.40625, 0.0), new OBB(0.403125f, 0.778124988079071, 0.403125f, 0.0, 0.34375, 0.0), new OBB(0.4f, 0.5875f, 0.4f, 0.0, 0.09375, 0.0)};
    }

    @Override
    public AABB getEnclosingAABB() {
        AABB bb = this.m_142469_();
        return new AABB(bb.f_82288_ - 1.0, bb.f_82289_, bb.f_82290_ - 1.0, bb.f_82291_ + 1.0, bb.f_82292_ + 0.3, bb.f_82293_ + 1.0);
    }
}

