/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.entity.monster;

import com.mojang.math.Vector3d;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.DamageTypeSource;
import frostnox.nightfall.action.Poise;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.entity.IHomeEntity;
import frostnox.nightfall.entity.ai.goal.EatEntityGoal;
import frostnox.nightfall.entity.ai.goal.FleeDamageGoal;
import frostnox.nightfall.entity.ai.goal.FleeEntityGoal;
import frostnox.nightfall.entity.ai.goal.MoveToNestGoal;
import frostnox.nightfall.entity.ai.goal.PursueTargetGoal;
import frostnox.nightfall.entity.ai.goal.WanderLandGoal;
import frostnox.nightfall.entity.ai.goal.target.TrackNearestTargetGoal;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.entity.entity.Diet;
import frostnox.nightfall.entity.entity.monster.HungryMonsterEntity;
import frostnox.nightfall.entity.entity.monster.UndeadEntity;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.registry.forge.EffectsNF;
import frostnox.nightfall.registry.forge.ParticleTypesNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.util.data.Wrapper;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class SkaraSwarmEntity
extends HungryMonsterEntity
implements IHomeEntity {
    protected BlockPos homePos = null;

    public SkaraSwarmEntity(EntityType<? extends HungryMonsterEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder getAttributeMap() {
        return SkaraSwarmEntity.createAttributes().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, (double)0.285f).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22277_, 15.0).m_22268_((Attribute)AttributesNF.HEARING_RANGE.get(), 10.0).m_22268_((Attribute)AttributesNF.POISE.get(), (double)Poise.MAXIMUM.ordinal()).m_22268_((Attribute)AttributesNF.SLASHING_DEFENSE.get(), 0.25).m_22268_((Attribute)AttributesNF.PIERCING_DEFENSE.get(), 0.25);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new PursueTargetGoal(this, 1.0){

            @Override
            public void m_8037_() {
                super.m_8037_();
                LivingEntity target = this.mob.m_5448_();
                if (target != null && ActionTracker.isPresent((Entity)this.mob) && this.mob.m_142469_().m_82381_(target.m_142469_()) && !target.m_21023_((MobEffect)EffectsNF.INFESTED.get())) {
                    target.m_6469_((DamageSource)DamageTypeSource.createEntitySource((LivingEntity)this.mob, DamageType.ABSOLUTE), 0.0f);
                    MobEffectInstance effect = new MobEffectInstance((MobEffect)EffectsNF.INFESTED.get(), 300);
                    target.m_147207_(effect, (Entity)this.mob);
                    ((ServerLevel)target.f_19853_).m_7726_().m_8445_((Entity)target, (Packet)new ClientboundUpdateMobEffectPacket(target.m_142049_(), effect));
                    this.mob.m_6710_(null);
                    this.mob.lastTargetPos = null;
                    this.mob.m_21561_(false);
                }
            }

            @Override
            public boolean m_8045_() {
                if (super.m_8045_()) {
                    return this.mob.m_5448_() != null && !this.mob.m_5448_().m_21023_((MobEffect)EffectsNF.INFESTED.get());
                }
                return false;
            }

            @Override
            protected int getAccuracy() {
                return 0;
            }
        });
        this.f_21345_.m_25352_(3, (Goal)new MoveToNestGoal(this, 1.0, 1.0));
        this.f_21345_.m_25352_(4, new FleeEntityGoal<LivingEntity>(this, LivingEntity.class, 0.8, 1.0, entity -> {
            if (entity.m_21224_()) {
                return false;
            }
            return entity.m_21023_((MobEffect)EffectsNF.INFESTED.get()) || !entity.m_6095_().m_204039_(TagsNF.SKARA_SWARM_PREY);
        }));
        this.f_21345_.m_25352_(5, (Goal)new FleeDamageGoal(this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new EatEntityGoal(this, 1.0, 10, 2));
        this.f_21345_.m_25352_(7, (Goal)new WanderLandGoal(this, 0.8));
        this.f_21346_.m_25352_(1, new TrackNearestTargetGoal<LivingEntity>((ActionableEntity)this, LivingEntity.class, true, entity -> {
            if (entity.m_21224_() || entity.m_21023_((MobEffect)EffectsNF.INFESTED.get())) {
                return false;
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                return !player.m_7500_() && !player.m_5833_();
            }
            return entity.m_6095_().m_204039_(TagsNF.SKARA_SWARM_PREY);
        }));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_ && this.m_6084_()) {
            float chance = Math.max(0.35f, this.m_21223_() / this.m_21233_());
            if (chance == 1.0f || this.f_19796_.nextFloat() < chance) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypesNF.SKARA.get(), this.m_20185_() + (double)(this.f_19796_.nextFloat() - 0.5f), this.m_20186_(), this.m_20189_() + (double)(this.f_19796_.nextFloat() - 0.5f), (double)MathUtil.toRadians(this.m_146908_()), this.f_19854_ != this.m_20185_() || this.f_19856_ != this.m_20189_() ? 1.0 : 0.0, (double)this.m_142049_());
            }
            if (this.randTickCount % 37 == 0) {
                ClientEngine.get().playEntitySound((Entity)this, (SoundEvent)SoundsNF.SKARA_SWARM_AMBIENT.get(), SoundSource.HOSTILE, 0.35f, 0.95f + this.f_19796_.nextFloat() * 0.1f);
            }
        }
    }

    @Override
    protected int getMaxSatiety() {
        return 60;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.homePos != null) {
            tag.m_128365_("homePos", (Tag)NbtUtils.m_129224_((BlockPos)this.homePos));
        }
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("homePos")) {
            this.homePos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("homePos"));
        }
    }

    @Override
    public float getPushResistance() {
        return 0.0f;
    }

    @Override
    public float getPushForce() {
        return 0.0f;
    }

    @Override
    public float getNavigatorWaypointDist() {
        return 0.25f;
    }

    @Override
    protected void m_6138_() {
    }

    protected void m_7324_(Entity pEntity) {
    }

    protected int m_5639_(float pFallDistance, float pDamageMultiplier) {
        return super.m_5639_(pFallDistance, pDamageMultiplier) - 80;
    }

    @Override
    public void m_7334_(Entity pusher) {
        if (!this.m_20365_(pusher) && !pusher.f_19794_ && !this.f_19794_ && this.f_20916_ <= 0 && pusher.f_19789_ > 0.0f && pusher instanceof LivingEntity) {
            LivingEntity entity = (LivingEntity)pusher;
            this.m_6469_(DamageTypeSource.createEntitySource(entity, "stomp", DamageType.ABSOLUTE), pusher.f_19789_ * 2.0f);
        }
    }

    @Override
    public boolean dropLootFromSkinning() {
        return false;
    }

    @Override
    public float getVisionAngle() {
        return 180.0f;
    }

    public boolean m_6779_(LivingEntity target) {
        return target.m_142066_() && !(target instanceof SkaraSwarmEntity);
    }

    @Override
    public boolean canTargetFromSound(LivingEntity target) {
        return !target.m_21023_((MobEffect)EffectsNF.INFESTED.get()) && (target.m_6095_().m_204039_(TagsNF.SKARA_SWARM_PREY) || target instanceof Player);
    }

    public boolean m_7301_(MobEffectInstance pEffectInstance) {
        MobEffect effect = pEffectInstance.m_19544_();
        if (effect == EffectsNF.BLEEDING.get() || effect == EffectsNF.POISON.get()) {
            return false;
        }
        return super.m_7301_(pEffectInstance);
    }

    protected void m_7355_(BlockPos pos, BlockState pBlock) {
    }

    @Override
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)SoundsNF.SKARA_SWARM_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundsNF.SKARA_SWARM_DEATH.get();
    }

    @Override
    public ParticleOptions getHurtParticle() {
        return null;
    }

    @Override
    public void onKillRemoval() {
    }

    @Override
    public boolean isImmuneTo(DamageTypeSource source, float damage) {
        if (source.m_19372_() || source.isFromBlock()) {
            return false;
        }
        if (source.m_7639_() instanceof Player || source.m_7639_() instanceof UndeadEntity) {
            return source.isType(DamageType.STRIKING) || source.isType(DamageType.PIERCING) || source.isType(DamageType.SLASHING);
        }
        return false;
    }

    @Override
    public float modifyIncomingDamage(DamageTypeSource source, float damage, Wrapper<Poise> poise) {
        if (source.isType(DamageType.STRIKING) || source.isType(DamageType.SLASHING) || source.isType(DamageType.PIERCING)) {
            return damage / 4.0f;
        }
        return damage;
    }

    @Override
    @Nullable
    public BlockPos getHomePos() {
        return this.homePos;
    }

    @Override
    public void setHomePos(@Nullable BlockPos pos) {
        this.homePos = pos;
    }

    @Override
    public EquipmentSlot getHitSlot(Vector3d hitPos, int boxIndex) {
        return EquipmentSlot.CHEST;
    }

    @Override
    public Diet getDiet() {
        return Diet.CARNIVORE;
    }

    @Override
    public boolean canEat(BlockState state) {
        return false;
    }

    @Override
    public boolean canEat(Entity entity) {
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity.f_20919_ > 20 && entity.m_6095_().m_204039_(TagsNF.EDIBLE_CORPSE);
        }
        return false;
    }

    @Override
    public SoundEvent getEatSound() {
        return null;
    }
}

