/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.entity.monster;

import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.DamageTypeSource;
import frostnox.nightfall.action.Impact;
import frostnox.nightfall.action.Poise;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.ai.goal.FleeDamageGoal;
import frostnox.nightfall.entity.ai.goal.RangedAttackGoal;
import frostnox.nightfall.entity.ai.goal.RushAttackGoal;
import frostnox.nightfall.entity.ai.goal.WanderLandGoal;
import frostnox.nightfall.entity.ai.goal.target.TrackNearestTargetGoal;
import frostnox.nightfall.entity.ai.pathfinding.FlankingLandEntityNavigator;
import frostnox.nightfall.entity.entity.monster.UndeadEntity;
import frostnox.nightfall.item.IProjectileItem;
import frostnox.nightfall.registry.ActionsNF;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.registry.forge.ItemsNF;
import frostnox.nightfall.registry.forge.ParticleTypesNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.animation.AnimationData;
import frostnox.nightfall.world.MoonPhase;
import java.util.EnumMap;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelTimeAccess;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class SkeletonEntity
extends UndeadEntity {
    public final float headRotation;
    private final Goal meleeGoal = new RushAttackGoal(this, 1.0);
    private final Goal rangedGoal = new RangedAttackGoal(this, 1.0, 16.0f);
    public IProjectileItem arrowItem = (IProjectileItem)ItemsNF.RUSTED_ARROW.get();

    public SkeletonEntity(EntityType<? extends SkeletonEntity> type, Level worldIn) {
        super((EntityType<? extends UndeadEntity>)type, worldIn);
        Random rand = new Random();
        this.headRotation = (float)Math.toRadians(15.0f * rand.nextFloat() * (float)(rand.nextBoolean() ? 1 : -1));
        this.updateGoals();
    }

    public static AttributeSupplier.Builder getAttributeMap() {
        return SkeletonEntity.createAttributes().m_22268_(Attributes.f_22276_, 80.0).m_22268_(Attributes.f_22279_, 0.27).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 1.0).m_22268_(Attributes.f_22283_, 1.0).m_22268_(Attributes.f_22277_, 30.0).m_22268_((Attribute)AttributesNF.HEARING_RANGE.get(), 15.0).m_22268_((Attribute)AttributesNF.PIERCING_DEFENSE.get(), 0.7).m_22268_((Attribute)AttributesNF.SLASHING_DEFENSE.get(), 0.7).m_22268_((Attribute)AttributesNF.STRIKING_DEFENSE.get(), -0.25).m_22268_((Attribute)AttributesNF.POISE.get(), (double)Poise.MEDIUM.ordinal());
    }

    public static EnumMap<EntityPart, AnimationData> getRightArmAnimMap() {
        EnumMap<EntityPart, AnimationData> map = new EnumMap<EntityPart, AnimationData>(EntityPart.class);
        map.put(EntityPart.BODY, new AnimationData(new Vector3f(0.375f, -0.125f, 0.0f), new Vector3f(5.0f, 0.0f, 0.0f)));
        map.put(EntityPart.ARM_RIGHT, new AnimationData(new Vector3f(0.0f, 0.5625f, 0.0f), new Vector3f(-5.0f, 0.0f, 0.0f)));
        map.put(EntityPart.HAND_RIGHT, new AnimationData(new Vector3f(0.0f, 0.5625f, 0.0f)));
        return map;
    }

    public void updateGoals() {
        if (!this.f_19853_.f_46443_) {
            this.f_21345_.m_25363_(this.meleeGoal);
            this.f_21345_.m_25363_(this.rangedGoal);
            if (this.m_21205_().m_204117_(TagsNF.BOW)) {
                this.f_21345_.m_25352_(2, this.rangedGoal);
            } else {
                this.f_21345_.m_25352_(2, this.meleeGoal);
            }
        }
    }

    @Override
    protected float getBaseReach() {
        return 3.5f;
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new WanderLandGoal(this, 0.8));
        this.f_21345_.m_25352_(5, (Goal)new FleeDamageGoal(this, 0.8));
        this.f_21345_.m_25352_(8, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new TrackNearestTargetGoal<Player>(this, Player.class, MoonPhase.get((LevelTimeAccess)this.f_19853_) != MoonPhase.FULL));
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        if (worldIn.m_5822_().nextBoolean()) {
            this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)ItemsNF.RUSTED_SPEAR.get()));
        } else {
            ItemStack bow = new ItemStack((ItemLike)ItemsNF.TWISTED_BOW.get());
            bow.m_41784_().m_128344_("ammo", (byte)this.arrowItem.getAmmoId());
            this.m_8061_(EquipmentSlot.MAINHAND, bow);
        }
        this.equipHumanoid(worldIn.m_5822_(), 0.3f, 0.3f, 0.3f, 1.0f, MoonPhase.get((LevelTimeAccess)worldIn) == MoonPhase.FULL ? 0.25f : 0.0f);
        this.updateGoals();
        return spawnDataIn;
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        if (this.arrowItem != ItemsNF.RUSTED_ARROW.get()) {
            tag.m_128359_("arrowItem", this.arrowItem.getItem().getRegistryName().toString());
        }
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        Item item;
        super.m_7378_(tag);
        if (tag.m_128441_("arrowItem") && (item = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)tag.m_128461_("arrowItem")))) instanceof IProjectileItem) {
            this.arrowItem = (IProjectileItem)item;
        }
        this.updateGoals();
    }

    public void m_8061_(EquipmentSlot p_32138_, ItemStack p_32139_) {
        super.m_8061_(p_32138_, p_32139_);
        if (!this.f_19853_.f_46443_) {
            this.updateGoals();
        }
    }

    public ItemStack m_6298_(ItemStack p_33038_) {
        return new ItemStack((ItemLike)((Item)this.arrowItem));
    }

    @Override
    public float getSafeDistanceToTarget() {
        return 4.0f;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        if (this.m_21224_()) {
            return super.m_6431_(poseIn, sizeIn);
        }
        return 1.7f;
    }

    protected int m_7302_(int pAir) {
        return pAir;
    }

    @Override
    public ResourceLocation pickActionEnemy(double distanceSqr, Entity target) {
        if (this.m_6844_(EquipmentSlot.MAINHAND).m_204117_(TagsNF.BOW)) {
            return ActionsNF.SKELETON_SHOOT.getId();
        }
        return ActionsNF.SKELETON_THRUST.getId();
    }

    @Override
    public Impact modifyIncomingImpact(DamageTypeSource source, Impact impact) {
        return source.isType(DamageType.STRIKING) ? impact.increase() : impact;
    }

    @Override
    public EquipmentSlot getHitSlot(Vector3d hitPos, int boxIndex) {
        double y = hitPos.f_86215_;
        if (y > 0.3125 && y <= 0.75) {
            return EquipmentSlot.LEGS;
        }
        if (y > 0.75 && y <= 1.5) {
            return EquipmentSlot.CHEST;
        }
        if (y > 1.5) {
            return EquipmentSlot.HEAD;
        }
        return EquipmentSlot.FEET;
    }

    @Override
    public ParticleOptions getHurtParticle() {
        return (ParticleOptions)ParticleTypesNF.FRAGMENT_BONE.get();
    }

    @Override
    public boolean canDoRangedAction() {
        return this.m_21205_().m_204117_(TagsNF.BOW);
    }

    @Override
    protected PathNavigation m_6037_(Level level) {
        return new FlankingLandEntityNavigator(this, level);
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)SoundsNF.SKELETON_AMBIENT.get();
    }

    @Override
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return (SoundEvent)SoundsNF.SKELETON_HURT.get();
    }

    @Override
    protected SoundEvent m_5592_() {
        return (SoundEvent)SoundsNF.SKELETON_DEATH.get();
    }

    protected void m_7355_(BlockPos pos, BlockState pBlock) {
        this.m_5496_((SoundEvent)SoundsNF.SKELETON_STEP.get(), 0.15f, 1.0f);
    }
}

