/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.entity.monster;

import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import frostnox.nightfall.block.block.nest.GuardedNestBlockEntity;
import frostnox.nightfall.block.block.nest.NestBlockEntity;
import frostnox.nightfall.capability.ChunkData;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.entity.EntityPart;
import frostnox.nightfall.entity.IChaser;
import frostnox.nightfall.entity.IHomeEntity;
import frostnox.nightfall.entity.ai.goal.EatBlockGoal;
import frostnox.nightfall.entity.ai.goal.EatEntityGoal;
import frostnox.nightfall.entity.ai.goal.FleeDamageGoal;
import frostnox.nightfall.entity.ai.goal.FleeEntityOrHomeGoal;
import frostnox.nightfall.entity.ai.goal.MoveToNestGoal;
import frostnox.nightfall.entity.ai.goal.RandomLookGoal;
import frostnox.nightfall.entity.ai.goal.RushAttackGoal;
import frostnox.nightfall.entity.ai.goal.WanderLandNestGoal;
import frostnox.nightfall.entity.ai.goal.target.TrackNearestTargetGoal;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.entity.entity.Diet;
import frostnox.nightfall.entity.entity.monster.HungryMonsterEntity;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.GenericEntityToClient;
import frostnox.nightfall.registry.ActionsNF;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.registry.forge.DataSerializersNF;
import frostnox.nightfall.registry.forge.ParticleTypesNF;
import frostnox.nightfall.util.animation.AnimationData;
import java.util.EnumMap;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class SpiderEntity
extends HungryMonsterEntity
implements IChaser,
IHomeEntity {
    protected static final EntityDataAccessor<Type> TYPE = SynchedEntityData.m_135353_(SpiderEntity.class, DataSerializersNF.SPIDER_TYPE);
    protected static final EntityDataAccessor<Boolean> SPECIAL = SynchedEntityData.m_135353_(SpiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> CLIMBING = SynchedEntityData.m_135353_(SpiderEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    public int targetTime;
    public int targetTimeLast;
    public int alertedTime;
    public boolean isChasingTarget;
    public boolean isScout;
    protected BlockPos homePos = null;

    public SpiderEntity(EntityType<? extends SpiderEntity> type, Level worldIn) {
        super((EntityType<? extends HungryMonsterEntity>)type, worldIn);
    }

    public static AttributeSupplier.Builder getAttributeMap() {
        return SpiderEntity.createAttributes().m_22268_(Attributes.f_22276_, 25.0).m_22268_(Attributes.f_22279_, (double)0.28f).m_22268_(Attributes.f_22278_, 0.0).m_22268_(Attributes.f_22281_, 1.0).m_22268_(Attributes.f_22282_, 0.0).m_22268_(Attributes.f_22283_, 4.0).m_22268_(Attributes.f_22277_, 15.0).m_22268_((Attribute)AttributesNF.HEARING_RANGE.get(), 8.0).m_22268_((Attribute)AttributesNF.SLASHING_DEFENSE.get(), 0.25).m_22268_((Attribute)AttributesNF.PIERCING_DEFENSE.get(), 0.25);
    }

    public static EnumMap<EntityPart, AnimationData> getHeadAnimMap() {
        EnumMap<EntityPart, AnimationData> map = new EnumMap<EntityPart, AnimationData>(EntityPart.class);
        map.put(EntityPart.HEAD, new AnimationData(new Vector3f(0.0f, 0.0f, 0.25f), new Vector3f(0.0f, 0.0f, 0.0f)));
        return map;
    }

    public Type getSpiderType() {
        return (Type)((Object)this.m_20088_().m_135370_(TYPE));
    }

    public boolean isSpecial() {
        return (Boolean)this.m_20088_().m_135370_(SPECIAL);
    }

    public void setClimbing(boolean climbing) {
        this.m_20088_().m_135381_(CLIMBING, (Object)climbing);
    }

    public boolean isClimbing() {
        return (Boolean)this.m_20088_().m_135370_(CLIMBING);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, new FleeEntityOrHomeGoal<LivingEntity>(this, LivingEntity.class, 1.1, 1.2, entity -> {
            if (entity.m_21224_()) {
                return false;
            }
            return entity.m_6095_().m_204039_(TagsNF.SPIDER_PREDATOR);
        }));
        this.f_21345_.m_25352_(3, (Goal)new RushAttackGoal(this, 1.1){

            @Override
            public void m_8056_() {
                super.m_8056_();
                SpiderEntity.this.isChasingTarget = true;
                NetworkHandler.toAllTracking((Entity)this.mob, new GenericEntityToClient(NetworkHandler.Type.CHASER_ACQUIRE_TARGET_CLIENT, this.mob.m_142049_()));
            }

            @Override
            public void m_8041_() {
                super.m_8041_();
                SpiderEntity.this.isChasingTarget = false;
                NetworkHandler.toAllTracking((Entity)this.mob, new GenericEntityToClient(NetworkHandler.Type.CHASER_REMOVE_TARGET_CLIENT, this.mob.m_142049_()));
            }
        });
        this.f_21345_.m_25352_(4, (Goal)new MoveToNestGoal(this, 1.3, 1.1){

            @Override
            public boolean m_8036_() {
                if (SpiderEntity.this.isScout || SpiderEntity.this.alertedTime > 0) {
                    return false;
                }
                return super.m_8036_();
            }
        });
        this.f_21345_.m_25352_(5, (Goal)new FleeDamageGoal(this, 1.1));
        this.f_21345_.m_25352_(6, (Goal)new EatEntityGoal(this, 1.0, 15, 2));
        this.f_21345_.m_25352_(7, (Goal)new EatBlockGoal(this, 1.0, 15, 2));
        this.f_21345_.m_25352_(8, (Goal)new WanderLandNestGoal(this, 0.9));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookGoal((Mob)this, 0.0033333332f));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, new TrackNearestTargetGoal<LivingEntity>((ActionableEntity)this, LivingEntity.class, true, entity -> {
            if (entity.m_21224_()) {
                return false;
            }
            if (entity instanceof Player) {
                Player player = (Player)entity;
                return !player.m_7500_() && !player.m_5833_();
            }
            return entity.m_6095_().m_204039_(TagsNF.SPIDER_PREY);
        }));
    }

    @Override
    public double getReducedAIThresholdSqr() {
        return 10000.0;
    }

    @Override
    public void m_6667_(DamageSource pCause) {
        BlockEntity blockEntity;
        super.m_6667_(pCause);
        if (this.f_20890_ && this.homePos != null && !this.f_19853_.f_46443_ && (blockEntity = this.f_19853_.m_7702_(this.homePos)) instanceof NestBlockEntity) {
            NestBlockEntity nest = (NestBlockEntity)blockEntity;
            nest.stopTrackingEntity(this.m_142081_());
            if (this.isScout && nest instanceof GuardedNestBlockEntity) {
                GuardedNestBlockEntity guardedNest = (GuardedNestBlockEntity)nest;
                if (this.m_142081_().equals(guardedNest.scout)) {
                    guardedNest.scout = null;
                    guardedNest.m_6596_();
                }
            }
        }
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        BlockEntity blockEntity;
        super.m_142687_(pReason);
        if (pReason.m_146965_() && this.homePos != null && !this.f_19853_.f_46443_ && (blockEntity = this.f_19853_.m_7702_(this.homePos)) instanceof NestBlockEntity) {
            NestBlockEntity nest = (NestBlockEntity)blockEntity;
            nest.stopTrackingEntity(this.m_142081_());
            if (this.isScout && nest instanceof GuardedNestBlockEntity) {
                GuardedNestBlockEntity guardedNest = (GuardedNestBlockEntity)nest;
                if (this.m_142081_().equals(guardedNest.scout)) {
                    guardedNest.scout = null;
                    guardedNest.m_6596_();
                }
            }
        }
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    @Override
    public boolean canTargetFromSound(LivingEntity target) {
        return target.m_6095_().m_204039_(TagsNF.SPIDER_PREY) || target instanceof Player;
    }

    public boolean m_6779_(LivingEntity target) {
        return target.m_142066_() && !(target instanceof SpiderEntity);
    }

    @Override
    public ResourceLocation pickActionEnemy(double distanceSqr, Entity target) {
        return switch (this.getSpiderType()) {
            default -> throw new IncompatibleClassChangeError();
            case Type.BLACK -> ActionsNF.SPIDER_BITE_POISONOUS.getId();
            case Type.BANDED -> ActionsNF.SPIDER_BITE_PARALYZING.getId();
            case Type.BROWN -> ActionsNF.SPIDER_BITE_STRONG.getId();
        };
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.targetTimeLast = this.targetTime;
        if (this.m_6084_()) {
            if (this.alertedTime > 0) {
                --this.alertedTime;
            }
            if (this.isChasingTarget) {
                if (this.targetTime < 9) {
                    ++this.targetTime;
                }
            } else if (this.targetTime > 0) {
                --this.targetTime;
            }
        }
        if (!this.f_19853_.f_46443_) {
            BlockEntity blockEntity;
            this.setClimbing(this.f_19862_);
            if (this.isScout && this.homePos != null && this.homePos.m_203193_((Position)this.m_20182_()) > 900.0 && (blockEntity = this.f_19853_.m_7702_(this.homePos)) instanceof GuardedNestBlockEntity) {
                GuardedNestBlockEntity nest = (GuardedNestBlockEntity)blockEntity;
                nest.scout = null;
                nest.m_6596_();
                this.isScout = false;
            }
        }
    }

    public boolean m_6147_() {
        return false;
    }

    public void m_7601_(BlockState pState, Vec3 pMotionMultiplier) {
        if (!pState.m_204336_(TagsNF.SPIDER_FREE_TRAVEL_BLOCK)) {
            super.m_7601_(pState, pMotionMultiplier);
        }
    }

    public float m_20098_() {
        BlockState inBlock = this.f_19853_.m_8055_(this.m_142538_());
        if (inBlock.m_204336_(TagsNF.SPIDER_FREE_TRAVEL_BLOCK)) {
            return 1.0f;
        }
        float jump = inBlock.m_60734_().m_49964_();
        if (jump == 1.0f) {
            BlockState onBlock = this.f_19853_.m_8055_(this.m_20099_());
            return onBlock.m_204336_(TagsNF.SPIDER_FREE_TRAVEL_BLOCK) ? 1.0f : onBlock.m_60734_().m_49964_();
        }
        return jump;
    }

    public float m_6041_() {
        BlockState inBlock = this.f_19853_.m_8055_(this.m_142538_());
        if (inBlock.m_204336_(TagsNF.SPIDER_FREE_TRAVEL_BLOCK)) {
            return 1.0f;
        }
        float speed = inBlock.m_60734_().m_49961_();
        if (speed == 1.0f) {
            BlockState onBlock = this.f_19853_.m_8055_(this.m_20099_());
            return onBlock.m_204336_(TagsNF.SPIDER_FREE_TRAVEL_BLOCK) ? 1.0f : onBlock.m_60734_().m_49961_();
        }
        return speed;
    }

    protected int m_5639_(float pFallDistance, float pDamageMultiplier) {
        return super.m_5639_(pFallDistance, pDamageMultiplier) - 30;
    }

    public void m_5997_(double pX, double pY, double pZ) {
        super.m_5997_(pX * 2.0, pY * 1.5, pZ * 2.0);
    }

    @Override
    public float getVisionAngle() {
        return 150.0f;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(TYPE, (Object)Type.BLACK);
        this.f_19804_.m_135372_(SPECIAL, (Object)false);
        this.f_19804_.m_135372_(CLIMBING, (Object)false);
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        boolean climbing;
        boolean special;
        super.m_7380_(tag);
        int type = this.getSpiderType().ordinal();
        if (type != 0) {
            tag.m_128405_("type", type);
        }
        if (special = this.isSpecial()) {
            tag.m_128379_("special", special);
        }
        if (climbing = this.isClimbing()) {
            tag.m_128379_("climbing", climbing);
        }
        if (this.homePos != null) {
            tag.m_128365_("homePos", (Tag)NbtUtils.m_129224_((BlockPos)this.homePos));
        }
        tag.m_128379_("isScout", this.isScout);
        tag.m_128405_("alertedTime", this.alertedTime);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.m_20088_().m_135381_(TYPE, (Object)Type.values()[tag.m_128451_("type")]);
        this.m_20088_().m_135381_(SPECIAL, (Object)tag.m_128471_("special"));
        this.m_20088_().m_135381_(CLIMBING, (Object)tag.m_128471_("climbing"));
        if (tag.m_128441_("homePos")) {
            this.homePos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_("homePos"));
        }
        this.isScout = tag.m_128471_("isScout");
        this.alertedTime = tag.m_128451_("alertedTime");
    }

    @Override
    public float getPushResistance() {
        return 1.0f;
    }

    @Override
    public float getPushForce() {
        return 1.0f;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        if (!((spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, (SpawnGroupData)spawnDataIn, dataTag)) instanceof GroupData)) {
            spawnDataIn = GroupData.create(ChunkData.get(worldIn.m_6018_().m_46745_(this.m_142538_())).getHumidity(this.m_142538_()));
        }
        this.m_20088_().m_135381_(TYPE, (Object)((GroupData)((Object)spawnDataIn)).type);
        if (this.f_19796_.nextInt() % 8192 == 0) {
            this.m_20088_().m_135381_(SPECIAL, (Object)true);
        }
        return spawnDataIn;
    }

    protected float m_6431_(Pose poseIn, EntityDimensions sizeIn) {
        return sizeIn.f_20378_ * 0.5f;
    }

    @Override
    public ParticleOptions getHurtParticle() {
        return (ParticleOptions)ParticleTypesNF.BLOOD_PALE_BLUE.get();
    }

    public float m_6100_() {
        return super.m_6100_() + 0.1f;
    }

    protected SoundEvent m_7515_() {
        if (!this.isChasingTarget) {
            return SoundEvents.f_12432_;
        }
        return null;
    }

    @Override
    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_12434_;
    }

    @Override
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12433_;
    }

    protected void m_7355_(BlockPos pos, BlockState pBlock) {
        this.m_5496_(SoundEvents.f_12435_, 0.15f, 1.0f);
    }

    @Override
    protected int getMaxSatiety() {
        return 96000;
    }

    @Override
    public Diet getDiet() {
        return Diet.CARNIVORE;
    }

    @Override
    public boolean canEat(Entity entity) {
        if (super.canEat(entity)) {
            return true;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            return livingEntity.f_20919_ > 20 && !(entity instanceof SpiderEntity) && entity.m_6095_().m_204039_(TagsNF.EDIBLE_CORPSE);
        }
        return false;
    }

    @Override
    public SoundEvent getEatSound() {
        return null;
    }

    @Override
    public EquipmentSlot getHitSlot(Vector3d hitPos, int boxIndex) {
        return EquipmentSlot.CHEST;
    }

    @Override
    @Nullable
    public BlockPos getHomePos() {
        return this.homePos;
    }

    @Override
    public void setHomePos(@Nullable BlockPos pos) {
        this.homePos = pos;
        if (this.homePos == null) {
            this.isScout = false;
        }
    }

    @Override
    public void onExitHome() {
        IHomeEntity.super.onExitHome();
        this.alertedTime = 400 + this.f_19796_.nextInt(100);
    }

    @Override
    public void setChasing(boolean value) {
        this.isChasingTarget = value;
    }

    @Override
    public boolean isChasing() {
        return this.isChasingTarget;
    }

    public static enum Type {
        BLACK,
        BANDED,
        BROWN;

    }

    public static class GroupData
    extends AgeableMob.AgeableMobGroupData {
        public final Type type;

        public GroupData(Type type) {
            super(0.0f);
            this.type = type;
        }

        public static GroupData create(float humidity) {
            Type type = humidity >= 0.7f ? Type.BLACK : (humidity > 0.3f ? Type.BANDED : Type.BROWN);
            return new GroupData(type);
        }
    }
}

