/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.entity.monster;

import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.entity.entity.monster.MonsterEntity;
import frostnox.nightfall.item.TieredArmorMaterial;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.GenericEntityToClient;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.registry.forge.ItemsNF;
import frostnox.nightfall.registry.forge.ParticleTypesNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.LevelUtil;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.world.MoonPhase;
import java.util.Random;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelTimeAccess;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;

public abstract class UndeadEntity
extends MonsterEntity {
    protected static final EntityDataAccessor<Float> ESSENCE = SynchedEntityData.m_135353_(UndeadEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135029_);
    private static final AttributeModifier FOLLOW_RANGE_MODIFIER = new AttributeModifier(UUID.fromString("a93ac4ad-6c06-4d90-9ce0-49c997c2ecc2"), "Full moon follow range bonus", 40.0, AttributeModifier.Operation.ADDITION);
    protected long lastLoadedDayTime;
    protected int resurrectTimer;
    protected boolean resurrecting;
    protected boolean fresh;
    protected boolean hasDregAlly;

    public UndeadEntity(EntityType<? extends UndeadEntity> type, Level worldIn) {
        super((EntityType<? extends MonsterEntity>)type, worldIn);
    }

    public int getRandomResurrectTime() {
        return 80 + this.f_19796_.nextInt(60);
    }

    public boolean isResurrecting() {
        return this.resurrecting;
    }

    public boolean canResurrect() {
        if (this.f_19853_.f_46443_) {
            return !this.resurrecting;
        }
        return !this.resurrecting && !this.m_6084_() && this.f_20919_ > 20 && !this.m_6060_() && LevelUtil.isNight((LevelAccessor)this.f_19853_) && (this.m_20096_() || this.m_20069_());
    }

    public void resurrect() {
        if (this.f_19853_.m_5776_()) {
            this.resurrecting = true;
            return;
        }
        this.resurrecting = true;
        NetworkHandler.toAllTracking((Entity)this, new GenericEntityToClient(NetworkHandler.Type.RESURRECT_UNDEAD_CLIENT, this.m_142049_()));
        Vec3 move = new Vec3(-0.22 * (double)(this.getSynchedRandom() % 2 == 0 ? 1 : -1), 0.0, 0.0).m_82524_(-MathUtil.toRadians(this.m_146908_()));
        this.m_20256_(this.m_20184_().m_82549_(move));
    }

    public float getMaxEssence() {
        return (float)AttributesNF.getMaxEssence((LivingEntity)this);
    }

    public float getEssencePercentage() {
        return this.getEssence() / this.getMaxEssence();
    }

    public float getEssence() {
        return ((Float)this.m_20088_().m_135370_(ESSENCE)).floatValue();
    }

    public void setEssence(float essence) {
        this.m_20088_().m_135381_(ESSENCE, (Object)Float.valueOf(Mth.m_14036_((float)essence, (float)0.0f, (float)this.getMaxEssence())));
    }

    public void addEssence(float essence) {
        this.setEssence(this.getEssence() + essence);
    }

    public float getTransparency() {
        return Math.min(1.0f, this.getEssencePercentage() + 0.75f);
    }

    @Override
    public double getReducedAIThresholdSqr() {
        return 40000.0;
    }

    @Override
    public boolean panicsOnFireDamage() {
        return false;
    }

    @Override
    public boolean dropLootFromSkinning() {
        return false;
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor worldIn, DifficultyInstance difficultyIn, MobSpawnType reason, @Nullable SpawnGroupData spawnDataIn, @Nullable CompoundTag dataTag) {
        spawnDataIn = super.m_6518_(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
        this.setEssence(this.getMaxEssence());
        this.lastLoadedDayTime = worldIn.m_6106_().m_6792_();
        this.fresh = true;
        return spawnDataIn;
    }

    public MobType m_6336_() {
        return MobType.f_21641_;
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ESSENCE, (Object)Float.valueOf(100.0f));
    }

    @Override
    public void m_7380_(CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128350_("essence", this.getEssence());
        tag.m_128379_("resurrecting", this.isResurrecting());
        tag.m_128356_("lastDayTime", this.lastLoadedDayTime);
        tag.m_128405_("resurrectTimer", this.resurrectTimer);
    }

    @Override
    public void m_7378_(CompoundTag tag) {
        super.m_7378_(tag);
        this.setEssence(tag.m_128457_("essence"));
        this.resurrecting = tag.m_128471_("resurrecting");
        this.lastLoadedDayTime = tag.m_128454_("lastDayTime");
        this.resurrectTimer = tag.m_128451_("resurrectTimer");
    }

    @Override
    public boolean canTargetFromSound(LivingEntity target) {
        Player player;
        return target instanceof Player && !(player = (Player)target).m_7500_() && !player.m_5833_();
    }

    public boolean m_6779_(LivingEntity pTarget) {
        if (pTarget instanceof Player) {
            Player player = (Player)pTarget;
            return !player.m_7500_() && !player.m_5833_();
        }
        return pTarget.m_6336_() != MobType.f_21641_ && pTarget.m_142066_();
    }

    @Override
    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    @Override
    public void m_8119_() {
        if (!this.f_19853_.f_46443_) {
            long timePassed = this.f_19853_.m_46468_() - this.lastLoadedDayTime;
            if (timePassed > 1L) {
                if (timePassed > 48000L) {
                    this.m_146870_();
                } else {
                    long essenceLost = LevelUtil.getDayTimePassed(this.f_19853_, timePassed) / (long)(this.m_21224_() ? 5 : 10);
                    this.addEssence(-essenceLost);
                    if (this.getEssence() <= 0.0f) {
                        this.m_146870_();
                    }
                }
            }
            this.lastLoadedDayTime = this.f_19853_.m_46468_();
            if (MoonPhase.get((LevelTimeAccess)this.f_19853_) == MoonPhase.FULL) {
                if (this.f_19797_ == 1) {
                    AttributeInstance followRange = this.m_21051_(Attributes.f_22277_);
                    followRange.m_22130_(FOLLOW_RANGE_MODIFIER);
                    followRange.m_22118_(FOLLOW_RANGE_MODIFIER);
                }
            } else {
                this.m_21051_(Attributes.f_22277_).m_22130_(FOLLOW_RANGE_MODIFIER);
            }
        }
        super.m_8119_();
        if (this.m_6084_() && this.f_20919_ > 0) {
            --this.f_20919_;
            if (this.f_20919_ == 0) {
                this.resurrecting = false;
            }
        }
        float essence = this.getEssence();
        if (this.f_19853_.f_46443_) {
            if (this.f_19797_ % 5 == 0 && this.f_19796_.nextFloat() > this.getTransparency()) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypesNF.ESSENCE_MOON.get(), this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
            }
        } else {
            Level level = this.f_19853_;
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                if (this.fresh) {
                    this.fresh = false;
                    this.m_5496_((SoundEvent)SoundsNF.UNDEAD_WARP.get(), 1.0f, 1.0f);
                    serverLevel.m_8767_((ParticleOptions)((SimpleParticleType)ParticleTypesNF.ESSENCE_MOON.get()), this.m_20185_(), this.m_20186_(), this.m_20189_(), Math.round(14.0f * this.m_20206_()) + this.f_19853_.f_46441_.nextInt(8), (double)this.m_20205_() * 0.5, (double)this.m_20206_() * 0.5, (double)this.m_20205_() * 0.5, 0.0);
                }
                if (LevelUtil.isDay((LevelAccessor)this.f_19853_) || this.m_21224_()) {
                    if (essence <= 0.0f) {
                        this.m_142687_(Entity.RemovalReason.KILLED);
                    } else {
                        this.setEssence(essence - (this.m_21224_() ? 0.25f : 0.1f));
                    }
                } else if ((double)essence < AttributesNF.getMaxEssence((LivingEntity)this)) {
                    this.setEssence(essence + 0.05f * MoonPhase.get((LevelTimeAccess)this.f_19853_).fullness);
                }
            }
        }
    }

    @Override
    protected void m_6153_() {
        if (!this.isResurrecting()) {
            ++this.f_20919_;
            if (!this.f_19853_.f_46443_ && this.canResurrect()) {
                if (this.resurrectTimer == 0) {
                    this.resurrectTimer = this.getRandomResurrectTime();
                }
                --this.resurrectTimer;
                if (this.resurrectTimer <= 0) {
                    this.resurrect();
                }
            }
        } else {
            this.f_20919_ = this.f_20919_ > 20 ? 20 : --this.f_20919_;
            if (this.f_20919_ == 0) {
                this.resurrecting = false;
            } else if (this.f_20919_ == 6) {
                this.f_20890_ = false;
                if (!this.f_19853_.f_46443_) {
                    this.m_21153_(this.m_21233_() / 2.0f);
                }
            } else if (this.f_20919_ == 20 && this.m_7515_() != null) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_7515_(), this.m_5720_(), this.m_6121_(), this.m_6100_(), false);
            }
        }
    }

    @Override
    protected void m_6668_(DamageSource pDamageSource) {
    }

    protected void m_5907_() {
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack item = this.m_6844_(slot);
            float dropChance = this.m_21519_(slot);
            if (item.m_41619_() || !(this.f_19796_.nextFloat() < dropChance)) continue;
            if (dropChance <= 1.0f && item.m_41763_()) {
                item.m_41721_((int)((float)item.m_41776_() * (1.0f - this.f_19796_.nextFloat() * 0.05f)));
            }
            this.m_19983_(item);
            this.m_8061_(slot, ItemStack.f_41583_);
        }
    }

    public void m_142687_(Entity.RemovalReason pReason) {
        this.m_142467_(pReason);
        if (pReason == Entity.RemovalReason.KILLED && this.f_20890_) {
            this.m_146850_(GameEvent.f_157809_);
            DamageSource source = this.m_21225_();
            this.forceDropAllDeathLoot(source == null ? DamageSource.f_19318_ : source);
            for (Player player : this.f_19853_.m_45976_(Player.class, this.m_142469_().m_82400_(this.m_21133_(Attributes.f_22277_)))) {
                if (player.m_5833_()) continue;
                IPlayerData capP = PlayerData.get(player);
                capP.setUndeadKilledThisNight(capP.getUndeadKilledThisNight() + 1);
            }
        }
        this.invalidateCaps();
    }

    public void m_142036_() {
        if (this.getEssence() > 0.0f) {
            return;
        }
        this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)SoundsNF.UNDEAD_WARP.get(), this.m_5720_(), 1.0f, 1.0f, false);
        for (int i = 0; i < Math.round(14.0f * this.m_20206_()) + this.f_19853_.f_46441_.nextInt(8); ++i) {
            this.f_19853_.m_7106_((ParticleOptions)ParticleTypesNF.ESSENCE_MOON.get(), this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), 0.0, 0.0, 0.0);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return ActionableEntity.createAttributes().m_22268_((Attribute)AttributesNF.WILLPOWER.get(), 15.0).m_22268_((Attribute)AttributesNF.FROST_DEFENSE.get(), 0.5);
    }

    protected void equipHumanoid(Random random, float headChance, float chestChance, float legsFeetChance, float metalChance, float extraChance) {
        metalChance += extraChance;
        if (random.nextFloat() < headChance + extraChance) {
            this.m_8061_(EquipmentSlot.HEAD, new ItemStack((ItemLike)ItemsNF.HELMETS.get(random.nextFloat() < metalChance ? TieredArmorMaterial.RUSTED : TieredArmorMaterial.RAGGED).get()));
        }
        if (random.nextFloat() < chestChance + extraChance) {
            this.m_8061_(EquipmentSlot.CHEST, new ItemStack((ItemLike)ItemsNF.CHESTPLATES.get(random.nextFloat() < metalChance ? TieredArmorMaterial.RUSTED : TieredArmorMaterial.RAGGED).get()));
        }
        if (random.nextFloat() < legsFeetChance + extraChance) {
            this.m_8061_(EquipmentSlot.LEGS, new ItemStack((ItemLike)ItemsNF.LEGGINGS.get(random.nextFloat() < metalChance ? TieredArmorMaterial.RUSTED : TieredArmorMaterial.RAGGED).get()));
            this.m_8061_(EquipmentSlot.FEET, new ItemStack((ItemLike)ItemsNF.BOOTS.get(random.nextFloat() < metalChance ? TieredArmorMaterial.RUSTED : TieredArmorMaterial.RAGGED).get()));
        }
    }
}

