/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.entity.projectile;

import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.DamageTypeSource;
import frostnox.nightfall.action.HitData;
import frostnox.nightfall.action.Impact;
import frostnox.nightfall.item.IProjectileItem;
import frostnox.nightfall.registry.forge.EntitiesNF;
import frostnox.nightfall.registry.forge.ItemsNF;
import frostnox.nightfall.util.LevelUtil;
import frostnox.nightfall.util.data.Vec3f;
import frostnox.nightfall.world.OrientedEntityHitResult;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;

public class ArrowEntity
extends AbstractArrow {
    protected IProjectileItem projectileItem;

    public ArrowEntity(EntityType<? extends ArrowEntity> entity, Level level) {
        super(entity, level);
    }

    public ArrowEntity(Level level, IProjectileItem projectileItem) {
        super((EntityType)EntitiesNF.ARROW.get(), level);
        this.projectileItem = projectileItem;
    }

    public ArrowEntity(Level level, LivingEntity owner, IProjectileItem projectileItem) {
        super((EntityType)EntitiesNF.ARROW.get(), owner, level);
        this.projectileItem = projectileItem;
    }

    public IProjectileItem getProjectileItem() {
        return this.projectileItem;
    }

    public Item getItem() {
        if (this.projectileItem == null) {
            return (Item)ItemsNF.FLINT_ARROW.get();
        }
        return this.projectileItem.getItem();
    }

    public void setItem(IProjectileItem item) {
        this.projectileItem = item;
    }

    protected ItemStack m_7941_() {
        return new ItemStack((ItemLike)this.projectileItem.getItem());
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 pStartVec, Vec3 pEndVec) {
        return LevelUtil.getHitEntity(this.f_19853_, (Entity)this, pStartVec, pEndVec, this.m_142469_().m_82369_(this.m_20184_()), x$0 -> this.m_5603_((Entity)x$0));
    }

    protected void m_5790_(EntityHitResult pResult) {
        if (!this.f_19853_.f_46443_) {
            float damage = (float)this.m_36789_();
            DamageType[] damageType = this.projectileItem.getProjectileDamageType();
            Entity target = pResult.m_82443_();
            Entity owner = this.m_37282_();
            Vec3 pos = pResult.m_82450_().m_82546_(target.m_20182_());
            Vec3 knockbackVec = pResult.m_82450_().m_82546_(this.m_20182_());
            DamageTypeSource damageSource = DamageTypeSource.createProjectileSource((Entity)this, damageType, (Entity)(owner == null ? this : owner), new HitData(target, (float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_, new Vec3f((float)knockbackVec.f_82479_, (float)knockbackVec.f_82480_, (float)knockbackVec.f_82481_).normalize(), ((OrientedEntityHitResult)pResult).boxIndex));
            damageSource.setImpactSoundType(damageType[0].getImpactSoundType(), target);
            double speed = this.m_20184_().m_82553_();
            damageSource.setImpact(speed > 2.0 ? Impact.HIGH : (speed > 1.0 ? Impact.MEDIUM : Impact.LOW));
            damageSource.setStun(Math.round(Math.min(8.0f * (float)speed / 1.5f, 16.0f)));
            if (target.m_6469_((DamageSource)damageSource, Math.min(damage * (float)speed / 1.5f, damage * 2.0f))) {
                if (target instanceof LivingEntity) {
                    LivingEntity livingTarget = (LivingEntity)target;
                    this.m_7761_(livingTarget);
                    livingTarget.m_21317_(livingTarget.m_21234_() + 1);
                }
                this.m_20256_(this.m_20184_().m_82542_(0.3, 0.3, 0.3));
            }
            this.m_146870_();
        }
    }

    protected void m_6901_() {
        ++this.f_36697_;
        if (this.f_36697_ >= 2400) {
            this.m_146870_();
        }
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19797_ == 1) {
            this.f_19812_ = true;
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        Item item = (Item)ForgeRegistries.ITEMS.getValue(ResourceLocation.parse((String)pCompound.m_128461_("item")));
        this.projectileItem = item instanceof IProjectileItem ? (IProjectileItem)item : (IProjectileItem)ItemsNF.FLINT_ARROW.get();
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128359_("item", this.projectileItem.getItem().getRegistryName().toString());
    }
}

