/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.entity.projectile;

import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.DamageTypeSource;
import frostnox.nightfall.action.HitData;
import frostnox.nightfall.action.Impact;
import frostnox.nightfall.util.LevelUtil;
import frostnox.nightfall.util.data.Vec3f;
import frostnox.nightfall.world.OrientedEntityHitResult;
import net.minecraft.Util;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.ForgeEventFactory;

public abstract class ItemProjectileEntity
extends Projectile
implements ItemSupplier {
    private static final EntityDataAccessor<ItemStack> ITEM = SynchedEntityData.m_135353_(ItemProjectileEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    protected float baseDamage;
    protected float knockback;

    protected ItemProjectileEntity(EntityType<? extends ItemProjectileEntity> pEntityType, Level level) {
        super(pEntityType, level);
    }

    protected ItemProjectileEntity(EntityType<? extends ItemProjectileEntity> pEntityType, double x, double pY, double z, Level level) {
        this(pEntityType, level);
        this.m_6034_(x, pY, z);
    }

    protected ItemProjectileEntity(EntityType<? extends ItemProjectileEntity> pEntityType, LivingEntity pShooter, Level level) {
        this(pEntityType, pShooter.m_20185_(), pShooter.m_20188_() - (double)0.1f, pShooter.m_20189_(), level);
        this.m_5602_((Entity)pShooter);
    }

    public abstract DamageType[] getDamageTypes();

    protected abstract Item getDefaultItem();

    protected double getGravity() {
        return 0.04;
    }

    public float getKnockback() {
        return this.knockback;
    }

    public void setKnockback(float knockback) {
        this.knockback = knockback;
    }

    public float getBaseDamage() {
        return this.baseDamage;
    }

    public void setBaseDamage(float baseDamage) {
        this.baseDamage = Math.max(0.0f, baseDamage);
    }

    public void setItem(ItemStack item) {
        this.m_20088_().m_135381_(ITEM, (Object)((ItemStack)Util.m_137469_((Object)item.m_41777_(), stack -> stack.m_41764_(1))));
    }

    public ItemStack m_7846_() {
        ItemStack item = (ItemStack)this.m_20088_().m_135370_(ITEM);
        return item.m_41619_() ? new ItemStack((ItemLike)this.getDefaultItem()) : item;
    }

    protected void m_5790_(EntityHitResult pResult) {
        if (!this.f_19853_.f_46443_) {
            Entity target = pResult.m_82443_();
            Entity owner = this.m_37282_();
            Vec3 pos = pResult.m_82450_().m_82546_(target.m_20182_());
            Vec3 knockbackVec = pResult.m_82450_().m_82546_(this.m_20182_());
            DamageType[] damageTypes = this.getDamageTypes();
            DamageTypeSource damageSource = DamageTypeSource.createProjectileSource((Entity)this, damageTypes, (Entity)(owner == null ? this : owner), new HitData(target, (float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_, new Vec3f((float)knockbackVec.f_82479_, (float)knockbackVec.f_82480_, (float)knockbackVec.f_82481_).normalize().scale(this.knockback), ((OrientedEntityHitResult)pResult).boxIndex));
            damageSource.setImpactSoundType(damageTypes[0].getImpactSoundType(), target);
            double speed = this.m_20184_().m_82553_();
            damageSource.setImpact(speed > 2.0 ? Impact.HIGH : (speed > 1.0 ? Impact.MEDIUM : Impact.LOW));
            damageSource.setStun(Math.round(Math.min(12.0f * (float)speed / 1.5f, 24.0f)));
            target.m_6469_((DamageSource)damageSource, Math.min(this.baseDamage * (float)speed / 1.5f, this.baseDamage * 2.0f));
        }
    }

    public void m_8119_() {
        float speed;
        super.m_8119_();
        HitResult hitResult = LevelUtil.getHitResult((Entity)this, x$0 -> this.m_5603_((Entity)x$0));
        if (hitResult.m_6662_() != HitResult.Type.MISS && !ForgeEventFactory.onProjectileImpact((Projectile)this, (HitResult)hitResult)) {
            this.m_6532_(hitResult);
        }
        this.m_20101_();
        Vec3 delta = this.m_20184_();
        double x = this.m_20185_() + delta.f_82479_;
        double y = this.m_20186_() + delta.f_82480_;
        double z = this.m_20189_() + delta.f_82481_;
        this.m_37283_();
        if (this.m_20069_()) {
            for (int i = 0; i < 4; ++i) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123795_, x - delta.f_82479_ * 0.25, y - delta.f_82480_ * 0.25, z - delta.f_82481_ * 0.25, delta.f_82479_, delta.f_82480_, delta.f_82481_);
            }
            speed = 0.8f;
        } else {
            speed = 0.99f;
        }
        this.m_20256_(delta.m_82490_((double)speed));
        if (!this.m_20068_()) {
            delta = this.m_20184_();
            this.m_20334_(delta.f_82479_, delta.f_82480_ - this.getGravity(), delta.f_82481_);
        }
        this.m_6034_(x, y, z);
    }

    public boolean m_6783_(double pDistance) {
        double size = this.m_142469_().m_82309_() * 4.0;
        if (Double.isNaN(size)) {
            size = 4.0;
        }
        return pDistance < (size *= 64.0) * size;
    }

    protected void m_8097_() {
        this.m_20088_().m_135372_(ITEM, (Object)ItemStack.f_41583_);
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        ItemStack item = this.m_7846_();
        if (!item.m_150930_(this.getDefaultItem()) || item.m_41782_()) {
            pCompound.m_128365_("item", (Tag)item.m_41739_(new CompoundTag()));
        }
        if (this.baseDamage > 0.0f) {
            pCompound.m_128350_("baseDamage", this.baseDamage);
        }
        if (this.knockback > 0.0f) {
            pCompound.m_128350_("knockback", this.knockback);
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("item")) {
            this.setItem(ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("item")));
        }
        this.baseDamage = pCompound.m_128457_("baseDamage");
        this.knockback = pCompound.m_128457_("knockback");
    }
}

