/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.entity.entity.projectile;

import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.Attack;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.DamageTypeSource;
import frostnox.nightfall.action.HitData;
import frostnox.nightfall.action.player.action.thrown.ThrowTechnique;
import frostnox.nightfall.item.IWeaponItem;
import frostnox.nightfall.registry.ActionsNF;
import frostnox.nightfall.registry.forge.EntitiesNF;
import frostnox.nightfall.util.LevelUtil;
import frostnox.nightfall.util.data.Vec3f;
import frostnox.nightfall.world.OrientedEntityHitResult;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class ThrownWeaponEntity
extends AbstractArrow {
    protected ItemStack item = ItemStack.f_41583_;
    protected ResourceLocation actionID = ActionsNF.EMPTY.getId();
    protected boolean dealtDamage = false;
    public boolean spinning;
    protected float damage;
    protected float curve;
    protected DamageType[] damageType;
    protected int airTicks;

    public ThrownWeaponEntity(EntityType<? extends ThrownWeaponEntity> entity, Level level) {
        super(entity, level);
    }

    public ThrownWeaponEntity(Level level, ItemStack item, ResourceLocation actionID) {
        super((EntityType)EntitiesNF.THROWN_WEAPON.get(), level);
        this.setItem(item);
        this.setAction(actionID, null);
    }

    public ThrownWeaponEntity(Level level, LivingEntity owner, ItemStack item, ResourceLocation actionID) {
        super((EntityType)EntitiesNF.THROWN_WEAPON.get(), owner, level);
        this.setItem(item);
        this.setAction(actionID, owner);
    }

    public void setItem(ItemStack item) {
        this.item = item.m_41777_();
        Item item2 = item.m_41720_();
        if (item2 instanceof IWeaponItem) {
            IWeaponItem weapon = (IWeaponItem)item2;
            this.damage = weapon.getBaseDamage();
        } else {
            this.damage = 20.0f;
        }
    }

    public void setAction(ResourceLocation actionID, @Nullable LivingEntity owner) {
        this.actionID = actionID;
        Action action = ActionsNF.get(actionID);
        if (action instanceof ThrowTechnique) {
            ThrowTechnique throwTechnique = (ThrowTechnique)action;
            this.curve = throwTechnique.curve;
            this.damageType = throwTechnique.getDamageTypes(owner);
            this.spinning = throwTechnique.spinning;
        } else {
            this.curve = 0.0f;
            this.damageType = DamageType.PIERCING.asArray();
            this.spinning = false;
        }
    }

    public void damageItem(int amount) {
        Level level = this.f_19853_;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.item.m_41629_(amount, this.f_19796_, null)) {
                serverLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, this.m_7941_()), this.m_20185_(), this.m_20186_(), this.m_20189_(), 10, ((double)this.f_19796_.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0, 0.0);
                this.m_146870_();
            }
        }
    }

    public boolean inGround() {
        return this.f_36703_;
    }

    public float getDamage() {
        return this.damage;
    }

    public float getCurve() {
        return this.curve;
    }

    public DamageType[] getDamageTypes() {
        return this.damageType;
    }

    public int getAirTicks() {
        return this.airTicks;
    }

    public ResourceLocation getActionID() {
        return this.actionID;
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_36704_ > 4) {
            this.dealtDamage = false;
        }
        if (this.f_19797_ == 1) {
            this.f_19812_ = true;
        }
        if (!this.f_36703_) {
            ++this.airTicks;
        }
    }

    protected void m_8060_(BlockHitResult result) {
        if (!this.dealtDamage) {
            this.damageItem(4 + this.f_19796_.nextInt(4));
        }
        this.m_36740_(null);
        super.m_8060_(result);
        if (this.m_7941_().m_41773_() >= this.m_7941_().m_41776_()) {
            this.m_36740_(SoundEvents.f_12018_);
            this.m_5496_(this.m_36784_(), 1.0f, 0.9f + 0.2f * this.f_19796_.nextFloat());
        } else {
            this.m_36740_(this.f_19853_.m_8055_(result.m_82425_()).m_60827_().m_56778_());
            this.m_5496_(this.m_36784_(), 1.0f, 0.5f + 0.2f * this.f_19796_.nextFloat());
        }
    }

    protected void m_5790_(EntityHitResult pResult) {
        Entity target = pResult.m_82443_();
        Entity owner = this.m_37282_();
        Vec3 pos = pResult.m_82450_().m_82546_(target.m_20182_());
        Vec3 knockbackVec = pResult.m_82450_().m_82546_(this.m_20182_());
        this.damageItem(4 + this.f_19796_.nextInt(4));
        DamageTypeSource damageSource = DamageTypeSource.createProjectileAttackSource((Entity)this, this.damageType, (Attack)ActionsNF.get(this.actionID), (Entity)(owner == null ? this : owner), new HitData(target, (float)pos.f_82479_, (float)pos.f_82480_, (float)pos.f_82481_, new Vec3f((float)knockbackVec.f_82479_, (float)knockbackVec.f_82480_, (float)knockbackVec.f_82481_).normalize(), ((OrientedEntityHitResult)pResult).boxIndex));
        if (this.m_7941_().m_41773_() >= this.m_7941_().m_41776_()) {
            damageSource.setSound(() -> SoundEvents.f_12018_);
        } else {
            damageSource.setImpactSoundType(this.damageType[0].getImpactSoundType(), target);
        }
        this.dealtDamage = true;
        double speed = this.m_20184_().m_82553_();
        if (speed > 1.0) {
            damageSource.setImpact(damageSource.getAttack().getImpact(null).increase());
        }
        if (target.m_6469_((DamageSource)damageSource, Math.min(this.damage * (float)speed, this.damage * 2.0f)) && target instanceof LivingEntity) {
            LivingEntity livingTarget = (LivingEntity)target;
            this.m_7761_(livingTarget);
        }
        this.m_20256_(this.m_20184_().m_82542_(0.3, 0.3, 0.3));
    }

    @Nullable
    protected EntityHitResult m_6351_(Vec3 pStartVec, Vec3 pEndVec) {
        return this.dealtDamage ? null : LevelUtil.getHitEntity(this.f_19853_, (Entity)this, pStartVec, pEndVec, this.m_142469_().m_82369_(this.m_20184_()), x$0 -> this.m_5603_((Entity)x$0));
    }

    protected boolean m_142470_(Player player) {
        return super.m_142470_(player) || this.m_36797_() && player.m_150109_().m_36054_(this.m_7941_());
    }

    public void m_6123_(Player pEntity) {
        super.m_6123_(pEntity);
    }

    protected void m_6901_() {
        ++this.f_36697_;
        if (this.f_36697_ >= 3600) {
            this.m_146870_();
        }
    }

    public void m_7378_(CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("item", 10)) {
            this.setItem(ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("item")));
        }
        if (pCompound.m_128425_("actionID", 8)) {
            this.setAction(ResourceLocation.parse((String)pCompound.m_128461_("actionID")), (LivingEntity)this.m_37282_());
        }
        this.dealtDamage = pCompound.m_128471_("dealtDamage");
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128365_("item", (Tag)this.item.m_41739_(new CompoundTag()));
        if (this.actionID != null) {
            pCompound.m_128359_("actionID", this.actionID.toString());
        }
        pCompound.m_128379_("dealtDamage", this.dealtDamage);
    }

    public ItemStack m_7941_() {
        return this.item.m_41777_();
    }

    public boolean m_6000_(double x, double pY, double z) {
        return true;
    }
}

