/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.event;

import com.google.common.hash.Hashing;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.ChunkData;
import frostnox.nightfall.capability.GlobalChunkData;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.capability.ILevelData;
import frostnox.nightfall.capability.ILightData;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.capability.LightData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.client.EntityLightEngine;
import frostnox.nightfall.encyclopedia.knowledge.IItemKnowledge;
import frostnox.nightfall.encyclopedia.knowledge.Knowledge;
import frostnox.nightfall.entity.PlayerAttribute;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.entity.entity.MovingBlockEntity;
import frostnox.nightfall.entity.entity.monster.DregEntity;
import frostnox.nightfall.entity.entity.projectile.ArrowEntity;
import frostnox.nightfall.entity.entity.projectile.ThrownWeaponEntity;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.command.GodModeCommand;
import frostnox.nightfall.network.message.GenericEntityToClient;
import frostnox.nightfall.network.message.capability.ActionTrackerToClient;
import frostnox.nightfall.network.message.capability.LevelDataToClient;
import frostnox.nightfall.network.message.capability.PlayerDataToClient;
import frostnox.nightfall.network.message.capability.SetAccessoriesToClient;
import frostnox.nightfall.network.message.entity.ArrowItemToClient;
import frostnox.nightfall.network.message.entity.HeadYRotToClient;
import frostnox.nightfall.network.message.entity.MovingBlockToClient;
import frostnox.nightfall.network.message.entity.SetAllyToClient;
import frostnox.nightfall.network.message.entity.ThrownWeaponToClient;
import frostnox.nightfall.registry.ActionsNF;
import frostnox.nightfall.registry.EntriesNF;
import frostnox.nightfall.registry.KnowledgeNF;
import frostnox.nightfall.registry.RegistriesNF;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.registry.forge.EffectsNF;
import frostnox.nightfall.util.LevelUtil;
import frostnox.nightfall.world.ContinentalWorldType;
import frostnox.nightfall.world.inventory.AccessoryInventory;
import frostnox.nightfall.world.inventory.AccessorySlot;
import frostnox.nightfall.world.inventory.PlayerInventoryContainer;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.Unit;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.ResultSlot;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityLeaveWorldEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.server.ServerStartingEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CapabilityEventHandler {
    private static boolean shouldAttachLevelCapability(Level level) {
        return level.m_6042_().m_63969_().equals((Object)ContinentalWorldType.LOCATION);
    }

    @SubscribeEvent
    public static void onAttachLevelCapabilityEvent(AttachCapabilitiesEvent<Level> event) {
        if (CapabilityEventHandler.shouldAttachLevelCapability((Level)event.getObject())) {
            event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"level_data"), (ICapabilityProvider)new LevelData.LevelDataCapability((Level)event.getObject()));
        }
    }

    @SubscribeEvent
    public static void onAttachChunkCapabilityEvent(AttachCapabilitiesEvent<LevelChunk> event) {
        if (LevelData.isPresent(((LevelChunk)event.getObject()).m_62953_())) {
            event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"chunk_data"), (ICapabilityProvider)new ChunkData.ChunkDataCapability((LevelChunk)event.getObject()));
        }
        event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"global_chunk_data"), (ICapabilityProvider)new GlobalChunkData.GlobalChunkDataCapability((LevelChunk)event.getObject()));
    }

    @SubscribeEvent
    public static void onAttachEntityCapabilityEvent(AttachCapabilitiesEvent<Entity> event) {
        Object object = event.getObject();
        if (object instanceof Player) {
            Player player = (Player)object;
            event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"player_data"), (ICapabilityProvider)new PlayerData.PlayerDataCapability(player));
            event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"player_action"), (ICapabilityProvider)new ActionTracker.ActionTrackerCapability((LivingEntity)player));
            event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"player_light"), (ICapabilityProvider)new LightData.LightDataCapability((Entity)player));
        } else {
            object = event.getObject();
            if (object instanceof ActionableEntity) {
                ActionableEntity entity = (ActionableEntity)((Object)object);
                event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"entity_action"), (ICapabilityProvider)new ActionTracker.ActionTrackerCapability((LivingEntity)entity));
            } else {
                object = event.getObject();
                if (object instanceof ItemEntity) {
                    ItemEntity itemEntity = (ItemEntity)object;
                    event.addCapability(ResourceLocation.fromNamespaceAndPath((String)"nightfall", (String)"entity_light"), (ICapabilityProvider)new LightData.LightDataCapability((Entity)itemEntity));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onLoadWorldEvent(WorldEvent.Load event) {
        ServerLevel level;
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel && LevelData.isPresent((Level)(level = (ServerLevel)levelAccessor))) {
            ILevelData capL = LevelData.get((Level)level);
            capL.onLoad(Hashing.sha512().hashLong(level.m_7328_()).asLong());
            capL.updateWeather();
            capL.updateWind();
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        Entity entity;
        LazyOptional capL;
        if (!event.getWorld().m_5776_() && (capL = (entity = event.getEntity()).getCapability(LightData.CAPABILITY)).isPresent()) {
            ((ILightData)capL.orElseThrow(() -> new IllegalArgumentException("Null in LazyOptional."))).setupClientNotifications();
        }
    }

    @SubscribeEvent
    public static void onServerStartingEvent(ServerStartingEvent event) {
        ServerLevel level = event.getServer().m_129783_();
        ServerLevelData data = (ServerLevelData)level.m_6106_();
        level.m_7726_().m_8438_(TicketType.f_9442_, new ChunkPos(new BlockPos(data.m_6789_(), 0, data.m_6526_())), 11, (Object)Unit.INSTANCE);
        if (!data.m_5468_() && event.getServer().m_129792_()) {
            event.getServer().m_129958_(true);
        }
    }

    @SubscribeEvent
    public static void onStartTrackingEvent(PlayerEvent.StartTracking event) {
        ActionableEntity target;
        Player target2;
        ServerPlayer tracker = (ServerPlayer)event.getPlayer();
        Entity entity = event.getTarget();
        LazyOptional capL = entity.getCapability(LightData.CAPABILITY);
        if (capL.isPresent() && ((ILightData)capL.orElseThrow(() -> new IllegalArgumentException("Null in LazyOptional."))).notifyClientOnStopTracking()) {
            NetworkHandler.toClient(tracker, new GenericEntityToClient(NetworkHandler.Type.ADD_LIGHT_SOURCE_CLIENT, entity.m_142049_()));
        }
        if (entity instanceof Player && (target2 = (Player)entity).m_6084_()) {
            IActionTracker targetCapA = ActionTracker.get((Entity)target2);
            IPlayerData targetCapP = PlayerData.get(target2);
            targetCapP.setLastDodgeTick(-100);
            targetCapP.setLastBlockTick(-100);
            NetworkHandler.toClient(tracker, new ActionTrackerToClient(targetCapA.writeNBT(), target2.m_142049_()));
            NetworkHandler.toClient(tracker, new PlayerDataToClient(targetCapP.writeNBT(), target2.m_142049_()));
            AccessoryInventory accessories = targetCapP.getAccessoryInventory();
            ObjectArrayList accessoriesList = new ObjectArrayList(0);
            for (AccessorySlot slot : AccessorySlot.values()) {
                ItemStack item = accessories.getItem(slot);
                if (item.m_41619_()) continue;
                accessoriesList.add(Pair.of((Object)((Object)slot), (Object)item));
            }
            if (!accessoriesList.isEmpty()) {
                NetworkHandler.toClient(tracker, new SetAccessoriesToClient((List<Pair<AccessorySlot, ItemStack>>)accessoriesList, target2.m_142049_()));
            }
            NetworkHandler.toClient(tracker, new HeadYRotToClient(target2.m_6080_(), target2.m_142049_()));
        } else if (entity instanceof ActionableEntity && (target = (ActionableEntity)entity).m_6084_()) {
            IActionTracker targetCapA = target.getActionTracker();
            NetworkHandler.toClient(tracker, new ActionTrackerToClient(targetCapA.writeNBT(), entity.m_142049_()));
            if (entity instanceof DregEntity) {
                DregEntity dreg = (DregEntity)entity;
                if (dreg.ally != null) {
                    NetworkHandler.toClient(tracker, new SetAllyToClient(dreg.ally.m_142049_(), dreg.m_142049_()));
                }
            }
        } else if (entity instanceof ThrownWeaponEntity) {
            ThrownWeaponEntity target3 = (ThrownWeaponEntity)entity;
            NetworkHandler.toClient(tracker, new ThrownWeaponToClient(target3.m_7941_(), target3.getActionID(), target3.m_142049_()));
        } else if (entity instanceof ArrowEntity) {
            ArrowEntity target4 = (ArrowEntity)entity;
            NetworkHandler.toClient(tracker, new ArrowItemToClient(target4.getProjectileItem(), target4.m_142049_()));
        } else if (entity instanceof MovingBlockEntity) {
            MovingBlockEntity target5 = (MovingBlockEntity)entity;
            if (target5.slideDir != Direction.DOWN) {
                NetworkHandler.toClient(tracker, new MovingBlockToClient(target5.getSlideTime(), target5.slideDir, false, target5.m_142049_()));
            }
        }
    }

    @SubscribeEvent
    public static void onEntityLeaveWorldEvent(EntityLeaveWorldEvent event) {
        Entity entity = event.getEntity();
        if (event.getWorld().m_5776_() && LightData.isPresent(entity)) {
            EntityLightEngine.get().removeLightSource(entity);
        }
    }

    @SubscribeEvent
    public static void onStopTrackingEvent(PlayerEvent.StopTracking event) {
        LazyOptional capL;
        ServerPlayer tracker = (ServerPlayer)event.getPlayer();
        Entity entity = event.getTarget();
        if (!entity.m_146910_() && (capL = entity.getCapability(LightData.CAPABILITY)).isPresent() && ((ILightData)capL.orElseThrow(() -> new IllegalArgumentException("Null in LazyOptional."))).notifyClientOnStopTracking()) {
            NetworkHandler.toAllTracking(entity, new GenericEntityToClient(NetworkHandler.Type.REMOVE_LIGHT_SOURCE_CLIENT, entity.m_142049_()));
        }
    }

    private static ContainerListener createKnowledgeListener(final ServerPlayer player) {
        return new ContainerListener(){

            public void m_7934_(AbstractContainerMenu menu, int slotIndex, ItemStack itemStack) {
                Slot slot;
                if (!itemStack.m_41619_() && !((slot = menu.m_38853_(slotIndex)) instanceof ResultSlot) && slot.f_40218_ == player.m_150109_()) {
                    for (Knowledge knowledge : RegistriesNF.getActiveServerKnowledge()) {
                        if (!(knowledge instanceof IItemKnowledge)) continue;
                        IItemKnowledge itemKnowledge = (IItemKnowledge)((Object)knowledge);
                        itemKnowledge.onPickedUpItem((Player)player, itemStack);
                    }
                }
            }

            public void m_142153_(AbstractContainerMenu p_143462_, int p_143463_, int p_143464_) {
            }
        };
    }

    @SubscribeEvent
    public static void onPlayerLogin(PlayerEvent.PlayerLoggedInEvent event) {
        ServerPlayer player = (ServerPlayer)event.getPlayer();
        if (LevelData.isPresent(player.f_19853_)) {
            ILevelData capL = LevelData.get(player.f_19853_);
            NetworkHandler.toClient(player, new LevelDataToClient(capL.writeNBTSync(capL.writeNBTClientInit(new CompoundTag()))));
        }
        player.f_36095_ = new PlayerInventoryContainer(player.m_150109_(), !player.f_19853_.m_5776_());
        player.f_36096_ = player.f_36095_;
        player.m_143399_((AbstractContainerMenu)player.f_36095_);
        player.f_36095_.m_38893_(CapabilityEventHandler.createKnowledgeListener(player));
        player.f_8921_ = 2;
        IPlayerData capP = PlayerData.get((Player)player);
        IActionTracker capA = ActionTracker.get((Entity)player);
        capP.setLastDodgeTick(-100);
        capP.setLastBlockTick(-100);
        capP.setClimbTicks(0);
        capP.setCrouchTicks(0);
        capP.setClimbing(false);
        capP.setLastMainItem();
        capP.setLastOffItem();
        if (capP.hasGodMode()) {
            player.m_6352_((Component)GodModeCommand.ENABLE, Util.f_137441_);
        }
        if (capP.hasNoEntries()) {
            capP.unlockEntry(EntriesNF.TOOLS.getId());
            player.m_21051_(Attributes.f_22283_).m_22100_(100.0);
            player.m_21051_(Attributes.f_22281_).m_22100_(2.0);
            player.m_21051_(Attributes.f_22276_).m_22100_(100.0);
            player.m_21153_(player.m_21233_());
        }
        capP.refreshEncyclopedia();
        NetworkHandler.toClient(player, new ActionTrackerToClient(capA.writeNBT(), player.m_142049_()));
        NetworkHandler.toClient(player, new PlayerDataToClient(capP.writeNBT(), player.m_142049_()));
        if (capP.needsAttributeSelection() && !player.m_36337_() && !player.m_5833_()) {
            NetworkHandler.toClient(player, new GenericEntityToClient(NetworkHandler.Type.OPEN_ATTRIBUTE_SELECTION_SCREEN_CLIENT, player.m_142049_()));
        }
    }

    @SubscribeEvent
    public static void onPlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        Player player = event.getPlayer();
        if (!player.m_6084_()) {
            player.reviveCaps();
        }
        IPlayerData capP = PlayerData.get(player);
        IActionTracker capA = ActionTracker.get((Entity)player);
        if (capP.dropBlockEntity()) {
            capA.startAction(ActionsNF.EMPTY.getId());
        }
        if (player.m_20159_()) {
            player.m_8127_();
        }
        if (player.m_6084_()) {
            for (Mob mob : player.f_19853_.m_45976_(Mob.class, player.m_142469_().m_82400_(15.0))) {
                if (!mob.m_21523_() || mob.m_21524_() != player) continue;
                mob.m_21455_(true, true);
            }
            LevelUtil.warpServerPlayer(event.getPlayer(), false);
        }
        if (!player.m_6084_()) {
            player.invalidateCaps();
        }
    }

    @SubscribeEvent
    public static void onPlayerRespawn(PlayerEvent.PlayerRespawnEvent event) {
        if (event.isEndConquered()) {
            return;
        }
        Player player = event.getPlayer();
        player.m_21051_(Attributes.f_22283_).m_22100_(100.0);
        player.m_21051_(Attributes.f_22281_).m_22100_(2.0);
        player.m_21051_(Attributes.f_22276_).m_22100_(100.0);
        player.m_21153_(player.m_21233_());
        ServerPlayer p = (ServerPlayer)event.getPlayer();
        p.f_8921_ = 2;
        IPlayerData capP = PlayerData.get((Player)p);
        IActionTracker capA = ActionTracker.get((Entity)p);
        capP.addRevelatoryKnowledge(KnowledgeNF.ESSENCE.getId());
        capP.setStamina(AttributesNF.getMaxStamina((Player)p));
        capA.startAction(ActionsNF.EMPTY.getId());
        capA.setFrame(-1);
        capA.setStunFrame(-1);
        capP.setLastDodgeTick(-100);
        capP.setLastBlockTick(-100);
        capP.setClimbTicks(0);
        capP.setAirTicks(0);
        capP.setCrouchTicks(0);
        capP.setClimbing(false);
        capP.setLastMainItem();
        capP.setLastOffItem();
        NetworkHandler.toClient(p, new ActionTrackerToClient(capA.writeNBT(), p.m_142049_()));
        NetworkHandler.toClient(p, new PlayerDataToClient(capP.writeNBT(), p.m_142049_()));
    }

    @SubscribeEvent
    public static void onPlayerChangedDimension(PlayerEvent.PlayerChangedDimensionEvent event) {
        ServerPlayer player = (ServerPlayer)event.getPlayer();
        if (LevelData.isPresent(player.f_19853_)) {
            ILevelData capL = LevelData.get(player.f_19853_);
            NetworkHandler.toClient(player, new LevelDataToClient(capL.writeNBTSync(capL.writeNBTClientInit(new CompoundTag()))));
        }
        IPlayerData capP = PlayerData.get((Player)player);
        IActionTracker capA = ActionTracker.get((Entity)player);
        capP.setLastDodgeTick(-100);
        capP.setLastBlockTick(-100);
        capP.setClimbTicks(0);
        capP.setAirTicks(0);
        capP.setCrouchTicks(0);
        capP.setClimbing(false);
        capP.setLastMainItem();
        capP.setLastOffItem();
        NetworkHandler.toClient(player, new ActionTrackerToClient(capA.writeNBT(), player.m_142049_()));
        NetworkHandler.toClient(player, new PlayerDataToClient(capP.writeNBT(), player.m_142049_()));
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        ServerPlayer clone = (ServerPlayer)event.getPlayer();
        original.reviveCaps();
        IActionTracker oCapA = ActionTracker.get((Entity)original);
        IActionTracker cCapA = ActionTracker.get((Entity)clone);
        IPlayerData oCapP = PlayerData.get(original);
        IPlayerData cCapP = PlayerData.get((Player)clone);
        clone.f_36095_ = new PlayerInventoryContainer(clone.m_150109_(), !clone.f_19853_.m_5776_());
        clone.f_36096_ = clone.f_36095_;
        clone.m_143399_((AbstractContainerMenu)clone.f_36095_);
        clone.f_8921_ = 2;
        clone.f_36095_.m_38893_(CapabilityEventHandler.createKnowledgeListener(clone));
        clone.m_150109_().m_36006_(original.m_150109_());
        cCapP.getAccessoryInventory().replaceWith(oCapP.getAccessoryInventory());
        clone.f_36097_ = original.f_36097_;
        MobEffectInstance starvation = original.m_21124_((MobEffect)EffectsNF.STARVATION_1.get());
        if (starvation == null) {
            starvation = original.m_21124_((MobEffect)EffectsNF.STARVATION.get());
        }
        if (starvation != null) {
            clone.m_7292_(starvation);
            MobEffectInstance finalStarvation = starvation;
            clone.f_8924_.execute(() -> clone.f_8906_.m_141995_((Packet)new ClientboundUpdateMobEffectPacket(clone.m_142049_(), finalStarvation)));
        }
        if (!clone.m_7500_() && !clone.m_5833_()) {
            MobEffectInstance despair = original.m_21124_((MobEffect)EffectsNF.DESPAIR.get());
            if (despair == null) {
                if (event.isWasDeath()) {
                    newDespair = new MobEffectInstance((MobEffect)EffectsNF.DESPAIR.get(), 48000);
                    clone.m_7292_(newDespair);
                    clone.f_8924_.execute(() -> clone.f_8906_.m_141995_((Packet)new ClientboundUpdateMobEffectPacket(clone.m_142049_(), newDespair)));
                }
            } else {
                newDespair = !event.isWasDeath() ? despair : new MobEffectInstance((MobEffect)EffectsNF.DESPAIR.get(), 48000, Math.min(2, despair.m_19564_() + 1));
                clone.m_7292_(newDespair);
                clone.f_8924_.execute(() -> clone.f_8906_.m_141995_((Packet)new ClientboundUpdateMobEffectPacket(clone.m_142049_(), newDespair)));
            }
        }
        cCapP.readEncyclopediaNBT(oCapP.writeEncyclopediaNBT(new CompoundTag()));
        cCapP.setStamina(oCapP.getStamina());
        cCapA.startAction(ActionsNF.EMPTY.getId());
        cCapA.setFrame(-1);
        cCapA.setStunFrame(-1);
        cCapP.setLastDodgeTick(-100);
        cCapP.setLastBlockTick(-100);
        cCapP.setClimbTicks(0);
        cCapP.setAirTicks(0);
        cCapP.setCrouchTicks(0);
        cCapP.setClimbing(false);
        cCapP.setLastMainItem();
        cCapP.setLastOffItem();
        cCapP.setNeedsAttributeSelection(oCapP.needsAttributeSelection());
        for (PlayerAttribute attribute : PlayerAttribute.values()) {
            cCapP.setAttributePoints(attribute, oCapP.getAttributePoints(attribute));
        }
        original.invalidateCaps();
    }
}

