/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.event;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.math.Vector3d;
import com.mojang.math.Vector3f;
import frostnox.nightfall.Nightfall;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.Attack;
import frostnox.nightfall.action.HitData;
import frostnox.nightfall.action.player.IClientAction;
import frostnox.nightfall.block.block.sign.StandingSignBlockNF;
import frostnox.nightfall.block.block.sign.WallSignBlockNF;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.ChunkData;
import frostnox.nightfall.capability.GlobalChunkData;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.capability.IChunkData;
import frostnox.nightfall.capability.IGlobalChunkData;
import frostnox.nightfall.capability.ILevelData;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.client.EntityLightEngine;
import frostnox.nightfall.client.gui.screen.SignEditScreenNF;
import frostnox.nightfall.client.gui.screen.encyclopedia.EncyclopediaScreen;
import frostnox.nightfall.client.gui.screen.encyclopedia.EntryPuzzleScreen;
import frostnox.nightfall.client.gui.screen.item.ModifiableItemScreen;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.data.recipe.BuildingRecipe;
import frostnox.nightfall.entity.IEntityWithItem;
import frostnox.nightfall.item.IActionableItem;
import frostnox.nightfall.item.IWeaponItem;
import frostnox.nightfall.item.client.IModifiable;
import frostnox.nightfall.item.item.BuildingMaterialItem;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.GenericToServer;
import frostnox.nightfall.network.message.capability.ActionToServer;
import frostnox.nightfall.network.message.capability.ModifiableIndexToServer;
import frostnox.nightfall.network.message.entity.DodgeToServer;
import frostnox.nightfall.network.message.entity.HitTargetToServer;
import frostnox.nightfall.network.message.world.DigBlockToServer;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.registry.forge.EffectsNF;
import frostnox.nightfall.registry.forge.ParticleTypesNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.LevelUtil;
import frostnox.nightfall.util.data.TimedValue;
import frostnox.nightfall.util.math.BoundingSphere;
import frostnox.nightfall.util.math.Mat4f;
import frostnox.nightfall.util.math.Quat;
import frostnox.nightfall.world.Weather;
import frostnox.nightfall.world.inventory.PlayerInventoryContainer;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.ChatComponent;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.InventoryScreen;
import net.minecraft.client.gui.screens.inventory.SignEditScreen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.debug.DebugRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.DrawSelectionEvent;
import net.minecraftforge.client.event.FOVModifierEvent;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.client.event.ScreenOpenEvent;
import net.minecraftforge.client.event.sound.SoundEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ClientEventHandler {
    private static final int EMPTY = -1;
    private static final int LEFT = 0;
    private static final int RIGHT = 1;
    private static int click = -1;
    private static int clickCounter = 0;
    private static boolean flagAttack = false;
    private static boolean flagUse = false;
    private static final TimedValue<ActionType> actionBuffer = new TimedValue<ActionType>(ActionType.EMPTY, 7);
    private static final TimedValue<Integer> hotbarBuffer = new TimedValue<Integer>(-1, 10);
    private static final TimedValue<Boolean> crawlJumpBuffer = new TimedValue<Boolean>(false, 10);
    private static final TimedValue<Boolean> dodgeBuffer = new TimedValue<Boolean>(false, 7);
    private static final boolean[] heldKeys = new boolean[4];
    private static int modifyCounter = 0;
    private static long lastSprintTime = 0L;
    private static final double DODGE_FORCE = 0.8;
    private static double xDodge;
    private static double zDodge;
    private static boolean triedJump;
    private static boolean skipClickInputEvent;
    private static boolean wasAttackKeyDown;
    private static boolean retryPickBlock;
    private static boolean disabledSprint;

    private static void updateHand(Player player) {
        IActionTracker capA = ActionTracker.get((Entity)player);
        IPlayerData capP = PlayerData.get(player);
        if (capA.isInactive()) {
            if (ClientEngine.get().keyOffhand.m_90857_() && !player.m_21206_().m_41619_()) {
                if (capP.isMainhandActive()) {
                    NetworkHandler.toServer(new GenericToServer(NetworkHandler.Type.ACTIVATE_OFFHAND));
                    clickCounter = 0;
                }
                capP.setOffhandActive();
            } else {
                if (!capP.isMainhandActive()) {
                    NetworkHandler.toServer(new GenericToServer(NetworkHandler.Type.ACTIVATE_MAINHAND));
                    clickCounter = 0;
                }
                capP.setMainhandActive();
            }
        }
    }

    private static void sendServerAction(IActionTracker capA, IPlayerData capP) {
        if (capA.isQueued()) {
            NetworkHandler.toServer(new GenericToServer(NetworkHandler.Type.QUEUE_ACTION_TRACKER));
        } else {
            NetworkHandler.toServer(new ActionToServer(capP.isMainhandActive(), capA.getActionID()));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void updateClickInput(boolean fromClick) {
        block48: {
            IWeaponItem weapon;
            IPlayerData capP;
            IActionTracker capA;
            LocalPlayer player;
            block49: {
                Action action;
                block47: {
                    IWeaponItem weapon2;
                    Minecraft mc = Minecraft.m_91087_();
                    player = mc.f_91074_;
                    if (player == null) return;
                    if (!player.m_6084_()) return;
                    if (player.m_6117_()) return;
                    if (player.m_108637_()) return;
                    if (mc.m_91104_()) {
                        return;
                    }
                    ClientEventHandler.updateHotbarBuffer((Player)player);
                    capA = ActionTracker.get((Entity)player);
                    capP = PlayerData.get((Player)player);
                    if (capA.isStunned() && capA.getStunFrame() == 1) {
                        actionBuffer.reset();
                        clickCounter = 0;
                    }
                    if (modifyCounter <= 0) {
                        ClientEventHandler.updateHand((Player)player);
                    }
                    ItemStack itemStack = player.m_21120_(capP.getActiveHand());
                    if (mc.f_91066_.f_92096_.m_90857_() || flagAttack) {
                        click = 0;
                    } else if (mc.f_91066_.f_92095_.m_90857_() || flagUse) {
                        click = 1;
                    } else if (clickCounter == 0 && itemStack.m_41720_() instanceof IWeaponItem) {
                        click = -1;
                    }
                    Item item = itemStack.m_41720_();
                    if (item instanceof IWeaponItem) {
                        weapon2 = (IWeaponItem)item;
                        if (fromClick && flagUse && ((Action)((Object)weapon2.getActionSet((Player)player).defaultTech.get())).getChargeState() == 0) {
                            return;
                        }
                    } else if (!(itemStack.m_41720_() instanceof IActionableItem)) {
                        actionBuffer.reset();
                    }
                    if (click == -1 && (mc.f_91066_.f_92096_.m_90857_() || mc.f_91066_.f_92095_.m_90857_()) || (click != 0 ? mc.f_91066_.f_92095_.m_90857_() : mc.f_91066_.f_92096_.m_90857_()) || fromClick) {
                        block46: {
                            if (!(player.m_21120_(capP.getActiveHand()).m_41720_() instanceof IWeaponItem)) {
                                if (fromClick && click == 0) {
                                    if (capA.isCharging()) {
                                        capA.queue();
                                        NetworkHandler.toServer(new GenericToServer(NetworkHandler.Type.QUEUE_ACTION_TRACKER));
                                    }
                                    clickCounter = 0;
                                }
                                if (fromClick && click == 0 && !(player.m_21206_().m_41720_() instanceof IActionableItem)) {
                                    capP.setMainhandActive();
                                    NetworkHandler.toServer(new GenericToServer(NetworkHandler.Type.ACTIVATE_MAINHAND));
                                    if (!(player.m_21205_().m_41720_() instanceof IWeaponItem)) return;
                                    weapon2 = (IWeaponItem)player.m_21205_().m_41720_();
                                    break block46;
                                } else {
                                    if (!(itemStack.m_41720_() instanceof IActionableItem)) return;
                                    if (!fromClick && click == 0 && itemStack.m_41720_() instanceof IWeaponItem) {
                                        ++clickCounter;
                                    }
                                    if (click != 0) return;
                                    if (capA.isInactive()) return;
                                    if (!(player.m_21120_(capP.getOppositeActiveHand()).m_41720_() instanceof IWeaponItem)) return;
                                    actionBuffer.set(clickCounter > 3 ? ActionType.ALTERNATE : ActionType.BASIC);
                                    return;
                                }
                            }
                            weapon2 = (IWeaponItem)player.m_21120_(capP.getActiveHand()).m_41720_();
                        }
                        if (!(mc.f_91080_ != null || fromClick && clickCounter != 0)) {
                            if (click == 0 && wasAttackKeyDown && player.f_20911_ && fromClick) {
                                actionBuffer.set(ActionType.BASIC);
                            }
                            if (click == 0 || !player.f_20911_) {
                                ++clickCounter;
                            }
                        }
                        if (click == 0 && (player.m_20089_() == Pose.SWIMMING || player.m_20089_() == Pose.FALL_FLYING)) {
                            if (weapon2.tryCrawlingAttack((Player)player)) {
                                ClientEventHandler.sendServerAction(capA, capP);
                                return;
                            }
                            if (crawlJumpBuffer.getValue() != false) return;
                            if (!capP.isCrawling()) return;
                            actionBuffer.set(ActionType.CRAWL);
                            return;
                        }
                        if (clickCounter > 3 && click == 0) {
                            if (capA.isInactive()) {
                                if (!weapon2.tryAlternateAttack((Player)player)) return;
                                ClientEventHandler.sendServerAction(capA, capP);
                                return;
                            }
                            if (mc.f_91066_.f_92095_.m_90857_()) return;
                            if (capA.getActionID().equals((Object)weapon2.getActionSet((Player)player).defaultTech.getId()) && !capA.isInactive()) {
                                if (!weapon2.tryTechnique((Player)player)) return;
                                ClientEventHandler.sendServerAction(capA, capP);
                                return;
                            }
                            if (!weapon2.tryBasicAttack((Player)player)) return;
                            ClientEventHandler.sendServerAction(capA, capP);
                            return;
                        }
                        if (clickCounter <= 1) return;
                        if (click != 1) return;
                        if (capA.isInactive()) {
                            if (!player.f_20911_) {
                                skipClickInputEvent = true;
                                Minecraft.m_91087_().m_91277_();
                                skipClickInputEvent = false;
                            }
                            if (!player.f_20911_ && weapon2.tryTechnique((Player)player)) {
                                ClientEventHandler.sendServerAction(capA, capP);
                                return;
                            }
                            if (player.f_20911_) return;
                            actionBuffer.set(ActionType.TECHNIQUE);
                            return;
                        }
                        if (weapon2.tryAlternateAttack((Player)player)) {
                            ClientEventHandler.sendServerAction(capA, capP);
                            return;
                        }
                        actionBuffer.set(ActionType.TECHNIQUE);
                        return;
                    }
                    action = capA.getAction();
                    if (!(player.m_21120_(capP.getActiveHand()).m_41720_() instanceof IWeaponItem)) {
                        if (click == 0 && !(player.m_21206_().m_41720_() instanceof IActionableItem) && player.m_21205_().m_41720_() instanceof IWeaponItem) {
                            weapon = (IWeaponItem)player.m_21205_().m_41720_();
                            capP.setMainhandActive();
                            NetworkHandler.toServer(new GenericToServer(NetworkHandler.Type.ACTIVATE_MAINHAND));
                            break block47;
                        } else {
                            if (!capA.isCharging()) return;
                            capA.queue();
                            NetworkHandler.toServer(new GenericToServer(NetworkHandler.Type.QUEUE_ACTION_TRACKER));
                            return;
                        }
                    }
                    weapon = (IWeaponItem)player.m_21120_(capP.getActiveHand()).m_41720_();
                }
                if (capA.getState() != action.getChargeState()) break block49;
                if (capA.getActionID().equals((Object)weapon.getActionSet((Player)player).defaultTech.getId()) || weapon.getActionSet((Player)player).recipeAction != null && capA.getActionID().equals((Object)weapon.getActionSet((Player)player).recipeAction.getId())) {
                    if (weapon.tryTechnique((Player)player)) {
                        NetworkHandler.toServer(new GenericToServer(NetworkHandler.Type.QUEUE_ACTION_TRACKER));
                    }
                    break block48;
                } else if (weapon.tryAlternateAttack((Player)player)) {
                    NetworkHandler.toServer(new GenericToServer(NetworkHandler.Type.QUEUE_ACTION_TRACKER));
                }
                break block48;
            }
            if (clickCounter > 0 && !player.f_20911_) {
                if (click == 0 && actionBuffer.getValue() != ActionType.CRAWL) {
                    if (weapon.tryBasicAttack((Player)player)) {
                        ClientEventHandler.sendServerAction(capA, capP);
                    } else {
                        actionBuffer.set(ActionType.BASIC);
                    }
                } else if (click == 1) {
                    if ((capA.isInactive() || clickCounter > 1) && weapon.tryTechnique((Player)player)) {
                        ClientEventHandler.sendServerAction(capA, capP);
                    } else {
                        actionBuffer.set(ActionType.TECHNIQUE);
                    }
                }
            }
        }
        clickCounter = 0;
    }

    @SubscribeEvent
    public static void onClientTickEvent(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || mc.m_91104_()) {
            return;
        }
        if (!player.m_6084_()) {
            ClientEngine.get().lastDashTick = -100;
            return;
        }
        IActionTracker capA = ActionTracker.get((Entity)player);
        IPlayerData capP = PlayerData.get((Player)player);
        ClientLevel level = player.f_108545_;
        if (event.phase == TickEvent.Phase.START) {
            Item item;
            if (LevelUtil.disallowPlayerSprint((Player)player) && !player.m_21023_(MobEffects.f_19610_)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19610_));
                disabledSprint = true;
            }
            ClientEngine.get().tickStart();
            EntityLightEngine.get().tickStart();
            retryPickBlock = true;
            crawlJumpBuffer.tick();
            if (crawlJumpBuffer.isActive() && capA.isInactive() && (player.m_20089_() == Pose.SWIMMING || player.m_20089_() == Pose.FALL_FLYING)) {
                capP.setCrawling(false);
                NetworkHandler.toServer(new GenericToServer(NetworkHandler.Type.STOP_CRAWLING));
                crawlJumpBuffer.reset();
                if (actionBuffer.getValue() == ActionType.CRAWL) {
                    actionBuffer.reset();
                }
            }
            dodgeBuffer.tick();
            if (dodgeBuffer.isActive() && !capA.isStunned() && ClientEventHandler.checkDodgeConditions((Player)player)) {
                ClientEventHandler.handleDodge(player);
            }
            hotbarBuffer.tick();
            ClientEventHandler.updateHotbarBuffer((Player)player);
            actionBuffer.tick();
            if (actionBuffer.isActive() && capA.getAction().getChargeState() != capA.getState() && !player.f_20911_ && (item = player.m_21120_(capP.getActiveHand()).m_41720_()) instanceof IWeaponItem) {
                IWeaponItem weapon = (IWeaponItem)item;
                switch (actionBuffer.getValue()) {
                    case BASIC: {
                        if (!weapon.tryBasicAttack((Player)player)) break;
                        ClientEventHandler.sendServerAction(capA, capP);
                        actionBuffer.reset();
                        break;
                    }
                    case ALTERNATE: {
                        if (!weapon.tryAlternateAttack((Player)player)) break;
                        ClientEventHandler.sendServerAction(capA, capP);
                        actionBuffer.reset();
                        break;
                    }
                    case TECHNIQUE: {
                        if (!player.f_20911_ && capA.isInactive()) {
                            skipClickInputEvent = true;
                            Minecraft.m_91087_().m_91277_();
                            skipClickInputEvent = false;
                            break;
                        }
                        if (((Action)((Object)weapon.getActionSet((Player)player).defaultTech.get())).getChargeState() == 0 || !weapon.tryTechnique((Player)player)) break;
                        ClientEventHandler.sendServerAction(capA, capP);
                        actionBuffer.reset();
                        break;
                    }
                    case CRAWL: {
                        if (!weapon.tryCrawlingAttack((Player)player)) break;
                        ClientEventHandler.sendServerAction(capA, capP);
                        actionBuffer.reset();
                    }
                }
            }
            if (!capA.isInactive() && player.m_21120_(capP.getActiveHand()).m_41619_()) {
                ClientEventHandler.resetClick();
                actionBuffer.reset();
            }
        } else {
            ILevelData capL;
            Action action;
            Object sphere4;
            Object sphere3;
            if (disabledSprint) {
                player.m_21195_(MobEffects.f_19610_);
                disabledSprint = false;
            }
            ClientEngine.get().tickEnd();
            MobEffectInstance infested = mc.f_91074_.m_21124_((MobEffect)EffectsNF.INFESTED.get());
            if (infested != null && infested.m_19557_() % 37 == 3) {
                ClientEngine.get().playEntitySound((Entity)mc.f_91074_, (SoundEvent)SoundsNF.SKARA_SWARM_AMBIENT.get(), SoundSource.PLAYERS, 1.0f, 0.95f + level.f_46441_.nextFloat() * 0.1f);
            }
            if (mc.f_91074_.f_19797_ - capP.getLastDodgeTick() == 1) {
                ClientEventHandler.doPlayerDodge(mc.f_91074_);
            } else if (mc.f_91074_.f_19797_ - capP.getLastDodgeTick() == 2) {
                Vec3 motion = mc.f_91074_.m_20184_();
                mc.f_91074_.m_6001_(xDodge * 0.8 * 0.25, motion.f_82480_, zDodge * 0.8 * 0.25);
            }
            capP.tickStamina();
            if (capA.isStunned()) {
                if (mc.f_91080_ instanceof AbstractContainerScreen) {
                    mc.f_91080_.m_7379_();
                }
                mc.f_91066_.f_92091_.m_7249_(false);
                if (capA.getStunFrame() == 0) {
                    mc.f_91066_.f_92096_.m_7249_(false);
                    mc.f_91066_.f_92095_.m_7249_(false);
                }
            }
            if (mc.f_91066_.f_92089_.m_90857_() && !player.m_150110_().f_35935_ && capA.isInactive() && capP.getStamina() > 0.0 && !player.m_6147_() && (player.m_20089_() == Pose.STANDING || player.m_20089_() == Pose.CROUCHING) && !player.m_20096_() && !player.m_20069_() && !player.m_20077_() && (capP.isClimbing() || player.f_19862_ && player.m_20184_().m_7098_() <= 0.0) && player.f_19797_ - capP.getLastDodgeTick() > 2 && !player.m_6117_()) {
                BoundingSphere sphere1 = new BoundingSphere(0.0, player.m_20089_() == Pose.CROUCHING ? 0.2f : 0.1f, 0.3f, 0.45f);
                BoundingSphere sphere2 = new BoundingSphere(0.0, -(player.m_20089_() == Pose.CROUCHING ? 0.1f : 0.3f), 0.3f, 0.45f);
                sphere3 = new BoundingSphere(0.0, -(player.m_20089_() == Pose.CROUCHING ? 0.45f : 0.8f), 0.3f, 0.45f);
                sphere4 = new BoundingSphere(0.0, -(player.m_20089_() == Pose.CROUCHING ? 0.75f : 1.2f), 0.3f, 0.45f);
                Mat4f userMatrix1 = new Mat4f(new Quat(player.m_5675_(1.0f), Vector3f.f_122225_, true));
                sphere1.transform(userMatrix1);
                sphere2.transform(userMatrix1);
                ((BoundingSphere)sphere3).transform(userMatrix1);
                ((BoundingSphere)sphere4).transform(userMatrix1);
                sphere1.xPos += player.m_20185_();
                sphere2.xPos += player.m_20185_();
                ((BoundingSphere)sphere3).xPos += player.m_20185_();
                ((BoundingSphere)sphere4).xPos += player.m_20185_();
                sphere1.yPos += player.m_20188_();
                sphere2.yPos += player.m_20188_();
                ((BoundingSphere)sphere3).yPos += player.m_20188_();
                ((BoundingSphere)sphere4).yPos += player.m_20188_();
                sphere1.zPos += player.m_20189_();
                sphere2.zPos += player.m_20189_();
                ((BoundingSphere)sphere3).zPos += player.m_20189_();
                ((BoundingSphere)sphere4).zPos += player.m_20189_();
                Vector3d hitCoords = new Vector3d(0.0, -1.0, 0.0);
                double speed = player.m_21133_(Attributes.f_22279_) * 10.0;
                if (sphere1.isSpaceClimbable((LivingEntity)player, hitCoords)) {
                    velocity = player.m_20184_();
                    if (velocity.f_82480_ < 1.0 && velocity.f_82480_ > -1.0) {
                        capP.sendClimbPosition(hitCoords);
                        if (!capP.isClimbing()) {
                            capP.setClimbing(true);
                            NetworkHandler.toServer(new GenericToServer(NetworkHandler.Type.START_CLIMBING));
                        }
                        y = player.f_19862_ ? (LevelUtil.isPositionFullyClimbable((LivingEntity)player, hitCoords) ? 0.1 : 0.07) : (LevelUtil.isPositionFullyClimbable((LivingEntity)player, hitCoords) && !player.m_6047_() ? -0.1 : 0.0);
                        player.m_20334_(velocity.f_82479_ * 0.9, y * speed, velocity.f_82481_ * 0.9);
                    }
                } else if (sphere2.isSpaceClimbable((LivingEntity)player, hitCoords)) {
                    velocity = player.m_20184_();
                    y = velocity.f_82480_;
                    if (velocity.f_82480_ < 1.0 && velocity.f_82480_ > -1.0) {
                        capP.sendClimbPosition(hitCoords);
                        if (!capP.isClimbing()) {
                            capP.setClimbing(true);
                            NetworkHandler.toServer(new GenericToServer(NetworkHandler.Type.START_CLIMBING));
                        }
                        y = player.f_19862_ ? (LevelUtil.isPositionFullyClimbable((LivingEntity)player, hitCoords) ? 0.1 : (sphere1.isSpaceObstructed((LivingEntity)player, new BlockPos(hitCoords.f_86214_, hitCoords.f_86215_ + 1.0, hitCoords.f_86216_)) ? 0.0 : 0.07)) : (LevelUtil.isPositionFullyClimbable((LivingEntity)player, hitCoords) && !player.m_6047_() ? Math.max(y + 0.0784 - 0.1, -0.1) : Math.max(y + 0.0784 - 0.025, -0.025));
                        player.m_20334_(velocity.f_82479_ * 0.9, y * speed, velocity.f_82481_ * 0.9);
                    }
                } else if (capP.isClimbing() && (((BoundingSphere)sphere3).isSpaceClimbable((LivingEntity)player, hitCoords) || ((BoundingSphere)sphere4).isSpaceClimbable((LivingEntity)player, hitCoords))) {
                    velocity = player.m_20184_();
                    y = velocity.f_82480_;
                    if (velocity.f_82480_ < 1.0 && velocity.f_82480_ > -1.0) {
                        capP.sendClimbPosition(hitCoords);
                        if (player.f_19862_) {
                            double xSize = player.m_142469_().m_82362_() / 2.0;
                            double ySize = player.m_142469_().m_82376_() - 0.01;
                            double zSize = player.m_142469_().m_82385_() / 2.0;
                            Iterable collisions = level.m_186434_(null, new AABB(hitCoords.f_86214_ - xSize, hitCoords.f_86215_, hitCoords.f_86216_ - zSize, hitCoords.f_86214_ + xSize, hitCoords.f_86215_ + ySize, hitCoords.f_86216_ + zSize));
                            y = collisions.iterator().hasNext() ? 0.07 : 0.14;
                        } else {
                            y = Math.max(y + 0.0784 - 0.05, -0.05);
                        }
                        player.m_20334_(velocity.f_82479_ * 0.9, y * speed, velocity.f_82481_ * 0.9);
                    }
                } else {
                    capP.setClimbing(false);
                    NetworkHandler.toServer(new GenericToServer(NetworkHandler.Type.STOP_CLIMBING));
                }
            } else if (capP.isClimbing()) {
                capP.setClimbing(false);
                NetworkHandler.toServer(new GenericToServer(NetworkHandler.Type.STOP_CLIMBING));
            }
            if (!capP.isClimbing() && capP.getClimbTicks() <= 0) {
                capP.setClimbPosition(new Vector3d(0.0, -1.0, 0.0));
            }
            if (player.m_20143_() && !mc.m_91104_()) {
                player.m_20334_(player.m_20184_().f_82479_, player.m_20184_().f_82480_ * 1.1722446, player.m_20184_().f_82481_);
            }
            ClientEventHandler.updateClickInput(false);
            ItemStack stack = player.m_21120_(capP.getActiveHand());
            if (modifyCounter > 0) {
                IModifiable modifiable;
                Optional<Screen> screen;
                sphere3 = stack.m_41720_();
                if (sphere3 instanceof IModifiable && (screen = (modifiable = (IModifiable)sphere3).modifyContinueClient(mc, stack, (Player)player, capP.getActiveHand(), modifyCounter)).isPresent()) {
                    mc.m_91152_(screen.get());
                }
                ++modifyCounter;
            }
            if ((action = capA.getAction()) instanceof IClientAction) {
                IClientAction clientAction = (IClientAction)((Object)action);
                clientAction.onClientTick((Player)player);
            }
            if (capA.isDamaging() && capP.getHitStopFrame() == -1 && (sphere4 = stack.m_41720_()) instanceof IActionableItem) {
                IActionableItem item = (IActionableItem)sphere4;
                if (action instanceof Attack) {
                    Attack attack = (Attack)action;
                    if (item.hasAction(capA.getActionID(), (Player)player) && capA.getLivingEntitiesHit() < attack.getMaxTargets()) {
                        boolean firstHit = capA.getHitEntities().isEmpty();
                        List<HitData> targets = capA.getEntitiesInAttack(attack, 0.5f);
                        if (capA.getLivingEntitiesHit() < attack.getMaxTargets()) {
                            targets.addAll(capA.getEntitiesInAttack(attack, 1.0f));
                        }
                        if (!targets.isEmpty()) {
                            if (firstHit) {
                                capA.setHitPause(0.0f);
                            }
                            for (HitData hitData : targets) {
                                NetworkHandler.toServer(new HitTargetToServer(hitData));
                            }
                        }
                    }
                }
                if (action.canHarvest() && ClientEngine.get().microHitResult == null && capA.getLivingEntitiesHit() == 0 && !capP.hasDugBlock() && capA.getFrame() == action.getBlockHitFrame(capA.getState(), (LivingEntity)player) && mc.f_91077_ != null && mc.f_91077_.m_6662_() == HitResult.Type.BLOCK) {
                    boolean canMineAny;
                    BlockPos center = ((BlockHitResult)mc.f_91077_).m_82425_();
                    boolean bl = canMineAny = !action.harvestableBlocks.equals(TagsNF.MINEABLE_WITH_SICKLE) && !action.harvestableBlocks.equals(TagsNF.MINEABLE_WITH_DAGGER) && !action.harvestableBlocks.equals((Object)BlockTags.f_144280_);
                    if (canMineAny || action.canHarvest(level.m_8055_(center))) {
                        capP.setDugBlock(true);
                        boolean facingX = player.m_6350_().m_122434_().equals((Object)Direction.Axis.X);
                        int xRange = stack.m_204117_(TagsNF.SICKLE) && (!action.isChargeable() || !facingX) ? 1 : 0;
                        int zRange = stack.m_204117_(TagsNF.SICKLE) && (!action.isChargeable() || facingX) ? 1 : 0;
                        int yRange = stack.m_204117_(TagsNF.SICKLE) && action.isChargeable() ? 1 : 0;
                        for (BlockPos pos : BlockPos.m_121976_((int)(center.m_123341_() - xRange), (int)(center.m_123342_() - yRange), (int)(center.m_123343_() - zRange), (int)(center.m_123341_() + xRange), (int)(center.m_123342_() + yRange), (int)(center.m_123343_() + zRange))) {
                            BlockState block = level.m_8055_(pos);
                            if (!canMineAny && !action.canHarvest(block)) continue;
                            IGlobalChunkData chunkData = GlobalChunkData.get(level.m_46745_(pos));
                            float progress = chunkData.getBreakProgress(pos) + level.m_8055_(pos).m_60625_((Player)player, (BlockGetter)level, pos) * AttributesNF.getStrengthMultiplier((LivingEntity)player) * capA.getChargeDestroyProgressMultiplier();
                            block.m_60686_((Level)level, pos, (Player)player);
                            if (progress >= 1.0f) {
                                if (block.onDestroyedByPlayer((Level)level, pos, (Player)player, false, block.m_60819_())) {
                                    block.m_60734_().m_6786_((LevelAccessor)level, pos, block);
                                    ClientEngine.get().visuallyDestroyBlock(pos, -1);
                                    chunkData.removeBreakProgress(pos);
                                }
                            } else {
                                ClientEngine.get().visuallyDestroyBlock(pos, (int)(progress * 10.0f) - 1);
                                chunkData.setBreakProgress(pos.m_7949_(), progress);
                            }
                            if (!pos.equals((Object)center)) continue;
                            if (progress < 1.0f && !block.m_60767_().m_76336_() && !stack.m_204117_(TagsNF.NO_HITSTOP)) {
                                capP.setHitStopFrame(capA.getFrame());
                            }
                            for (int i = 0; i < player.m_21187_().nextInt() % 3 + 6; ++i) {
                                mc.f_91061_.addBlockHitEffects(pos, (BlockHitResult)mc.f_91077_);
                            }
                            SoundType sound = level.m_8055_(pos).getSoundType((LevelReader)level, pos, (Entity)player);
                            level.m_5594_((Player)player, pos, sound.m_56778_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.75f);
                            NetworkHandler.toServer(new DigBlockToServer(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
                        }
                    }
                }
            }
            if (LevelData.isPresent((Level)level) && mc.f_91075_ != null && (capL = LevelData.get((Level)level)).getGlobalWeatherIntensity() > -0.15f) {
                int lastSectionZ;
                BlockPos camPos = mc.f_91075_.m_146901_();
                Vec3 camVec = mc.f_91075_.m_146892_();
                int lastSectionX = SectionPos.m_123171_((int)camPos.m_123341_());
                LevelChunk chunk = level.m_6325_(lastSectionX, lastSectionZ = SectionPos.m_123171_((int)camPos.m_123343_()));
                if (!chunk.m_6430_()) {
                    IChunkData capC = ChunkData.get(chunk);
                    BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
                    for (int i = 0; i < (int)(Mth.m_14036_((float)capL.getWeatherIntensity(capC, camPos), (float)0.0f, (float)1.0f) * 250.0f); ++i) {
                        double radius = 16.0 + 16.0 * level.f_46441_.nextDouble();
                        float theta = (float)Math.PI * 2 * level.f_46441_.nextFloat();
                        float phi = (float)Math.acos(2.0 * level.f_46441_.nextDouble() - 1.0);
                        float phiSin = Mth.m_14031_((float)phi);
                        double x = camVec.f_82479_ + radius * (double)phiSin * (double)Mth.m_14089_((float)theta);
                        double y = camVec.f_82480_ + radius * (double)phiSin * (double)Mth.m_14031_((float)theta);
                        double z = camVec.f_82481_ + radius * (double)Mth.m_14089_((float)phi);
                        pos.m_122178_(Mth.m_14107_((double)x), Mth.m_14107_((double)y), Mth.m_14107_((double)z));
                        int sectionX = SectionPos.m_123171_((int)pos.m_123341_());
                        int sectionZ = SectionPos.m_123171_((int)pos.m_123343_());
                        if (sectionX != lastSectionX || sectionZ != lastSectionZ) {
                            chunk = level.m_6325_(sectionX, sectionZ);
                            lastSectionX = sectionX;
                            lastSectionZ = sectionZ;
                            if (chunk.m_6430_()) continue;
                            capC = ChunkData.get(chunk);
                        }
                        if (chunk.m_6430_() || chunk.m_5885_(Heightmap.Types.MOTION_BLOCKING, pos.m_123341_() & 0xF, pos.m_123343_() & 0xF) >= pos.m_123342_()) continue;
                        Weather localWeather = capL.getWeather(capC, (BlockPos)pos);
                        if (localWeather == Weather.RAIN) {
                            level.m_7106_((ParticleOptions)ParticleTypesNF.RAIN.get(), x, y, z, 0.0, 0.0, 0.0);
                            continue;
                        }
                        if (localWeather != Weather.SNOW || !(level.f_46441_.nextFloat() < 0.19f)) continue;
                        level.m_7106_((ParticleOptions)ParticleTypesNF.SNOW.get(), x, y, z, 0.0, 0.0, 0.0);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onSoundSourceEvent(SoundEvent.SoundSourceEvent event) {
        ResourceLocation loc = event.getSound().m_7904_();
        if (loc.equals((Object)SoundEvents.f_12323_.m_11660_()) || loc.equals((Object)SoundEvents.f_12322_.m_11660_())) {
            event.getEngine().f_120217_.m_120399_(event.getSound());
        }
    }

    @SubscribeEvent
    public static void onDrawSelectionEvent(DrawSelectionEvent event) {
        if (ClientEngine.get().microHitResult != null) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onKeyInput(InputEvent event) {
        int key;
        int action = 0;
        if (event instanceof InputEvent.ClickInputEvent) {
            InputEvent.ClickInputEvent clickEvent = (InputEvent.ClickInputEvent)event;
            key = clickEvent.getKeyMapping().getKey().m_84873_();
            if (clickEvent.isAttack() || clickEvent.isUseItem()) {
                Minecraft mc = Minecraft.m_91087_();
                if (mc.f_91074_ != null && !mc.f_91074_.m_150110_().f_35937_ && mc.f_91077_ != null && mc.f_91077_.m_6662_() == HitResult.Type.ENTITY) {
                    double reach = Math.max(1.0, mc.f_91074_.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_() - 2.0);
                    if (mc.f_91077_.m_82450_().m_82557_(mc.f_91074_.m_20299_(ClientEngine.get().getPartialTick())) > reach * reach) {
                        mc.f_91077_ = BlockHitResult.m_82426_((Vec3)mc.f_91077_.m_82450_(), (Direction)Direction.UP, (BlockPos)BlockPos.f_121853_);
                        return;
                    }
                }
            }
        } else if (event instanceof InputEvent.KeyInputEvent) {
            InputEvent.KeyInputEvent keyEvent = (InputEvent.KeyInputEvent)event;
            action = keyEvent.getAction();
            key = keyEvent.getKey();
        } else if (event instanceof InputEvent.MouseInputEvent) {
            InputEvent.MouseInputEvent mouseEvent = (InputEvent.MouseInputEvent)event;
            action = mouseEvent.getAction();
            key = mouseEvent.getButton();
        } else {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer p = mc.f_91074_;
        if (key == 292) {
            if (p == null || !p.m_6084_() || !p.m_7500_()) {
                mc.f_91066_.f_92064_ = false;
                mc.f_91066_.f_92065_ = false;
            }
            return;
        }
        if (p == null || !p.m_6084_()) {
            return;
        }
        IActionTracker capA = ActionTracker.get((Entity)p);
        IPlayerData capP = PlayerData.get((Player)p);
        if (key == mc.f_91066_.f_92096_.getKey().m_84873_()) {
            if (mc.f_91066_.f_92096_.m_90857_()) {
                wasAttackKeyDown = action == 1;
            } else if (action == 0) {
                wasAttackKeyDown = false;
            }
        } else if (key == ClientEngine.get().keyDash.getKey().m_84873_() && action != 0) {
            for (int i = 0; i < 4; ++i) {
                ClientEventHandler.heldKeys[i] = false;
            }
            if (mc.f_91066_.f_92085_.m_90857_()) {
                ClientEventHandler.heldKeys[0] = true;
            }
            if (mc.f_91066_.f_92087_.m_90857_()) {
                ClientEventHandler.heldKeys[1] = true;
            }
            if (mc.f_91066_.f_92088_.m_90857_()) {
                ClientEventHandler.heldKeys[2] = true;
            }
            if (mc.f_91066_.f_92086_.m_90857_()) {
                ClientEventHandler.heldKeys[3] = true;
            }
            if (!ClientEventHandler.checkBooleanArray(heldKeys)) {
                ClientEventHandler.heldKeys[1] = true;
            }
            if (!(!ClientEventHandler.checkDodgeConditions((Player)p) || mc.f_91066_.f_92085_.m_90857_() && mc.f_91066_.f_92087_.m_90857_() || mc.f_91066_.f_92088_.m_90857_() && mc.f_91066_.f_92086_.m_90857_())) {
                if (ActionTracker.get((Entity)p).isStunned()) {
                    dodgeBuffer.set(true);
                    return;
                }
                ClientEventHandler.handleDodge(p);
            }
        } else if (key == ClientEngine.get().keyOffhand.getKey().m_84873_()) {
            if (modifyCounter <= 0) {
                ClientEventHandler.updateHand((Player)p);
            }
        } else if (key == ClientEngine.get().keyEncyclopedia.getKey().m_84873_() && ClientEngine.get().keyEncyclopedia.m_90859_()) {
            if (mc.f_91080_ == null) {
                mc.m_91152_((Screen)new EncyclopediaScreen());
            }
        } else if (key == ClientEngine.get().keyModify.getKey().m_84873_() && action != 2) {
            InteractionHand hand = PlayerData.get((Player)p).getActiveHand();
            ItemStack item = p.m_21120_(hand);
            if (action == 0) {
                Item item2 = item.m_41720_();
                if (item2 instanceof IModifiable) {
                    IModifiable modifiable = (IModifiable)item2;
                    modifiable.modifyReleaseClient(mc, item, (Player)p, hand, modifyCounter);
                }
                modifyCounter = 0;
            } else {
                IModifiable modifiable;
                Optional<Screen> screen;
                modifyCounter = 1;
                Item item3 = item.m_41720_();
                if (item3 instanceof IModifiable && (screen = (modifiable = (IModifiable)item3).modifyStartClient(mc, item, (Player)p, hand)).isPresent()) {
                    mc.m_91152_(screen.get());
                }
            }
        } else if (key == mc.f_91066_.f_92090_.getKey().m_84873_() && action != 2 && mc.f_91080_ == null) {
            if (action == 1) {
                long sprintTime = System.currentTimeMillis();
                if (!(sprintTime - lastSprintTime >= 250L || p.m_20089_() == Pose.FALL_FLYING || capP.isCrawling() || p.m_5833_() || p.m_150110_().f_35935_ || !capA.isInactive() && !capA.getAction().isInterruptible() || p.m_20159_() || p.m_204029_(FluidTags.f_13131_))) {
                    capP.setCrawling(true);
                    NetworkHandler.toServer(new GenericToServer(NetworkHandler.Type.START_CRAWLING));
                    p.m_20124_(Pose.SWIMMING);
                    p.setForcedPose(Pose.SWIMMING);
                }
                lastSprintTime = sprintTime;
            }
        } else if (key == mc.f_91066_.f_92089_.getKey().m_84873_() && mc.f_91080_ == null) {
            if (capP.isCrawling() && p.m_20998_(ClientEngine.get().getPartialTick()) > 0.25f && (capA.isInactive() || capA.getAction().isInterruptible())) {
                mc.f_91066_.f_92089_.m_7249_(false);
                capP.setCrawling(false);
                NetworkHandler.toServer(new GenericToServer(NetworkHandler.Type.STOP_CRAWLING));
                p.setForcedPose(null);
            }
        } else {
            if (p.m_6117_() || mc.m_91104_() || mc.f_91080_ != null) {
                return;
            }
            if (!capA.isInactive()) {
                int index = -1;
                for (int i = 0; i < mc.f_91066_.f_92056_.length; ++i) {
                    if (mc.f_91066_.f_92056_[i].getKey().m_84873_() != key) continue;
                    index = i;
                }
                if (index != -1) {
                    hotbarBuffer.set(index);
                    actionBuffer.reset();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onClickInputEvent(InputEvent.ClickInputEvent event) {
        if (skipClickInputEvent) {
            return;
        }
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || !player.m_6084_()) {
            return;
        }
        if (mc.f_91080_ instanceof ModifiableItemScreen) {
            event.setSwingHand(false);
            event.setCanceled(true);
            return;
        }
        IActionTracker capA = ActionTracker.get((Entity)player);
        IPlayerData capP = PlayerData.get((Player)player);
        if (event.isPickBlock()) {
            ItemStack heldItem;
            Item item;
            if (retryPickBlock) {
                KeyMapping.m_90835_((InputConstants.Key)mc.f_91066_.f_92097_.getKey());
                retryPickBlock = false;
            }
            if ((item = (heldItem = player.m_21120_(capP.getActiveHand())).m_41720_()) instanceof BuildingMaterialItem) {
                BuildingMaterialItem buildingItem = (BuildingMaterialItem)item;
                if (mc.f_91077_ != null) {
                    HitResult hitResult = mc.f_91077_;
                    if (hitResult instanceof BlockHitResult) {
                        BlockHitResult blockHit = (BlockHitResult)hitResult;
                        pos = blockHit.m_82425_();
                        BlockState state = player.f_19853_.m_8055_((BlockPos)pos);
                        ItemStack pickItem = state.getCloneItemStack((HitResult)blockHit, (BlockGetter)player.f_19853_, (BlockPos)pos, (Player)player);
                        if (pickItem.m_41720_() == heldItem.m_41720_()) {
                            List<BuildingRecipe> recipes = buildingItem.getRecipes(player.f_19853_, (Player)player);
                            Block block = state.m_60734_();
                            if (block instanceof WallSignBlockNF) {
                                block = (Block)ForgeRegistries.BLOCKS.getValue(ResourceLocation.fromNamespaceAndPath((String)block.getRegistryName().m_135827_(), (String)block.getRegistryName().m_135815_().replace("wall", "standing")));
                            }
                            for (int i = 0; i < recipes.size(); ++i) {
                                BlockItem blockItem;
                                BuildingRecipe recipe = recipes.get(i);
                                Item item2 = recipe.output;
                                if (!(item2 instanceof BlockItem) || (blockItem = (BlockItem)item2).m_40614_() != block) continue;
                                ClientEngine.get().setModifiableIndex(capP.isMainhandActive(), recipe.m_8043_(), i);
                                buildingItem.setLastUsedItem(recipe.m_8043_().m_41720_());
                                break;
                            }
                        }
                    } else {
                        IEntityWithItem entity;
                        ItemStack pickItem;
                        EntityHitResult entityHit;
                        Entity state;
                        pos = mc.f_91077_;
                        if (pos instanceof EntityHitResult && (state = (entityHit = (EntityHitResult)pos).m_82443_()) instanceof IEntityWithItem && (pickItem = (entity = (IEntityWithItem)state).getPickedResult((HitResult)entityHit)).m_41720_() == heldItem.m_41720_()) {
                            List<BuildingRecipe> recipes = buildingItem.getRecipes(player.f_19853_, (Player)player);
                            Item armorStandItem = entity.getItemForm();
                            for (int i = 0; i < recipes.size(); ++i) {
                                BuildingRecipe recipe = recipes.get(i);
                                if (recipe.output != armorStandItem) continue;
                                ClientEngine.get().setModifiableIndex(capP.isMainhandActive(), recipe.m_8043_(), i);
                                buildingItem.setLastUsedItem(recipe.m_8043_().m_41720_());
                                break;
                            }
                        }
                    }
                }
            }
            return;
        }
        if (event.isAttack()) {
            flagAttack = true;
        } else if (event.isUseItem()) {
            flagUse = true;
        }
        ClientEventHandler.updateClickInput(true);
        Action action = capA.getAction();
        if (flagAttack) {
            action.onAttackInput((Player)player);
        }
        if (flagUse) {
            action.onUseInput((Player)player);
        }
        flagAttack = false;
        flagUse = false;
        if (ClientEngine.get().microHitResult != null) {
            event.setSwingHand(false);
            event.setCanceled(true);
        } else if (!capA.isInactive()) {
            event.setSwingHand(false);
            if (!(!event.isAttack() || capP.getHeldContents().m_128456_() && player.m_21120_(capP.getActiveHand()).m_41720_() instanceof IWeaponItem)) {
                event.setCanceled(true);
            }
        } else if (event.isAttack() && (player.m_21120_(capP.getActiveHand()).m_41720_() instanceof IWeaponItem || player.m_21205_().m_41720_() instanceof IWeaponItem)) {
            event.setSwingHand(false);
        }
        if (event.isUseItem() && mc.f_91077_ != null) {
            if (mc.f_91077_.m_6662_() == HitResult.Type.BLOCK) {
                if (!event.shouldSwingHand() && capP.getHeldContents().m_128456_()) {
                    event.setCanceled(true);
                }
            } else if (mc.f_91077_.m_6662_() == HitResult.Type.ENTITY && !player.m_150110_().f_35937_) {
                double reach = Math.max(1.0, player.m_21051_((Attribute)ForgeMod.REACH_DISTANCE.get()).m_22135_() - 2.0);
                if (mc.f_91077_.m_82450_().m_82557_(player.m_20299_(ClientEngine.get().getPartialTick())) > reach * reach) {
                    mc.f_91077_ = BlockHitResult.m_82426_((Vec3)mc.f_91077_.m_82450_(), (Direction)Direction.UP, (BlockPos)BlockPos.f_121853_);
                }
            }
        }
        if (event.isUseItem() && event.getHand() == capP.getActiveHand() && player.m_21120_(capP.getActiveHand()).m_41720_() instanceof IModifiable) {
            int index;
            int n = index = event.getHand() == InteractionHand.MAIN_HAND ? ClientEngine.get().getModifiableIndexMain() : ClientEngine.get().getModifiableIndexOff();
            if (index >= 0) {
                NetworkHandler.toServer(new ModifiableIndexToServer(index));
            }
        }
    }

    @SubscribeEvent
    public static void onRawMouseEvent(InputEvent.RawMouseEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || !player.m_6084_()) {
            return;
        }
        IActionTracker capC = ActionTracker.get((Entity)player);
    }

    @SubscribeEvent
    public static void onMouseScrollEvent(InputEvent.MouseScrollEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || !player.m_6084_()) {
            return;
        }
        IActionTracker capA = ActionTracker.get((Entity)player);
        if (!capA.isInactive()) {
            event.setCanceled(true);
            int selected = player.m_150109_().f_35977_;
            int i = (int)Math.signum(event.getScrollDelta());
            selected -= i;
            while (selected < 0) {
                selected += 9;
            }
            while (selected >= 9) {
                selected -= 9;
            }
            hotbarBuffer.set(selected);
            actionBuffer.reset();
        }
    }

    @SubscribeEvent
    public static void onKeyInputEvent(InputEvent.KeyInputEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || !player.m_6084_()) {
            return;
        }
        IActionTracker capA = ActionTracker.get((Entity)player);
        IPlayerData capP = PlayerData.get((Player)player);
        Action action = capA.getAction();
        if (!capA.isInactive() && !action.isInterruptible() || capA.isStunned() || mc.f_91080_ instanceof ModifiableItemScreen) {
            if (event.getKey() == mc.f_91066_.f_92093_.getKey().m_84873_()) {
                mc.f_91066_.f_92093_.m_90859_();
            } else {
                for (KeyMapping key : mc.f_91066_.f_92056_) {
                    if (event.getKey() != key.getKey().m_84873_()) continue;
                    key.m_90859_();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onMovementInputUpdateEvent(MovementInputUpdateEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || !player.m_6084_()) {
            return;
        }
        IActionTracker capA = ActionTracker.get((Entity)player);
        IPlayerData capP = PlayerData.get((Player)player);
        Action action = capA.getAction();
        if (triedJump) {
            int dodgeTicks = player.f_19797_ - PlayerData.get((Player)player).getLastDodgeTick();
            if (dodgeTicks >= 3 && player.m_20096_() && !capA.isStunned()) {
                event.getInput().f_108572_ = true;
                triedJump = false;
            }
            if (dodgeTicks >= 6) {
                triedJump = false;
            }
        }
        if (player.f_19797_ - capP.getLastDodgeTick() < 3) {
            triedJump = event.getInput().f_108572_;
            event.getInput().f_108572_ = false;
        }
        if (player.m_6067_()) {
            double swimSpeed = player.m_21133_((Attribute)ForgeMod.SWIM_SPEED.get());
            player.m_20334_(player.m_20184_().f_82479_, player.m_20184_().f_82480_ * (double)0.85f * swimSpeed, player.m_20184_().f_82481_);
        }
        if (!(!player.m_6844_(EquipmentSlot.CHEST).canElytraFly((LivingEntity)player) || capA.isInactive() || action.isInterruptible() || player.m_20096_() || player.m_20069_() || player.m_20077_() || player.m_6147_())) {
            event.getInput().f_108572_ = false;
        }
        if (capA.isStunned()) {
            event.getInput().f_108572_ = false;
            event.getInput().f_108573_ = false;
        } else if (player.m_20143_() && event.getInput().f_108572_) {
            event.getInput().f_108572_ = false;
            if (player.m_20998_(ClientEngine.get().getPartialTick()) >= 1.0f) {
                crawlJumpBuffer.set(true);
                if (actionBuffer.getValue() == ActionType.CRAWL) {
                    actionBuffer.reset();
                }
            }
        }
    }

    @SubscribeEvent
    public static void onFlyableFallEvent(PlayerFlyableFallEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || !player.m_6084_()) {
            return;
        }
        IActionTracker capC = ActionTracker.get((Entity)player);
    }

    @SubscribeEvent
    public static void onScreenOpenEvent(ScreenOpenEvent event) {
        Minecraft mc = Minecraft.m_91087_();
        LocalPlayer player = mc.f_91074_;
        if (player == null || !player.m_6084_()) {
            return;
        }
        IActionTracker capA = ActionTracker.get((Entity)player);
        if (capA.isStunned()) {
            if (event.getScreen() instanceof AbstractContainerScreen || event.getScreen() instanceof ModifiableItemScreen) {
                event.setCanceled(true);
            }
        } else if (event.getScreen() instanceof InventoryScreen) {
            event.setScreen((Screen)ClientEngine.get().getInventoryScreen((Player)player));
        } else {
            Screen screen = event.getScreen();
            if (screen instanceof EntryPuzzleScreen) {
                EntryPuzzleScreen entryPuzzleScreen = (EntryPuzzleScreen)screen;
                Screen screen2 = mc.f_91080_;
                if (screen2 instanceof EncyclopediaScreen) {
                    EncyclopediaScreen encyclopediaScreen = (EncyclopediaScreen)screen2;
                    encyclopediaScreen.setEntryScreen((Screen)entryPuzzleScreen);
                }
                event.setCanceled(true);
            } else {
                screen = event.getScreen();
                if (screen instanceof SignEditScreen) {
                    SignEditScreen screen3 = (SignEditScreen)screen;
                    if (screen3.f_99254_.m_58900_().m_60734_() instanceof StandingSignBlockNF || screen3.f_99254_.m_58900_().m_60734_() instanceof WallSignBlockNF) {
                        event.setScreen((Screen)new SignEditScreenNF(screen3.f_99254_, mc.m_167974_()));
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onClientLoggedInEvent(ClientPlayerNetworkEvent.LoggedInEvent event) {
        LocalPlayer p = event.getPlayer();
        p.f_36095_ = new PlayerInventoryContainer(p.m_150109_(), false);
        p.f_36096_ = p.f_36095_;
        ClientEngine.get().dirtyScreen();
        p.m_21051_(Attributes.f_22283_).m_22100_(100.0);
        p.m_21051_(Attributes.f_22281_).m_22100_(2.0);
        p.m_21051_(Attributes.f_22276_).m_22100_(100.0);
        if (!p.m_7500_() && !p.m_5833_()) {
            DebugRenderer debugRenderer = Minecraft.m_91087_().f_91064_;
            if (debugRenderer.m_113506_()) {
                debugRenderer.m_113506_();
            }
            Minecraft.m_91087_().m_91290_().m_114473_(false);
        }
        if (((Boolean)Nightfall.Config.DISPLAY_CONTROLS_MESSAGE.get()).booleanValue()) {
            Minecraft.m_91087_().f_91065_.m_93076_().m_93785_((Component)new TranslatableComponent("nightfall.message.controls_command"));
            Nightfall.Config.DISPLAY_CONTROLS_MESSAGE.set((Object)false);
            Nightfall.Config.DISPLAY_CONTROLS_MESSAGE.save();
        }
    }

    @SubscribeEvent
    public static void onClientLoggedOutEvent(ClientPlayerNetworkEvent.LoggedOutEvent event) {
        EntityLightEngine.get().clear();
        EncyclopediaScreen.selectedTab = null;
        Minecraft.m_91087_().f_91060_.f_109408_.clear();
        Minecraft.m_91087_().f_91060_.f_109409_.clear();
    }

    @SubscribeEvent
    public static void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        if (event.getEntity() == Minecraft.m_91087_().f_91074_) {
            EntityLightEngine.get().clear();
        }
    }

    @SubscribeEvent
    public static void onClientRespawnEvent(ClientPlayerNetworkEvent.RespawnEvent event) {
        LocalPlayer p = event.getPlayer();
        p.f_36095_ = new PlayerInventoryContainer(p.m_150109_(), false);
        p.f_36096_ = p.f_36095_;
        ClientEngine.get().dirtyScreen();
        triedJump = false;
        actionBuffer.reset();
        hotbarBuffer.reset();
        crawlJumpBuffer.reset();
        dodgeBuffer.reset();
        ClientEventHandler.resetClick();
    }

    @SubscribeEvent
    public static void onClientChatReceivedEvent(ClientChatReceivedEvent event) {
        if (event.getMessage().m_6111_().equals("commands.info.server_controls")) {
            Minecraft mc = Minecraft.m_91087_();
            ChatComponent chat = mc.f_91065_.m_93076_();
            chat.m_93785_((Component)new TranslatableComponent("commands.info.encyclopedia", new Object[]{ClientEngine.get().keyEncyclopedia.getKey().m_84875_()}).m_130940_(ChatFormatting.GRAY));
            chat.m_93785_((Component)new TranslatableComponent("commands.info.dash", new Object[]{ClientEngine.get().keyDash.getKey().m_84875_()}));
            chat.m_93785_((Component)new TranslatableComponent("commands.info.crawl", new Object[]{mc.f_91066_.f_92090_.getKey().m_84875_()}).m_130940_(ChatFormatting.GRAY));
            chat.m_93785_((Component)new TranslatableComponent("commands.info.climb", new Object[]{mc.f_91066_.f_92089_.getKey().m_84875_()}));
            chat.m_93785_((Component)new TranslatableComponent("commands.info.prioritize_offhand", new Object[]{ClientEngine.get().keyOffhand.getKey().m_84875_()}).m_130940_(ChatFormatting.GRAY));
            chat.m_93785_((Component)new TranslatableComponent("commands.info.modify_item_behavior", new Object[]{ClientEngine.get().keyModify.getKey().m_84875_()}));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onFOVModifierEvent(FOVModifierEvent event) {
        float max;
        IActionTracker capA;
        Player player = event.getEntity();
        if (player == null || !player.m_6084_()) {
            return;
        }
        event.setNewfov(event.getFov() - ((float)player.m_21051_(Attributes.f_22279_).m_22135_() - 0.1f) * 5.0f);
        if (player.m_20142_()) {
            event.setNewfov(event.getNewfov() + 0.15f);
        }
        if ((capA = ActionTracker.get((Entity)player)).isCharging() && capA.getAction().hasChargeZoom() && (max = (float)capA.getAction().getMaxCharge()) > 0.0f) {
            float frame = (float)capA.getFrame() + max / 3.0f;
            float progress = Math.min(1.0f, Mth.m_14179_((float)capA.modifyPartialTick(ClientEngine.get().getPartialTick()), (float)((frame - 1.0f) / max), (float)(frame / max)));
            progress = progress < 1.0f ? (progress *= progress) : 1.0f;
            event.setNewfov(event.getNewfov() * Math.max(1.0f - progress * 0.15f, 0.15f));
        }
    }

    private static void handleDodge(LocalPlayer p) {
        int dir = 0;
        if (heldKeys[0] && heldKeys[3]) {
            dir = 1;
        } else if (heldKeys[0] && heldKeys[2]) {
            dir = 7;
        } else if (heldKeys[1] && heldKeys[3]) {
            dir = 3;
        } else if (heldKeys[1] && heldKeys[2]) {
            dir = 5;
        } else if (heldKeys[1]) {
            dir = 4;
        } else if (heldKeys[2]) {
            dir = 6;
        } else if (heldKeys[3]) {
            dir = 2;
        }
        IPlayerData capP = PlayerData.get((Player)p);
        if (p.f_19797_ - capP.getLastDodgeTick() < 10) {
            capP.addStamina(-50.0);
        } else {
            capP.addStamina(-25.0);
        }
        capP.setLastDodgeTick(p.f_19797_);
        capP.setDodgeDirection(dir);
        NetworkHandler.toServer(new DodgeToServer(dir));
        ClientEventHandler.doDodge(p);
        AnimationUtil.createDodgeParticles((Player)p);
    }

    private static boolean checkDodgeConditions(Player p) {
        ModifiableItemScreen modifiableItemScreen;
        Screen screen;
        Minecraft mc = Minecraft.m_91087_();
        IPlayerData capP = PlayerData.get(p);
        IActionTracker capA = ActionTracker.get((Entity)p);
        return mc.m_91288_() != null && (mc.f_91080_ == null || (screen = mc.f_91080_) instanceof ModifiableItemScreen && (modifiableItemScreen = (ModifiableItemScreen)screen).allowMovementInputs()) && !mc.f_91066_.f_92089_.m_90857_() && capP.getStamina() > 0.0 && !p.m_6117_() && p.m_20096_() && p.f_19797_ - capP.getLastDodgeTick() >= 5 && !p.m_20069_() && !p.m_20077_() && !p.m_6047_() && p.m_20089_() != Pose.SWIMMING && capP.getHeldContents().m_128456_() && capA.getAction().allowDodging(capA.getState());
    }

    private static boolean checkBooleanArray(boolean[] b) {
        for (boolean x : b) {
            if (!x) continue;
            return true;
        }
        return false;
    }

    private static void doDodge(LocalPlayer p) {
        double a = p.m_6080_();
        if (!ClientEventHandler.checkBooleanArray(heldKeys)) {
            a += -180.0;
        } else if (heldKeys[2] && heldKeys[3]) {
            if (!heldKeys[0]) {
                a += -180.0;
            }
        } else if (heldKeys[0] && heldKeys[1]) {
            if (heldKeys[2]) {
                a += 90.0;
            }
            if (heldKeys[3]) {
                a += -90.0;
            }
            if (!heldKeys[2] && !heldKeys[3]) {
                a += -180.0;
            }
        } else {
            int count = 0;
            int offset = 0;
            if (heldKeys[0]) {
                ++count;
            }
            if (heldKeys[1]) {
                offset = heldKeys[2] ? (offset += 180) : (offset -= 180);
                ++count;
            }
            if (heldKeys[2]) {
                offset += 90;
                ++count;
            }
            if (heldKeys[3]) {
                offset -= 90;
                ++count;
            }
            a += (double)(offset / count);
        }
        a = a % 360.0 * (Math.PI / 180);
        double d = 1.0;
        double ratioX = -Math.sin(a) / d;
        double ratioZ = Math.cos(a) / d;
        xDodge = ratioX;
        zDodge = ratioZ;
        ClientEventHandler.doPlayerDodge(p);
    }

    private static void doPlayerDodge(LocalPlayer player) {
        if (player != null && player.m_6084_()) {
            Vec3 motion = player.m_20184_();
            float speedFactor = player.m_6041_();
            double x = xDodge * 0.8 * (double)speedFactor;
            double y = motion.f_82480_;
            double z = zDodge * 0.8 * (double)speedFactor;
            player.m_6001_(x, y, z);
        }
    }

    private static void updateHotbarBuffer(Player player) {
        if (hotbarBuffer.isActive() && hotbarBuffer.getValue() != player.m_150109_().f_35977_ && ActionTracker.get((Entity)player).isInactive()) {
            player.m_150109_().f_35977_ = hotbarBuffer.getValue();
            PlayerData.get(player).setLastMainItem();
            hotbarBuffer.reset();
        }
    }

    private static void resetClick() {
        click = -1;
        clickCounter = 0;
    }

    static {
        skipClickInputEvent = false;
        wasAttackKeyDown = false;
        retryPickBlock = false;
    }

    private static enum ActionType {
        EMPTY,
        BASIC,
        ALTERNATE,
        TECHNIQUE,
        CRAWL;

    }
}

