/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.event;

import com.google.common.collect.Multimap;
import com.mojang.datafixers.util.Pair;
import com.mojang.math.Vector3f;
import frostnox.nightfall.Nightfall;
import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.DamageTypeSource;
import frostnox.nightfall.action.Poise;
import frostnox.nightfall.block.IHoldable;
import frostnox.nightfall.block.IMetal;
import frostnox.nightfall.block.IMicroGrid;
import frostnox.nightfall.block.TieredHeat;
import frostnox.nightfall.block.block.crucible.CrucibleContainer;
import frostnox.nightfall.block.block.tree.TreeStemBlock;
import frostnox.nightfall.block.fluid.MetalFluid;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.ChunkData;
import frostnox.nightfall.capability.GlobalChunkData;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.capability.IChunkData;
import frostnox.nightfall.capability.IGlobalChunkData;
import frostnox.nightfall.capability.ILevelData;
import frostnox.nightfall.capability.IPlayerData;
import frostnox.nightfall.capability.LevelData;
import frostnox.nightfall.capability.LightData;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.client.ClientEngine;
import frostnox.nightfall.data.TagsNF;
import frostnox.nightfall.data.recipe.CrucibleRecipe;
import frostnox.nightfall.data.recipe.MixtureRecipe;
import frostnox.nightfall.entity.ITamable;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.item.IActionableItem;
import frostnox.nightfall.item.IWeaponItem;
import frostnox.nightfall.item.item.AttributeAccessoryItem;
import frostnox.nightfall.item.item.MeleeWeaponItem;
import frostnox.nightfall.item.item.TieredArmorItem;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.capability.LevelDataToClient;
import frostnox.nightfall.network.message.capability.SetAccessoriesToClient;
import frostnox.nightfall.network.message.capability.StatusToClient;
import frostnox.nightfall.network.message.entity.HurtDirToClient;
import frostnox.nightfall.network.message.world.ChunkClimateToServer;
import frostnox.nightfall.network.message.world.ChunkDigProgressToServer;
import frostnox.nightfall.network.message.world.DigBlockToClient;
import frostnox.nightfall.registry.ActionsNF;
import frostnox.nightfall.registry.EntriesNF;
import frostnox.nightfall.registry.KnowledgeNF;
import frostnox.nightfall.registry.RegistriesNF;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.registry.forge.EffectsNF;
import frostnox.nightfall.registry.forge.ItemsNF;
import frostnox.nightfall.registry.forge.ParticleTypesNF;
import frostnox.nightfall.registry.forge.SoundsNF;
import frostnox.nightfall.registry.vanilla.GameEventsNF;
import frostnox.nightfall.util.AnimationUtil;
import frostnox.nightfall.util.CombatUtil;
import frostnox.nightfall.util.LevelUtil;
import frostnox.nightfall.util.MathUtil;
import frostnox.nightfall.util.RenderUtil;
import frostnox.nightfall.world.ILightSource;
import frostnox.nightfall.world.MoonPhase;
import frostnox.nightfall.world.generation.ContinentalChunkGenerator;
import frostnox.nightfall.world.inventory.AccessoryInventory;
import frostnox.nightfall.world.inventory.AccessorySlot;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.text.DecimalFormat;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LevelTimeAccess;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.PotionEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class CommonEventHandler {
    @SubscribeEvent
    public static void onLeftClickBlockEvent(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getPlayer();
        if (player == null) {
            return;
        }
        if (!player.m_6084_()) {
            return;
        }
        IPlayerData capP = PlayerData.get(player);
        if (!ActionTracker.get((Entity)player).isInactive() || player.m_21120_(capP.getActiveHand()).m_41720_() instanceof MeleeWeaponItem) {
            event.setCanceled(true);
        } else if (event.getHand() == InteractionHand.MAIN_HAND) {
            Level level = player.f_19853_;
            BlockPos pos = event.getPos();
            IGlobalChunkData chunkData = GlobalChunkData.get(level.m_46745_(pos));
            if (player.m_150110_().f_35937_) {
                chunkData.removeBreakProgress(pos);
                if (!level.f_46443_) {
                    NetworkHandler.toAllTrackingAndSelf((Entity)player, new DigBlockToClient(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), -1.0f));
                }
                return;
            }
            event.setCanceled(true);
            BlockState block = level.m_8055_(pos);
            ItemStack item = event.getItemStack();
            boolean isTool = item.m_204117_(TagsNF.TOOL);
            float progress = level.m_8055_(pos).m_60625_(player, (BlockGetter)level, pos) * AttributesNF.getStrengthMultiplier((LivingEntity)player);
            if (!isTool) {
                progress *= 0.66f;
            }
            progress += chunkData.getBreakProgress(pos);
            block.m_60686_(level, pos, player);
            if (progress >= 1.0f) {
                boolean canHarvest;
                BlockEntity blockEntity = player.f_19853_.m_7702_(pos);
                if (!level.f_46443_) {
                    ServerPlayer serverPlayer = (ServerPlayer)player;
                    int exp = ForgeHooks.onBlockBreakEvent((Level)player.f_19853_, (GameType)serverPlayer.f_8941_.m_9290_(), (ServerPlayer)serverPlayer, (BlockPos)pos);
                    if (exp == -1) {
                        NetworkHandler.toClient(serverPlayer, new DigBlockToClient(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), progress));
                        return;
                    }
                }
                if (block.onDestroyedByPlayer(level, pos, player, canHarvest = block.canHarvestBlock((BlockGetter)player.f_19853_, pos, player), block.m_60819_())) {
                    block.m_60734_().m_6786_((LevelAccessor)level, pos, block);
                    if (level.f_46443_) {
                        ClientEngine.get().visuallyDestroyBlock(pos, -1);
                    } else if (canHarvest) {
                        block.m_60734_().m_6240_(player.f_19853_, player, pos, block, blockEntity, item);
                        if (!player.m_7500_() && item.m_204117_(TagsNF.TOOL)) {
                            item.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(InteractionHand.MAIN_HAND));
                        }
                    }
                    chunkData.removeBreakProgress(pos);
                }
            } else {
                if (level.f_46443_) {
                    ClientEngine.get().visuallyDestroyBlock(pos, (int)(progress * 10.0f) - 1);
                }
                chunkData.setBreakProgress(pos, progress);
            }
            if (block.m_60800_((BlockGetter)level, pos) > 0.0f) {
                SoundType sound = block.getSoundType((LevelReader)player.f_19853_, pos, (Entity)player);
                if (player.f_19797_ % 5 == 0) {
                    player.f_19853_.m_5594_(player, pos, sound.m_56778_(), SoundSource.BLOCKS, (sound.m_56773_() + 1.0f) / 2.0f, sound.m_56774_() * 0.75f);
                }
            }
            if (!level.f_46443_) {
                NetworkHandler.toAllTrackingAndSelf((Entity)player, new DigBlockToClient(pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), progress));
            }
        }
    }

    @SubscribeEvent
    public static void onEntityInteractSpecificEvent(PlayerInteractEvent.EntityInteractSpecific event) {
        Player player = event.getPlayer();
        if (player == null || event.getTarget() == null) {
            return;
        }
        IActionTracker capA = ActionTracker.get((Entity)player);
        IPlayerData capP = PlayerData.get(player);
        if (!capA.isInactive()) {
            if (capA.getActionID().equals((Object)ActionsNF.HOLD_ENTITY.getId())) {
                capP.useBlockEntity(event.getTarget());
                event.setCancellationResult(InteractionResult.CONSUME);
                event.setCanceled(true);
            } else if (!CommonEventHandler.allowRightClick(player, capP.getActiveHand())) {
                event.setCancellationResult(InteractionResult.CONSUME);
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onRightClickItemEvent(PlayerInteractEvent.RightClickItem event) {
        if (!CommonEventHandler.allowRightClick(event.getPlayer(), event.getHand())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRightClickBlockEvent(PlayerInteractEvent.RightClickBlock event) {
        Player player = event.getPlayer();
        if (player.f_19853_.f_46443_ && ClientEngine.get().microHitResult != null || !player.m_150110_().f_35937_ && player.f_20913_ < 2 && player.f_20911_) {
            event.setCanceled(true);
            return;
        }
        IPlayerData capP = PlayerData.get(player);
        if (event.getHand() == InteractionHand.MAIN_HAND) {
            if (player.m_6047_() && !player.f_19853_.m_5776_()) {
                BlockEntity blockEntity;
                IActionTracker capA = ActionTracker.get((Entity)player);
                if (capA.getActionID().equals((Object)ActionsNF.HOLD_ENTITY.getId()) && capP.getHoldTicks() == 4) {
                    BlockPos pos = event.getFace() == null || player.f_19853_.m_8055_(event.getPos()).m_60767_().m_76336_() ? event.getPos() : event.getPos().m_142300_(event.getFace());
                    capP.putBlockEntity(pos, event.getHitVec());
                    event.setCanceled(true);
                } else if (capP.getHoldTicks() == -1 && capA.isInactive() && player.m_21120_(event.getHand()).m_41619_() && (blockEntity = player.f_19853_.m_7702_(event.getPos())) instanceof IHoldable) {
                    IHoldable holdable = (IHoldable)blockEntity;
                    capP.holdBlockEntity(holdable);
                    event.setCanceled(true);
                }
            } else if (ActionTracker.get((Entity)player).getActionID().equals((Object)ActionsNF.HOLD_ENTITY.getId())) {
                capP.useBlockEntity(event.getPos());
                event.setCanceled(true);
            }
        }
        if (!CommonEventHandler.allowRightClick(player, event.getHand())) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onPlayerHarvestEvent(PlayerEvent.HarvestCheck event) {
        IActionTracker capA;
        Player player = event.getPlayer();
        if (player == null || !player.m_6084_()) {
            return;
        }
        IPlayerData capP = PlayerData.get(player);
        if (!capP.isMainhandActive() && player.m_21120_(capP.getActiveHand()).m_41735_(event.getTargetBlock())) {
            event.setCanHarvest(true);
        }
        if (!(capA = ActionTracker.get((Entity)player)).isInactive()) {
            event.setCanHarvest(event.canHarvest() || capA.getAction().canHarvest(event.getTargetBlock()));
        }
    }

    private static int getTooltipIndex(List<Component> tooltip) {
        if (tooltip.isEmpty()) {
            return 0;
        }
        int sub = 0;
        for (Component component : tooltip) {
            TranslatableComponent translatable;
            if (component.m_7383_().m_131135_() != null && ChatFormatting.DARK_GRAY.m_126665_().equals(component.m_7383_().m_131135_().m_131265_())) {
                ++sub;
                continue;
            }
            if (!(component instanceof TranslatableComponent) || !(translatable = (TranslatableComponent)component).m_131328_().equals("item.durability")) continue;
            ++sub;
        }
        return Math.max(1, tooltip.size() - sub);
    }

    @SubscribeEvent
    public static void onItemTooltipEvent(ItemTooltipEvent event) {
        List tooltip = event.getToolTip();
        ItemStack item = event.getItemStack();
        int hideFlags = item.m_41618_();
        tooltip.removeIf(c -> c == TextComponent.f_131282_);
        if (ItemStack.m_41626_((int)hideFlags, (ItemStack.TooltipPart)ItemStack.TooltipPart.ADDITIONAL)) {
            EntityBlock entityBlock;
            BlockItem blockItem;
            Item metalFluid22;
            ObjectArrayList groups = new ObjectArrayList();
            if (item.m_204117_(TagsNF.MEAT)) {
                groups.add(new TranslatableComponent("nightfall.food_group.meat"));
            }
            if (item.m_204117_(TagsNF.VEGETABLE)) {
                groups.add(new TranslatableComponent("nightfall.food_group.vegetable"));
            }
            if (item.m_204117_(TagsNF.FRUIT)) {
                groups.add(new TranslatableComponent("nightfall.food_group.fruit"));
            }
            if (item.m_204117_(TagsNF.GRAIN)) {
                groups.add(new TranslatableComponent("nightfall.food_group.grain"));
            }
            if (item.m_204117_(TagsNF.HERB)) {
                groups.add(new TranslatableComponent("nightfall.food_group.herb"));
            }
            if (!groups.isEmpty()) {
                int units = MixtureRecipe.getUnitsOf(new ItemStack((ItemLike)item.m_41720_(), 1));
                MutableComponent component = units == 1 ? new TranslatableComponent("food.small").m_130940_(ChatFormatting.BLUE).m_130946_(" ") : (units == 2 ? new TranslatableComponent("food.medium").m_130940_(ChatFormatting.BLUE).m_130946_(" ") : (units == 3 ? new TranslatableComponent("food.large").m_130940_(ChatFormatting.BLUE).m_130946_(" ") : new TextComponent(units + " ").m_130940_(ChatFormatting.BLUE)));
                for (int i = 0; i < groups.size(); ++i) {
                    component.m_7220_((Component)groups.get(i));
                    if (i == groups.size() - 1) continue;
                    component.m_130946_(", ");
                }
                tooltip.add(CommonEventHandler.getTooltipIndex(tooltip), component);
            }
            if (event.getPlayer() != null) {
                IPlayerData capP;
                for (CrucibleRecipe recipe : event.getPlayer().f_19853_.m_7465_().m_44013_(CrucibleRecipe.TYPE)) {
                    Fluid fluid;
                    if (!recipe.getInput().test(item) || !((fluid = recipe.getResultFluid().getFluid()) instanceof MetalFluid)) continue;
                    MetalFluid metalFluid22 = (MetalFluid)fluid;
                    tooltip.add(CommonEventHandler.getTooltipIndex(tooltip), new TextComponent(recipe.getResultFluid().getAmount() + " ").m_130940_(ChatFormatting.BLUE).m_7220_((Component)new TranslatableComponent("metal." + metalFluid22.metal.getName())));
                    break;
                }
                if (item.m_204117_(TagsNF.HEAT_RESISTANT_ITEM_1) && (capP = PlayerData.get(event.getPlayer())).hasCompletedEntry(EntriesNF.POTTERY.getId())) {
                    int tier = item.m_204117_(TagsNF.HEAT_RESISTANT_ITEM_2) && capP.hasCompletedEntry(EntriesNF.SMELTING.getId()) ? 2 : 1;
                    tooltip.add(CommonEventHandler.getTooltipIndex(tooltip), new TranslatableComponent("block.heat_resistant." + tier).m_130948_(Style.f_131099_.m_178520_(TieredHeat.fromTier((int)tier).color.getRGB())));
                }
            }
            if ((metalFluid22 = item.m_41720_()) instanceof BlockItem && (metalFluid22 = (blockItem = (BlockItem)metalFluid22).m_40614_()) instanceof EntityBlock && (entityBlock = (EntityBlock)metalFluid22).m_142194_(BlockPos.f_121853_, blockItem.m_40614_().m_49966_()) instanceof IHoldable) {
                tooltip.add(CommonEventHandler.getTooltipIndex(tooltip), new TranslatableComponent("block.holdable").m_130940_(ChatFormatting.BLUE).m_130946_(" ").m_7220_((Component)new TranslatableComponent("block.holdable.control").m_130940_(ChatFormatting.AQUA)));
            }
        }
        if (ItemStack.m_41626_((int)hideFlags, (ItemStack.TooltipPart)ItemStack.TooltipPart.MODIFIERS)) {
            FoodProperties food;
            BlockItem blockItem;
            Block block;
            Item component22;
            boolean hasAnySlot = false;
            if (item.getEquipmentSlot() != null) {
                hasAnySlot = true;
            } else {
                for (AccessorySlot slot : AccessorySlot.values()) {
                    if (!slot.acceptsItem(item)) continue;
                    hasAnySlot = true;
                    tooltip.add(CommonEventHandler.getTooltipIndex(tooltip), new TranslatableComponent("item.modifiers." + slot).m_130940_(ChatFormatting.GRAY));
                }
            }
            Object entityBlock = item.m_41720_();
            if (entityBlock instanceof AttributeAccessoryItem) {
                AttributeAccessoryItem accessoryItem = (AttributeAccessoryItem)((Object)entityBlock);
                for (Item slot : AccessorySlot.values()) {
                    Multimap<Attribute, AttributeModifier> map = accessoryItem.getAttributeModifiers((AccessorySlot)slot, item);
                    if (map.isEmpty()) continue;
                    for (Map.Entry entry : map.entries()) {
                        Attribute attribute = (Attribute)entry.getKey();
                        boolean forcePercentage = attribute.equals(AttributesNF.BLEEDING_RESISTANCE.get()) || attribute.equals(AttributesNF.POISON_RESISTANCE.get()) || attribute.equals(AttributesNF.STAMINA_REDUCTION.get());
                        AttributeModifier modifier = (AttributeModifier)entry.getValue();
                        double d = modifier.m_22218_();
                        double finalAmount = !forcePercentage && modifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_BASE && modifier.m_22217_() != AttributeModifier.Operation.MULTIPLY_TOTAL ? (attribute.equals(Attributes.f_22278_) ? d * 10.0 : d) : d * 100.0;
                        if (d > 0.0) {
                            tooltip.add(CommonEventHandler.getTooltipIndex(tooltip), new TranslatableComponent("attribute.modifier.plus." + (forcePercentage ? 2 : modifier.m_22217_().m_22235_()), new Object[]{ItemStack.f_41584_.format(finalAmount), new TranslatableComponent(attribute.m_22087_())}).m_130940_(ChatFormatting.BLUE));
                            continue;
                        }
                        if (!(d < 0.0)) continue;
                        tooltip.add(CommonEventHandler.getTooltipIndex(tooltip), new TranslatableComponent("attribute.modifier.take." + (forcePercentage ? 2 : modifier.m_22217_().m_22235_()), new Object[]{ItemStack.f_41584_.format(-finalAmount), new TranslatableComponent(attribute.m_22087_())}).m_130940_(ChatFormatting.RED));
                    }
                }
            }
            if (hasAnySlot) {
                entityBlock = item.m_41720_();
                if (entityBlock instanceof TieredArmorItem) {
                    TieredArmorItem armor = (TieredArmorItem)((Object)entityBlock);
                    if (armor.getAttributeModifiers(armor.slot, item).isEmpty()) {
                        tooltip.add(CommonEventHandler.getTooltipIndex(tooltip), new TranslatableComponent("item.modifiers." + armor.slot.m_20751_()).m_130940_(ChatFormatting.GRAY));
                    }
                    if (armor.material.getPoise() != Poise.NONE) {
                        tooltip.add(new TranslatableComponent("poise." + armor.material.getPoise().m_7912_()).m_130940_(ChatFormatting.DARK_GREEN).m_130946_(" ").m_7220_((Component)new TranslatableComponent(((Attribute)AttributesNF.POISE.get()).m_22087_()).m_130940_(ChatFormatting.BLUE)));
                    }
                    for (Map.Entry entry : item.m_41638_(armor.slot).entries()) {
                        if (!((Attribute)entry.getKey()).equals(AttributesNF.BLEEDING_RESISTANCE.get()) && !((Attribute)entry.getKey()).equals(AttributesNF.POISON_RESISTANCE.get()) && !((Attribute)entry.getKey()).equals(AttributesNF.STAMINA_REDUCTION.get())) continue;
                        AttributeModifier modifier = (AttributeModifier)entry.getValue();
                        double base = modifier.m_22218_();
                        double percentage = base * 100.0;
                        TranslatableComponent replacement = base >= 0.0 ? (TranslatableComponent)new TranslatableComponent("attribute.modifier.plus.2", new Object[]{ItemStack.f_41584_.format(percentage), new TranslatableComponent(((Attribute)entry.getKey()).m_22087_())}).m_130940_(ChatFormatting.GOLD) : (TranslatableComponent)new TranslatableComponent("attribute.modifier.take.2", new Object[]{ItemStack.f_41584_.format(percentage *= -1.0), new TranslatableComponent(((Attribute)entry.getKey()).m_22087_())}).m_130940_(ChatFormatting.GOLD);
                        block6: for (int i = 0; i < tooltip.size(); ++i) {
                            Object object = tooltip.get(i);
                            if (!(object instanceof TranslatableComponent)) continue;
                            TranslatableComponent translatable = (TranslatableComponent)object;
                            for (Object object2 : translatable.m_131329_()) {
                                TranslatableComponent tArg;
                                if (!(object2 instanceof TranslatableComponent) || !(tArg = (TranslatableComponent)object2).m_131328_().equals(((Attribute)entry.getKey()).m_22087_())) continue;
                                tooltip.set(i, replacement);
                                continue block6;
                            }
                        }
                    }
                    DecimalFormat format = new DecimalFormat("0.0");
                    float durabilityPenalty = CombatUtil.getArmorDefenseDurabilityPenalty(item.m_41776_() - item.m_41773_(), item.m_41776_());
                    boolean penalized = durabilityPenalty < 1.0f;
                    for (int i = 0; i < 6; ++i) {
                        float defense = armor.material.getDefense(armor.slot, DamageType.values()[i].asArray(), false);
                        tooltip.add(CommonEventHandler.getTooltipIndex(tooltip), new TextComponent(format.format(defense * 100.0f * durabilityPenalty) + "% ").m_130940_(penalized ? ChatFormatting.DARK_RED : ChatFormatting.DARK_GREEN).m_7220_((Component)RenderUtil.getDamageTypeText(DamageType.values()[i]).m_130946_(" ").m_7220_((Component)new TranslatableComponent("item.armor.defense")).m_130940_(ChatFormatting.BLUE)));
                    }
                }
                if (item.m_41720_() instanceof ILightSource) {
                    tooltip.add(CommonEventHandler.getTooltipIndex(tooltip), new TranslatableComponent("item.emits_light").m_130940_(ChatFormatting.BLUE));
                }
                if (item.m_150930_((Item)ItemsNF.MASK.get())) {
                    tooltip.add(CommonEventHandler.getTooltipIndex(tooltip), new TranslatableComponent("item.nightfall.mask.info").m_130940_(ChatFormatting.BLUE));
                }
                if (item.m_150930_((Item)ItemsNF.WARDING_CHARM.get())) {
                    tooltip.add(CommonEventHandler.getTooltipIndex(tooltip), new TranslatableComponent("item.nightfall.warding_charm.info").m_130940_(ChatFormatting.BLUE));
                }
                for (Item component22 : tooltip) {
                    if (!(component22 instanceof TranslatableComponent)) continue;
                    TranslatableComponent translatable = (TranslatableComponent)component22;
                    boolean plus = translatable.m_131328_().contains("attribute.modifier.plus");
                    boolean take = translatable.m_131328_().contains("attribute.modifier.take");
                    if (!plus && !take) continue;
                    boolean invert = false;
                    for (Object arg : translatable.m_131329_()) {
                        if (!(arg instanceof TranslatableComponent)) continue;
                        TranslatableComponent tArg = (TranslatableComponent)arg;
                        if (tArg.m_131328_().contains(((Attribute)AttributesNF.STAMINA_REDUCTION.get()).m_22087_())) {
                            invert = true;
                        }
                        tArg.m_130948_(translatable.m_7383_());
                    }
                    if (plus) {
                        translatable.m_130940_(invert ? ChatFormatting.DARK_RED : ChatFormatting.DARK_GREEN);
                        continue;
                    }
                    translatable.m_130940_(invert ? ChatFormatting.DARK_GREEN : ChatFormatting.DARK_RED);
                }
            }
            if ((component22 = item.m_41720_()) instanceof BlockItem && (block = (blockItem = (BlockItem)component22).m_40614_()).m_204297_().m_203656_(TagsNF.HAS_PHYSICS)) {
                int integrity = 0;
                if (block.m_204297_().m_203656_(TagsNF.SUPPORT_1)) {
                    ++integrity;
                }
                if (block.m_204297_().m_203656_(TagsNF.SUPPORT_2)) {
                    integrity += 2;
                }
                if (block.m_204297_().m_203656_(TagsNF.SUPPORT_4)) {
                    integrity += 4;
                }
                if (block.m_204297_().m_203656_(TagsNF.SUPPORT_8)) {
                    integrity += 8;
                }
                if (integrity > 0) {
                    tooltip.add(CommonEventHandler.getTooltipIndex(tooltip), new TranslatableComponent("item.integrity", new Object[]{integrity}).m_130940_(ChatFormatting.DARK_AQUA));
                }
            }
            if ((food = item.getFoodProperties(null)) != null) {
                float saturation = food.m_38745_();
                tooltip.add(CommonEventHandler.getTooltipIndex(tooltip), new TranslatableComponent("item.nutrition", new Object[]{food.m_38744_()}).m_130940_(ChatFormatting.DARK_GREEN));
                if (saturation < 0.2f) {
                    tooltip.add(CommonEventHandler.getTooltipIndex(tooltip), new TranslatableComponent("item.low_saturation").m_130940_(ChatFormatting.DARK_GREEN));
                } else if (saturation < 0.4f) {
                    tooltip.add(CommonEventHandler.getTooltipIndex(tooltip), new TranslatableComponent("item.medium_saturation").m_130940_(ChatFormatting.DARK_GREEN));
                } else {
                    tooltip.add(CommonEventHandler.getTooltipIndex(tooltip), new TranslatableComponent("item.high_saturation").m_130940_(ChatFormatting.DARK_GREEN));
                }
                for (Pair pair : food.m_38749_()) {
                    if (((Float)pair.getSecond()).floatValue() < 1.0f) continue;
                    MobEffectInstance effect = (MobEffectInstance)pair.getFirst();
                    TranslatableComponent tip = new TranslatableComponent(effect.m_19576_());
                    MobEffect mobeffect = effect.m_19544_();
                    if (effect.m_19564_() > 0) {
                        tip = new TranslatableComponent("potion.withAmplifier", new Object[]{tip, new TranslatableComponent("potion.potency." + effect.m_19564_())});
                    }
                    if (effect.m_19557_() > 20) {
                        tip = new TranslatableComponent("potion.withDuration", new Object[]{tip, MobEffectUtil.m_19581_((MobEffectInstance)effect, (float)1.0f)});
                    }
                    tooltip.add(tip.m_130940_(mobeffect.m_19483_().m_19497_()));
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPotionAddedEvent(PotionEvent.PotionAddedEvent event) {
        MobEffectInstance oldEffect;
        boolean poison;
        MobEffectInstance effect = event.getPotionEffect();
        boolean bleeding = effect.m_19544_() == EffectsNF.BLEEDING.get();
        boolean bl = poison = effect.m_19544_() == EffectsNF.POISON.get();
        if (bleeding || poison) {
            LivingEntity entity = event.getEntityLiving();
            if (entity.m_6084_() && (entity instanceof Player || entity instanceof ActionableEntity)) {
                int duration = effect.m_19557_();
                duration = bleeding ? (int)Math.round((double)duration * (1.0 - entity.m_21133_((Attribute)AttributesNF.BLEEDING_RESISTANCE.get()))) : (int)Math.round((double)duration * (1.0 - entity.m_21133_((Attribute)AttributesNF.POISON_RESISTANCE.get())));
                if (event.getOldPotionEffect() != null) {
                    effect.m_19558_(new MobEffectInstance(effect.m_19544_(), duration += event.getOldPotionEffect().m_19557_(), effect.m_19564_(), effect.m_19571_(), effect.m_19572_(), effect.m_19575_(), null));
                } else {
                    effect.m_19558_(new MobEffectInstance(effect.m_19544_(), duration, effect.m_19564_(), effect.m_19571_(), effect.m_19572_(), effect.m_19575_(), null));
                }
                IActionTracker capA = ActionTracker.get((Entity)entity);
                if (bleeding) {
                    capA.setBleedDuration(duration);
                    if (!entity.f_19853_.f_46443_) {
                        NetworkHandler.toAllTrackingAndSelf((Entity)entity, new StatusToClient(capA.getBleedDuration(), entity.m_142049_(), StatusToClient.Status.BLEEDING));
                    }
                } else {
                    capA.setPoisonDuration(duration);
                    if (!entity.f_19853_.f_46443_) {
                        NetworkHandler.toAllTrackingAndSelf((Entity)entity, new StatusToClient(capA.getPoisonDuration(), entity.m_142049_(), StatusToClient.Status.POISON));
                    }
                }
            }
        } else if (effect.m_19544_() == EffectsNF.PARALYSIS.get() && (oldEffect = event.getOldPotionEffect()) != null) {
            effect.m_19558_(new MobEffectInstance(effect.m_19544_(), Math.max(oldEffect.m_19557_(), effect.m_19557_()), Math.min(2, Math.max(oldEffect.m_19564_() + 1, effect.m_19564_())), effect.m_19571_(), effect.m_19572_(), effect.m_19575_(), null));
        }
    }

    @SubscribeEvent
    public static void onPotionRemoveEvent(PotionEvent.PotionRemoveEvent event) {
        MobEffectInstance instance = event.getPotionEffect();
        MobEffect effect = instance.m_19544_();
        if (effect == EffectsNF.BLEEDING.get() || effect == EffectsNF.POISON.get()) {
            LivingEntity entity = event.getEntityLiving();
            if (entity.m_6084_() && (entity instanceof Player || entity instanceof ActionableEntity)) {
                IActionTracker capA = ActionTracker.get((Entity)entity);
                if (effect == EffectsNF.BLEEDING.get()) {
                    capA.setBleedDuration(0);
                    if (!entity.f_19853_.f_46443_) {
                        NetworkHandler.toAllTrackingAndSelf((Entity)entity, new StatusToClient(0, entity.m_142049_(), StatusToClient.Status.BLEEDING));
                    }
                } else {
                    capA.setPoisonDuration(0);
                    if (!entity.f_19853_.f_46443_) {
                        NetworkHandler.toAllTrackingAndSelf((Entity)entity, new StatusToClient(0, entity.m_142049_(), StatusToClient.Status.POISON));
                    }
                }
            }
        } else if (effect == EffectsNF.INFESTED.get()) {
            LivingEntity entity = event.getEntityLiving();
            entity.f_19853_.m_6269_(null, (Entity)entity, (SoundEvent)SoundsNF.SKARA_SWARM_HURT.get(), SoundSource.HOSTILE, 1.0f, 0.9f + entity.f_19853_.f_46441_.nextFloat() * 0.2f);
        }
    }

    @SubscribeEvent
    public static void onLivingUpdateEvent(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (entity.m_6084_() && ActionTracker.isPresent((Entity)entity)) {
            IActionTracker capA = ActionTracker.get((Entity)entity);
            if (entity.f_19853_.m_5776_()) {
                MobEffectInstance infested;
                if (capA.getBleedDuration() > 0) {
                    ParticleOptions particle;
                    if (entity instanceof ActionableEntity) {
                        ActionableEntity actEntity = (ActionableEntity)entity;
                        particle = actEntity.getHurtParticle();
                    } else {
                        particle = (ParticleOptions)ParticleTypesNF.BLOOD_RED.get();
                    }
                    if (particle != null) {
                        int mod = 15;
                        int duration = capA.getBleedDuration();
                        if (duration > 1800) {
                            mod = 4;
                        } else if (duration > 1200) {
                            mod = 8;
                        } else if (duration > 600) {
                            mod = 12;
                        }
                        if (entity.f_19797_ % mod == 0) {
                            entity.f_19853_.m_7106_(particle, entity.m_20208_(0.5), entity.m_20187_(), entity.m_20262_(0.5), 0.0, -8.0, 0.0);
                        }
                    }
                }
                if (capA.getPoisonDuration() > 0 && entity.f_19797_ % 18 == 0) {
                    entity.f_19853_.m_7106_((ParticleOptions)ParticleTypesNF.POISON.get(), entity.m_20208_(0.5), entity.m_20187_(), entity.m_20262_(0.5), (entity.m_21187_().nextDouble() - 0.5) * 2.0, -entity.m_21187_().nextDouble(), (entity.m_21187_().nextDouble() - 0.5) * 2.0);
                }
                if ((infested = entity.m_21124_((MobEffect)EffectsNF.INFESTED.get())) != null && infested.m_19557_() > 0) {
                    entity.f_19853_.m_7106_((ParticleOptions)ParticleTypesNF.SKARA.get(), entity.m_20208_(0.5), entity.m_20187_(), entity.m_20262_(0.5), (double)(entity.m_21187_().nextFloat() * (float)Math.PI * 2.0f), 0.0, 0.0);
                }
            }
        }
        if (!entity.f_19853_.f_46443_ && entity.m_21023_((MobEffect)EffectsNF.INFESTED.get()) && (entity.m_6060_() || entity.m_204029_(FluidTags.f_13131_))) {
            entity.m_21195_((MobEffect)EffectsNF.INFESTED.get());
        }
        if (entity.m_20096_() && entity.m_20161_()) {
            BlockState state = entity.f_19853_.m_8055_(entity.m_20097_());
            state.m_60734_().m_141947_(entity.f_19853_, entity.m_20097_(), state, (Entity)entity);
        }
        if (!(entity instanceof ActionableEntity)) {
            return;
        }
        if (entity.f_20924_ == 1.5f) {
            entity.f_20924_ = entity.f_20923_;
        }
    }

    @SubscribeEvent
    public static void onEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        ItemEntity itemEntity;
        Entity entity;
        if (!event.getWorld().m_5776_() && (entity = event.getEntity()) instanceof ItemEntity && (itemEntity = (ItemEntity)entity).m_32055_().m_204117_(TagsNF.FLUID_ITEM)) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            IPlayerData capP = PlayerData.get(player);
            capP.dropBlockEntity();
            if (!player.f_19853_.m_46469_().m_46207_(GameRules.f_46133_)) {
                capP.getAccessoryInventory().dropAll();
            }
        }
    }

    @SubscribeEvent
    public static void onLoadWorldEvent(WorldEvent.Load event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel level = (ServerLevel)levelAccessor;
            RegistriesNF.buildActiveKnowledge(level);
            RegistriesNF.buildNaturalVegetation();
        }
    }

    private static boolean isSpawnAreaFlat(ContinentalChunkGenerator generator, BlockPos.MutableBlockPos pos) {
        int centerX = pos.m_123341_();
        int centerZ = pos.m_123343_();
        for (int x = centerX - 1; x <= centerX + 1; ++x) {
            pos.m_142451_(x);
            for (int z = centerZ - 1; z <= centerZ + 1; ++z) {
                pos.m_142443_(z);
                if (Math.abs(generator.getHeight(x, z) - pos.m_123342_()) <= 1) continue;
                return false;
            }
        }
        return true;
    }

    @SubscribeEvent
    public static void onCreateSpawnPositionEvent(WorldEvent.CreateSpawnPosition event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel) {
            int dist;
            ServerLevel level = (ServerLevel)levelAccessor;
            ChunkGenerator chunkGenerator = level.m_7726_().m_8481_();
            if (!(chunkGenerator instanceof ContinentalChunkGenerator)) {
                return;
            }
            ContinentalChunkGenerator generator = (ContinentalChunkGenerator)chunkGenerator;
            int x = dist = 32;
            int z = dist;
            BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
            int seaLevel = generator.m_6337_();
            while (true) {
                float humidity;
                float temp;
                int height;
                if ((height = generator.getHeight(x, 0)) > seaLevel && height < seaLevel + 9 && (temp = generator.getTemperature(x, 0)) > 0.3f && temp < 0.7f && (humidity = generator.getHumidity(x, 0)) > 0.3f && humidity < 0.7f) {
                    pos.m_122178_(x, height, 0);
                    if (CommonEventHandler.isSpawnAreaFlat(generator, pos)) break;
                }
                if ((height = generator.getHeight(-x, 0)) > seaLevel && height < seaLevel + 9 && (temp = generator.getTemperature(-x, 0)) > 0.3f && temp < 0.7f && (humidity = generator.getHumidity(-x, 0)) > 0.3f && humidity < 0.7f) {
                    pos.m_122178_(-x, height, 0);
                    if (CommonEventHandler.isSpawnAreaFlat(generator, pos)) break;
                }
                x += dist;
                height = generator.getHeight(0, z);
                if (height > seaLevel && height < seaLevel + 9 && (temp = generator.getTemperature(0, z)) > 0.3f && temp < 0.7f && (humidity = generator.getHumidity(0, z)) > 0.3f && humidity < 0.7f) {
                    pos.m_122178_(0, height, z);
                    if (CommonEventHandler.isSpawnAreaFlat(generator, pos)) break;
                }
                if ((height = generator.getHeight(0, -z)) > seaLevel && height < seaLevel + 9 && (temp = generator.getTemperature(0, -z)) > 0.3f && temp < 0.7f && (humidity = generator.getHumidity(0, -z)) > 0.3f && humidity < 0.7f) {
                    pos.m_122178_(0, height, -z);
                    if (CommonEventHandler.isSpawnAreaFlat(generator, pos)) break;
                }
                z += dist;
            }
            event.getSettings().m_7250_(pos.m_7949_(), 0.0f);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onLivingEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            entity = event.getTo().m_41720_();
            if (entity instanceof TieredArmorItem) {
                TieredArmorItem armor = (TieredArmorItem)entity;
                if (event.getSlot() != EquipmentSlot.MAINHAND && event.getSlot() != EquipmentSlot.OFFHAND && player.f_8921_ <= 0 && !event.getFrom().m_41726_(event.getTo()) && armor.material.getSoundEvent() != null) {
                    event.getEntityLiving().m_146850_(GameEvent.f_157811_);
                    event.getEntityLiving().m_183503_().m_6269_(null, event.getEntity(), armor.material.getSoundEvent(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    private static void playFallSound(LivingEntity entity) {
        BlockPos pos = entity.m_20097_();
        BlockState blockstate = entity.f_19853_.m_8055_(pos);
        if (!blockstate.m_60795_()) {
            SoundType soundtype = blockstate.getSoundType((LevelReader)entity.f_19853_, pos, (Entity)entity);
            entity.m_5496_(soundtype.m_56779_(), soundtype.m_56773_() * 0.25f, soundtype.m_56774_());
        }
    }

    @SubscribeEvent
    public static void onLivingFallEvent(LivingFallEvent event) {
        float distance = event.getDistance();
        float damageMultiplier = event.getDamageMultiplier();
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof Player) {
            Player player = (Player)livingEntity;
            if (distance > 1.0f && !player.m_20067_() && Mth.m_14167_((float)((distance * 0.5f - 3.0f) * damageMultiplier)) <= 0) {
                CommonEventHandler.playFallSound((LivingEntity)player);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerFlyableFallEvent(PlayerFlyableFallEvent event) {
        if (event.getDistance() > 1.0f && !event.getPlayer().m_20067_()) {
            CommonEventHandler.playFallSound((LivingEntity)event.getPlayer());
        }
    }

    @SubscribeEvent
    public static void onBlockNeighborNotifyEvent(BlockEvent.NeighborNotifyEvent event) {
        ServerLevel level;
        LevelAccessor levelAccessor = event.getWorld();
        if (levelAccessor instanceof ServerLevel && LevelData.isPresent((Level)(level = (ServerLevel)levelAccessor))) {
            BlockState state = event.getState();
            if (state.m_60795_() || state.m_60767_().m_76332_()) {
                ChunkData.get(level.m_46745_(event.getPos())).schedulePhysicsTickAround(event.getPos());
            } else if (state.m_204336_(TagsNF.HAS_PHYSICS)) {
                ChunkData.get(level.m_46745_(event.getPos())).schedulePhysicsTick(event.getPos());
            }
        }
    }

    @SubscribeEvent
    public static void onBreakSpeedEvent(PlayerEvent.BreakSpeed event) {
        BlockState state;
        IActionTracker capA;
        Player player = event.getPlayer();
        float speed = event.getNewSpeed();
        if (player.m_204029_(FluidTags.f_13131_) && !EnchantmentHelper.m_44934_((LivingEntity)player)) {
            speed *= 2.5f;
        }
        if (!player.m_20096_()) {
            speed *= 5.0f;
        }
        if (player.m_6084_() && !(capA = ActionTracker.get((Entity)player)).isInactive()) {
            if (!capA.getAction().canHarvest(event.getState())) {
                speed /= 4.0f;
            }
            if (capA.getAction().is(TagsNF.SLOW_PLAYER_HARVEST_ACTION)) {
                speed /= 2.0f;
            } else if (capA.getAction().is(TagsNF.ADZE_ACTION)) {
                speed *= 0.75f;
            }
        }
        if ((state = event.getState()).m_204336_(TagsNF.TREE_WOOD)) {
            int size = 0;
            BlockPos.MutableBlockPos pos = event.getPos().m_122032_();
            while (state.m_204336_(BlockTags.f_13106_)) {
                if (state.m_60734_() instanceof TreeStemBlock) {
                    block0 : switch ((TreeStemBlock.Type)((Object)state.m_61143_(TreeStemBlock.TYPE))) {
                        case TOP: 
                        case ROTATED_TOP: {
                            switch ((Direction.Axis)state.m_61143_((Property)TreeStemBlock.f_55923_)) {
                                case X: {
                                    pos.m_142451_(pos.m_123341_() + 1);
                                    break block0;
                                }
                                case Y: {
                                    pos.m_142448_(pos.m_123342_() + 1);
                                    break block0;
                                }
                                case Z: {
                                    pos.m_142443_(pos.m_123343_() - 1);
                                }
                            }
                            break;
                        }
                        case BOTTOM: 
                        case ROTATED_BOTTOM: {
                            switch ((Direction.Axis)state.m_61143_((Property)TreeStemBlock.f_55923_)) {
                                case X: {
                                    pos.m_142451_(pos.m_123341_() - 1);
                                    break block0;
                                }
                                case Y: {
                                    pos.m_142448_(pos.m_123342_() - 1);
                                    break block0;
                                }
                                case Z: {
                                    pos.m_142443_(pos.m_123343_() + 1);
                                }
                            }
                            break;
                        }
                        default: {
                            pos.m_142448_(pos.m_123342_() + 1);
                            break;
                        }
                    }
                } else {
                    pos.m_142448_(pos.m_123342_() + 1);
                }
                ++size;
                state = player.f_19853_.m_8055_((BlockPos)pos);
            }
            if (size > 1) {
                speed *= 1.0f / ((float)size * 0.8f);
            }
        }
        event.setNewSpeed(speed);
    }

    /*
     * Enabled aggressive block sorting
     */
    @SubscribeEvent
    public static void onPlayerTickEvent(TickEvent.PlayerTickEvent event) {
        FluidStack fluid;
        Fluid fluid2;
        Object object;
        IPlayerData capP;
        IActionTracker capA;
        Level level;
        Player player;
        block77: {
            block75: {
                Pose pose;
                block76: {
                    block74: {
                        DamageTypeSource damageTypeSource;
                        DamageSource dirtyAccessories2;
                        block72: {
                            block73: {
                                player = event.player;
                                if (player == null) {
                                    return;
                                }
                                level = player.f_19853_;
                                if (event.phase != TickEvent.Phase.END) break block72;
                                if (level.f_46443_) break block73;
                                if (player.m_6084_()) {
                                    if (player.f_19797_ == 1) {
                                        LevelUtil.warpServerPlayer(player, false);
                                    }
                                    if (player.m_36324_().m_38702_() <= 0 && !player.m_21023_((MobEffect)EffectsNF.STARVATION.get()) && !player.m_21023_((MobEffect)EffectsNF.STARVATION_1.get())) {
                                        player.m_7292_(new MobEffectInstance((MobEffect)EffectsNF.STARVATION_1.get(), 100, 0));
                                    }
                                }
                                break block72;
                            }
                            if (player.f_20919_ == 20) {
                                LevelUtil.warpClientPlayer(player, false);
                            }
                        }
                        if (!player.m_6084_()) {
                            return;
                        }
                        capA = ActionTracker.get((Entity)player);
                        capP = PlayerData.get(player);
                        if (event.phase == TickEvent.Phase.START) {
                            capP.setTicksSinceHit(capP.getTicksSinceHit() + 1);
                            if (player.f_20924_ == 1.5f) {
                                player.f_20924_ = player.f_20923_;
                            }
                            if (!level.m_5776_()) {
                                if (!capP.getLastMainItem().m_41726_(player.m_21205_())) {
                                    capP.setLastMainItem();
                                }
                                if (!capP.getLastOffItem().m_41726_(player.m_21206_())) {
                                    capP.setLastOffItem();
                                }
                                if (!player.m_150110_().f_35934_) {
                                    player.m_36399_(0.00125f);
                                }
                            }
                            if (capA.isCharging() && !(player.m_21120_(capP.getActiveHand()).m_41720_() instanceof IActionableItem)) {
                                capA.queue();
                            }
                            Action action = capA.getAction();
                            action.onTick((LivingEntity)player);
                            if (action.getSound() != null && capA.getFrame() == 1 && !capA.hasHitPause() && capA.isDamaging() && player.m_21120_(capP.getActiveHand()).m_41720_() instanceof IActionableItem) {
                                player.m_5496_(action.isChargeable() && capA.getCharge() >= Math.round((float)action.getMaxCharge() * 0.75f) ? action.getExtraSound().get() : action.getSound().get(), 1.0f, 1.0f + level.f_46441_.nextFloat(-0.03f, 0.03f));
                                player.m_146850_(GameEventsNF.ACTION_SOUND);
                            }
                            if (!level.m_5776_()) {
                                AccessoryInventory accessories = capP.getAccessoryInventory();
                                ObjectArrayList dirtyAccessories2 = new ObjectArrayList(0);
                                for (AccessorySlot slot : AccessorySlot.values()) {
                                    AttributeAccessoryItem attributeItem;
                                    ItemStack newItem;
                                    ItemStack oldItem = capP.getLastAccessory(slot);
                                    if (ItemStack.m_41728_((ItemStack)oldItem, (ItemStack)(newItem = accessories.getItem(slot)))) continue;
                                    Item item = oldItem.m_41720_();
                                    if (item instanceof AttributeAccessoryItem) {
                                        attributeItem = (AttributeAccessoryItem)item;
                                        player.m_21204_().m_22161_(attributeItem.getAttributeModifiers(slot, oldItem));
                                    }
                                    if ((item = newItem.m_41720_()) instanceof AttributeAccessoryItem) {
                                        attributeItem = (AttributeAccessoryItem)item;
                                        player.m_21204_().m_22178_(attributeItem.getAttributeModifiers(slot, newItem));
                                    }
                                    ItemStack copiedItem = newItem.m_41777_();
                                    capP.setLastAccessory(slot, copiedItem);
                                    dirtyAccessories2.add(it.unimi.dsi.fastutil.Pair.of((Object)((Object)slot), (Object)copiedItem));
                                }
                                if (!dirtyAccessories2.isEmpty()) {
                                    NetworkHandler.toAllTracking((Entity)player, new SetAccessoriesToClient((List<it.unimi.dsi.fastutil.Pair<AccessorySlot, ItemStack>>)dirtyAccessories2, player.m_142049_()));
                                }
                            }
                            capA.tick();
                            return;
                        }
                        if (!level.m_5776_() && player.m_20069_()) {
                            LightData.get((Entity)player).inWaterTickServer();
                        }
                        capP.setPunchTicks(capP.getPunchTicks() - 1);
                        if (capA.isStunned()) {
                            capP.dropBlockEntity();
                        }
                        if (player.f_19864_ && (dirtyAccessories2 = player.m_21225_()) instanceof DamageTypeSource && ((damageTypeSource = (DamageTypeSource)dirtyAccessories2).isDoT() || damageTypeSource.isFromBlock())) {
                            player.f_19864_ = false;
                        }
                        if (level.m_5776_()) {
                            if (player.f_19797_ - Math.max(ClientEngine.get().lastDashTick, capP.getLastDodgeTick()) < 4) {
                                player.f_19787_ = Math.min(player.f_19787_, player.f_19867_ + 0.13f);
                            }
                        } else {
                            capP.updateExpandableInventory(false);
                            if (player.f_19864_) {
                                NetworkHandler.toClient((ServerPlayer)player, new HurtDirToClient(player.f_20918_, player.m_142049_()));
                            }
                        }
                        if (player.m_21255_() && player.m_20069_()) {
                            player.m_36321_();
                        }
                        if (AnimationUtil.getClimbProgress(player, 1.0f) > 0.0f) {
                            player.m_6858_(false);
                        }
                        if (capP.isClimbing()) {
                            if (!level.m_5776_()) {
                                player.m_20334_(player.m_20184_().f_82479_, 0.0, player.m_20184_().f_82481_);
                            }
                            player.m_183634_();
                        }
                        if (capP.isCrawling()) break block74;
                        dirtyAccessories2 = player.m_21120_(capP.getActiveHand()).m_41720_();
                        if (!(dirtyAccessories2 instanceof IWeaponItem)) break block75;
                        IWeaponItem weapon = (IWeaponItem)dirtyAccessories2;
                        if (!capA.getActionID().equals((Object)weapon.getActionSet((Player)player).crawl.getId())) break block75;
                    }
                    if (!player.m_20159_() && !player.m_5803_() && !player.m_5833_()) break block76;
                    capP.setCrawling(false);
                    player.m_20124_(Pose.STANDING);
                    player.setForcedPose(null);
                    break block77;
                }
                if (player.m_21255_()) {
                    pose = Pose.FALL_FLYING;
                    player.f_20932_ = player.f_20931_ = Math.min(1.0f, (float)player.m_21256_() / 10.0f);
                } else {
                    pose = Pose.SWIMMING;
                }
                player.m_20124_(pose);
                player.setForcedPose(pose);
                if (player.m_204029_(FluidTags.f_13131_)) {
                    capP.setCrawling(false);
                    player.m_6858_(true);
                    break block77;
                } else {
                    player.m_6858_(false);
                    if (pose != Pose.FALL_FLYING) {
                        capP.setCrawling(true);
                    }
                }
                break block77;
            }
            player.setForcedPose(null);
        }
        if (capP.isClimbing()) {
            capP.setClimbTicks(Math.min(capP.getClimbTicks() + 1, 4));
        } else {
            capP.setClimbTicks(Math.max(-1, capP.getClimbTicks() - 1));
        }
        if (!(player.m_20096_() || player.m_20159_() || player.m_6147_() || capP.isClimbing() || player.m_21255_())) {
            capP.setAirTicks(Math.min(capP.getAirTicks() + 1, 9));
        } else {
            capP.setAirTicks(Math.max(-1, capP.getAirTicks() - 2));
        }
        if (player.m_6047_()) {
            capP.setCrouchTicks(Math.min(capP.getCrouchTicks() + 1, 4));
        } else {
            capP.setCrouchTicks(Math.max(-1, capP.getCrouchTicks() - 1));
        }
        if (!capP.getHeldContents().m_128456_()) {
            capP.setHoldTicks(Math.min(capP.getHoldTicks() + 1, 4));
        } else {
            capP.setHoldTicks(Math.max(-1, capP.getHoldTicks() - 1));
        }
        Action action = capA.getAction();
        if (capA.getState() == 1 && capA.getFrame() == 1 && !capA.isStunnedOrHitPaused()) {
            capP.setDugBlock(false);
            capP.setHitStopFrame(-1);
        }
        if (level.f_46443_ && player != ClientEngine.get().getPlayer()) {
            ItemStack stack = player.m_21120_(capP.getActiveHand());
            if (capA.isDamaging() && capP.getHitStopFrame() == -1 && capA.getFrame() == action.getBlockHitFrame(capA.getState(), (LivingEntity)player)) {
                if (stack.m_204117_(TagsNF.GRID_INTERACTABLE) && CommonEventHandler.isHittingMicroGrid(player, level)) {
                    capP.setHitStopFrame(capA.getFrame());
                } else if (stack.m_41720_() instanceof IActionableItem && action.canHarvest() && capA.getLivingEntitiesHit() == 0) {
                    Vec3 eyePos = player.m_146892_();
                    Vec3 viewVec = player.m_20252_(1.0f);
                    double reach = player.getReachDistance();
                    Vec3 endPos = eyePos.m_82520_(viewVec.f_82479_ * reach, viewVec.f_82480_ * reach, viewVec.f_82481_ * reach);
                    BlockHitResult hitResult = level.m_45547_(new ClipContext(eyePos, endPos, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)player));
                    if (hitResult.m_6662_() == HitResult.Type.BLOCK) {
                        IGlobalChunkData chunkData;
                        float progress;
                        boolean canMineAny;
                        BlockPos pos = hitResult.m_82425_();
                        boolean bl = canMineAny = !action.harvestableBlocks.equals(TagsNF.MINEABLE_WITH_SICKLE) && !action.harvestableBlocks.equals(TagsNF.MINEABLE_WITH_DAGGER) && !action.harvestableBlocks.equals((Object)BlockTags.f_144280_);
                        if ((canMineAny || action.canHarvest(level.m_8055_(pos))) && (progress = (chunkData = GlobalChunkData.get(level.m_46745_(pos))).getBreakProgress(pos) + level.m_8055_(pos).m_60625_(player, (BlockGetter)level, pos) * AttributesNF.getStrengthMultiplier((LivingEntity)player) * capA.getChargeDestroyProgressMultiplier()) < 1.0f && !level.m_8055_(pos).m_60767_().m_76336_() && !stack.m_204117_(TagsNF.NO_HITSTOP)) {
                            capP.setHitStopFrame(capA.getFrame());
                        }
                    }
                }
            }
        }
        if (!level.m_5776_()) {
            IActionableItem item;
            if (LevelUtil.isDay((LevelAccessor)level)) {
                capP.setUndeadKilledThisNight(0);
            }
            capP.tickStamina();
            capP.tickRevelatoryKnowledge();
            if (!capA.isInactive() && !capA.isStunned() && capA.getState() == 0 && capA.getFrame() <= 2 && (object = player.m_21120_(capP.getActiveHand()).m_41720_()) instanceof IActionableItem && !(item = (IActionableItem)object).hasAction(capA.getActionID(), player)) {
                capA.stunServer(12, false);
            }
        }
        if (!capA.isInactive()) {
            if (!action.allowSprinting()) {
                player.m_6858_(false);
            }
            if (!action.allowCrawling()) {
                if (player.m_21255_()) {
                    player.m_36321_();
                }
                if (player.m_20089_() != Pose.STANDING && player.m_20089_() != Pose.CROUCHING) {
                    capA.stunServer(16, false);
                }
            }
        }
        if (capA.isStunned()) {
            if (player.m_21255_()) {
                player.m_36321_();
            }
            CombatUtil.addTransientMultiplier((LivingEntity)player, player.m_21051_(Attributes.f_22279_), -0.5, CombatUtil.STUN_SLOW_ID, "stun_slow");
        } else {
            CombatUtil.removeTransientModifier((LivingEntity)player, player.m_21051_(Attributes.f_22279_), CombatUtil.STUN_SLOW_ID);
        }
        if (player.f_19797_ - capP.getLastDodgeTick() < 4) {
            player.f_20883_ = player.f_20884_;
        }
        if (!(capA.isInactive() || ActionsNF.isEmpty(capA.getActionID()) || capA.isStunned() || action.getRegistryName().equals((Object)ActionsNF.HOLD_ENTITY.getId()))) {
            CombatUtil.alignBodyRotWithHead((LivingEntity)player, capA);
        } else if (capP.isClimbing() || player.m_6147_()) {
            CombatUtil.alignBodyRotWithHead((LivingEntity)player, capP);
        }
        capA.setLastPosition(player.m_20182_());
        if (level.f_46443_) return;
        if (LevelUtil.isNight((LevelAccessor)level)) {
            MoonPhase moonPhase = MoonPhase.get((LevelTimeAccess)level);
            if (moonPhase != MoonPhase.NEW) {
                capP.addRevelatoryKnowledge(KnowledgeNF.UNDEAD_PRESENCE.getId());
            }
            if (moonPhase == MoonPhase.FULL) {
                capP.addRevelatoryKnowledge(KnowledgeNF.ESSENCE.getId());
            }
        }
        if (!((object = player.f_36096_) instanceof CrucibleContainer)) return;
        CrucibleContainer crucibleContainer = (CrucibleContainer)((Object)object);
        object = crucibleContainer.entity.fluids.iterator();
        do {
            if (!object.hasNext()) return;
        } while (!((fluid2 = (fluid = (FluidStack)object.next()).getFluid()) instanceof MetalFluid));
        MetalFluid metalFluid = (MetalFluid)fluid2;
        if (metalFluid.metal.getCategory() == IMetal.Category.HARD) {
            capP.addKnowledge(KnowledgeNF.MELTED_HARD_METAL.getId());
        }
        if (metalFluid.metal.getCategory() != IMetal.Category.HARD) {
            if (metalFluid.metal.getCategory() != IMetal.Category.MYSTIC) return;
        }
        capP.addKnowledge(KnowledgeNF.MELTED_CASTABLE_METAL.getId());
    }

    @SubscribeEvent
    public static void onWorldTickEvent(TickEvent.WorldTickEvent event) {
        Level level = event.world;
        if (level instanceof ServerLevel) {
            ServerLevel level2 = (ServerLevel)level;
            if (event.phase == TickEvent.Phase.END && LevelData.isPresent((Level)level2)) {
                ILevelData cap = LevelData.get((Level)level2);
                cap.tick();
                if (level2.m_142572_().m_129921_() % 1000 == 0) {
                    LevelDataToClient message = new LevelDataToClient(cap.writeNBTSync(new CompoundTag()));
                    for (ServerPlayer player : level2.m_6907_()) {
                        NetworkHandler.toClient(player, message);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void onChunkLoadEvent(ChunkEvent.Load event) {
        ChunkAccess chunkAccess = event.getChunk();
        if (chunkAccess instanceof LevelChunk) {
            LevelChunk chunk = (LevelChunk)chunkAccess;
            Level level = (Level)event.getWorld();
            if (LevelData.isPresent(level)) {
                if (level.m_5776_()) {
                    NetworkHandler.toServer(new ChunkClimateToServer(chunk));
                } else {
                    long loadDay;
                    ServerLevel serverLevel = (ServerLevel)event.getWorld();
                    IChunkData capC = ChunkData.get(chunk);
                    if (capC.isNew()) {
                        ChunkGenerator chunkGenerator = serverLevel.m_7726_().m_8481_();
                        if (chunkGenerator instanceof ContinentalChunkGenerator) {
                            ContinentalChunkGenerator generator = (ContinentalChunkGenerator)chunkGenerator;
                            int i = chunk.m_7697_().m_45604_();
                            int j = chunk.m_7697_().m_45605_();
                            for (int x = 0; x < 16; x += 5) {
                                for (int z = 0; z < 16; z += 5) {
                                    int worldX = x + i;
                                    int worldZ = z + j;
                                    capC.setTemperature(x, z, generator.getTemperature(worldX, worldZ));
                                    capC.setHumidity(x, z, generator.getHumidity(worldX, worldZ));
                                }
                            }
                        } else {
                            for (int x = 0; x < 16; x += 5) {
                                for (int z = 0; z < 16; z += 5) {
                                    capC.setTemperature(x, z, 0.5f);
                                    capC.setHumidity(x, z, 0.5f);
                                }
                            }
                        }
                        capC.setOld();
                    }
                    if (LevelUtil.hasPassedNight(loadDay = capC.getLastLoadedDayTime(), (Level)serverLevel)) {
                        capC.setSpawnedUndead(false);
                        chunk.m_8092_(false);
                    }
                }
            }
            if (level.f_46443_) {
                NetworkHandler.toServer(new ChunkDigProgressToServer(chunk));
            }
        }
    }

    @SubscribeEvent
    public static void onChunkUnloadEvent(ChunkEvent.Unload event) {
        ChunkAccess chunkAccess = event.getChunk();
        if (chunkAccess instanceof LevelChunk) {
            LevelAccessor levelAccessor;
            LevelChunk chunk = (LevelChunk)chunkAccess;
            if (LevelData.isPresent((Level)event.getWorld()) && (levelAccessor = event.getWorld()) instanceof ServerLevel) {
                ServerLevel level = (ServerLevel)levelAccessor;
                IChunkData cap = ChunkData.get(chunk);
                cap.setLastLoadedDayTime(level.m_46468_());
                chunk.m_8092_(true);
            }
        }
    }

    @SubscribeEvent
    public static void onEntityStartRidingEvent(EntityMountEvent event) {
        Entity rider = event.getEntityMounting();
        if (!rider.f_19853_.f_46443_) {
            if (event.isMounting()) {
                ITamable tamable;
                if (rider instanceof Player) {
                    Player player = (Player)rider;
                    Nightfall.LOGGER.info(player.f_19797_ + ", " + rider.f_19789_);
                    if (!(player.m_7500_() || rider.m_20096_() || rider.m_20069_() || rider.m_20077_())) {
                        event.setCanceled(true);
                    }
                } else if (event.getEntityBeingMounted() instanceof Boat && (!rider.m_6095_().m_204039_(TagsNF.BOAT_PASSENGER) || rider instanceof ITamable && !(tamable = (ITamable)rider).isTamed())) {
                    event.setCanceled(true);
                }
            } else if (!event.isCanceled()) {
                Entity vehicle = event.getEntityBeingMounted();
                if (vehicle.f_19789_ > rider.f_19789_) {
                    rider.f_19789_ = vehicle.f_19789_;
                }
            }
        }
    }

    private static boolean allowRightClick(Player player, InteractionHand hand) {
        ItemStack item;
        IActionTracker capA = ActionTracker.get((Entity)player);
        IPlayerData capP = PlayerData.get(player);
        if (hand.equals((Object)InteractionHand.MAIN_HAND) && !capP.isMainhandActive() ? !(item = player.m_21206_()).equals(ItemStack.f_41583_) : capP.isMainhandActive() && hand.equals((Object)InteractionHand.OFF_HAND)) {
            return false;
        }
        return capA.isInactive() || capA.getAction().isInterruptible() || !capP.getHeldContents().m_128456_();
    }

    private static boolean isHittingMicroGrid(Player player, Level level) {
        int searchReach = 3;
        int playerReach = 2;
        Vector3f look = new Vector3f(player.m_20252_(1.0f));
        Vec3 startVec = player.m_146892_();
        look.m_122261_((float)playerReach);
        Vec3 endVec = startVec.m_82520_((double)look.m_122239_(), (double)look.m_122260_(), (double)look.m_122269_());
        BlockPos.MutableBlockPos blockPos = new BlockPos.MutableBlockPos();
        for (int x = -searchReach; x <= searchReach; ++x) {
            for (int y = -searchReach; y <= searchReach; ++y) {
                for (int z = -searchReach; z <= searchReach; ++z) {
                    Vector3f gridSize;
                    blockPos.m_122169_(startVec.f_82479_ + (double)x, startVec.f_82480_ + (double)y, startVec.f_82481_ + (double)z);
                    BlockEntity blockEntity = level.m_7702_((BlockPos)blockPos);
                    if (!(blockEntity instanceof IMicroGrid)) continue;
                    IMicroGrid gridEntity = (IMicroGrid)blockEntity;
                    float rot = -gridEntity.getRotationDegrees();
                    Vec3 gridPos = gridEntity.getWorldPos((BlockPos)blockPos, 0.0f, 0.0f, 0.0f);
                    Optional prelimHitVec = new AABB(gridPos, gridPos.m_82520_((double)(gridSize = MathUtil.rotatePointByYaw(new Vector3f((float)gridEntity.getGridXSize() / 16.0f, (float)gridEntity.getGridYSize() / 16.0f, (float)gridEntity.getGridZSize() / 16.0f), rot)).m_122239_(), (double)gridSize.m_122260_(), (double)gridSize.m_122269_())).m_82371_(startVec, endVec);
                    if (prelimHitVec.isEmpty() || level.m_45547_(new ClipContext(startVec, (Vec3)prelimHitVec.get(), ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, (Entity)player)).m_6662_() != HitResult.Type.MISS) continue;
                    for (int gridX = 0; gridX < gridEntity.getGridXSize(); ++gridX) {
                        for (int gridY = 0; gridY < gridEntity.getGridYSize(); ++gridY) {
                            for (int gridZ = 0; gridZ < gridEntity.getGridZSize(); ++gridZ) {
                                Vector3f selectPos = MathUtil.rotatePointByYaw(new Vector3f((float)gridX / 16.0f, (float)gridY / 16.0f, (float)gridZ / 16.0f), rot);
                                Vector3f selectSize = MathUtil.rotatePointByYaw(new Vector3f(0.0625f, 0.0625f, 0.0625f), rot);
                                Vec3 finalPos = gridPos.m_82520_((double)selectPos.m_122239_(), (double)selectPos.m_122260_(), (double)selectPos.m_122269_());
                                Optional hitVec = new AABB(finalPos, finalPos.m_82520_((double)selectSize.m_122239_(), (double)selectSize.m_122260_(), (double)selectSize.m_122269_())).m_82371_(startVec, endVec);
                                if (!gridEntity.getGrid()[gridX][gridY][gridZ] || !hitVec.isPresent()) continue;
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }
}

