/*
 * Decompiled with CFR 0.152.
 */
package frostnox.nightfall.event;

import frostnox.nightfall.action.Action;
import frostnox.nightfall.action.Attack;
import frostnox.nightfall.action.AttackEffect;
import frostnox.nightfall.action.DamageType;
import frostnox.nightfall.action.DamageTypeSource;
import frostnox.nightfall.action.Impact;
import frostnox.nightfall.action.Poise;
import frostnox.nightfall.capability.ActionTracker;
import frostnox.nightfall.capability.IActionTracker;
import frostnox.nightfall.capability.PlayerData;
import frostnox.nightfall.entity.entity.ActionableEntity;
import frostnox.nightfall.entity.entity.ArmorStandDummyEntity;
import frostnox.nightfall.item.IWeaponItem;
import frostnox.nightfall.network.NetworkHandler;
import frostnox.nightfall.network.message.entity.HitParticlesToClient;
import frostnox.nightfall.network.message.entity.HitTargetToServer;
import frostnox.nightfall.registry.forge.AttributesNF;
import frostnox.nightfall.registry.forge.EffectsNF;
import frostnox.nightfall.util.CombatUtil;
import frostnox.nightfall.util.data.Vec2f;
import frostnox.nightfall.util.data.Vec3f;
import frostnox.nightfall.util.data.Wrapper;
import frostnox.nightfall.world.OrientedEntityHitResult;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingKnockBackEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class DamageEventHandler {
    @SubscribeEvent
    public static void onLivingDeathEvent(LivingDeathEvent event) {
        LivingEntity livingEntity = event.getEntityLiving().m_21231_().m_19294_();
        if (livingEntity instanceof ActionableEntity) {
            ActionableEntity killer = (ActionableEntity)livingEntity;
            killer.lastTargetPos = null;
            killer.m_6710_(null);
        }
    }

    @SubscribeEvent
    public static void onAttackEntityEvent(AttackEntityEvent event) {
        Player p = event.getPlayer();
        if (p != null && p.m_6084_()) {
            Entity target = event.getTarget();
            boolean notLiving = !(target instanceof LivingEntity) || target instanceof ArmorStandDummyEntity || target instanceof ArmorStand;
            boolean usingWeapon = p.m_21120_(PlayerData.get(p).getActiveHand()).m_41720_() instanceof IWeaponItem;
            if (p.f_19853_.f_46443_ && !usingWeapon && target.m_6097_() && !target.m_7313_((Entity)p) && (notLiving || PlayerData.get(p).getPunchTicks() <= 0)) {
                PlayerData.get(p).setPunchTicks(8);
                float damage = (float)p.m_21133_(Attributes.f_22281_);
                if (damage > 0.0f) {
                    int n;
                    EntityHitResult hitResult = (EntityHitResult)Minecraft.m_91087_().f_91077_;
                    Vec3 hitPos = hitResult.m_82450_();
                    if (hitResult instanceof OrientedEntityHitResult) {
                        OrientedEntityHitResult orientedHitResult = (OrientedEntityHitResult)hitResult;
                        n = orientedHitResult.boxIndex;
                    } else {
                        n = -1;
                    }
                    int boxIndex = n;
                    NetworkHandler.toServer(new HitTargetToServer(target.m_142049_(), (float)(hitPos.f_82479_ - target.m_20185_()), (float)(hitPos.f_82480_ - target.m_20186_()), (float)(hitPos.f_82481_ - target.m_20189_()), Vec3f.ZERO, boxIndex));
                }
            }
            event.setCanceled(!notLiving || usingWeapon);
        }
    }

    @SubscribeEvent
    public static void onLivingAttackEvent(LivingAttackEvent event) {
        if (event.getEntityLiving().f_19802_ > 10) {
            event.getEntityLiving().f_19802_ = 10;
        }
        float damageAmount = event.getAmount();
        DamageTypeSource source = event.getSource() instanceof DamageTypeSource ? (DamageTypeSource)event.getSource() : DamageTypeSource.convertFromVanilla(event.getSource());
        if (source.isFromBlock() && (event.getEntity() instanceof ActionableEntity || event.getEntity() instanceof Player) && ActionTracker.get((Entity)event.getEntityLiving()).getBlockInvulnerableTime() > 0) {
            event.setCanceled(true);
            return;
        }
        if (source.isDoT() && (event.getEntity() instanceof ActionableEntity || event.getEntity() instanceof Player) && ActionTracker.get((Entity)event.getEntityLiving()).getDotInvulnerableTime() > 0) {
            event.setCanceled(true);
            return;
        }
        LivingEntity livingEntity = event.getEntityLiving();
        if (livingEntity instanceof ServerPlayer) {
            IActionTracker capA;
            ServerPlayer player = (ServerPlayer)livingEntity;
            if (source != DamageSource.f_19317_ && PlayerData.get((Player)player).hasGodMode()) {
                event.setCanceled(true);
            }
            if ((capA = ActionTracker.get((Entity)player)).getAction().onAttackReceived((LivingEntity)player, source, damageAmount) <= 0.0f) {
                float durabilityDmg = Math.max(1.0f, damageAmount / 20.0f);
                InteractionHand hand = PlayerData.get((Player)player).getActiveHand();
                if (!player.m_7500_()) {
                    player.m_21120_(hand).m_41622_((int)durabilityDmg, (LivingEntity)player, p -> p.m_21190_(hand));
                }
                if (source.isFromBlock()) {
                    capA.setBlockInvulnerableTime(10);
                }
                CombatUtil.knockbackEntity((Entity)player, source.getKnockbackVec().scale(source.getAttack().getKnockback() / 2.0f));
                event.setCanceled(true);
            }
        } else {
            ActionableEntity entity;
            livingEntity = event.getEntityLiving();
            if (livingEntity instanceof ActionableEntity && (entity = (ActionableEntity)livingEntity).isImmuneTo(source, damageAmount)) {
                event.setCanceled(true);
            }
        }
    }

    @SubscribeEvent
    public static void onLivingHurtEvent(LivingHurtEvent event) {
        float chargedModifier;
        Object hand;
        Action action;
        DamageTypeSource source;
        float damageAmount = event.getAmount();
        if (damageAmount > 32768.0f) {
            return;
        }
        if (event.getSource() instanceof DamageTypeSource) {
            source = (DamageTypeSource)event.getSource();
            if (source.m_19372_()) {
                damageAmount *= 7.5f;
            }
        } else {
            damageAmount *= 5.0f;
            source = DamageTypeSource.convertFromVanilla(event.getSource());
        }
        float originalAmount = damageAmount;
        DamageSource damageSrc = event.getSource();
        LivingEntity entity = event.getEntityLiving();
        if (source.hasOwner() && (source.getOwner() instanceof Player || source.getOwner() instanceof ActionableEntity) && (action = ActionTracker.get(source.getOwner()).getAction()) instanceof Attack) {
            Attack attack = (Attack)action;
            damageAmount = attack.onDamageDealtPre((LivingEntity)source.getOwner(), entity, damageAmount);
        }
        if (entity instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)entity;
            IActionTracker capA = ActionTracker.get((Entity)player);
            float durabilityDmg = Math.max(1.0f, damageAmount / 20.0f);
            damageAmount = capA.getAction().onDamageReceived((LivingEntity)player, source, damageAmount);
            if (damageAmount != originalAmount) {
                hand = PlayerData.get((Player)player).getActiveHand();
                if (!player.m_7500_()) {
                    player.m_21120_(hand).m_41622_((int)durabilityDmg, (LivingEntity)player, arg_0 -> DamageEventHandler.lambda$onLivingHurtEvent$1((InteractionHand)hand, arg_0));
                }
            }
        }
        Wrapper<Poise> poise = new Wrapper<Poise>(AttributesNF.getPoise(entity));
        float oldDamageAmount = damageAmount;
        damageAmount = CombatUtil.applyEffectDamageCalculations(entity, source, damageAmount);
        damageAmount = CombatUtil.applyAttributeDamageCalculations(entity, source, damageAmount);
        damageAmount = CombatUtil.applyBodyDamageCalculations(entity, source, damageAmount, poise);
        damageAmount = CombatUtil.applyAccessoryDamageCalculations(entity, source, damageAmount);
        if (source.hasOwner() && (source.getOwner() instanceof Player || source.getOwner() instanceof ActionableEntity) && (hand = ActionTracker.get(source.getOwner()).getAction()) instanceof Attack) {
            Attack attack = (Attack)((Object)hand);
            damageAmount = attack.onDamageDealtPost((LivingEntity)source.getOwner(), entity, damageAmount);
        }
        Impact impact = source.getImpact();
        if (entity instanceof ActionableEntity) {
            ActionableEntity actionable = (ActionableEntity)entity;
            impact = actionable.modifyIncomingImpact(source, impact);
        }
        boolean impacted = !impact.negatedBy((Poise)((Object)poise.val));
        float reducedDamage = Math.min(2.0f, damageAmount / originalAmount);
        float f = chargedModifier = source.getOwner() instanceof Player || source.getOwner() instanceof ActionableEntity ? ActionTracker.get(source.getOwner()).getChargeAttackMultiplier() : 1.0f;
        if (reducedDamage > 0.1f) {
            LivingEntity livingEntity;
            Entity entity2;
            float chanceModifier = Math.min(1.0f, reducedDamage + 0.25f);
            if (source.getEffects() != null) {
                for (AttackEffect attackEffect : source.getEffects()) {
                    if (!(entity.f_19853_.m_5822_().nextFloat() <= attackEffect.chance * chanceModifier)) continue;
                    entity.m_147207_(attackEffect.getEffect(), source.m_7639_());
                }
            }
            for (AttackEffect attackEffect : source.getAttack().getEffects((entity2 = source.m_7639_()) instanceof LivingEntity ? (livingEntity = (LivingEntity)entity2) : null)) {
                if (!(entity.f_19853_.m_5822_().nextFloat() <= attackEffect.chance * chanceModifier)) continue;
                entity.m_147207_(attackEffect.getEffect(), source.m_7639_());
            }
        }
        float magnitude = Math.max(source.getAttack().getKnockback() / 2.0f, source.getAttack().getKnockback() * (impacted ? 1.0f : 0.5f) * chargedModifier);
        CombatUtil.knockbackEntity((Entity)entity, source.getKnockbackVec().scale(magnitude));
        damageAmount = Math.max(damageAmount, oldDamageAmount * 0.1f);
        float healthDamage = Math.max(damageAmount - entity.m_6103_(), 0.0f);
        entity.m_7911_(entity.m_6103_() - (damageAmount - healthDamage));
        float f2 = damageAmount - healthDamage;
        if (f2 > 0.0f && f2 < 3.4028235E37f && damageSrc.m_7640_() instanceof Player) {
            ((Player)damageSrc.m_7640_()).m_36222_(Stats.f_12929_, Math.round(f2 * 10.0f));
        }
        int stunDuration = source.getStunDuration();
        if (damageAmount > 0.0f) {
            float z;
            float y;
            float x;
            IActionTracker capA;
            boolean doStun = true;
            if (healthDamage != 0.0f) {
                ActionableEntity actionable;
                float health = entity.m_21223_();
                if (healthDamage >= health && healthDamage - health < 40.0f && entity instanceof ActionableEntity && (actionable = (ActionableEntity)entity).getCollapseAction() != null && !actionable.getActionTracker().getActionID().equals((Object)actionable.getCollapseAction())) {
                    doStun = false;
                    healthDamage = health - 1.0f;
                    actionable.forceAction(actionable.getCollapseAction());
                }
                entity.m_21231_().m_19289_(damageSrc, health, healthDamage);
                entity.m_21153_(health - healthDamage);
                if (damageSrc.m_7640_() instanceof Player && healthDamage < 3.4028235E37f) {
                    ((Player)damageSrc.m_7640_()).m_36222_(Stats.f_12931_, Math.round(healthDamage * 10.0f));
                }
            }
            if (doStun && impacted && stunDuration > 0 && (entity instanceof ActionableEntity || entity instanceof Player) && !(capA = ActionTracker.get((Entity)entity)).isStunned()) {
                capA.stunServer(Math.round((float)stunDuration * chargedModifier), false);
            }
            if (source.hasHitCoords()) {
                x = (float)source.getHitCoords().f_86214_;
                y = (float)source.getHitCoords().f_86215_;
                z = (float)source.getHitCoords().f_86216_;
            } else {
                x = (float)(entity.m_142469_().m_82362_() * 0.5);
                y = (float)(entity.m_142469_().m_82376_() * 0.5);
                z = (float)(entity.m_142469_().m_82385_() * 0.5);
            }
            if (damageAmount > 10.0f) {
                Vec2f particleVec = new Vec2f(source.getKnockbackVec().x(), source.getKnockbackVec().z()).normalize().reverse();
                NetworkHandler.toAllTrackingAndSelf((Entity)entity, new HitParticlesToClient(entity.m_142049_(), damageAmount, x, y, z, particleVec.x(), particleVec.y()));
            }
            x = (float)((double)x + entity.m_20185_());
            y = (float)((double)y + entity.m_20186_());
            z = (float)((double)z + entity.m_20189_());
            if (source.getSound() != null && (!source.isDoT() || entity instanceof Player)) {
                entity.f_19853_.m_6263_(null, (double)x, (double)y, (double)z, source.getSound(), entity.m_5720_(), 1.0f, 1.0f + entity.f_19853_.f_46441_.nextFloat(-0.03f, 0.03f));
            }
            if (entity instanceof ActionableEntity) {
                ActionableEntity actionableEntity = (ActionableEntity)entity;
                if (!source.isType(DamageType.ABSOLUTE) && (!source.isDoT() || source.isType(DamageType.FIRE) && actionableEntity.panicsOnFireDamage())) {
                    actionableEntity.reactToDamage = true;
                }
            }
        }
        if (entity instanceof ActionableEntity || entity instanceof Player) {
            IActionTracker capA = ActionTracker.get((Entity)entity);
            if (source.isFromBlock()) {
                capA.setBlockInvulnerableTime(10);
            }
        }
        if (entity.f_20924_ == 1.5f) {
            entity.f_20924_ = entity.f_20923_;
        }
        entity.m_146850_(GameEvent.f_157808_);
        event.setCanceled(true);
    }

    @SubscribeEvent
    public static void onLivingKnockBackEvent(LivingKnockBackEvent event) {
        event.setStrength(0.0f);
    }

    @SubscribeEvent
    public static void onLivingHealEvent(LivingHealEvent event) {
        if (event.getEntityLiving().m_21023_((MobEffect)EffectsNF.BLEEDING.get())) {
            event.setAmount(event.getAmount() / 2.0f);
        }
    }

    private static /* synthetic */ void lambda$onLivingHurtEvent$1(InteractionHand hand, ServerPlayer p_219998_1_) {
        p_219998_1_.m_21190_(hand);
    }
}

